# Generated by default/object.tt
package Paws::SageMaker::PipelineExperimentConfig;
  use Moose;
  has ExperimentName => (is => 'ro', isa => 'Str');
  has TrialName => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::PipelineExperimentConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::PipelineExperimentConfig object:

  $service_obj->Method(Att1 => { ExperimentName => $value, ..., TrialName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::PipelineExperimentConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->ExperimentName

=head1 DESCRIPTION

Specifies the names of the experiment and trial created by a pipeline.

=head1 ATTRIBUTES


=head2 ExperimentName => Str

The name of the experiment.


=head2 TrialName => Str

The name of the trial.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

