# NAME

Readonly::Values::Syslog - Syslog Constants

# VERSION

Version 0.03

# SYNOPSIS

    use Readonly::Values::Syslog;

    # Example usage in logging
    sub log_message {
        my ($level, $message) = @_;

        if (exists($syslog_values{$level})) {
            print "[$level] $message\n";
        } else {
            print "[UNKNOWN] $message\n";
        }
    }

# AUTHOR

Nigel Horne, `<njh at nigelhorne.com>`

# BUGS

# SEE ALSO

- [https://last9.io/blog/what-are-syslog-levels/](https://last9.io/blog/what-are-syslog-levels/)

# SUPPORT

This module is provided as-is without any warranty.

Please report any bugs or feature requests to `bug-readonly-values-syslog at rt.cpan.org`,
or through the web interface at
[http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Readonly-Values-Syslog](http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Readonly-Values-Syslog).
I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.

You can find documentation for this module with the perldoc command.

    perldoc Readonly::Values::Syslog

You can also look for information at:

- MetaCPAN

    [https://metacpan.org/dist/Readonly-Values-Syslog](https://metacpan.org/dist/Readonly-Values-Syslog)

- RT: CPAN's request tracker

    [https://rt.cpan.org/NoAuth/Bugs.html?Dist=Readonly-Values-Syslog](https://rt.cpan.org/NoAuth/Bugs.html?Dist=Readonly-Values-Syslog)

- CPAN Testers' Matrix

    [http://matrix.cpantesters.org/?dist=Readonly-Values-Syslog](http://matrix.cpantesters.org/?dist=Readonly-Values-Syslog)

- CPAN Testers Dependencies

    [http://deps.cpantesters.org/?module=Readonly::Values::Syslog](http://deps.cpantesters.org/?module=Readonly::Values::Syslog)

# LICENSE AND COPYRIGHT

Copyright 2025 Nigel Horne.

Usage is subject to licence terms.

The licence terms of this software are as follows:

- Personal single user, single computer use: GPL2
- All other users (including Commercial, Charity, Educational, Government)
  must apply in writing for a licence for use from Nigel Horne at the
  above e-mail.
