%******************************************************************************
%  FILE = math.red				Sun May 17 20:07:37 EDT 1987
% 
%  Procedures in this file:
% 
%  SIMPTAYLOR
% 
%  REDTEN source code
%  Copyright (c) 1986, 1987 University of Toronto.
%  All Rights Reserved.
%
%  Written by John Harper and Charles Dyer
%
%  Permission to use this software without fee is granted subject to 
%  the following restrictions:
% 
%  1. This software may not be used or distributed for direct commercial
%     gain.
% 
%  2. The author is not responsible for the consequences of use of this
%     software, no matter how awful, even if they arise from flaws in it.
% 
%  3. The origin of this software must not be misrepresented, either by
%     explicit claim or by omission.
% 
%  4. This code may be altered to suit your need, but such alterations
%     must be plainly marked and the code must not be misrepresented
%     as the original software.
% 
%  5. This notice may not be removed or altered.
% 
%**********************************************************************

PUT ('TAYLOR, 'SIMPFN, 'SIMPTAYLOR);
PUT ('taylor, 'OTHERNAME, 'TAYLOR);

% compute a taylor series of an expression. based on the taylor function
% in muMATH.

SYMBOLIC PROCEDURE SIMPTAYLOR (U);
BEGIN SCALAR EX, VAR, PT, POW, NVAR, LEX, LEX1, LEX2, LEX3;
  EX := MYCAR (U);
  IF NOT (VAR := MYCADR (U)) THEN RETURN (SIMP EX);
  IF IDP (VAR) THEN PT := 0
  ELSE <<
    PT := MYCADDR (VAR);
    VAR := MYCADR (VAR)
  >>;
  POW := MYCADDR (U) OR 6;
  IF NOT FIXP (POW) THEN RETURN (MKSQ ('TAYLOR . U, 1));
  NVAR := AEVAL (LIST ('DIFFERENCE, VAR, PT));
  LEX := 1;
  LEX1 := LEX2 := 0;
  LOOP:
    LEX3 := AEVAL (LIST ('SUB, LIST ('EQUAL, VAR, PT), EX));
    LEX2 := AEVAL (LIST ('PLUS, LEX2, LIST ('TIMES, LIST ('EXPT, NVAR, LEX1),
                   LIST ('QUOTIENT, LEX3, LEX))));
    IF (LEX1 := LEX1 + 1) > POW THEN RETURN (SIMP LEX2);
    EX := AEVAL (LIST ('DF, EX, VAR));
    IF EX = 0 THEN RETURN (SIMP LEX2);
    LEX := LEX * LEX1;
  GOTO LOOP;
END;

;END;
