/* readxwd.c */
/* This program is limited to X11 format XWD files */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: readxwd.c,v 1.2 1993/07/20 17:15:26 gbourhis Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/XWDFile.h>
#define MAXCOLORS 256
char *malloc();

char *
readxwd(input_file,hdfpal,palsize,cols,rows)
     char *input_file;
     char *hdfpal;
     int *cols,*rows,*palsize;
{
  FILE *ifd;
  char *imageP;
  unsigned int nspace;
  int padright;

  /* open input file */
  if (strcmp(input_file,"-") == 0)
    ifd = stdin;
  else
    ifd = fopen(input_file,"r");
  /* get X info from file */
  if (getinit(ifd, cols, rows, &padright, palsize, hdfpal) < 0)
    return NULL;
  
  /* alloc image array */
  nspace = *cols * *rows;
  imageP = malloc(nspace);

  /* fill image array */
  if (imageP)
    getimage(ifd, imageP, *rows, *cols, padright);

  if (ifd != stdin)
    fclose(ifd);
  return(imageP);
}

int bits_per_item, bits_used, bit_shift, bits_per_pixel, pixel_mask;
int bit_order, byte_swap;
char buf[4];
char *byteP;
short *shortP;
long *longP;

short bs_short();
int bs_int();
long bs_long();

int IsItXWD(fileName)
char *fileName;
{
char header[sizeof(XWDFileHeader)];
XWDFileHeader *h11P;
unsigned long swaptest = 1;
FILE *file;
char junk[10000];

	h11P = (XWDFileHeader *) header;
	if (!(file = fopen(fileName,"r"))) {
       		return 0;
       		}
	if (fread(header,sizeof(*h11P),1,file) != 1 ) {
		goto notXWD;
		}
	if (*(char *) &swaptest)
		_swaplong(header, sizeof(header));
	if (h11P->file_version != XWD_FILE_VERSION)
		goto notXWD;
	if (h11P->header_size < sizeof(*h11P) ||
	    h11P->header_size - sizeof(*h11P) > sizeof(junk))
		goto notXWD;
	if ( fread( junk, 1, h11P->header_size - sizeof(*h11P), file ) !=
			h11P->header_size - sizeof(*h11P) ) {
			/* couldn't read rest of X11 XWD file header */
		goto notXWD;
		}

	fclose(file);
	return(1);
 notXWD:
	fclose(file);
	return 0;
}

getinit( file, colsP, rowsP, padrightP, palsizeP, hdfpal)
     FILE *file;
     int *colsP, *rowsP, *padrightP, *palsizeP;
     char *hdfpal;
{
  /* Assume X11 headers are larger than X10 ones. */
  char header[sizeof(XWDFileHeader)];
  unsigned long swaptest = 1;
  XWDFileHeader *h11P;
  char junk[10000];
  int i, np, dummy1, dummy2, dummy3;
  unsigned  short minred, maxred;
  XColor x11col;
  
  h11P = (XWDFileHeader *) header;
  
  if (fread(header,sizeof(*h11P),1,file) != 1 )
    {
      fprintf(stderr,"couldn't read X11 XWD file header\n");
      return(-1);
    }
  if (*(char *) &swaptest)
    _swaplong(header, sizeof(header));

  *colsP = h11P->pixmap_width;
  *rowsP = h11P->pixmap_height;
  *padrightP = h11P->bytes_per_line * 8 / h11P->bits_per_pixel - *colsP;
  *palsizeP = h11P->colormap_entries;

  if ( fread( junk, 1, h11P->header_size - sizeof(*h11P), file ) != 
      h11P->header_size - sizeof(*h11P) )
    {
      fprintf(stderr,"couldn't read rest of X11 XWD file header");
      return(-1);
    }
  
  /* Check whether we can handle this dump. */
  if ( h11P->pixmap_depth > 8 )
    {
      fprintf(stderr,"can't handle X11 pixmap_depth > 8\n");
      return(-1);
    }
  if ( h11P->bits_per_rgb > 8 )
    {
      fprintf(stderr,"can't handle X11 bits_per_rgb > 8");
      return(-1);
    }
  if ( h11P->ncolors > MAXCOLORS )
    {
      fprintf(stderr,"can't handle X11 ncolors > %d");
      return(-1);
    }
  if ( h11P->pixmap_format != ZPixmap )
    {
      fprintf(stderr,"can't handle X11 pixmap_format %d\n",
	      h11P->pixmap_format);
      return(-1);
    }
  if ( h11P->bitmap_unit != 8 && h11P->bitmap_unit != 16 && 
      h11P->bitmap_unit != 32 )
    {
      fprintf(stderr,"X11 bitmap_unit (%d) is non-standard - can't handle");
      return(-1);
    }
  
/*****************************************************************************/
  /* Read X11 colormap. */
  minred = 65535;
  maxred = 0;
  for ( i = 0; i < h11P->colormap_entries; i++ )
    {
      if ( fread( &x11col, sizeof(XColor), 1, file ) != 1 )
	{
	  fprintf(stderr,"couldn't read X11 XWD colormap");
	  return(-1);
	}
      if (*(char *) &swaptest) {
	_swaplong((char *) &x11col.pixel, sizeof(long));
	_swapshort((char *) &x11col.red, 3 * sizeof(short));
      }
      if (x11col.pixel < MAXCOLORS)
	{
	  if (minred > x11col.red) minred = x11col.red;
	  if (maxred < x11col.red) maxred = x11col.red;
	  np = x11col.pixel * 3;
	  dummy1 = (unsigned) x11col.red / 256 ;
	  dummy2 = (unsigned) x11col.green / 256 ;
	  dummy3 = (unsigned) x11col.blue / 256 ;
	  hdfpal[np]   = (unsigned char) dummy1;
	  hdfpal[np+1] = (unsigned char) dummy2;
	  hdfpal[np+2] = (unsigned char) dummy3;
	}
      else
	{
	  fprintf(stderr,"pixel value outside of valid HDF palette\n");
	  return(-1);
	}
    }
#ifdef DEBUG
  fprintf(stderr,"minred = %d, maxred = %d\n",minred,maxred);
#endif
  /* rest of stuff for getpixnum */
  byte_swap = (h11P->byte_order== LSBFirst) && !(*(char *) &swaptest) ||
    (*(char *) &swaptest) && (h11P->byte_order==MSBFirst);
  bits_per_item = h11P->bitmap_unit;
  bits_used = bits_per_item;
  bits_per_pixel = h11P->bits_per_pixel;
  bit_order = h11P->bitmap_bit_order;
  pixel_mask = ( 1 << bits_per_pixel ) - 1;
  
  byteP = (char *) buf;
  shortP = (short *) buf;
  longP = (long *) buf;
  return 0;

}

getimage(file,image,y,x,pad)
     FILE *file;
     char *image;
     int x,y,pad;
{
  int i,j;

  for (i=0; i<y; i++)
    {
      for (j=0; j<x; j++)
	*(image++) = getpixnum(file);
      for ( j = 0; j < pad; j++ ) 
	(void) getpixnum( file );
    }
}


int
  getpixnum( file )
FILE *file;
{
  int p;
  
  if ( bits_used == bits_per_item )
    {
      if ( fread( buf, bits_per_item / 8, 1, file ) != 1 )
	fprintf(stderr, "couldn't read bits" );
      if ( byte_swap )
	switch ( bits_per_item )
	  {
	  case 8:
	    break;
	    
	  case 16:
	    *shortP = bs_short( *shortP );
	    break;
	    
	  case 32:
	    *longP = bs_long( *longP );
	    break;
	    
	  default:
	    fprintf(stderr, "can't happen" );
	  }
      bits_used = 0;
      
      if ( bit_order == MSBFirst )
	bit_shift = bits_per_item - bits_per_pixel;
      else
	bit_shift = 0;
    }
  
  switch ( bits_per_item )
    {
    case 8:
      p = ( *byteP >> bit_shift) & pixel_mask;
      break;
      
    case 16:
      p = ( *shortP >> bit_shift) & pixel_mask;
      break;
      
    case 32:
      p = ( *longP >> bit_shift) & pixel_mask;
      break;
      
    default:
      fprintf(stderr, "can't happen" );
    }
  
  if ( bit_order == MSBFirst )
    bit_shift -= bits_per_pixel;
  else
    bit_shift += bits_per_pixel;
  bits_used += bits_per_pixel;
  
  return p;
}


short
  bs_short( s )
short s;
{
  short ss;
  unsigned char *bp, t;
  
  ss = s;
  bp = (unsigned char *) &ss;
  t = bp[0];
  bp[0] = bp[1];
  bp[1] = t;
  return ss;
}

int
  bs_int( i )
int i;
{
  int ii;
  unsigned char *bp, t;
  
  ii = i;
  bp = (unsigned char *) &ii;
  t = bp[0];
  bp[0] = bp[3];
  bp[3] = t;
  t = bp[1];
  bp[1] = bp[2];
  bp[2] = t;
  return ii;
}

long bs_long( l )
     long l;
{
  return bs_int( l );
}

_swapshort (bp, n)
    register char *bp;
    register unsigned n;
{
    register char c;
    register char *ep = bp + n;

    while (bp < ep) {
	c = *bp;
	*bp = *(bp + 1);
	bp++;
	*bp++ = c;
    }
}

_swaplong (bp, n)
    register char *bp;
    register unsigned n;
{
    register char c;
    register char *ep = bp + n;
    register char *sp;

    while (bp < ep) {
	sp = bp + 3;
	c = *sp;
	*sp = *bp;
	*bp++ = c;
	sp = bp + 1;
	c = *sp;
	*sp = *bp;
	*bp++ = c;
	bp += 2;
    }
}
