/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#include <stdio.h>
#include <math.h>

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
#include <Xm/FileSB.h>
#include <Xm/Text.h>
#include <Xm/Separator.h>

#include "list.h"
#include "txtUI.h"
#include "net.h"
#include "view.h"
#include "mode.h"


#define DEF_WHITE	WhitePixel(myDpy, DefaultScreen(myDpy))
#define DEF_BLACK	BlackPixel(myDpy, DefaultScreen(myDpy))


extern Widget InitOptions();
extern Widget InitOverlayTools();
extern Dptr *InitDHash();
extern void CBPublish();
extern void CBViewOverlay();
extern void MyOutputCreate();
extern void CBSetLine();
extern void CBSetLineSelect();
extern void CBSetArrow();
extern void CBSetOval();
extern void CBSetBox();
extern void CBSetFreehand();
extern void CBSetText();
extern void CBSetErase();
extern void CBSetEraseBlock();
extern void CBGrabProc();
extern void CBSetPaste();
extern void CBSetPasteNoBack();
extern void CBDrawAreaPress();
extern void CBDrawAreaMove();
extern void CBDrawAreaRelease();
extern void CBDrawAreaKeyPress();
extern void CBTextExposed();
extern void CBTextValueChange();
extern void CBTextScrollY();
extern void CBTextScrollX();
extern void CBClearDrawArea();
extern void RegisterData();
extern void RegisterPopup();
extern void NewTextWindow();

extern List objectList;
extern Display *myDpy;
extern List vList;
extern NetPort *outP;


#define MALLOC  malloc
#define FREE    free

#ifndef TRUE
#define TRUE    1
#define FALSE   0
#endif

#define ABS(x) (((x)> 0)? (x): ((x) * -1.0))

#define LPR_COMMAND "/usr/ucb/lpr"

static List textList;
static Widget rootWidget;
static Widget fileBox;
static int fileBoxOpen;
static void CBFileNewOk();
static void CBFileNewCancel();
static void CBFileSaveOk();
static void CBFileSaveCancel();
static void CBFileIncludeOk();
static void CBFileIncludeCancel();
static Boolean textLock = False;

void TextReceiveMessage();



TextLock(lock)
Boolean lock;
{
TextUI *text;
Arg	argList[10];
	
	textLock = lock;
	text = (TextUI *) ListHead(textList);
	while (text) {
		/* set New and Open... to insensitive */
	        XtSetSensitive(text->button[0],!lock);
	        XtSetSensitive(text->button[1],!lock);

		/* make uneditable */
        	XtSetArg(argList[0], XmNeditable,!lock);
		/* make unselectable */
		if (lock)
	        	XtSetArg(argList[1], XmNselectThreshold,9999);
		else 
	        	XtSetArg(argList[1], XmNselectThreshold,5);

		XtSetValues(text->textWin,argList,2);

		text = (TextUI *) ListNext(textList);
		}
}


TextUI *TextSearchByName(name)
char *name;
{
TextUI *text;
	text = (TextUI *) ListHead(textList);
	while (text) {
		if (!strcmp(name,text->name))
			return(text);
		text = (TextUI *) ListNext(textList);
		}
	return(0);
	
}


void TextExit()
{
}


static void CBTextDone(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
TextUI *text; 

        text= (TextUI *) client_data;

	XtPopdown(text->top);
	/*
        XtUnmanageChild(text->mainWindow);
	*/
}


static void CBFileNewCancel(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
TextUI	*text;
	text = (TextUI *) call_data;
        XtUnmanageChild(fileBox);
        fileBoxOpen = FALSE;

        XtRemoveCallback(fileBox,XmNokCallback,CBFileNewOk,(caddr_t)text);
        XtRemoveCallback(fileBox,XmNcancelCallback,CBFileNewCancel,(caddr_t)text);

}



static void CBFileNewOk(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
XmFileSelectionBoxCallbackStruct *f;
char *fileName;
register int x;
TextUI *text;
Text t;

	text = (TextUI *) client_data;;
        f = (XmFileSelectionBoxCallbackStruct *) call_data;
        XtUnmanageChild(fileBox);
        fileBoxOpen = FALSE;

        XmStringGetLtoR(f->value,XmSTRING_DEFAULT_CHARSET,&fileName);
        XtRemoveCallback(fileBox,XmNokCallback,CBFileNewOk,(caddr_t)text);
        XtRemoveCallback(fileBox,XmNcancelCallback,CBFileNewCancel,(caddr_t)text);
	t.title = fileName;
	t.id = "Local File";
	t.selLeft = 0;
	t.selRight = 0;
	t.insertPt = 0;
	t.replaceAll = TRUE;
	t.numReplace = 0;
	if (t.dim = TextReadFile(fileName,&(t.textString))) {
		NetSendText(0,&t,FALSE,TEXT_MODULE_NAME);
		TextReceiveMessage(&t);
		}
		
        XtRemoveCallback(fileBox,XmNokCallback,CBFileNewOk,(caddr_t)text);
        XtRemoveCallback(fileBox,XmNcancelCallback,CBFileNewCancel,(caddr_t)text);
}



static void CBTextNew(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
TextUI *text; 

        text= (TextUI *) client_data;
        if (fileBoxOpen) {
                XRaiseWindow(XtDisplay(fileBox),XtWindow(fileBox));
                ErrMesg("File Select Window already open\n");
                return;
                }
        XtManageChild(fileBox);
        XtAddCallback(fileBox,XmNokCallback,CBFileNewOk,(caddr_t)text);
        XtAddCallback(fileBox,XmNcancelCallback,CBFileNewCancel,(caddr_t)text);
        fileBoxOpen = TRUE;
}

static void CBFileIncludeCancel(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
TextUI	*text;
	text = (TextUI *) call_data;
        XtUnmanageChild(fileBox);
        fileBoxOpen = FALSE;

        XtRemoveCallback(fileBox,XmNokCallback,CBFileIncludeOk,(caddr_t)text);
        XtRemoveCallback(fileBox,XmNcancelCallback,CBFileIncludeCancel,(caddr_t)text);

}


static void CBFileIncludeOk(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
XmFileSelectionBoxCallbackStruct *f;
char *fileName;
register int x;
TextUI *text;
Text t;

	text = (TextUI *) client_data;;
        f = (XmFileSelectionBoxCallbackStruct *) call_data;
        XtUnmanageChild(fileBox);
        fileBoxOpen = FALSE;

        XmStringGetLtoR(f->value,XmSTRING_DEFAULT_CHARSET,&fileName);
        XtRemoveCallback(fileBox,XmNokCallback,CBFileNewOk,(caddr_t)text);
        XtRemoveCallback(fileBox,XmNcancelCallback,CBFileNewCancel,(caddr_t)text);
	t.title = text->name;
	t.id = "Local File";
	t.selLeft = 0;
	t.selRight = 0;
	t.insertPt = XmTextGetInsertionPosition(text->textWin);
	t.replaceAll = FALSE;
	t.numReplace = 0;
	if (t.dim = TextReadFile(fileName,&(t.textString))) {
		if (text->ispub)
		{
			NetSendText(0,&t,FALSE,TEXT_MODULE_NAME);
		}
		TextReceiveMessage(&t);
		}
		
        XtRemoveCallback(fileBox,XmNokCallback,CBFileIncludeOk,(caddr_t)text);
        XtRemoveCallback(fileBox,XmNcancelCallback,CBFileIncludeCancel,(caddr_t)text);
}


static void CBTextInclude(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
TextUI *text; 

        text= (TextUI *) client_data;
        if (fileBoxOpen) {
                XRaiseWindow(XtDisplay(fileBox),XtWindow(fileBox));
                ErrMesg("File Select Window already open\n");
                return;
                }
        XtManageChild(fileBox);
        XtAddCallback(fileBox,XmNokCallback,CBFileIncludeOk,(caddr_t)text);
        XtAddCallback(fileBox,XmNcancelCallback,CBFileIncludeCancel,(caddr_t)text);
        fileBoxOpen = TRUE;
}


static void CBFileSaveCancel(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
TextUI	*text;

	text = (TextUI *) call_data;
        XtUnmanageChild(fileBox);
        fileBoxOpen = FALSE;

        XtRemoveCallback(fileBox,XmNokCallback,CBFileSaveOk,(caddr_t)text);
        XtRemoveCallback(fileBox,XmNcancelCallback,CBFileSaveCancel,(caddr_t)text);

}


static void CBTextPrint(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
char	*textString;
char	buff[1024];
char	ebuff[1024];
TextUI	*text;
char 	*fileName;

	text = (TextUI *) client_data;
	textString = XmTextGetString(text->textWin);
	if (!textString)  {
		ErrMesg("Couldn't get text String from Widget. Not Saved...\n");
		return;
		}
	fileName = tempnam(0,"ncsa");
	TextWriteASCIIFile(fileName,textString);
	XtFree(textString);
	sprintf(ebuff,"%s -T %s %s\n",LPR_COMMAND,text->name,fileName);
	system(ebuff);
	sprintf(ebuff,"/bin/rm -f %s \n",fileName);
	system(ebuff);
	sprintf(buff,"text is printing\n"); /*** actually should check status*/
					    /* with a wait(status); */
	WriteMesg(buff);
	free(fileName);
}

static void CBFileSaveOk(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
XmFileSelectionBoxCallbackStruct *f;
char *fileName;
register int x;
TextUI *text;
Text t;
char	*textString;
char	buff[1024];

	text = (TextUI *) client_data;;
        f = (XmFileSelectionBoxCallbackStruct *) call_data;
        XtUnmanageChild(fileBox);
        fileBoxOpen = FALSE;

        XmStringGetLtoR(f->value,XmSTRING_DEFAULT_CHARSET,&fileName);
	
	textString = XmTextGetString(text->textWin);
	if (!textString)  {
		ErrMesg("Couldn't get text String from Widget. Not Saved...\n");
		return;
		}
	TextWriteASCIIFile(fileName,textString);
	XtFree(textString);
	sprintf(buff,"File %s is saved\n",fileName);
	WriteMesg(buff);

        XtRemoveCallback(fileBox,XmNokCallback,CBFileSaveOk,(caddr_t)text);
        XtRemoveCallback(fileBox,XmNcancelCallback,CBFileSaveCancel,(caddr_t)text);
}

static void CBTextSave(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
TextUI *text; 

        text= (TextUI *) client_data;
        if (fileBoxOpen) {
                XRaiseWindow(XtDisplay(fileBox),XtWindow(fileBox));
                ErrMesg("File Select Window already open\n");
                return;
                }
        XtManageChild(fileBox);
        XtAddCallback(fileBox,XmNokCallback,CBFileSaveOk,(caddr_t)text);
        XtAddCallback(fileBox,XmNcancelCallback,CBFileSaveCancel,(caddr_t)text);
        fileBoxOpen = TRUE;
}





static void CBTextGotSelection(w,client_data,call_data)
/* Send Selection */
Widget w;
caddr_t client_data;
caddr_t call_data;
{
XmTextPosition left;
XmTextPosition right;
TextUI *text;

	if (textLock)
		return;
	text = (TextUI *) client_data;

	left = right = 0;
#ifdef DEBUG
        printf("Got Selection\n");
#endif
        XmTextGetSelectionPosition(text->textWin,&left,&right);
#ifdef DEBUG
        printf("left = %d, right = %d\n",left,right);
#endif
	if (text->ispub)
	{
		NetSendTextSelection(0,text->name,left,right);
	}
}


static void TextReceiveSelection(text,left,right)
/* Highlight area */
TextUI *text;
int left,right;
{
#ifdef DEBUG
        printf("Just received selection %d to %d for %s\n",left,right,text->name);
#endif
	if (!XtIsManaged(text->top))
		XtPopup(text->top,XtGrabNone);
		
        XmTextSetSelection(text->textWin,left,right,CurrentTime);

        /*
        XmTextSetHighlight(text->textWin,left,right,XmHIGHLIGHT_SELECTED);
        */

        XmTextSetInsertionPosition(text->textWin,right);
        XmTextShowPosition(text->textWin,right);
}


static void CBTextChangeVerify(w,client_data,tVerify)
Widget w;
caddr_t client_data;
XmTextVerifyCallbackStruct *tVerify;
{
TextUI *text;
Text t;

#ifdef DEBUG
	printf("CBTextChangeVerify(): I've been called \n");
#endif
	text = (TextUI *) client_data;
	if (text->selfModify) {
		tVerify->doit = True;
		return;
		}

	if (!(tVerify->reason == XmCR_MODIFYING_TEXT_VALUE)) {
#ifdef DEBUG
		printf("CBTextChangeVerify(): not modified, returning\n");
#endif
		return;
		}
#ifdef DEBUG
	printf("doit = %d\ncurrInsert=%d, newInsert= %d\nstartPos=%d endPos=%d\ntextBlockLength = %d \"%s\"\n", tVerify->doit,tVerify->currInsert,
		tVerify->newInsert,
		tVerify->startPos,tVerify->endPos,tVerify->text->length,
		tVerify->text->ptr);
#endif

	tVerify->doit = True;

	t.title = text->name;
	t.id = "me";
	t.selLeft = 0;
	t.selRight = 0;
	t.insertPt = tVerify->startPos;
	t.numReplace = ABS(tVerify->startPos - tVerify->endPos);
	t.replaceAll = 0;
	t.dim = tVerify->text->length;
	if (t.dim)
		t.textString = tVerify->text->ptr;
	else
		t.textString = (char *) 0;
	if (text->ispub)
	{
		NetSendText(0,&t,FALSE,TEXT_MODULE_NAME);
	}
}


TextUI *TextCreate(rootWidget,title,ispub)
Widget rootWidget;
char *title;
int ispub;
{
Arg argList[30];
Cardinal i=0;
TextUI	*text;
Widget pulldown, b;
Widget toolform, overlayform, paletteform;
Widget vscroll, hscroll;
XmString label;
View *V;
char tlab[256];

	if (!(V = (View *)MALLOC(sizeof(View))))
	{
		ErrMesg("Out of Memory\n");
		return(0);
	}
	V->type = V_TEXT;
	V->cData = NULL;

	if (!(text = (TextUI *) MALLOC(sizeof(TextUI)))) {
		ErrMesg("Out of Memory\n");
		return(0);
		}
	text->name = title;
	text->ispub = ispub;

	if (ispub == True)
	{
		sprintf(tlab, "Public %s", text->name);
	}
	else
	{
		sprintf(tlab, "Private %s", text->name);
	}


        i = 0;
        XtSetArg(argList[i], XmNallowShellResize, False); i++;
        XtSetArg(argList[i], XtNtitle, tlab); i++;
        XtSetArg(argList[i], XmNkeyboardFocusPolicy, XmPOINTER); i++;
        XtSetArg(argList[i], XmNdeleteResponse, XmUNMAP); i++;
        text->top = XtCreatePopupShell("Text", topLevelShellWidgetClass,
                                        rootWidget, argList, i);
        i=0;
        XtSetArg(argList[i],XmNwidth,600); i++;
        XtSetArg(argList[i],XmNheight,400); i++;
        XtSetArg(argList[i],XmNresizePolicy,XmRESIZE_GROW); i++;
	text->mainWindow = XmCreateForm(text->top,"Text",argList,i);
	XtManageChild(text->mainWindow);

        i=0;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
        text->menuBar= XmCreateMenuBar(text->mainWindow,0,argList,i);
        XtManageChild(text->menuBar);

	i=0;
        XtSetArg(argList[i],XmNorientation,XmVERTICAL); i++;
        text->pulldown[0] = XmCreatePulldownMenu(text->menuBar,"pulldown",
                                                        argList,i);

        i=0;
        label = XmStringCreateSimple("File");
        XtSetArg(argList[i],XmNsubMenuId,text->pulldown[0]); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        XtSetArg(argList[i],XmNmnemonic,'F'); i++;
        b = XmCreateCascadeButton(text->menuBar,0,argList,i);
        XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Publish");
        XtSetArg(argList[i], XmNmnemonic, 'u'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButtonGadget(text->pulldown[0],
		"menuButton", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBPublish, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

        i=0;
        label = XmStringCreateSimple("New");
        XtSetArg(argList[i],XmNmnemonic,'N'); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        text->button[0]= XmCreatePushButtonGadget(text->pulldown[0],
                                "menuButton",argList,i);
        XtAddCallback(text->button[0],XmNactivateCallback,CBTextNew,(caddr_t)text);
	XmStringFree(label);

        i=0;
        label = XmStringCreateSimple("Open...");
        XtSetArg(argList[i],XmNmnemonic,'O'); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        text->button[1]= XmCreatePushButtonGadget(text->pulldown[0],
                                "menuButton",argList,i);
        XtAddCallback(text->button[1],XmNactivateCallback,CBTextInclude,(caddr_t)text);
	XmStringFree(label);

        i=0;
        label = XmStringCreateSimple("Save As...");
        XtSetArg(argList[i],XmNmnemonic,'S'); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        text->button[2]= XmCreatePushButtonGadget(text->pulldown[0],
				"menuButton", argList,i);
        XtAddCallback(text->button[2],XmNactivateCallback,CBTextSave,(caddr_t)text);
	XmStringFree(label);

        i=0;
        label = XmStringCreateSimple("Print");
        XtSetArg(argList[i],XmNmnemonic,'P'); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        text->button[3]= XmCreatePushButtonGadget(text->pulldown[0],
				"menuButton", argList,i);
        XtAddCallback(text->button[3],XmNactivateCallback,CBTextPrint,(caddr_t)text);
	XmStringFree(label);

	i = 0;
	text->button[4] = XmCreateSeparator(text->pulldown[0],
                                "menuButton", argList,i);
	
        i=0;
        label = XmStringCreateSimple("Close Window");
        XtSetArg(argList[i],XmNmnemonic,'C'); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        text->button[5]= XmCreatePushButtonGadget(text->pulldown[0],
				"menuButton", argList,i);
        XtAddCallback(text->button[5],XmNactivateCallback,CBTextDone,(caddr_t)text);
        XtManageChildren(text->button,6);
	XmStringFree(label);

	/*
	 * Edit menu
	 */
	i = 0;
	XtSetArg(argList[i], XmNorientation, XmVERTICAL); i++;
	pulldown = XmCreatePulldownMenu(text->menuBar, "pulldown", argList, i);

	i = 0;
	label = XmStringCreateSimple("Edit");
        XtSetArg(argList[i], XmNsubMenuId, pulldown); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNmnemonic, 'E'); i++;
	b = XmCreateCascadeButton(text->menuBar, "viewer", argList, i);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Show Overlay");
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNmnemonic, 'S'); i++;
	XtSetArg(argList[i], XmNset, True); i++;
	XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
	b = XmCreateToggleButtonGadget(pulldown, "viewer", argList, i);
	XtAddCallback(b, XmNvalueChangedCallback, CBViewOverlay, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Clear Overlay");
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'l'); i++;
	b = XmCreatePushButtonGadget(pulldown, "viewer", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBClearDrawArea, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	b = XmCreateSeparator(pulldown, "separator", argList, i);
	XtManageChild(b);

	i = 0;
	label = XmStringCreateSimple("Copy");
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'C'); i++;
	b = XmCreatePushButtonGadget(pulldown, "viewer", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBGrabProc, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Paste");
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'P'); i++;
	b = XmCreatePushButtonGadget(pulldown, "viewer", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBSetPaste, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Paste (No Back)");
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'N'); i++;
	b = XmCreatePushButtonGadget(pulldown, "viewer", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBSetPasteNoBack, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

	/*
	 * Overlay menu
	 */
        V->optionMenu = (Widget) 0;
        V->operationMenu = (Widget) 0;

	/*
	 * Now is only Width menu
	 */
	V->optionMenu = InitOptions(V, text->menuBar);
	ListAddEntry(vList,V);

	/*
	 * InitOverlayTools sets up the toolbox and sets V->colorpal
	 */
	toolform = InitOverlayTools(V, text->mainWindow, text->menuBar,
		&overlayform, &paletteform);

        i=0;
        XtSetArg(argList[i],XmNtopWidget,text->menuBar); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_WIDGET); i++;
        XtSetArg(argList[i],XmNbottomAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
/*
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
*/
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, toolform); i++;
        XtSetArg(argList[i],XmNx,0); i++;
        XtSetArg(argList[i],XmNy,30); i++;

        XtSetArg(argList[i],XmNwidth,600); i++;
        XtSetArg(argList[i],XmNheight,365); i++;
/*
        XtSetArg(argList[i],XmNscrollVertical,True); i++;
        XtSetArg(argList[i],XmNscrollVertical,XmAUTOMATIC); i++;
*/
        XtSetArg(argList[i],XmNeditMode,XmMULTI_LINE_EDIT); i++;
	XtSetArg(argList[i],XmNeditable,True); i++;
	XtSetArg(argList[i],XmNoutputCreate,MyOutputCreate); i++;
	XtSetArg(argList[i],XmNuserData,(caddr_t)V); i++;
	text->textWin = XmCreateScrolledText(text->mainWindow,"Text",argList,i);
	XtManageChild(text->textWin);

	i=0;
	XtSetArg(argList[i],XmNverticalScrollBar,&vscroll); i++;
	XtSetArg(argList[i],XmNhorizontalScrollBar,&hscroll); i++;
	XtGetValues(XtParent(text->textWin),argList,i);

/*EJB
        XtAddCallback(vscroll, XmNdragCallback, CBTextScrollY,
			(caddr_t)V);
        XtAddCallback(vscroll, XmNdecrementCallback, CBTextScrollY,
			(caddr_t)V);
        XtAddCallback(vscroll, XmNincrementCallback, CBTextScrollY,
			(caddr_t)V);
        XtAddCallback(vscroll, XmNpageDecrementCallback, CBTextScrollY,
			(caddr_t)V);
        XtAddCallback(vscroll, XmNpageIncrementCallback, CBTextScrollY,
			(caddr_t)V);

        XtAddCallback(hscroll, XmNdragCallback, CBTextScrollX,
			(caddr_t)V);
        XtAddCallback(hscroll, XmNdecrementCallback, CBTextScrollX,
			(caddr_t)V);
        XtAddCallback(hscroll, XmNincrementCallback, CBTextScrollX,
			(caddr_t)V);
        XtAddCallback(hscroll, XmNpageDecrementCallback, CBTextScrollX,
			(caddr_t)V);
        XtAddCallback(hscroll, XmNpageIncrementCallback, CBTextScrollX,
			(caddr_t)V);
*/

        XtAddCallback(text->textWin, XmNmodifyVerifyCallback,
			CBTextChangeVerify, (caddr_t)text);
        XtAddCallback(text->textWin, XmNvalueChangedCallback,
			CBTextValueChange, (caddr_t)V);
/*EJB
        XtAddCallback(text->textWin, XmNactivateCallback,
			CBTextTest, (caddr_t)1);
*/

        XtAddEventHandler(text->textWin, ButtonReleaseMask, 0,
			CBTextGotSelection, (caddr_t)text);

	XtAddEventHandler(text->textWin, ExposureMask, 0, CBTextExposed,
				(caddr_t)V);
	XtAddEventHandler(text->textWin, ButtonPressMask, 0, CBDrawAreaPress,
				(caddr_t)V);
	XtAddEventHandler(text->textWin, ButtonMotionMask, 0, CBDrawAreaMove,
				(caddr_t)V);
	XtAddEventHandler(text->textWin,ButtonReleaseMask, 0, CBDrawAreaRelease,
				(caddr_t)V);
	XtAddEventHandler(text->textWin, KeyPressMask, 0, CBDrawAreaKeyPress,
				(caddr_t)V);

	V->shell = text->top;
	V->drawArea = text->textWin;
/*
	V->colorpal = (Widget)NULL;
*/
	V->toolform = toolform;
	V->palform = (Widget)NULL;
	V->rowwin = (Widget)NULL;
	V->colwin = (Widget)NULL;
	V->vscroll = vscroll;
	V->hscroll = hscroll;
	V->lastToggle = (Widget)NULL;
	V->cutbuffer = (XImage *)NULL;
	V->drawPix = (Pixmap)NULL;
	V->doodlePix = (Pixmap)NULL;
	V->isUp = False;
	V->viewOverlay = True;
	V->ispub = ispub;
	V->cData = (Cdata *)MALLOC(sizeof(Cdata));
	V->cData->name = (char *)MALLOC(strlen(title) + 1);
	strcpy(V->cData->name, title);
	V->cData->type = D_TEXT;
	V->cData->hasPalette = False;
	V->cData->ydim = 0;
	V->cData->V = V;
	ListAddEntry(objectList, V->cData);
#ifdef MAC_COMPAT
	if (strcmp(title, "Text") == 0)
	{
		RegisterPopup(V->shell, title, False, V);
	}
	else
	{
#endif /* MAC_COMPAT */
	RegisterData(V->cData);
#ifdef MAC_COMPAT
	}
#endif /* MAC_COMPAT */
	V->Mode = NONE;
#ifdef MAC_COMPAT
	V->doodleWidth = 5;
#else
	V->doodleWidth = 5;
#endif /* MAC_COMPAT */
	V->doodleColor = 254;
	V->next = NULL;
	V->Scroll_x = 0;
	V->Scroll_y = 0;

	V->Doodles = InitDHash();


#ifdef DEBUG
	printf("TextCreate():Text widget is %x\n",text->textWin);
#endif

	text->selfModify = FALSE;

	ListAddEntry(textList,text);

	TextLock(textLock);
	return (text);

} /* TextCreate() */


void TextReceiveMessage(t)
Text *t; /* the contents of *t is assumed to dissappear after return */
{
TextUI *text;
char new;


	new = FALSE;
	if (!(text = TextSearchByName(t->title))) {
		if (outP == NULL)
		{
			text = TextCreate(rootWidget,t->title,0);
		}
		else
		{
			text = TextCreate(rootWidget,t->title,1);
		}
		new= TRUE;
		if (!text)
			return; 
		if (!(text->name = (char *) MALLOC(strlen(t->title)+1))) {
			ErrMesg("Out of Memory getting new text\n");
			return;
			}
		strcpy(text->name,t->title);
		}

#ifdef DEBUG
	printf("TextReceiveMessage():Text widget is %x\n",text->textWin);
#endif

	text->selfModify = TRUE;
	t->textString[t->dim] = '\0';
#ifdef DEBUG
	printf("TextReceiveMessage(): insertPt = %d,numReplace = %d,\n",
			t->insertPt,t->numReplace); 
	printf("	replaceAll = %d: dim = %d: textString = %s\n",
		t->replaceAll,t->dim,t->textString);
#endif
	if (t->selLeft || t->selRight) {
		TextReceiveSelection(text,t->selLeft,t->selRight);
		}
	if (t->dim)  {
		if (t->replaceAll) {
#ifdef DEBUG
			printf("Replacing all\n");
#endif
			XmTextSetString(text->textWin,t->textString);
			if (new)
				XtPopup(text->top,XtGrabNone);
			else if (!XtIsManaged(text->top))
				XtPopup(text->top,XtGrabNone);
			text->selfModify = FALSE;
			return;
			}
		else {
#ifdef DEBUG
			printf("XmTextReplace(_,%d,%d,%s)\n",
					t->insertPt,
					t->insertPt + t->numReplace,
       	                                 t->textString);
#endif

			if (t->numReplace) {
				XmTextReplace(text->textWin,t->insertPt,
						t->insertPt + t->numReplace,
						t->textString);
				TextReceiveSelection(text,
					t->insertPt,t->insertPt);
				}
			else {
				XmTextInsert(text->textWin,t->insertPt,
						t->textString);
				}
			if (!XtIsManaged(text->top))
				XtPopup(text->top,XtGrabNone);
			}
		}
	else {
		if (t->numReplace) {/* it's a delete */
			XmTextReplace(text->textWin,t->insertPt,
					t->insertPt + t->numReplace, 0);
			}
		}

	text->selfModify = FALSE;
		
}

void TextNew(t,garbage)
Text *t;
int garbage;
{
	TextReceiveMessage(t);
}


void TextChange(t,garbage)
Text *t;
int garbage;
{
	TextReceiveMessage(t);
}

void TextDestroy(t,garbage)
Text *t;
int garbage;
{

}

	
TextInit(root)
Widget root;
{
TextUI *text;
Arg argList[10];

	textList = ListCreate();

	rootWidget = root;

        fileBox =  XmCreateFileSelectionDialog(rootWidget,"fileSelectionBox",
                        argList,0);
        fileBoxOpen = FALSE;


}


void
CBNewText(w, client_data, call_data)
        Widget w;
        caddr_t client_data, call_data;
{
	NewTextWindow();
}

