#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

char *createndf(FILE **fp, char *file, int nx, int ny, int nz)
{
  char *ndffile = file;
  
  if (!file) {
    int lenp=0;
    char *p = getenv("TMPDIR");
    if (p) lenp = strlen(p);
    ndffile = (char *)malloc((20 + lenp) * sizeof(*ndffile));
    sprintf(ndffile,"%s/__pid%d.ndf",
	    p?p:".",
	    getpid());
  }

  *fp = fopen(ndffile,"w");
  fprintf(*fp,"%d %d %d\n",nx,ny,nz);

  return ndffile;
}


int appendndf(FILE *fp, int startproc, int endproc, char *machine,
	      char *a_out, char *all_args)
{
  fprintf(fp,"%d-%d %s %s %s\n",startproc,endproc,machine,a_out,all_args);
  return (endproc - startproc + 1);
}

