      PROGRAM P114
C
C      PROGRAM 11.4 FORCED VIBRATION OF A RECTANGULAR
C      ELASTO-PLASTIC SOLID IN PLANE STRAIN USING 8-NODE
C      QUADRILATERAL ELEMENTS:LUMPED MASS:EXPLICIT INTEGRATION
C
C      ALTER NEXT LINE TO CHANGE PROBLEM SIZE
C
      PARAMETER (ILOADS=1000,INX=20,INY=20,INO=20,INF=50)
C
      DOUBLE PRECISION AA
      DOUBLE PRECISION BB
      DOUBLE PRECISION RHO
      DOUBLE PRECISION E
      DOUBLE PRECISION V
      DOUBLE PRECISION SBARY
      DOUBLE PRECISION PLOAD
      DOUBLE PRECISION DTIM
      DOUBLE PRECISION TIM
      DOUBLE PRECISION AREA
      DOUBLE PRECISION DET
      DOUBLE PRECISION QUOT
      DOUBLE PRECISION SIGM
      DOUBLE PRECISION DSBAR
      DOUBLE PRECISION THETA
      DOUBLE PRECISION FNEW
      DOUBLE PRECISION SBAR
      DOUBLE PRECISION F
      DOUBLE PRECISION FAC
      DOUBLE PRECISION DEE(4,4),PL(4,4),SAMP(3,2),COORD(8,2),JAC(2,2),
     +                 JAC1(2,2),DER(2,8),DERIV(2,8),BEE(4,16),ELD(16),
     +                 FUN(8),EMM(16),STRESS(4),EPS(4),SIGMA(4),
     +                 BT(16,4),ELOAD(16),BLOAD(16),VAL(INO),X1(ILOADS),
     +                 D1X1(ILOADS),D2X1(ILOADS),MM(ILOADS),
     +                 BDYLDS(ILOADS),SX(INX,INY,4),SY(INX,INY,4),
     +                 TXY(INX,INY,4),SZ(INX,INY,4),EX(INX,INY,4),
     +                 EY(INX,INY,4),GXY(INX,INY,4),EZ(INX,INY,4)
      INTEGER G(16),NO(INO),NF(INF,2)
      DATA IDEE,IBEE,IH/3*4/,IJAC,IJAC1,IDER,IDERIV,NODOF,IT/6*2/
      DATA ICOORD,NOD/2*8/,IBT,IDOF/2*16/,ISAMP/3/
C
C      INPUT AND INITIALISATION
C
      READ (5,FMT=*) NXE,NYE,N,NN,NR,NGP,AA,BB,RHO,E,V,SBARY,PLOAD,DTIM,
     +  ISTEP,NPRI
      CALL READNF(NF,INF,NN,NODOF,NR)
      READ (5,FMT=*) NL, (NO(I),VAL(I),I=1,NL)
      IGTOT = NGP*NGP
      CALL NULL3(SX,INX,INY,NXE,NYE,IGTOT)
      CALL NULL3(SY,INX,INY,NXE,NYE,IGTOT)
      CALL NULL3(TXY,INX,INY,NXE,NYE,IGTOT)
      CALL NULL3(SZ,INX,INY,NXE,NYE,IGTOT)
      CALL NULL3(EX,INX,INY,NXE,NYE,IGTOT)
      CALL NULL3(EY,INX,INY,NXE,NYE,IGTOT)
      CALL NULL3(GXY,INX,INY,NXE,NYE,IGTOT)
      CALL NULL3(EZ,INX,INY,NXE,NYE,IGTOT)
      CALL NULVEC(X1,N)
      CALL NULVEC(D1X1,N)
      CALL NULVEC(D2X1,N)
      CALL NULVEC(MM,N)
      CALL GAUSS(SAMP,ISAMP,NGP)
C
C      EXPLICIT INTEGRATION LOOP
C
      TIM = 0.D0
      WRITE (6,FMT=1000) TIM,X1(50),D1X1(50),D2X1(50)
      DO 10 JJ = 1,ISTEP
          TIM = TIM + DTIM
C
C      APPLIED LOAD
C
          DO 20 I = 1,N
   20     X1(I) = X1(I) + (D1X1(I)+D2X1(I)*DTIM*.5D0)*DTIM
          CALL NULVEC(BDYLDS,N)
C
C      FORM ELEMENT STRAIN-DISPLACEMENT RELATIONSHIPS
C
          DO 30 IP = 1,NXE
              DO 30 IQ = 1,NYE
                  AREA = .0D0
                  CALL NULVEC(BLOAD,IDOF)
                  CALL GEOM8X(IP,IQ,NXE,AA,BB,COORD,ICOORD,G,NF,INF)
                  DO 40 M = 1,IDOF
                      IF (G(M).EQ.0) ELD(M) = 0.0D0
   40             IF (G(M).NE.0) ELD(M) = X1(G(M))
                  IG = 0
                  DO 50 I = 1,NGP
                      DO 50 J = 1,NGP
                          IG = IG + 1
                          CALL NULL(DEE,IDEE,IH,IH)
                          CALL FMDRAD(DEE,IDEE,E,V)
                          CALL FMQUAD(DER,IDER,FUN,SAMP,ISAMP,I,J)
                          CALL MATMUL(DER,IDER,COORD,ICOORD,JAC,IJAC,IT,
     +                                NOD,IT)
                          CALL TWOBY2(JAC,IJAC,JAC1,IJAC1,DET)
                          CALL MATMUL(JAC1,IJAC1,DER,IDER,DERIV,IDERIV,
     +                                IT,IT,NOD)
                          CALL NULL(BEE,IBEE,IH,IDOF)
                          CALL FORMB(BEE,IBEE,DERIV,IDERIV,NOD)
                          QUOT = DET*SAMP(I,2)*SAMP(J,2)
                          AREA = AREA + QUOT*RHO
                          CALL MVMULT(BEE,IBEE,ELD,IH,IDOF,EPS)
                          EPS(1) = EPS(1) - EX(IP,IQ,IG)
                          EPS(2) = EPS(2) - EY(IP,IQ,IG)
                          EPS(3) = EPS(3) - GXY(IP,IQ,IG)
                          EPS(4) = EPS(4) - EZ(IP,IQ,IG)
                          CALL MVMULT(DEE,IDEE,EPS,IH,IH,SIGMA)
                          STRESS(1) = SIGMA(1) + SX(IP,IQ,IG)
                          STRESS(2) = SIGMA(2) + SY(IP,IQ,IG)
                          STRESS(3) = SIGMA(3) + TXY(IP,IQ,IG)
                          STRESS(4) = SIGMA(4) + SZ(IP,IQ,IG)
                          CALL INVAR(STRESS,SIGM,DSBAR,THETA)
                          FNEW = DSBAR - SBARY
C
C      CHECK WHETHER YIELD IS VIOLATED
C
                          IF (FNEW.LT.0.D0) GO TO 70
                          STRESS(1) = SX(IP,IQ,IG)
                          STRESS(2) = SY(IP,IQ,IG)
                          STRESS(3) = TXY(IP,IQ,IG)
                          STRESS(4) = SZ(IP,IQ,IG)
                          CALL INVAR(STRESS,SIGM,SBAR,THETA)
                          F = SBAR - SBARY
                          FAC = FNEW/ (FNEW-F)
                          STRESS(1) = SX(IP,IQ,IG) + (1.D0-FAC)*SIGMA(1)
                          STRESS(2) = SY(IP,IQ,IG) + (1.D0-FAC)*SIGMA(2)
                          STRESS(3) = TXY(IP,IQ,IG) +
     +                                (1.D0-FAC)*SIGMA(3)
                          STRESS(4) = SZ(IP,IQ,IG) + (1.D0-FAC)*SIGMA(4)
                          CALL VMPL(E,V,STRESS,PL)
                          DO 60 K = 1,IH
                              DO 60 L = 1,IH
   60                     DEE(K,L) = DEE(K,L) - FAC*PL(K,L)
   70                     CALL MVMULT(DEE,IDEE,EPS,IH,IH,SIGMA)
                          SIGMA(1) = SIGMA(1) + SX(IP,IQ,IG)
                          SIGMA(2) = SIGMA(2) + SY(IP,IQ,IG)
                          SIGMA(3) = SIGMA(3) + TXY(IP,IQ,IG)
                          SIGMA(4) = SIGMA(4) + SZ(IP,IQ,IG)
                          CALL MATRAN(BT,IBT,BEE,IBEE,IH,IDOF)
                          CALL MVMULT(BT,IBT,SIGMA,IDOF,IH,ELOAD)
                          DO 80 K = 1,IDOF
   80                     BLOAD(K) = BLOAD(K) + ELOAD(K)*QUOT
C
C      UPDATE GAUSS POINT STRESSES AND STRAINS
C
                          SX(IP,IQ,IG) = SIGMA(1)
                          SY(IP,IQ,IG) = SIGMA(2)
                          TXY(IP,IQ,IG) = SIGMA(3)
                          SZ(IP,IQ,IG) = SIGMA(4)
                          EX(IP,IQ,IG) = EX(IP,IQ,IG) + EPS(1)
                          EY(IP,IQ,IG) = EY(IP,IQ,IG) + EPS(2)
                          GXY(IP,IQ,IG) = GXY(IP,IQ,IG) + EPS(3)
                          EZ(IP,IQ,IG) = EZ(IP,IQ,IG) + EPS(4)
   50             CONTINUE
                  DO 90 M = 1,IDOF
                      IF (G(M).EQ.0) GO TO 90
                      BDYLDS(G(M)) = BDYLDS(G(M)) - BLOAD(M)
   90             CONTINUE
                  IF (JJ.NE.1) GO TO 30
C
C      FORM LUMPED MASS MATRIX
C
                  DO 100 I = 1,IDOF
  100             EMM(I) = .2D0*AREA
                  DO 110 I = 1,13,4
  110             EMM(I) = .05D0*AREA
                  DO 120 I = 2,14,4
  120             EMM(I) = .05D0*AREA
                  DO 130 I = 1,IDOF
  130             IF (G(I).NE.0) MM(G(I)) = MM(G(I)) + EMM(I)
   30     CONTINUE
          DO 140 I = 1,NL
  140     BDYLDS(NO(I)) = BDYLDS(NO(I)) + VAL(I)*PLOAD
          DO 150 I = 1,N
              BDYLDS(I) = BDYLDS(I)/MM(I)
              D1X1(I) = D1X1(I) + (D2X1(I)+BDYLDS(I))*.5D0*DTIM
  150     D2X1(I) = BDYLDS(I)
          IF (JJ.EQ.JJ/NPRI*NPRI) WRITE (6,FMT=1000) TIM,X1(50),
     +        D1X1(50),D2X1(50)
   10 CONTINUE

 1000 FORMAT (4D12.4)

      STOP

      END
