#! /bin/sh -e
#########################################################################
# Script to take the output of 'xalparse' and put it into a form	#
# suitable for building alias files with non-local aliases, and with	#
# the improved IDA-1.4.1 configuration which implements the new		#
# method.								#
#									#
# Note.  This assumes that MAILERTABLE has an entry:			#
# LOCAL!localhost	new.aliases.uucp				#
# (where new.aliases.uucp represents the $DUMMY defined below).		#
#########################################################################

# The location of the program.
XALPARSE=/usr/lib/mail/xalparse
# Name of dummy domain for non-local aliases.
DUMMY=al.ias.UUCP
# Define names of scratch files.
ALIAS=/tmp/ALIAS.$$
GENERIC=/tmp/GENERIC.$$
#
#
if [ $# != 3 ] ; then
	echo "Syntax: $0 sourcefile aliasfile genericsfile"
	exit 1
fi
#
$XALPARSE $1 $ALIAS $GENERIC
cat - << EOF > $2
### This file built by xalparse from sourcefile $1
###
### WARNING: DO NOT EDIT THIS FILE
###
### Your changes will go away.  Instead edit the sourcefile.
###
EOF

cat $2 $GENERIC > $3

sed 's/^\([^:]*\)@\(.*\):/\1%\2@'$DUMMY:/   $ALIAS >> $2

rm -f $ALIAS $GENERIC
