/**
 * SPDX-FileCopyrightText: 2020-2023 Osimis S.A., 2024-2025 Orthanc Team SRL, 2021-2025 Sebastien Jodogne, ICTEAM UCLouvain
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */

/**
 * Python plugin for Orthanc
 * Copyright (C) 2020-2023 Osimis S.A., Belgium
 * Copyright (C) 2024-2025 Orthanc Team SRL, Belgium
 * Copyright (C) 2021-2025 Sebastien Jodogne, ICTEAM UCLouvain, Belgium
 *
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 **/


// WARNING: Auto-generated file. Do not modify it by hand.


// Forward declaration of the autogenerated methods
static PyObject *sdk_OrthancPluginRestOutput_OrthancPluginAnswerBuffer(
  sdk_OrthancPluginRestOutput_Object* self, PyObject *args);
static PyObject *sdk_OrthancPluginRestOutput_OrthancPluginCompressAndAnswerPngImage(
  sdk_OrthancPluginRestOutput_Object* self, PyObject *args);
static PyObject *sdk_OrthancPluginRestOutput_OrthancPluginRedirect(
  sdk_OrthancPluginRestOutput_Object* self, PyObject *args);
static PyObject *sdk_OrthancPluginRestOutput_OrthancPluginSendHttpStatusCode(
  sdk_OrthancPluginRestOutput_Object* self, PyObject *args);
static PyObject *sdk_OrthancPluginRestOutput_OrthancPluginSendUnauthorized(
  sdk_OrthancPluginRestOutput_Object* self, PyObject *args);
static PyObject *sdk_OrthancPluginRestOutput_OrthancPluginSendMethodNotAllowed(
  sdk_OrthancPluginRestOutput_Object* self, PyObject *args);
static PyObject *sdk_OrthancPluginRestOutput_OrthancPluginSetCookie(
  sdk_OrthancPluginRestOutput_Object* self, PyObject *args);
static PyObject *sdk_OrthancPluginRestOutput_OrthancPluginSetHttpHeader(
  sdk_OrthancPluginRestOutput_Object* self, PyObject *args);
static PyObject *sdk_OrthancPluginRestOutput_OrthancPluginStartMultipartAnswer(
  sdk_OrthancPluginRestOutput_Object* self, PyObject *args);
static PyObject *sdk_OrthancPluginRestOutput_OrthancPluginSendMultipartItem(
  sdk_OrthancPluginRestOutput_Object* self, PyObject *args);
static PyObject *sdk_OrthancPluginRestOutput_OrthancPluginSendHttpStatus(
  sdk_OrthancPluginRestOutput_Object* self, PyObject *args);
static PyObject *sdk_OrthancPluginRestOutput_OrthancPluginCompressAndAnswerJpegImage(
  sdk_OrthancPluginRestOutput_Object* self, PyObject *args);
static PyObject *sdk_OrthancPluginRestOutput_OrthancPluginSetHttpErrorDetails(
  sdk_OrthancPluginRestOutput_Object* self, PyObject *args);
static PyObject *sdk_OrthancPluginRestOutput_OrthancPluginStartStreamAnswer(
  sdk_OrthancPluginRestOutput_Object* self, PyObject *args);
static PyObject *sdk_OrthancPluginRestOutput_OrthancPluginSendStreamChunk(
  sdk_OrthancPluginRestOutput_Object* self, PyObject *args);
// End of forward declarations


// Forward declaration of the custom methods
// End of forward declarations


static PyMethodDef sdk_OrthancPluginRestOutput_Methods[] = {
  { "AnswerBuffer",
    (PyCFunction) sdk_OrthancPluginRestOutput_OrthancPluginAnswerBuffer, METH_VARARGS,
    "Generated from C function OrthancPluginAnswerBuffer()" },
  { "CompressAndAnswerPngImage",
    (PyCFunction) sdk_OrthancPluginRestOutput_OrthancPluginCompressAndAnswerPngImage, METH_VARARGS,
    "Generated from C function OrthancPluginCompressAndAnswerPngImage()" },
  { "Redirect",
    (PyCFunction) sdk_OrthancPluginRestOutput_OrthancPluginRedirect, METH_VARARGS,
    "Generated from C function OrthancPluginRedirect()" },
  { "SendHttpStatusCode",
    (PyCFunction) sdk_OrthancPluginRestOutput_OrthancPluginSendHttpStatusCode, METH_VARARGS,
    "Generated from C function OrthancPluginSendHttpStatusCode()" },
  { "SendUnauthorized",
    (PyCFunction) sdk_OrthancPluginRestOutput_OrthancPluginSendUnauthorized, METH_VARARGS,
    "Generated from C function OrthancPluginSendUnauthorized()" },
  { "SendMethodNotAllowed",
    (PyCFunction) sdk_OrthancPluginRestOutput_OrthancPluginSendMethodNotAllowed, METH_VARARGS,
    "Generated from C function OrthancPluginSendMethodNotAllowed()" },
  { "SetCookie",
    (PyCFunction) sdk_OrthancPluginRestOutput_OrthancPluginSetCookie, METH_VARARGS,
    "Generated from C function OrthancPluginSetCookie()" },
  { "SetHttpHeader",
    (PyCFunction) sdk_OrthancPluginRestOutput_OrthancPluginSetHttpHeader, METH_VARARGS,
    "Generated from C function OrthancPluginSetHttpHeader()" },
  { "StartMultipartAnswer",
    (PyCFunction) sdk_OrthancPluginRestOutput_OrthancPluginStartMultipartAnswer, METH_VARARGS,
    "Generated from C function OrthancPluginStartMultipartAnswer()" },
  { "SendMultipartItem",
    (PyCFunction) sdk_OrthancPluginRestOutput_OrthancPluginSendMultipartItem, METH_VARARGS,
    "Generated from C function OrthancPluginSendMultipartItem()" },
  { "SendHttpStatus",
    (PyCFunction) sdk_OrthancPluginRestOutput_OrthancPluginSendHttpStatus, METH_VARARGS,
    "Generated from C function OrthancPluginSendHttpStatus()" },
  { "CompressAndAnswerJpegImage",
    (PyCFunction) sdk_OrthancPluginRestOutput_OrthancPluginCompressAndAnswerJpegImage, METH_VARARGS,
    "Generated from C function OrthancPluginCompressAndAnswerJpegImage()" },
  { "SetHttpErrorDetails",
    (PyCFunction) sdk_OrthancPluginRestOutput_OrthancPluginSetHttpErrorDetails, METH_VARARGS,
    "Generated from C function OrthancPluginSetHttpErrorDetails()" },
  { "StartStreamAnswer",
    (PyCFunction) sdk_OrthancPluginRestOutput_OrthancPluginStartStreamAnswer, METH_VARARGS,
    "Generated from C function OrthancPluginStartStreamAnswer()" },
  { "SendStreamChunk",
    (PyCFunction) sdk_OrthancPluginRestOutput_OrthancPluginSendStreamChunk, METH_VARARGS,
    "Generated from C function OrthancPluginSendStreamChunk()" },
  { NULL }  /* Sentinel */
};


static int sdk_OrthancPluginRestOutput_Constructor(
  sdk_OrthancPluginRestOutput_Object *self, PyObject *args, PyObject *kwds)
{
  PythonLock::LogCall("Creating Python object of class OrthancPluginRestOutput");

  self->object_ = NULL;
  self->borrowed_ = false;
  
  long long object = 0;
  unsigned char borrowed = false;
  
  if (PyArg_ParseTuple(args, "Lb", &object, &borrowed))
  {
    self->object_ = reinterpret_cast<OrthancPluginRestOutput*>(static_cast<intptr_t>(object));
    self->borrowed_ = borrowed;
    return 0;
  }
  else
  {
    PyErr_SetString(PyExc_ValueError, "Expected a pair (pointer, borrowed) in the constructor");
    return -1;
  }
}


/**
 * Static global structure => the fields that are beyond the last
 * initialized field are set to zero.
 * https://stackoverflow.com/a/11152199/881731
 **/
static PyTypeObject sdk_OrthancPluginRestOutput_Type = {
  PyVarObject_HEAD_INIT(NULL, 0)
  "orthanc.RestOutput",    /* tp_name */
  sizeof(sdk_OrthancPluginRestOutput_Object), /* tp_basicsize */
};




static void RegisterOrthancPluginRestOutputClass(PyObject* module)
{
  sdk_OrthancPluginRestOutput_Type.tp_new = PyType_GenericNew;
  sdk_OrthancPluginRestOutput_Type.tp_flags = Py_TPFLAGS_DEFAULT;
  sdk_OrthancPluginRestOutput_Type.tp_doc = "Generated from Orthanc C class: OrthancPluginRestOutput";
  sdk_OrthancPluginRestOutput_Type.tp_methods = sdk_OrthancPluginRestOutput_Methods;
  sdk_OrthancPluginRestOutput_Type.tp_init = (initproc) sdk_OrthancPluginRestOutput_Constructor;

  
  if (PyType_Ready(&sdk_OrthancPluginRestOutput_Type) < 0)
  {
    ORTHANC_PLUGINS_LOG_ERROR("Cannot register Python class: OrthancPluginRestOutput");
    ORTHANC_PLUGINS_THROW_EXCEPTION(InternalError);
  }

  Py_INCREF(&sdk_OrthancPluginRestOutput_Type);
  if (PyModule_AddObject(module, "RestOutput", (PyObject *)&sdk_OrthancPluginRestOutput_Type) < 0)
  {
    ORTHANC_PLUGINS_LOG_ERROR("Cannot register Python class: OrthancPluginRestOutput");
    Py_DECREF(&sdk_OrthancPluginRestOutput_Type);
    ORTHANC_PLUGINS_THROW_EXCEPTION(InternalError);
  }
}


PyTypeObject* GetOrthancPluginRestOutputType()
{
  return &sdk_OrthancPluginRestOutput_Type;
}
