# Pacemaker Documentation

Pacemaker has multiple forms of documentation:

* The primary end-user documentation is a series of "books":

    * Clusters From Scratch: Simplified walk-through of setting up a
      cluster for the first time
    * Pacemaker Administration: Tips for managing a cluster
    * Pacemaker Development: How to work on the Pacemaker code base
    * Pacemaker Explained: Configuration reference guide
    * Pacemaker Remote: Configuration and walk-throughs for extended
      clusters

  The source for these is kept beneath this directory. Generated versions
  are available online in epub, PDF, and HTML format at:

    https://clusterlabs.org/pacemaker/doc/

* Annotated source code in HTML format can be generated by running
  "make global" in this directory, which requires the gtags and htags tools.
  This is generated for releases and can be viewed online at:

    https://clusterlabs.org/pacemaker/global/

* Pacemaker manual pages are generated and installed automatically when
  building the software. HTML versions can be generated by running
  "make manhtml" in this directory, which requires the groff tool.
  This is generated for releases and can be viewed online at:

    https://clusterlabs.org/pacemaker/man/

* For developers, documentation for Pacemaker's public C API is generated
  by running "make doxygen" in this directory, which requires the doxygen tool.
  This is generated for releases and can be viewed online at:

    https://clusterlabs.org/pacemaker/doxygen/

* Also for developers, a report of Pacemaker ABI compatibility between any two
  commits can be generated by running in this directory:

    make LAST_RELEASE=$EARLIER_COMMIT TAG=$NEWER_COMMIT abi-www

  which requires the abi-compliance-checker tool. This is generated for each
  release compared to the previous release and can be viewed online at:

    https://clusterlabs.org/pacemaker/abi/

* In addition, there are a few old text files in this directory focusing on
  particular characteristics of Pacemaker clusters. These are mostly outdated
  but do still have some useful information. The plan is to incorporate an
  updated version of them into the books.

## Editing the Books

We are currently transitioning from using Publican to Sphinx
to generate the books.

### Publican

Each book has a subdirectory by book title, containing a en-US subdirectory.

Each book's en-US directory has .txt files, which are the chapter sources in
asciidoc format. The file asciidoc.reference in this directory has a quick
guide to asciidoc; search online for more detailed help.

Once you have edited the asciidoc as desired, run "make" in this directory
to generate all the books locally. You can view the results by pointing your
web browser to (replacing BOOK\_TITLE appropriately):

    file:///path/to/checkout/doc/BOOK_TITLE/publish/

Each en-US subdirectory also contains some raw XML files of lesser interest:

* Author\_Group.xml: This contains the author listing at the top of the
  generated book. To avoid clutter, we just put "Pacemaker project
  contributors" here and list individual authors in the revision history, so
  this typically does not need to be edited.
* Book\_Info.xml: Revision numbers, etc. This is generally updated only for
  official releases.
* Revision\_History.xml: This can be updated for any change, listing the
  individual authors.

### Sphinx

There is a sphinx subdirectory here with a subdirectory for each book by title.
Each book's directory contains .rst files, which are the chapter sources in
reStructuredText format (with index.rst as the starting point).

Once you have edited the sources as desired, run "make" in the sphinx
subdirectory to generate all the books locally. You can view the results by
pointing your web browser to (replacing PATH\_TO\_CHECKOUT and BOOK\_TITLE
appropriately):

    file:///PATH_TO_CHECKOUT/doc/sphinx/BOOK_TITLE/_build/html/index.html

See the comments at the top of doc/sphinx/Makefile.am for various options you
can use. For a guide to sphinx-flavored reStructuredText, see:

    https://www.sphinx-doc.org/en/master/usage/restructuredtext/
