/*-
 * Copyright (c) 2009 Marius Strobl <marius@FreeBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/8/sys/sparc64/pci/firereg.h 233812 2012-04-02 20:14:40Z marius $
 */

#ifndef _SPARC64_PCI_FIREREG_H_
#define	_SPARC64_PCI_FIREREG_H_

#define	FIRE_NINTR				3	/* 2 OFW + 1 MSIq */
#define	FIRE_NRANGE				4
#define	FIRE_NREG				2

#define	FIRE_PCI				0
#define	FIRE_CTRL				1

/* PCI configuration and status registers */
#define	FO_PCI_INT_MAP_BASE			0x01000
#define	FO_PCI_INT_CLR_BASE			0x01400
#define	FO_PCI_EQ_BASE_ADDR			0x10000
#define	FO_PCI_EQ_CTRL_SET_BASE			0x11000
#define	FO_PCI_EQ_CTRL_CLR_BASE			0x11200
#define	FO_PCI_EQ_TL_BASE			0x11600
#define	FO_PCI_EQ_HD_BASE			0x11800
#define	FO_PCI_MSI_MAP_BASE			0x20000
#define	FO_PCI_MSI_CLR_BASE			0x28000
#define	FO_PCI_ERR_COR				0x30000
#define	FO_PCI_ERR_NONFATAL			0x30008
#define	FO_PCI_ERR_FATAL			0x30010
#define	FO_PCI_PM_PME				0x30018
#define	FO_PCI_PME_TO_ACK			0x30020
#define	FO_PCI_IMU_INT_EN			0x31008
#define	FO_PCI_IMU_INT_STAT			0x31010
#define	FO_PCI_IMU_ERR_STAT_CLR			0x31018
#define	FO_PCI_IMU_RDS_ERR_LOG			0x31028
#define	FO_PCI_IMU_SCS_ERR_LOG			0x31030
#define	FO_PCI_IMU_EQS_ERR_LOG			0x31038
#define	FO_PCI_DMC_CORE_BLOCK_INT_EN		0x31800
#define	FO_PCI_DMC_CORE_BLOCK_ERR_STAT		0x31808
#define	FO_PCI_MULTI_CORE_ERR_STAT		0x31810
#define	FO_PCI_MSI_32_BIT_ADDR			0x34000
#define	FO_PCI_MSI_64_BIT_ADDR			0x34008
#define	FO_PCI_MMU				0x40000
#define	FO_PCI_MMU_INT_EN			0x41008
#define	FO_PCI_MMU_INT_STAT			0x41010
#define	FO_PCI_MMU_ERR_STAT_CLR			0x41018
#define	FO_PCI_MMU_TRANS_FAULT_ADDR		0x41028
#define	FO_PCI_MMU_TRANS_FAULT_STAT		0x41030
#define	FO_PCI_ILU_INT_EN			0x51008
#define	FO_PCI_ILU_INT_STAT			0x51010
#define	FO_PCI_ILU_ERR_STAT_CLR			0x51018
#define	FO_PCI_DMC_DBG_SEL_PORTA		0x53000
#define	FO_PCI_DMC_DBG_SEL_PORTB		0x53008
#define	FO_PCI_PEC_CORE_BLOCK_INT_EN		0x51800
#define	FO_PCI_PEC_CORE_BLOCK_INT_STAT		0x51808
#define	FO_PCI_TLU_CTRL				0x80000
#define	FO_PCI_TLU_OEVENT_INT_EN		0x81008
#define	FO_PCI_TLU_OEVENT_INT_STAT		0x81010
#define	FO_PCI_TLU_OEVENT_STAT_CLR		0x81018
#define	FO_PCI_TLU_RX_OEVENT_HDR1_LOG		0x81028
#define	FO_PCI_TLU_RX_OEVENT_HDR2_LOG		0x81030
#define	FO_PCI_TLU_TX_OEVENT_HDR1_LOG		0x81038
#define	FO_PCI_TLU_TX_OEVENT_HDR2_LOG		0x81040
#define	FO_PCI_TLU_DEV_CTRL			0x90008
#define	FO_PCI_TLU_LNK_CTRL			0x90020
#define	FO_PCI_TLU_LNK_STAT			0x90028
#define	FO_PCI_TLU_UERR_INT_EN			0x91008
#define	FO_PCI_TLU_UERR_INT_STAT		0x91010
#define	FO_PCI_TLU_UERR_STAT_CLR		0x91018
#define	FO_PCI_TLU_RX_UERR_HDR1_LOG		0x91028
#define	FO_PCI_TLU_RX_UERR_HDR2_LOG		0x91030
#define	FO_PCI_TLU_TX_UERR_HDR1_LOG		0x91038
#define	FO_PCI_TLU_TX_UERR_HDR2_LOG		0x91040
#define	FO_PCI_TLU_CERR_INT_EN			0xa1008
#define	FO_PCI_TLU_CERR_INT_STAT		0xa1010
#define	FO_PCI_TLU_CERR_STAT_CLR		0xa1018
#define	FO_PCI_LPU_RST				0xe2008
#define	FO_PCI_LPU_INT_STAT			0xe2040
#define	FO_PCI_LPU_INT_MASK			0xe0248
#define	FO_PCI_LPU_LNK_LYR_CFG			0xe2200
#define	FO_PCI_LPU_LNK_LYR_INT_STAT		0xe2210
#define	FO_PCI_LPU_FLW_CTRL_UPDT_CTRL		0xe2240
#define	FO_PCI_LPU_TXLNK_FREQ_LAT_TMR_THRS	0xe2400
#define	FO_PCI_LPU_TXLNK_RPLY_TMR_THRS		0xe2410
#define	FO_PCI_LPU_TXLNK_RTR_FIFO_PTR		0xe2430
#define	FO_PCI_LPU_PHY_LYR_INT_STAT		0xe2610
#define	FO_PCI_LPU_LTSSM_CFG2			0xe2788
#define	FO_PCI_LPU_LTSSM_CFG3			0xe2790
#define	FO_PCI_LPU_LTSSM_CFG4			0xe2798
#define	FO_PCI_LPU_LTSSM_CFG5			0xe27a0

/* PCI interrupt mapping registers */
#define	FO_PCI_IMAP_MDO_MODE			0x8000000000000000ULL
#define	FO_PCI_IMAP_V				0x0000000080000000ULL
#define	FIRE_PCI_IMAP_T_JPID_MASK		0x000000007c000000ULL
#define	FIRE_PCI_IMAP_T_JPID_SHFT		26
#define	OBERON_PCI_IMAP_T_DESTID_MASK		0x000000007fe00000ULL
#define	OBERON_PCI_IMAP_T_DESTID_SHFT		21
#define	FO_PCI_IMAP_INT_CTRL_NUM_MASK		0x00000000000003c0ULL
#define	FO_PCI_IMAP_INT_CTRL_NUM_SHFT		6

/* PCI interrupt clear registers - use INTCLR_* from <machine/bus_common.h> */

/* PCI event queue base address register */
#define	FO_PCI_EQ_BASE_ADDR_BYPASS		0xfffc000000000000ULL
#define	FO_PCI_EQ_BASE_ADDR_MASK		0xfffffffffff80000ULL
#define	FO_PCI_EQ_BASE_ADDR_SHFT		19

/* PCI event queue control set registers */
#define	FO_PCI_EQ_CTRL_SET_ENOVERR		0x0200000000000000ULL
#define	FO_PCI_EQ_CTRL_SET_EN			0x0000100000000000ULL

/* PCI event queue control clear registers */
#define	FO_PCI_EQ_CTRL_CLR_COVERR		0x0200000000000000ULL
#define	FO_PCI_EQ_CTRL_CLR_E2I			0x0000800000000000ULL
#define	FO_PCI_EQ_CTRL_CLR_DIS			0x0000100000000000ULL

/* PCI event queue tail registers */
#define	FO_PCI_EQ_TL_OVERR			0x0200000000000000ULL
#define	FO_PCI_EQ_TL_MASK			0x000000000000007fULL
#define	FO_PCI_EQ_TL_SHFT			0

/* PCI event queue head registers */
#define	FO_PCI_EQ_HD_MASK			0x000000000000007fULL
#define	FO_PCI_EQ_HD_SHFT			0

/* PCI MSI mapping registers */
#define	FO_PCI_MSI_MAP_V			0x8000000000000000ULL
#define	FO_PCI_MSI_MAP_EQWR_N			0x4000000000000000ULL
#define	FO_PCI_MSI_MAP_EQNUM_MASK		0x000000000000003fULL
#define	FO_PCI_MSI_MAP_EQNUM_SHFT		0

/* PCI MSI clear registers */
#define	FO_PCI_MSI_CLR_EQWR_N			0x4000000000000000ULL

/*
 * PCI IMU interrupt enable, interrupt status and error status clear
 * registers
 */
#define	FO_PCI_IMU_ERR_INT_SPARE_S_MASK		0x00007c0000000000ULL
#define	FO_PCI_IMU_ERR_INT_SPARE_S_SHFT		42
#define	FO_PCI_IMU_ERR_INT_EQ_OVER_S		0x0000020000000000ULL
#define	FO_PCI_IMU_ERR_INT_EQ_NOT_EN_S		0x0000010000000000ULL
#define	FO_PCI_IMU_ERR_INT_MSI_MAL_ERR_S	0x0000008000000000ULL
#define	FO_PCI_IMU_ERR_INT_MSI_PAR_ERR_S	0x0000004000000000ULL
#define	FO_PCI_IMU_ERR_INT_PMEACK_MES_NOT_EN_S	0x0000002000000000ULL
#define	FO_PCI_IMU_ERR_INT_PMPME_MES_NOT_EN_S	0x0000001000000000ULL
#define	FO_PCI_IMU_ERR_INT_FATAL_MES_NOT_EN_S	0x0000000800000000ULL
#define	FO_PCI_IMU_ERR_INT_NFATAL_MES_NOT_EN_S	0x0000000400000000ULL
#define	FO_PCI_IMU_ERR_INT_COR_MES_NOT_EN_S	0x0000000200000000ULL
#define	FO_PCI_IMU_ERR_INT_MSI_NOT_EN_S		0x0000000100000000ULL
#define	FO_PCI_IMU_ERR_INT_SPARE_P_MASK		0x0000000000007c00ULL
#define	FO_PCI_IMU_ERR_INT_SPARE_P_SHFT		10
#define	FO_PCI_IMU_ERR_INT_EQ_OVER_P		0x0000000000000200ULL
#define	FO_PCI_IMU_ERR_INT_EQ_NOT_EN_P		0x0000000000000100ULL
#define	FO_PCI_IMU_ERR_INT_MSI_MAL_ERR_P	0x0000000000000080ULL
#define	FO_PCI_IMU_ERR_INT_MSI_PAR_ERR_P	0x0000000000000040ULL
#define	FO_PCI_IMU_ERR_INT_PMEACK_MES_NOT_EN_P	0x0000000000000020ULL
#define	FO_PCI_IMU_ERR_INT_PMPME_MES_NOT_EN_P	0x0000000000000010ULL
#define	FO_PCI_IMU_ERR_INT_FATAL_MES_NOT_EN_P	0x0000000000000008ULL
#define	FO_PCI_IMU_ERR_INT_NFATAL_MES_NOT_EN_P	0x0000000000000004ULL
#define	FO_PCI_IMU_ERR_INT_COR_MES_NOT_EN_P	0x0000000000000002ULL
#define	FO_PCI_IMU_ERR_INT_MSI_NOT_EN_P		0x0000000000000001ULL

/* PCI IMU RDS error log register */
#define	FO_PCI_IMU_RDS_ERR_LOG_TYPE_MASK	0xfc00000000000000ULL
#define	FO_PCI_IMU_RDS_ERR_LOG_TYPE_SHFT	58
#define	FO_PCI_IMU_RDS_ERR_LOG_LENGTH_MASK	0x03ff000000000000ULL
#define	FO_PCI_IMU_RDS_ERR_LOG_LENGTH_SHFT	48
#define	FO_PCI_IMU_RDS_ERR_LOG_REQ_ID_MASK	0x0000ffff00000000ULL
#define	FO_PCI_IMU_RDS_ERR_LOG_REQ_ID_SHFT	32
#define	FO_PCI_IMU_RDS_ERR_LOG_TLP_TAG_MASK	0x00000000ff000000ULL
#define	FO_PCI_IMU_RDS_ERR_LOG_TLP_TAG_SHFT	24
#define	FO_PCI_IMU_RDS_ERR_LOG_BE_MCODE_MASK	0x0000000000ff0000ULL
#define	FO_PCI_IMU_RDS_ERR_LOG_BE_MCODE_SHFT	16
#define	FO_PCI_IMU_RDS_ERR_LOG_MSI_DATA_MASK	0x000000000000ffffULL
#define	FO_PCI_IMU_RDS_ERR_LOG_MSI_DATA_SHFT	0

/* PCI IMU SCS error log register */
#define	FO_PCI_IMU_SCS_ERR_LOG_TYPE_MASK	0xfc00000000000000ULL
#define	FO_PCI_IMU_SCS_ERR_LOG_TYPE_SHFT	58
#define	FO_PCI_IMU_SCS_ERR_LOG_LENGTH_MASK	0x03ff000000000000ULL
#define	FO_PCI_IMU_SCS_ERR_LOG_LENGTH_SHFT	48
#define	FO_PCI_IMU_SCS_ERR_LOG_REQ_ID_MASK	0x0000ffff00000000ULL
#define	FO_PCI_IMU_SCS_ERR_LOG_REQ_ID_SHFT	32
#define	FO_PCI_IMU_SCS_ERR_LOG_TLP_TAG_MASK	0x00000000ff000000ULL
#define	FO_PCI_IMU_SCS_ERR_LOG_TLP_TAG_SHFT	24
#define	FO_PCI_IMU_SCS_ERR_LOG_BE_MODE_MASK	0x0000000000ff0000ULL
#define	FO_PCI_IMU_SCS_ERR_LOG_BE_MCODE_SHFT	16
#define	FO_PCI_IMU_SCS_ERR_LOG_EQ_NUM_MASK	0x000000000000003fULL
#define	FO_PCI_IMU_SCS_ERR_LOG_EQ_NUM_SHFT	0

/* PCI IMU EQS error log register */
#define	FO_PCI_IMU_EQS_ERR_LOG_EQ_NUM_MASK	0x000000000000003fULL
#define	FO_PCI_IMU_EQS_ERROR_LOG_EQ_NUM_SHFT	0

/*
 * PCI ERR COR, ERR NONFATAL, ERR FATAL, PM PME and PME To ACK mapping
 * registers
 */
#define	FO_PCI_ERR_PME_V			0x8000000000000000ULL
#define	FO_PCI_ERR_PME_EQNUM_MASK		0x000000000000003fULL
#define	FO_PCI_ERR_PME_EQNUM_SHFT		0

/* PCI DMC core and block interrupt enable register */
#define	FO_PCI_DMC_CORE_BLOCK_INT_EN_DMC	0x8000000000000000ULL
#define	FO_PCI_DMC_CORE_BLOCK_INT_EN_MMU	0x0000000000000002ULL
#define	FO_PCI_DMC_CORE_BLOCK_INT_EN_IMU	0x0000000000000001ULL

/* PCI DMC core and block error status register */
#define	FO_PCI_DMC_CORE_BLOCK_ERR_STAT_MMU	0x0000000000000002ULL
#define	FO_PCI_DMC_CORE_BLOCK_ERR_STAT_IMU	0x0000000000000001ULL

/* PCI multi core error status register */
#define	FO_PCI_MULTI_CORE_ERR_STAT_PEC		0x0000000000000002ULL
#define	FO_PCI_MULTI_CORE_ERR_STAT_DMC		0x0000000000000001ULL

/* PCI MSI 32-bit address register */
#define	FO_PCI_MSI_32_BIT_ADDR_MASK		0x00000000ffff0000ULL
#define	FO_PCI_MSI_32_BIT_ADDR_SHFT		16

/* PCI MSI 64-bit address register */
#define	FO_PCI_MSI_64_BIT_ADDR_MASK		0x0000ffffffff0000ULL
#define	FO_PCI_MSI_64_BIT_ADDR_SHFT		16

/*
 * PCI MMU interrupt enable, interrupt status and error status clear
 * registers
 */
#define	FO_PCI_MMU_ERR_INT_S_MASK		0x0000ffff00000000ULL
#define	FO_PCI_MMU_ERR_INT_S_SHFT		32
#define	FO_PCI_MMU_ERR_INT_TBW_DPE_S		0x0000800000000000ULL
#define	FO_PCI_MMU_ERR_INT_TBW_ERR_S		0x0000400000000000ULL
#define	FO_PCI_MMU_ERR_INT_TBW_UDE_S		0x0000200000000000ULL
#define	FO_PCI_MMU_ERR_INT_TBW_DME_S		0x0000100000000000ULL
#define	FO_PCI_MMU_ERR_INT_SPARE3_S		0x0000080000000000ULL
#define	FO_PCI_MMU_ERR_INT_SPARE2_S		0x0000040000000000ULL
#define	FO_PCI_MMU_ERR_INT_TTC_CAE_S		0x0000020000000000ULL
#define	FIRE_PCI_MMU_ERR_INT_TTC_DPE_S		0x0000010000000000ULL
#define	OBERON_PCI_MMU_ERR_INT_TTC_DUE_S	0x0000010000000000ULL
#define	FO_PCI_MMU_ERR_INT_TTE_PRT_S		0x0000008000000000ULL
#define	FO_PCI_MMU_ERR_INT_TTE_INV_S		0x0000004000000000ULL
#define	FO_PCI_MMU_ERR_INT_TRN_OOR_S		0x0000002000000000ULL
#define	FO_PCI_MMU_ERR_INT_TRN_ERR_S		0x0000001000000000ULL
#define	FO_PCI_MMU_ERR_INT_SPARE1_S		0x0000000800000000ULL
#define	FO_PCI_MMU_ERR_INT_SPARE0_S		0x0000000400000000ULL
#define	FO_PCI_MMU_ERR_INT_BYP_OOR_S		0x0000000200000000ULL
#define	FO_PCI_MMU_ERR_INT_BYP_ERR_S		0x0000000100000000ULL
#define	FO_PCI_MMU_ERR_INT_P_MASK		0x000000000000ffffULL
#define	FO_PCI_MMU_ERR_INT_P_SHFT		0
#define	FO_PCI_MMU_ERR_INT_TBW_DPE_P		0x0000000000008000ULL
#define	FO_PCI_MMU_ERR_INT_TBW_ERR_P		0x0000000000004000ULL
#define	FO_PCI_MMU_ERR_INT_TBW_UDE_P		0x0000000000002000ULL
#define	FO_PCI_MMU_ERR_INT_TBW_DME_P		0x0000000000001000ULL
#define	FO_PCI_MMU_ERR_INT_SPARE3_P		0x0000000000000800ULL
#define	FO_PCI_MMU_ERR_INT_SPARE2_P		0x0000000000000400ULL
#define	FO_PCI_MMU_ERR_INT_TTC_CAE_P		0x0000000000000200ULL
#define	FIRE_PCI_MMU_ERR_INT_TTC_DPE_P		0x0000000000000100ULL
#define	OBERON_PCI_MMU_ERR_INT_TTC_DUE_P	0x0000000000000100ULL
#define	FO_PCI_MMU_ERR_INT_TTE_PRT_P		0x0000000000000080ULL
#define	FO_PCI_MMU_ERR_INT_TTE_INV_P		0x0000000000000040ULL
#define	FO_PCI_MMU_ERR_INT_TRN_OOR_P		0x0000000000000020ULL
#define	FO_PCI_MMU_ERR_INT_TRN_ERR_P		0x0000000000000010ULL
#define	FO_PCI_MMU_ERR_INT_SPARE1_P		0x0000000000000008ULL
#define	FO_PCI_MMU_ERR_INT_SPARE0_P		0x0000000000000004ULL
#define	FO_PCI_MMU_ERR_INT_BYP_OOR_P		0x0000000000000002ULL
#define	FO_PCI_MMU_ERR_INT_BYP_ERR_P		0x0000000000000001ULL

/* PCI MMU translation fault address register */
#define	FO_PCI_MMU_TRANS_FAULT_ADDR_VA_MASK	0xfffffffffffffffcULL
#define	FO_PCI_MMU_TRANS_FAULT_ADDR_VA_SHFT	2

/* PCI MMU translation fault status register */
#define	FO_PCI_MMU_TRANS_FAULT_STAT_ENTRY_MASK	0x000001ff00000000ULL
#define	FO_PCI_MMU_TRANS_FAULT_STAT_ENTRY_SHFT	32
#define	FO_PCI_MMU_TRANS_FAULT_STAT_TYPE_MASK	0x00000000007f0000ULL
#define	FO_PCI_MMU_TRANS_FAULT_STAT_TYPE_SHFT	16
#define	FO_PCI_MMU_TRANS_FAULT_STAT_ID_MASK	0x000000000000ffffULL
#define	FO_PCI_MMU_TRANS_FAULT_STAT_ID_SHFT	0

/*
 * PCI ILU interrupt enable, interrupt status and error status clear
 * registers
 */
#define	FO_PCI_ILU_ERR_INT_SPARE3_S		0x0000008000000000ULL
#define	FO_PCI_ILU_ERR_INT_SPARE2_S		0x0000004000000000ULL
#define	FO_PCI_ILU_ERR_INT_SPARE1_S		0x0000002000000000ULL
#define	FIRE_PCI_ILU_ERR_INT_IHB_PE_S		0x0000001000000000ULL
#define	OBERON_PCI_ILU_ERR_INT_IHB_UE_S		0x0000001000000000ULL
#define	FO_PCI_ILU_ERR_INT_SPARE3_P		0x0000000000000080ULL
#define	FO_PCI_ILU_ERR_INT_SPARE2_P		0x0000000000000040ULL
#define	FO_PCI_ILU_ERR_INT_SPARE1_P		0x0000000000000020ULL
#define	FIRE_PCI_ILU_ERR_INT_IHB_PE_P		0x0000000000000010ULL
#define	OBERON_PCI_ILU_ERR_INT_IHB_UE_P		0x0000000000000010ULL

/* PCI DMC debug select registers for port a/b */
#define	FO_PCI_DMC_DBG_SEL_PORT_BLCK_MASK	0x00000000000003c0ULL
#define	FO_PCI_DMC_DBG_SEL_PORT_BLCK_SHFT	6
#define	FO_PCI_DMC_DBG_SEL_PORT_SUB_MASK	0x0000000000000038ULL
#define	FO_PCI_DMC_DBG_SEL_PORT_SUB_SHFT	3
#define	FO_PCI_DMC_DBG_SEL_PORT_SUB_SGNL_MASK	0x0000000000000007ULL
#define	FO_PCI_DMC_DBG_SEL_PORT_SUB_SGNL_SHFT	0

/* PCI PEC core and block interrupt enable register */
#define	FO_PCI_PEC_CORE_BLOCK_INT_EN_PEC	0x8000000000000000ULL
#define	FO_PCI_PEC_CORE_BLOCK_INT_EN_ILU	0x0000000000000008ULL
#define	FO_PCI_PEC_CORE_BLOCK_INT_EN_UERR	0x0000000000000004ULL
#define	FO_PCI_PEC_CORE_BLOCK_INT_EN_CERR	0x0000000000000002ULL
#define	FO_PCI_PEC_CORE_BLOCK_INT_EN_OEVENT	0x0000000000000001ULL

/* PCI PEC core and block interrupt status register */
#define	FO_PCI_PEC_CORE_BLOCK_INT_STAT_ILU	0x0000000000000008ULL
#define	FO_PCI_PEC_CORE_BLOCK_INT_STAT_UERR	0x0000000000000004ULL
#define	FO_PCI_PEC_CORE_BLOCK_INT_STAT_CERR	0x0000000000000002ULL
#define	FO_PCI_PEC_CORE_BLOCK_INT_STAT_OEVENT	0x0000000000000001ULL

/* PCI TLU control register */
#define	FO_PCI_TLU_CTRL_L0S_TIM_MASK		0x00000000ff000000ULL
#define	FO_PCI_TLU_CTRL_L0S_TIM_SHFT		24
#define	FO_PCI_TLU_CTRL_NWPR_EN			0x0000000000100000ULL
#define	FO_PCI_TLU_CTRL_CTO_SEL_MASK		0x0000000000070000ULL
#define	FO_PCI_TLU_CTRL_CTO_SEL_SHFT		16
#define	FO_PCI_TLU_CTRL_CFG_MASK		0x000000000000ffffULL
#define	FO_PCI_TLU_CTRL_CFG_SHFT		0
#define	FO_PCI_TLU_CTRL_CFG_REMAIN_DETECT_QUIET	0x0000000000000100ULL
#define	FO_PCI_TLU_CTRL_CFG_PAD_LOOPBACK_EN	0x0000000000000080ULL
#define	FO_PCI_TLU_CTRL_CFG_EWRAP_LOOPBACK_EN	0x0000000000000040ULL
#define	FO_PCI_TLU_CTRL_CFG_DIGITAL_LOOPBACK_EN	0x0000000000000020ULL
#define	FO_PCI_TLU_CTRL_CFG_MPS_MASK		0x000000000000001cULL
#define	FO_PCI_TLU_CTRL_CFG_MPS_SHFT		2
#define	FO_PCI_TLU_CTRL_CFG_COMMON_CLK_CFG	0x0000000000000002ULL
#define	FO_PCI_TLU_CTRL_CFG_PORT		0x0000000000000001ULL

/*
 * PCI TLU other event interrupt enable, interrupt status and status clear
 * registers
 */
#define	FO_PCI_TLU_OEVENT_S_MASK		0x00ffffff00000000ULL
#define	FO_PCI_TLU_OEVENT_S_SHFT		32
#define	FO_PCI_TLU_OEVENT_SPARE_S		0x0080000000000000ULL
#define	FO_PCI_TLU_OEVENT_MFC_S			0x0040000000000000ULL
#define	FO_PCI_TLU_OEVENT_CTO_S			0x0020000000000000ULL
#define	FO_PCI_TLU_OEVENT_NFP_S			0x0010000000000000ULL
#define	FO_PCI_TLU_OEVENT_LWC_S			0x0008000000000000ULL
#define	FO_PCI_TLU_OEVENT_MRC_S			0x0004000000000000ULL
#define	FO_PCI_TLU_OEVENT_WUC_S			0x0002000000000000ULL
#define	FO_PCI_TLU_OEVENT_RUC_S			0x0001000000000000ULL
#define	FO_PCI_TLU_OEVENT_CRS_S			0x0000800000000000ULL
#define	FO_PCI_TLU_OEVENT_IIP_S			0x0000400000000000ULL
#define	FO_PCI_TLU_OEVENT_EDP_S			0x0000200000000000ULL
#define	FIRE_PCI_TLU_OEVENT_EHP_S		0x0000100000000000ULL
#define	OBERON_PCI_TLU_OEVENT_EHBUE_S		0x0000100000000000ULL
#define	OBERON_PCI_TLU_OEVENT_EDBUE_S		0x0000100000000000ULL
#define	FO_PCI_TLU_OEVENT_LIN_S			0x0000080000000000ULL
#define	FO_PCI_TLU_OEVENT_LRS_S			0x0000040000000000ULL
#define	FO_PCI_TLU_OEVENT_LDN_S			0x0000020000000000ULL
#define	FO_PCI_TLU_OEVENT_LUP_S			0x0000010000000000ULL
#define	FO_PCI_TLU_OEVENT_LPU_S_MASK		0x000000c000000000ULL
#define	FO_PCI_TLU_OEVENT_LPU_S_SHFT		38
#define	OBERON_PCI_TLU_OEVENT_TLUEITMO_S	0x0000008000000000ULL
#define	FO_PCI_TLU_OEVENT_ERU_S			0x0000002000000000ULL
#define	FO_PCI_TLU_OEVENT_ERO_S			0x0000001000000000ULL
#define	FO_PCI_TLU_OEVENT_EMP_S			0x0000000800000000ULL
#define	FO_PCI_TLU_OEVENT_EPE_S			0x0000000400000000ULL
#define	FIRE_PCI_TLU_OEVENT_ERP_S		0x0000000200000000ULL
#define	OBERON_PCI_TLU_OEVENT_ERBU_S		0x0000000200000000ULL
#define	FIRE_PCI_TLU_OEVENT_EIP_S		0x0000000100000000ULL
#define	OBERON_PCI_TLU_OEVENT_EIUE_S		0x0000000100000000ULL
#define	FO_PCI_TLU_OEVENT_P_MASK		0x0000000000ffffffULL
#define	FO_PCI_TLU_OEVENT_P_SHFT		0
#define	FO_PCI_TLU_OEVENT_SPARE_P		0x0000000000800000ULL
#define	FO_PCI_TLU_OEVENT_MFC_P			0x0000000000400000ULL
#define	FO_PCI_TLU_OEVENT_CTO_P			0x0000000000200000ULL
#define	FO_PCI_TLU_OEVENT_NFP_P			0x0000000000100000ULL
#define	FO_PCI_TLU_OEVENT_LWC_P			0x0000000000080000ULL
#define	FO_PCI_TLU_OEVENT_MRC_P			0x0000000000040000ULL
#define	FO_PCI_TLU_OEVENT_WUC_P			0x0000000000020000ULL
#define	FO_PCI_TLU_OEVENT_RUC_P			0x0000000000010000ULL
#define	FO_PCI_TLU_OEVENT_CRS_P			0x0000000000008000ULL
#define	FO_PCI_TLU_OEVENT_IIP_P			0x0000000000004000ULL
#define	FO_PCI_TLU_OEVENT_EDP_P			0x0000000000002000ULL
#define	FIRE_PCI_TLU_OEVENT_EHP_P		0x0000000000001000ULL
#define	OBERON_PCI_TLU_OEVENT_EHBUE_P		0x0000000000001000ULL
#define	OBERON_PCI_TLU_OEVENT_EDBUE_P		0x0000000000001000ULL
#define	FO_PCI_TLU_OEVENT_LIN_P			0x0000000000000800ULL
#define	FO_PCI_TLU_OEVENT_LRS_P			0x0000000000000400ULL
#define	FO_PCI_TLU_OEVENT_LDN_P			0x0000000000000200ULL
#define	FO_PCI_TLU_OEVENT_LUP_P			0x0000000000000100ULL
#define	FO_PCI_TLU_OEVENT_LPU_P_MASK		0x00000000000000c0ULL
#define	FO_PCI_TLU_OEVENT_LPU_P_SHFT		6
#define	OBERON_PCI_TLU_OEVENT_TLUEITMO_P	0x0000000000000080ULL
#define	FO_PCI_TLU_OEVENT_ERU_P			0x0000000000000020ULL
#define	FO_PCI_TLU_OEVENT_ERO_P			0x0000000000000010ULL
#define	FO_PCI_TLU_OEVENT_EMP_P			0x0000000000000008ULL
#define	FO_PCI_TLU_OEVENT_EPE_P			0x0000000000000004ULL
#define	FIRE_PCI_TLU_OEVENT_ERP_P		0x0000000000000002ULL
#define	OBERON_PCI_TLU_OEVENT_ERBU_P		0x0000000000000002ULL
#define	FIRE_PCI_TLU_OEVENT_EIP_P		0x0000000000000001ULL
#define	OBERON_PCI_TLU_OEVENT_EIUE_P		0x0000000000000001ULL

/* PCI receive/transmit DLU/TLU other event header 1/2 log registers */
#define	FO_PCI_TLU_OEVENT_HDR_LOG_MASK		0xffffffffffffffffULL
#define	FO_PCI_TLU_OEVENT_HDR_LOG_SHFT		0

/* PCI TLU device control register */
#define	FO_PCI_TLU_DEV_CTRL_MRRS_MASK		0x0000000000007000ULL
#define	FO_PCI_TLU_DEV_CTRL_MRRS_SHFT		12
#define	FO_PCI_TLU_DEV_CTRL_MPS_MASK		0x00000000000000e0ULL
#define	FO_PCI_TLU_DEV_CTRL_MPS_SHFT		5

/*
 * PCI TLU uncorrectable error interrupt enable, interrupt status and
 * status clear registers
 */
#define	FO_PCI_TLU_UERR_INT_S_MASK		0x001fffff00000000ULL
#define	FO_PCI_TLU_UERR_INT_S_SHFT		32
#define	FO_PCI_TLU_UERR_INT_UR_S		0x0010000000000000ULL
#define	OBERON_PCI_TLU_UERR_INT_ECRC_S		0x0008000000000000ULL
#define	FO_PCI_TLU_UERR_INT_MFP_S		0x0004000000000000ULL
#define	FO_PCI_TLU_UERR_INT_ROF_S		0x0002000000000000ULL
#define	FO_PCI_TLU_UERR_INT_UC_S		0x0001000000000000ULL
#define	FO_PCI_TLU_UERR_INT_CA_S		0x0000800000000000ULL
#define	FO_PCI_TLU_UERR_INT_CTO_S		0x0000400000000000ULL
#define	FO_PCI_TLU_UERR_INT_FCP_S		0x0000200000000000ULL
#define	FIRE_PCI_TLU_UERR_INT_PP_S		0x0000100000000000ULL
#define	OBERON_PCI_TLU_UERR_INT_POIS_S		0x0000100000000000ULL
#define	FO_PCI_TLU_UERR_INT_DLP_S		0x0000001000000000ULL
#define	FO_PCI_TLU_UERR_INT_TE_S		0x0000000100000000ULL
#define	FO_PCI_TLU_UERR_INT_P_MASK		0x00000000001fffffULL
#define	FO_PCI_TLU_UERR_INT_P_SHFT		0
#define	FO_PCI_TLU_UERR_INT_UR_P		0x0000000000100000ULL
#define	OBERON_PCI_TLU_UERR_INT_ECRC_P		0x0000000000080000ULL
#define	FO_PCI_TLU_UERR_INT_MFP_P		0x0000000000040000ULL
#define	FO_PCI_TLU_UERR_INT_ROF_P		0x0000000000020000ULL
#define	FO_PCI_TLU_UERR_INT_UC_P		0x0000000000010000ULL
#define	FO_PCI_TLU_UERR_INT_CA_P		0x0000000000008000ULL
#define	FO_PCI_TLU_UERR_INT_CTO_P		0x0000000000004000ULL
#define	FO_PCI_TLU_UERR_INT_FCP_P		0x0000000000002000ULL
#define	FIRE_PCI_TLU_UERR_INT_PP_P		0x0000000000001000ULL
#define	OBERON_PCI_TLU_UERR_INT_POIS_P		0x0000000000001000ULL
#define	FO_PCI_TLU_UERR_INT_DLP_P		0x0000000000000010ULL
#define	FO_PCI_TLU_UERR_INT_TE_P		0x0000000000000001ULL

/*
 * PCI TLU correctable error interrupt enable, interrupt status and
 * status clear registers
 */
#define	FO_PCI_TLU_CERR_INT_S_MASK		0x001fffff00000000ULL
#define	FO_PCI_TLU_CERR_INT_S_SHFT		32
#define	FO_PCI_TLU_CERR_INT_RTO_S		0x0000100000000000ULL
#define	FO_PCI_TLU_CERR_INT_RNR_S		0x0000010000000000ULL
#define	FO_PCI_TLU_CERR_INT_BDP_S		0x0000008000000000ULL
#define	FO_PCI_TLU_CERR_INT_BTP_S		0x0000004000000000ULL
#define	FO_PCI_TLU_CERR_INT_RE_S		0x0000000100000000ULL
#define	FO_PCI_TLU_CERR_INT_P_MASK		0x00000000001fffffULL
#define	FO_PCI_TLU_CERR_INT_P_SHFT		0
#define	FO_PCI_TLU_CERR_INT_RTO_P		0x0000000000001000ULL
#define	FO_PCI_TLU_CERR_INT_RNR_P		0x0000000000000100ULL
#define	FO_PCI_TLU_CERR_INT_BDP_P		0x0000000000000080ULL
#define	FO_PCI_TLU_CERR_INT_BTP_P		0x0000000000000040ULL
#define	FO_PCI_TLU_CERR_INT_RE_P		0x0000000000000001ULL

/* PCI TLU reset register */
#define	FO_PCI_LPU_RST_WE			0x0000000080000000ULL
#define	FO_PCI_LPU_RST_UNUSED_MASK		0x0000000000000e00ULL
#define	FO_PCI_LPU_RST_UNUSED_SHFT		9
#define	FO_PCI_LPU_RST_ERR			0x0000000000000100ULL
#define	FO_PCI_LPU_RST_TXLINK			0x0000000000000080ULL
#define	FO_PCI_LPU_RST_RXLINK			0x0000000000000040ULL
#define	FO_PCI_LPU_RST_SMLINK			0x0000000000000020ULL
#define	FO_PCI_LPU_RST_LTSSM			0x0000000000000010ULL
#define	FO_PCI_LPU_RST_TXPHY			0x0000000000000008ULL
#define	FO_PCI_LPU_RST_RXPHY			0x0000000000000004ULL
#define	FO_PCI_LPU_RST_TXPCS			0x0000000000000002ULL
#define	FO_PCI_LPU_RST_RXPCS			0x0000000000000001ULL

/* PCI TLU link control register */
#define	FO_PCI_TLU_LNK_CTRL_EXTSYNC		0x0000000000000080ULL
#define	FO_PCI_TLU_LNK_CTRL_CLK			0x0000000000000040ULL
#define	FO_PCI_TLU_LNK_CTRL_RETRAIN		0x0000000000000020ULL
#define	FO_PCI_TLU_LNK_CTRL_DIS			0x0000000000000010ULL
#define	FO_PCI_TLU_LNK_CTRL_RCB			0x0000000000000008ULL
#define	FO_PCI_TLU_LNK_CTRL_ASPM_L0S_L1S	0x0000000000000003ULL
#define	FO_PCI_TLU_LNK_CTRL_ASPM_L1S		0x0000000000000002ULL
#define	FO_PCI_TLU_LNK_CTRL_ASPM_L0S		0x0000000000000001ULL
#define	FO_PCI_TLU_LNK_CTRL_ASPM_DIS		0x0000000000000000ULL

/* PCI TLU link status register */
#define	FO_PCI_TLU_LNK_STAT_CLK			0x0000000000001000ULL
#define	FO_PCI_TLU_LNK_STAT_TRAIN		0x0000000000000800ULL
#define	FO_PCI_TLU_LNK_STAT_ERR			0x0000000000000400ULL
#define	FO_PCI_TLU_LNK_STAT_WDTH_MASK		0x00000000000003f0ULL
#define	FO_PCI_TLU_LNK_STAT_WDTH_SHFT		4
#define	FO_PCI_TLU_LNK_STAT_SPEED_MASK		0x000000000000000fULL
#define	FO_PCI_TLU_LNK_STAT_SPEED_SHFT		0

/*
 * PCI receive/transmit DLU/TLU uncorrectable error header 1/2 log
 * registers
 */
#define	FO_PCI_TLU_UERR_HDR_LOG_MASK		0xffffffffffffffffULL
#define	FO_PCI_TLU_UERR_HDR_LOG_SHFT		0

/* PCI DLU/LPU interrupt status and mask registers */
#define	FO_PCI_LPU_INT_INT			0x0000000080000000ULL
#define	FIRE_PCI_LPU_INT_PRF_CNT2_OFLW		0x0000000000000080ULL
#define	FIRE_PCI_LPU_INT_PRF_CNT1_OFLW		0x0000000000000040ULL
#define	FO_PCI_LPU_INT_LNK_LYR			0x0000000000000020ULL
#define	FO_PCI_LPU_INT_PHY_ERR			0x0000000000000010ULL
#define	FIRE_PCI_LPU_INT_LTSSM			0x0000000000000008ULL
#define	FIRE_PCI_LPU_INT_PHY_TX			0x0000000000000004ULL
#define	FIRE_PCI_LPU_INT_PHY_RX			0x0000000000000002ULL
#define	FIRE_PCI_LPU_INT_PHY_GB			0x0000000000000001ULL

/* PCI DLU/LPU link layer config register */
#define	FIRE_PCI_LPU_LNK_LYR_CFG_AUTO_UPDT_DIS	0x0000000000080000ULL
#define	FIRE_PCI_LPU_LNK_LYR_CFG_FREQ_NAK_EN	0x0000000000040000ULL
#define	FIRE_PCI_LPU_LNK_LYR_CFG_RPLY_AFTER_REQ	0x0000000000020000ULL
#define	FIRE_PCI_LPU_LNK_LYR_CFG_LAT_THRS_WR_EN	0x0000000000010000ULL
#define	FO_PCI_LPU_LNK_LYR_CFG_VC0_EN		0x0000000000000100ULL
#define	FIRE_PCI_LPU_LNK_LYR_CFG_L0S_ADJ_FAC_EN	0x0000000000000010ULL
#define	FIER_PCI_LPU_LNK_LYR_CFG_TLP_XMIT_FC_EN	0x0000000000000008ULL
#define	FO_PCI_LPU_LNK_LYR_CFG_FREQ_ACK_EN	0x0000000000000004ULL
#define	FO_PCI_LPU_LNK_LYR_CFG_RETRY_DIS	0x0000000000000002ULL

/* PCI DLU/LPU link layer interrupt and status register */
#define	FO_PCI_LPU_LNK_LYR_INT_STAT_LNK_ERR_ACT	0x0000000080000000ULL
#define	OBERON_PCI_LPU_LNK_LYR_INT_STAT_PBUS_PE 0x0000000000800000ULL
#define	FO_PCI_LPU_LNK_LYR_INT_STAT_USPRTD_DLLP	0x0000000000400000ULL
#define	FO_PCI_LPU_LNK_LYR_INT_STAT_DLLP_RX_ERR	0x0000000000200000ULL
#define	FO_PCI_LPU_LNK_LYR_INT_STAT_BAD_DLLP	0x0000000000100000ULL
#define	FO_PCI_LPU_LNK_LYR_INT_STAT_TLP_RX_ERR	0x0000000000040000ULL
#define	FO_PCI_LPU_LNK_LYR_INT_STAT_SRC_ERR_TLP	0x0000000000020000ULL
#define	FO_PCI_LPU_LNK_LYR_INT_STAT_BAD_TLP	0x0000000000010000ULL
#define	FO_PCI_LPU_LNK_LYR_INT_STAT_RBF_UDF_ERR	0x0000000000000200ULL
#define	FO_PCI_LPU_LNK_LYR_INT_STAT_RBF_OVF_ERR	0x0000000000000100ULL
#define	FO_PCI_LPU_LNK_LYR_INT_STAT_EG_TLPM_ERR	0x0000000000000080ULL
#define	FO_PCI_LPU_LNK_LYR_INT_STAT_EG_TFRM_ERR	0x0000000000000040ULL
#define	FO_PCI_LPU_LNK_LYR_INT_STAT_RBF_PE	0x0000000000000020ULL
#define	FO_PCI_LPU_LNK_LYR_INT_STAT_EGRESS_PE	0x0000000000000010ULL
#define	FO_PCI_LPU_LNK_LYR_INT_STAT_RPLY_TMR_TO	0x0000000000000004ULL
#define	FO_PCI_LPU_LNK_LYR_INT_STAT_RPLY_NUM_RO	0x0000000000000002ULL
#define	FO_PCI_LPU_LNK_LYR_INT_STAT_DLNK_PES	0x0000000000000001ULL

/* PCI DLU/LPU flow control update control register */
#define	FO_PCI_LPU_FLW_CTRL_UPDT_CTRL_FC0_C_EN	0x0000000000000004ULL
#define	FO_PCI_LPU_FLW_CTRL_UPDT_CTRL_FC0_NP_EN	0x0000000000000002ULL
#define	FO_PCI_LPU_FLW_CTRL_UPDT_CTRL_FC0_P_EN	0x0000000000000001ULL

/* PCI DLU/LPU txlink ACKNAK latency timer threshold register */
#define	FO_PCI_LPU_TXLNK_FREQ_LAT_TMR_THRS_MASK	0x000000000000ffffULL
#define	FO_PCI_LPU_TXLNK_FREQ_LAT_TMR_THRS_SHFT	0

/* PCI DLU/LPU txlink replay timer threshold register */
#define	FO_PCI_LPU_TXLNK_RPLY_TMR_THRS_MASK	0x00000000000fffffULL
#define	FO_PCI_LPU_TXLNK_RPLY_TMR_THRS_SHFT	0

/* PCI DLU/LPU txlink FIFO pointer register */
#define	FO_PCI_LPU_TXLNK_RTR_FIFO_PTR_TL_MASK	0x00000000ffff0000ULL
#define	FO_PCI_LPU_TXLNK_RTR_FIFO_PTR_TL_SHFT	16
#define	FO_PCI_LPU_TXLNK_RTR_FIFO_PTR_HD_MASK	0x000000000000ffffULL
#define	FO_PCI_LPU_TXLNK_RTR_FIFO_PTR_HD_SHFT	0

/* PCI DLU/LPU phy layer interrupt and status register */
#define	FO_PCI_LPU_PHY_LYR_INT_STAT_PHY_LYR_ERR	0x0000000080000000ULL
#define	FO_PCI_LPU_PHY_LYR_INT_STAT_KC_DLLP_ERR	0x0000000000000800ULL
#define	FO_PCI_LPU_PHY_LYR_INT_STAT_END_POS_ERR	0x0000000000000400ULL
#define	FO_PCI_LPU_PHY_LYR_INT_STAT_LNK_ERR	0x0000000000000200ULL
#define	FO_PCI_LPU_PHY_LYR_INT_STAT_TRN_ERR	0x0000000000000100ULL
#define	FO_PCI_LPU_PHY_LYR_INT_STAT_EDB_DET	0x0000000000000080ULL
#define	FO_PCI_LPU_PHY_LYR_INT_STAT_SDP_END	0x0000000000000040ULL
#define	FO_PCI_LPU_PHY_LYR_INT_STAT_STP_END_EDB	0x0000000000000020ULL
#define	FO_PCI_LPU_PHY_LYR_INT_STAT_INVC_ERR	0x0000000000000010ULL
#define	FO_PCI_LPU_PHY_LYR_INT_STAT_MULTI_SDP	0x0000000000000008ULL
#define	FO_PCI_LPU_PHY_LYR_INT_STAT_MULTI_STP	0x0000000000000004ULL
#define	FO_PCI_LPU_PHY_LYR_INT_STAT_ILL_SDP_POS	0x0000000000000002ULL
#define	FO_PCI_LPU_PHY_LYR_INT_STAT_ILL_STP_POS	0x0000000000000001ULL

/* PCI DLU/LPU LTSSM config2 register */
#define	FO_PCI_LPU_LTSSM_CFG2_12_TO_MASK	0x00000000ffffffffULL
#define	FO_PCI_LPU_LTSSM_CFG2_12_TO_SHFT	0

/* PCI DLU/LPU LTSSM config3 register */
#define	FO_PCI_LPU_LTSSM_CFG3_2_TO_MASK		0x00000000ffffffffULL
#define	FO_PCI_LPU_LTSSM_CFG3_2_TO_SHFT		0

/* PCI DLU/LPU LTSSM config4 register */
#define	FO_PCI_LPU_LTSSM_CFG4_TRN_CTRL_MASK	0x00000000ff000000ULL
#define	FO_PCI_LPU_LTSSM_CFG4_TRN_CTRL_SHFT	24
#define	FO_PCI_LPU_LTSSM_CFG4_DATA_RATE_MASK	0x0000000000ff0000ULL
#define	FO_PCI_LPU_LTSSM_CFG4_DATA_RATE_SHFT	16
#define	FO_PCI_LPU_LTSSM_CFG4_N_FTS_MASK	0x000000000000ff00ULL
#define	FO_PCI_LPU_LTSSM_CFG4_N_FTS_SHFT	8
#define	FO_PCI_LPU_LTSSM_CFG4_LNK_NUM_MASK	0x00000000000000ffULL
#define	FO_PCI_LPU_LTSSM_CFG4_LNK_NUM_SHFT	0

/* PCI DLU/LPU LTSSM config5 register */
#define	FO_PCI_LPU_LTSSM_CFG5_UNUSED0_MASK	0x00000000ffffe000ULL
#define	FO_PCI_LPU_LTSSM_CFG5_UNUSED0_SHFT	13
#define	FO_PCI_LPU_LTSSM_CFG5_RCV_DET_TST_MODE	0x0000000000001000ULL
#define	FO_PCI_LPU_LTSSM_CFG5_POLL_CMPLNC_DIS	0x0000000000000800ULL
#define	FO_PCI_LPU_LTSSM_CFG5_TX_IDLE_TX_FTS	0x0000000000000400ULL
#define	FO_PCI_LPU_LTSSM_CFG5_RX_FTS_RVR_LK	0x0000000000000200ULL
#define	FO_PCI_LPU_LTSSM_CFG5_UNUSED1_MASK	0x0000000000000180ULL
#define	FO_PCI_LPU_LTSSM_CFG5_UNUSED1_SHFT	7
#define	FO_PCI_LPU_LTSSM_CFG5_LPBK_NTRY_ACTIVE	0x0000000000000040ULL
#define	FO_PCI_LPU_LTSSM_CFG5_LPBK_NTRY_EXIT	0x0000000000000020ULL
#define	FO_PCI_LPU_LTSSM_CFG5_LPBK_ACTIVE_EXIT	0x0000000000000010ULL
#define	FO_PCI_LPU_LTSSM_CFG5_L1_IDLE_RCVRY_LK	0x0000000000000008ULL
#define	FO_PCI_LPU_LTSSM_CFG5_L0_TRN_CNTRL_RST	0x0000000000000004ULL
#define	FO_PCI_LPU_LTSSM_CFG5_L0_LPBK		0x0000000000000002ULL
#define	FO_PCI_LPU_LTSSM_CFG5_UNUSED2		0x0000000000000001ULL

/* Controller configuration and status registers */
#define	FIRE_JBUS_PAR_CTRL			0x60010
#define	FO_XBC_ERR_LOG_EN			0x61000
#define	FO_XBC_INT_EN				0x61008
#define	FO_XBC_INT_STAT				0x61010
#define	FO_XBC_ERR_STAT_CLR			0x61018
#define	FIRE_JBC_FATAL_RST_EN			0x61028
#define	FIRE_JBCINT_ITRANS_ERR_LOG		0x61040
#define	FIRE_JBCINT_ITRANS_ERR_LOG2		0x61048
#define	FIRE_JBCINT_OTRANS_ERR_LOG		0x61040
#define	FIRE_JBCINT_OTRANS_ERR_LOG2		0x61048
#define	FIRE_FATAL_ERR_LOG			0x61050
#define	FIRE_FATAL_ERR_LOG2			0x61058
#define	FIRE_MERGE_TRANS_ERR_LOG		0x61060
#define	FIRE_DMCINT_ODCD_ERR_LOG		0x61068
#define	FIRE_DMCINT_IDC_ERR_LOG			0x61070
#define	FIRE_JBC_CSR_ERR_LOG			0x61078
#define	FIRE_JBC_CORE_BLOCK_INT_EN		0x61800
#define	FIRE_JBC_CORE_BLOCK_ERR_STAT		0x61808
#define	FO_XBC_PRF_CNT_SEL			0x62000
#define	FO_XBC_PRF_CNT0				0x62008
#define	FO_XBC_PRF_CNT1				0x62010

/* JBus parity control register */
#define	FIRE_JBUS_PAR_CTRL_P_EN			0x8000000000000000ULL
#define	FIRE_JBUS_PAR_CTRL_INVRTD_PAR_MASK	0x000000000000003cULL
#define	FIRE_JBUS_PAR_CTRL_INVRTD_PAR_SHFT	2
#define	FIRE_JBUS_PAR_CTRL_NEXT_DATA		0x0000000000000002ULL
#define	FIRE_JBUS_PAR_CTRL_NEXT_ADDR		0x0000000000000001ULL

/* JBC error log enable register - may also apply to UBC */
#define	FIRE_JBC_ERR_LOG_EN_SPARE_MASK		0x00000000e0000000ULL
#define	FIRE_JBC_ERR_LOG_EN_SPARE_SHFT		29
#define	FIRE_JBC_ERR_LOG_EN_PIO_UNMAP_RD	0x0000000010000000ULL
#define	FIRE_JBC_ERR_LOG_EN_ILL_ACC_RD		0x0000000008000000ULL
#define	FIRE_JBC_ERR_LOG_EN_EBUS_TO		0x0000000004000000ULL
#define	FIRE_JBC_ERR_LOG_EN_MB_PEA		0x0000000002000000ULL
#define	FIRE_JBC_ERR_LOG_EN_MB_PER		0x0000000001000000ULL
#define	FIRE_JBC_ERR_LOG_EN_MB_PEW		0x0000000000800000ULL
#define	FIRE_JBC_ERR_LOG_EN_UE_ASYN		0x0000000000400000ULL
#define	FIRE_JBC_ERR_LOG_EN_CE_ASYN		0x0000000000200000ULL
#define	FIRE_JBC_ERR_LOG_EN_JTE			0x0000000000100000ULL
#define	FIRE_JBC_ERR_LOG_EN_JBE			0x0000000000080000ULL
#define	FIRE_JBC_ERR_LOG_EN_JUE			0x0000000000040000ULL
#define	FIRE_JBC_ERR_LOG_EN_IJP			0x0000000000020000ULL
#define	FIRE_JBC_ERR_LOG_EN_ICISE		0x0000000000010000ULL
#define	FIRE_JBC_ERR_LOG_EN_CPE			0x0000000000008000ULL
#define	FIRE_JBC_ERR_LOG_EN_APE			0x0000000000004000ULL
#define	FIRE_JBC_ERR_LOG_EN_WR_DPE		0x0000000000002000ULL
#define	FIRE_JBC_ERR_LOG_EN_RD_DPE		0x0000000000001000ULL
#define	FIRE_JBC_ERR_LOG_EN_ILL_BMW		0x0000000000000800ULL
#define	FIRE_JBC_ERR_LOG_EN_ILL_BMR		0x0000000000000400ULL
#define	FIRE_JBC_ERR_LOG_EN_BJC			0x0000000000000200ULL
#define	FIRE_JBC_ERR_LOG_EN_PIO_UNMAP		0x0000000000000100ULL
#define	FIRE_JBC_ERR_LOG_EN_PIO_DPE		0x0000000000000080ULL
#define	FIRE_JBC_ERR_LOG_EN_PIO_CPE		0x0000000000000040ULL
#define	FIRE_JBC_ERR_LOG_EN_ILL_ACC		0x0000000000000020ULL
#define	FIRE_JBC_ERR_LOG_EN_UNSOL_RD		0x0000000000000010ULL
#define	FIRE_JBC_ERR_LOG_EN_UNSOL_INT		0x0000000000000008ULL
#define	FIRE_JBC_ERR_LOG_EN_JTCEEW		0x0000000000000004ULL
#define	FIRE_JBC_ERR_LOG_EN_JTCEEI		0x0000000000000002ULL
#define	FIRE_JBC_ERR_LOG_EN_JTCEER		0x0000000000000001ULL

/* JBC interrupt enable, interrupt status and error status clear registers */
#define	FIRE_JBC_ERR_INT_SPARE_S_MASK		0xe000000000000000ULL
#define	FIRE_JBC_ERR_INT_SPARE_S_SHFT		61
#define	FIRE_JBC_ERR_INT_PIO_UNMAP_RD_S		0x1000000000000000ULL
#define	FIRE_JBC_ERR_INT_ILL_ACC_RD_S		0x0800000000000000ULL
#define	FIRE_JBC_ERR_INT_EBUS_TO_S		0x0400000000000000ULL
#define	FIRE_JBC_ERR_INT_MB_PEA_S		0x0200000000000000ULL
#define	FIRE_JBC_ERR_INT_MB_PER_S		0x0100000000000000ULL
#define	FIRE_JBC_ERR_INT_MB_PEW_S		0x0080000000000000ULL
#define	FIRE_JBC_ERR_INT_UE_ASYN_S		0x0040000000000000ULL
#define	FIRE_JBC_ERR_INT_CE_ASYN_S		0x0020000000000000ULL
#define	FIRE_JBC_ERR_INT_JTE_S			0x0010000000000000ULL
#define	FIRE_JBC_ERR_INT_JBE_S			0x0008000000000000ULL
#define	FIRE_JBC_ERR_INT_JUE_S			0x0004000000000000ULL
#define	FIRE_JBC_ERR_INT_IJP_S			0x0002000000000000ULL
#define	FIRE_JBC_ERR_INT_ICISE_S		0x0001000000000000ULL
#define	FIRE_JBC_ERR_INT_CPE_S			0x0000800000000000ULL
#define	FIRE_JBC_ERR_INT_APE_S			0x0000400000000000ULL
#define	FIRE_JBC_ERR_INT_WR_DPE_S		0x0000200000000000ULL
#define	FIRE_JBC_ERR_INT_RD_DPE_S		0x0000100000000000ULL
#define	FIRE_JBC_ERR_INT_ILL_BMW_S		0x0000080000000000ULL
#define	FIRE_JBC_ERR_INT_ILL_BMR_S		0x0000040000000000ULL
#define	FIRE_JBC_ERR_INT_BJC_S			0x0000020000000000ULL
#define	FIRE_JBC_ERR_INT_PIO_UNMAP_S		0x0000010000000000ULL
#define	FIRE_JBC_ERR_INT_PIO_DPE_S		0x0000008000000000ULL
#define	FIRE_JBC_ERR_INT_PIO_CPE_S		0x0000004000000000ULL
#define	FIRE_JBC_ERR_INT_ILL_ACC_S		0x0000002000000000ULL
#define	FIRE_JBC_ERR_INT_UNSOL_RD_S		0x0000001000000000ULL
#define	FIRE_JBC_ERR_INT_UNSOL_INT_S		0x0000000800000000ULL
#define	FIRE_JBC_ERR_INT_JTCEEW_S		0x0000000400000000ULL
#define	FIRE_JBC_ERR_INT_JTCEEI_S		0x0000000200000000ULL
#define	FIRE_JBC_ERR_INT_JTCEER_S		0x0000000100000000ULL
#define	FIRE_JBC_ERR_INT_SPARE_P_MASK		0x00000000e0000000ULL
#define	FIRE_JBC_ERR_INT_SPARE_P_SHFT		29
#define	FIRE_JBC_ERR_INT_PIO_UNMAP_RD_P		0x0000000010000000ULL
#define	FIRE_JBC_ERR_INT_ILL_ACC_RD_P		0x0000000008000000ULL
#define	FIRE_JBC_ERR_INT_EBUS_TO_P		0x0000000004000000ULL
#define	FIRE_JBC_ERR_INT_MB_PEA_P		0x0000000002000000ULL
#define	FIRE_JBC_ERR_INT_MB_PER_P		0x0000000001000000ULL
#define	FIRE_JBC_ERR_INT_MB_PEW_P		0x0000000000800000ULL
#define	FIRE_JBC_ERR_INT_UE_ASYN_P		0x0000000000400000ULL
#define	FIRE_JBC_ERR_INT_CE_ASYN_P		0x0000000000200000ULL
#define	FIRE_JBC_ERR_INT_JTE_P			0x0000000000100000ULL
#define	FIRE_JBC_ERR_INT_JBE_P			0x0000000000080000ULL
#define	FIRE_JBC_ERR_INT_JUE_P			0x0000000000040000ULL
#define	FIRE_JBC_ERR_INT_IJP_P			0x0000000000020000ULL
#define	FIRE_JBC_ERR_INT_ICISE_P		0x0000000000010000ULL
#define	FIRE_JBC_ERR_INT_CPE_P			0x0000000000008000ULL
#define	FIRE_JBC_ERR_INT_APE_P			0x0000000000004000ULL
#define	FIRE_JBC_ERR_INT_WR_DPE_P		0x0000000000002000ULL
#define	FIRE_JBC_ERR_INT_RD_DPE_P		0x0000000000001000ULL
#define	FIRE_JBC_ERR_INT_ILL_BMW_P		0x0000000000000800ULL
#define	FIRE_JBC_ERR_INT_ILL_BMR_P		0x0000000000000400ULL
#define	FIRE_JBC_ERR_INT_BJC_P			0x0000000000000200ULL
#define	FIRE_JBC_ERR_INT_PIO_UNMAP_P		0x0000000000000100ULL
#define	FIRE_JBC_ERR_INT_PIO_DPE_P		0x0000000000000080ULL
#define	FIRE_JBC_ERR_INT_PIO_CPE_P		0x0000000000000040ULL
#define	FIRE_JBC_ERR_INT_ILL_ACC_P		0x0000000000000020ULL
#define	FIRE_JBC_ERR_INT_UNSOL_RD_P		0x0000000000000010ULL
#define	FIRE_JBC_ERR_INT_UNSOL_INT_P		0x0000000000000008ULL
#define	FIRE_JBC_ERR_INT_JTCEEW_P		0x0000000000000004ULL
#define	FIRE_JBC_ERR_INT_JTCEEI_P		0x0000000000000002ULL
#define	FIRE_JBC_ERR_INT_JTCEER_P		0x0000000000000001ULL

/* UBC interrupt enable, error status and error status clear registers */
#define	OBERON_UBC_ERR_INT_PIORBEUE_S		0x0004000000000000ULL
#define	OBERON_UBC_ERR_INT_PIOWBEUE_S		0x0002000000000000ULL
#define	OBERON_UBC_ERR_INT_PIOWTUE_S		0x0001000000000000ULL
#define	OBERON_UBC_ERR_INT_MEMWTAXB_S		0x0000080000000000ULL
#define	OBERON_UBC_ERR_INT_MEMRDAXB_S		0x0000040000000000ULL
#define	OBERON_UBC_ERR_INT_DMAWTUEB_S		0x0000020000000000ULL
#define	OBERON_UBC_ERR_INT_DMARDUEB_S		0x0000010000000000ULL
#define	OBERON_UBC_ERR_INT_MEMWTAXA_S		0x0000000800000000ULL
#define	OBERON_UBC_ERR_INT_MEMRDAXA_S		0x0000000400000000ULL
#define	OBERON_UBC_ERR_INT_DMAWTUEA_S		0x0000000200000000ULL
#define	OBERON_UBC_ERR_INT_DMARDUEA_S		0x0000000100000000ULL
#define	OBERON_UBC_ERR_INT_PIORBEUE_P		0x0000000000040000ULL
#define	OBERON_UBC_ERR_INT_PIOWBEUE_P		0x0000000000020000ULL
#define	OBERON_UBC_ERR_INT_PIOWTUE_P		0x0000000000010000ULL
#define	OBERON_UBC_ERR_INT_MEMWTAXB_P		0x0000000000000800ULL
#define	OBERON_UBC_ERR_INT_MEMRDAXB_P		0x0000000000000400ULL
#define	OBERON_UBC_ERR_INT_DMARDUEB_P		0x0000000000000200ULL
#define	OBERON_UBC_ERR_INT_DMAWTUEB_P		0x0000000000000100ULL
#define	OBERON_UBC_ERR_INT_MEMWTAXA_P		0x0000000000000008ULL
#define	OBERON_UBC_ERR_INT_MEMRDAXA_P		0x0000000000000004ULL
#define	OBERON_UBC_ERR_INT_DMAWTUEA_P		0x0000000000000002ULL
#define	OBERON_UBC_ERR_INT_DMARDUEA_P		0x0000000000000001ULL

/* JBC fatal reset enable register */
#define	FIRE_JBC_FATAL_RST_EN_SPARE_P_INT_MASK	0x000000000c000000ULL
#define	FIRE_JBC_FATAL_RST_EN_SPARE_P_INT_SHFT	26
#define	FIRE_JBC_FATAL_RST_EN_MB_PEA_P_INT	0x0000000002000000ULL
#define	FIRE_JBC_FATAL_RST_EN_CPE_P_INT		0x0000000000008000ULL
#define	FIRE_JBC_FATAL_RST_EN_APE_P_INT		0x0000000000004000ULL
#define	FIRE_JBC_FATAL_RST_EN_PIO_CPE_INT	0x0000000000000040ULL
#define	FIRE_JBC_FATAL_RST_EN_JTCEEW_P_INT	0x0000000000000004ULL
#define	FIRE_JBC_FATAL_RST_EN_JTCEEI_P_INT	0x0000000000000002ULL
#define	FIRE_JBC_FATAL_RST_EN_JTCEER_P_INT	0x0000000000000001ULL

/* JBC JBCINT in transaction error log register */
#define	FIRE_JBCINT_ITRANS_ERR_LOG_Q_WORD_MASK	0x00c0000000000000ULL
#define	FIRE_JBCINT_ITRANS_ERR_LOG_Q_WORD_SHFT	54
#define	FIRE_JBCINT_ITRANS_ERR_LOG_TRANSID_MASK	0x0003000000000000ULL
#define	FIRE_JBCINT_ITRANS_ERR_LOG_TRANSID_SHFT	48
#define	FIRE_JBCINT_ITRANS_ERR_LOG_ADDR_MASK	0x000007ffffffffffULL
#define	FIRE_JBCINT_ITRANS_ERR_LOG_ADDR_SHFT	0

/* JBC JBCINT in transaction error log register 2 */
#define	FIRE_JBCINT_ITRANS_ERR_LOG2_ARB_WN_MASK	0x000ffffff0000000ULL
#define	FIRE_JBCINT_ITRANS_ERR_LOG2_ARB_WN_SHFT	28
#define	FIRE_JBCINT_ITRANS_ERR_LOG2_J_REQ_MASK	0x000000000fe00000ULL
#define	FIRE_JBCINT_ITRANS_ERR_LOG2_J_REQ_SHFT	21
#define	FIRE_JBCINT_ITRANS_ERR_LOG2_J_PACK_MASK	0x00000000001fffffULL
#define	FIRE_JBCINT_ITRANS_ERR_LOG2_J_PACK_SHFT	0

/* JBC JBCINT out transaction error log register */
#define	FIRE_JBCINT_OTRANS_ERR_LOG_TRANSID_MASK	0x003f000000000000ULL
#define	FIRE_JBCINT_OTRANS_ERR_LOG_TRANSID_SHFT	48
#define	FIRE_JBCINT_OTRANS_ERR_LOG_ADDR_MASK	0x000007ffffffffffULL
#define	FIRE_JBCINT_OTRANS_ERR_LOG_ADDR_SHFT	0

/* JBC JBCINT out transaction error log register 2 */
#define	FIRE_JBCINT_OTRANS_ERR_LOG2_ARB_WN_MASK	0x000ffffff0000000ULL
#define	FIRE_JBCINT_OTRANS_ERR_LOG2_ARB_WN_SHFT	28
#define	FIRE_JBCINT_OTRANS_ERR_LOG2_J_REQ_MASK	0x000000000fe00000ULL
#define	FIRE_JBCINT_OTRANS_ERR_LOG2_J_REQ_SHFT	21
#define	FIRE_JBCINT_OTRANS_ERR_LOG2_J_PACK_MASK	0x00000000001fffffULL
#define	FIRE_JBCINT_OTRANS_ERR_LOG2_J_PACK_SHFT	0

/* JBC merge transaction error log register */
#define	FIRE_FATAL_ERR_LOG_DATA_MASK		0xffffffffffffffffULL
#define	FIRE_FATAL_ERR_LOG_DATA_SHFT		0

/* JBC merge transaction error log register 2 */
#define	FIRE_FATAL_ERR_LOG2_ARB_WN_MASK		0x000ffffff0000000ULL
#define	FIRE_FATAL_ERR_LOG2_ARB_WN_SHFT		28
#define	FIRE_FATAL_ERR_LOG2_J_REQ_MASK		0x000000000fe00000ULL
#define	FIRE_FATAL_ERR_LOG2_J_REQ_SHFT		21
#define	FIRE_FATAL_ERR_LOG2_J_PACK_MASK		0x00000000001fffffULL
#define	FIRE_FATAL_ERR_LOG2_J_PACK_SHFT		0

/* JBC merge transaction error log register */
#define	FIRE_MERGE_TRANS_ERR_LOG_Q_WORD_MASK	0x00c0000000000000ULL
#define	FIRE_MERGE_TRANS_ERR_LOG_Q_WORD_SHFT	54
#define	FIRE_MERGE_TRANS_ERR_LOG_TRANSID_MASK	0x0003000000000000ULL
#define	FIRE_MERGE_TRANS_ERR_LOG_TRANSID_SHFT	48
#define	FIRE_MERGE_TRANS_ERR_LOG_JBC_TAG_MASK	0x0000f80000000000ULL
#define	FIRE_MERGE_TRANS_ERR_LOG_JBC_TAG_SHFT	43
#define	FIRE_MERGE_TRANS_ERR_LOG_ADDR_MASK	0x000007ffffffffffULL
#define	FIRE_MERGE_TRANS_ERR_LOG_ADDR_SHFT	0

/* JBC DMCINT ODCD error log register */
#define	FIRE_DMCINT_ODCD_ERR_LOG_TRANS_ID_MASK	0x0030000000000000ULL
#define	FIRE_DMCINT_ODCD_ERR_LOG_TRANS_ID_SHFT	52
#define	FIRE_DMCINT_ODCD_ERR_LOG_AID_MASK	0x000f000000000000ULL
#define	FIRE_DMCINT_ODCD_ERR_LOG_AID_SHFT	48
#define	FIRE_DMCINT_ODCD_ERR_LOG_TTYPE_MASK	0x0000f80000000000ULL
#define	FIRE_DMCINT_ODCD_ERR_LOG_TTYPE_SHFT	43
#define	FIRE_DMCINT_ODCD_ERR_LOG_ADDR_MASK	0x000007ffffffffffULL
#define	FIRE_DMCINT_ODCD_ERR_LOG_ADDR_SHFT	0

/* JBC DMCINT IDC error log register */
#define	FIRE_DMCINT_IDC_ERR_DMC_CTAG_MASK	0x000000000fff0000ULL
#define	FIRE_DMCINT_IDC_ERR_DMC_CTAG_SHFT	16
#define	FIRE_DMCINT_IDC_ERR_TRANSID_MASK	0x000000000000c000ULL
#define	FIRE_DMCINT_IDC_ERR_AGNTID_MASK		0x0000000000003c00ULL
#define	FIRE_DMCINT_IDC_ERR_AGNTID_SHFT		10
#define	FIRE_DMCINT_IDC_ERR_SRCID_MASK		0x00000000000003e0ULL
#define	FIRE_DMCINT_IDC_ERR_SRCID_SHFT		5
#define	FIRE_DMCINT_IDC_ERR_TARGID_MASK		0x000000000000001fULL
#define	FIRE_DMCINT_IDC_ERRO_TARGID_SHFT	0

/* JBC CSR error log register */
#define	FIRE_JBC_CSR_ERR_LOG_WR			0x0000040000000000ULL
#define	FIRE_JBC_CSR_ERR_LOG_BMASK_MASK		0x000003fffc000000ULL
#define	FIRE_JBC_CSR_ERR_LOG_BMASK_SHFT		26
#define	FIRE_JBC_CSR_ERR_LOG_ADDR_MASK		0x0000000003ffffffULL
#define	FIRE_JBC_CSR_ERR_LOG_ADDR_SHFT		0

/* JBC core and block interrupt enable register */
#define	FIRE_JBC_CORE_BLOCK_INT_EN_JBC		0x8000000000000000ULL
#define	FIRE_JBC_CORE_BLOCK_INT_EN_CSR		0x0000000000000008ULL
#define	FIRE_JBC_CORE_BLOCK_INT_EN_MERGE	0x0000000000000004ULL
#define	FIRE_JBC_CORE_BLOCK_INT_EN_JBCINT	0x0000000000000002ULL
#define	FIRE_JBC_CORE_BLOCK_INT_EN_DMCINT	0x0000000000000001ULL

/* JBC core and block error status register */
#define	FIRE_JBC_CORE_BLOCK_ERR_STAT_CSR	0x0000000000000008ULL
#define	FIRE_JBC_CORE_BLOCK_ERR_STAT_MERGE	0x0000000000000004ULL
#define	FIRE_JBC_CORE_BLOCK_ERR_STAT_JBCINT	0x0000000000000002ULL
#define	FIRE_JBC_CORE_BLOCK_ERR_STAT_DMCINT	0x0000000000000001ULL

/* JBC performance counter select register - may also apply to UBC */
#define	FO_XBC_PRF_CNT_PIO_RD_PCIEB		0x0000000000000018ULL
#define	FO_XBC_PRF_CNT_PIO_WR_PCIEB		0x0000000000000017ULL
#define	FO_XBC_PRF_CNT_PIO_RD_PCIEA		0x0000000000000016ULL
#define	FO_XBC_PRF_CNT_PIO_WR_PCIEA		0x0000000000000015ULL
#define	FO_XBC_PRF_CNT_WB			0x0000000000000014ULL
#define	FO_XBC_PRF_CNT_PIO_FRGN			0x0000000000000013ULL
#define	FO_XBC_PRF_CNT_XB_NCHRNT		0x0000000000000012ULL
#define	FO_XBC_PRF_CNT_FO_CHRNT			0x0000000000000011ULL
#define	FO_XBC_PRF_CNT_XB_CHRNT			0x0000000000000010ULL
#define	FO_XBC_PRF_CNT_AOKOFF_DOKOFF		0x000000000000000fULL
#define	FO_XBC_PRF_CNT_DOKOFF			0x000000000000000eULL
#define	FO_XBC_PRF_CNT_AOKOFF			0x000000000000000dULL
#define	FO_XBC_PRF_CNT_RD_TOTAL			0x000000000000000cULL
#define	FO_XBC_PRF_CNT_WR_TOTAL			0x000000000000000bULL
#define	FO_XBC_PRF_CNT_WR_PARTIAL		0x000000000000000aULL
#define	FO_XBC_PRF_CNT_PIOS_CSR_RINGB		0x0000000000000009ULL
#define	FO_XBC_PRF_CNT_PIOS_CSR_RINGA		0x0000000000000008ULL
#define	FO_XBC_PRF_CNT_PIOS_EBUS		0x0000000000000007ULL
#define	FO_XBC_PRF_CNT_PIOS_I2C			0x0000000000000006ULL
#define	FO_XBC_PRF_CNT_RD_LAT_SMPLS		0x0000000000000005ULL
#define	FO_XBC_PRF_CNT_RD_LAT			0x0000000000000004ULL
#define	FO_XBC_PRF_CNT_ON_XB			0x0000000000000003ULL
#define	FO_XBC_PRF_CNT_XB_IDL			0x0000000000000002ULL
#define	FO_XBC_PRF_CNT_XB_CLK			0x0000000000000001ULL
#define	FO_XBC_PRF_CNT_NONE			0x0000000000000000ULL
#define	FO_XBC_PRF_CNT_CNT1_SHFT		8
#define	FO_XBC_PRF_CNT_CNT0_SHFT		0

/* JBC performance counter 0/1 registers - may also apply to UBC */
#define	FO_XBC_PRF_CNT_MASK			0xffffffffffffffffULL
#define	FO_XBC_PRF_CNT_SHFT			0

/* Lookup tables */
const uint16_t const fire_freq_nak_tmr_thrs[6][4] = {
	{ 0x00ed, 0x049, 0x043, 0x030 },
	{ 0x01a0, 0x076, 0x06b, 0x048 },
	{ 0x022f, 0x09a, 0x056, 0x056 },
	{ 0x042f, 0x11a, 0x096, 0x096 },
	{ 0x082f, 0x21a, 0x116, 0x116 },
	{ 0x102f, 0x41a, 0x216, 0x216 }
};

const uint16_t const fire_rply_tmr_thrs[6][4] = {
	{ 0x0379, 0x112, 0x0fc, 0x0b4 },
	{ 0x0618, 0x1BA, 0x192, 0x10e },
	{ 0x0831, 0x242, 0x143, 0x143 },
	{ 0x0fb1, 0x422, 0x233, 0x233 },
	{ 0x1eb0, 0x7e1, 0x412, 0x412 },
	{ 0x3cb0, 0xf61, 0x7d2, 0x7d2 }
};

/* Register default values */
#define	FO_PCI_TLU_CTRL_L0S_TIM_DFLT		0xda
#define	FO_PCI_TLU_CTRL_CFG_DFLT		0x1
#define	FO_PCI_LPU_LTSSM_CFG2_12_TO_DFLT	0x2dc6c0
#define	FO_PCI_LPU_LTSSM_CFG3_2_TO_DFLT		0x7a120
#define	FO_PCI_LPU_LTSSM_CFG4_DATA_RATE_DFLT	0x2
#define	FO_PCI_LPU_LTSSM_CFG4_N_FTS_DFLT	0x8c
#define	OBERON_PCI_LPU_TXLNK_RPLY_TMR_THRS_DFLT	0xc9
#define	FO_PCI_LPU_TXLNK_RTR_FIFO_PTR_HD_DFLT	0x0
#define	FO_PCI_LPU_TXLNK_RTR_FIFO_PTR_TL_DFLT	0xffff

/* INO macros */
#define	FO_EQ_FIRST_INO				0x18
#define	FO_EQ_LAST_INO				0x3b
#define	FO_DMC_PEC_INO				0x3e
#define	FO_XCB_INO				0x3f
#define	FO_MAX_INO				FO_XCB_INO

/* Device space macros */
#define	FO_CONF_BUS_SHFT			20
#define	FO_CONF_DEV_SHFT			15
#define	FO_CONF_FUNC_SHFT			12
#define	FO_CONF_REG_SHFT			0
#define	FO_IO_SIZE				0x10000000
#define	FO_MEM_SIZE				0x1ffff0000

#define	FO_CONF_OFF(bus, slot, func, reg)				\
	(((bus) << FO_CONF_BUS_SHFT) |					\
	((slot) << FO_CONF_DEV_SHFT) |					\
	((func) << FO_CONF_FUNC_SHFT) |					\
	((reg) << FO_CONF_REG_SHFT))

/* Width of the physical addresses the IOMMU translates to */
#define	FIRE_IOMMU_BITS				43
#define	OBERON_IOMMU_BITS			47

/* Event queue macros */
#define	FO_EQ_ALIGNMENT				(512 * 1024)
#define	FO_EQ_NRECORDS				128
#define	FO_EQ_RECORD_SIZE			64

/* Event queue record format */
struct fo_msiq_record {
	uint64_t	fomqr_word0;
	uint64_t	fomqr_word1;
	uint64_t	fomqr_reserved[6];
};

#define	FO_MQR_WORD0_FMT_TYPE_MASK		0x7f00000000000000ULL
#define	FO_MQR_WORD0_FMT_TYPE_SHFT		56
#define	FO_MQR_WORD0_FMT_TYPE_MSI64		0x7800000000000000ULL
#define	FO_MQR_WORD0_FMT_TYPE_MSI32		0x5800000000000000ULL
#define	FO_MQR_WORD0_FMT_TYPE_MSG		0x3000000000000000ULL
#define	FO_MQR_WORD0_FMT_TYPE_MSG_ROUTE_MASK	0x0700000000000000ULL
#define	FO_MQR_WORD0_FMT_TYPE_MSG_ROUTE_SHFT	56
#define	FO_MQR_WORD0_LENGTH_MASK		0x00ffc00000000000ULL
#define	FO_MQR_WORD0_LENGTH_SHFT		46
#define	FO_MQR_WORD0_ADDR0_MASK			0x00003fff00000000ULL
#define	FO_MQR_WORD0_ADDR0_SHFT			32
#define	FO_MQR_WORD0_RID_MASK			0x00000000ffff0000ULL
#define	FO_MQR_WORD0_RID_SHFT			16
#define	FO_MQR_WORD0_DATA0_MASK			0x000000000000ffffULL
#define	FO_MQR_WORD0_DATA0_SHFT			0
#define	FO_MQR_WORD1_ADDR1_MASK			0xffffffffffff0000ULL
#define	FO_MQR_WORD1_ADDR1_SHFT			16
#define	FO_MQR_WORD1_DATA1_MASK			0x000000000000ffffULL
#define	FO_MQR_WORD1_DATA1_SHFT			0

#endif /* !_SPARC64_PCI_FIREREG_H_ */
