/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <math.h>

#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>

#include <X11/extensions/shape.h>

#include "struct.h"
#include "config.h"

#define	ABSDIFF(a,b)	((long)((a) - (b)) < 0 ? (b) - (a) : (a) - (b))


/*
 * Global variables
 */
extern	XtAppContext	app_context;

extern	Widget	toplevel,		/* Das Toplevel widget fuer die Cursor */
		dir_area;		/* Wird zum Loeschen der Selction gebraucht */

extern	Cursor	def_cursor;
extern	Cursor	file_cursor;
extern	Cursor	busy_cursor;

extern	GC		line_gc;
extern	GC		selc_gc;
extern	GC		back_gc;

extern	Dimension	folder_count;
extern	Folder_Glyph	*folders[];
extern	Folder_Glyph	*folder;
extern	Dir_Glyph	root;

extern	Dimension	selc_f;		/* Die derzeitigen Selections */
extern	Dir_Glyph	*selc_g;
extern	Time		selc_t;		/* Der Timer fuer Doppelclicks */
	Folder_Glyph	*selc_fo = NULL;/* Der Folder in dem selectiert wurde */

extern	Dir_Glyph	*last_g;
extern	Dimension	last_v;
extern	Dimension	last_y;
	Folder_Glyph	*last_fo = NULL;

	WS_Glyph	*selc_ws = NULL;/* Parameter fuer Workspacehandling */
	Dimension	selc_w = 16000;
	WS_Glyph	*last_ws = NULL;
	Dimension	last_w = 16000;
extern	WS_Glyph	workspace;

extern	Boolean		GRAB;
	Boolean		REFRESH = FALSE;

extern	xfm_struct	defaults;
extern  Suffix_Glyph    *filetypes;

extern	Boolean		FILE_CHANGED;
extern	Boolean		DIR_CHANGED;

extern	int		label_height;
extern	int		vp_width;

extern	Dimension	typelength;

	Widget		ws_move_shell = NULL;	/* Es wird ein Window erzeugt, in dem zum verschieben */
						/* von Icons das Icon dargestellt wird */
	int		ws_move_offx;
	int		ws_move_offy;
extern	GC		selc_gc;
extern	Pixmap		File_Exec_PM;
extern	Pixmap		Shape_Exec_PM;
extern	int		workspace_changed;



/*
 * Function Prototypes
 */

XtActionProc	startSingle    (Widget w, XButtonEvent *e,
				String *s, Cardinal *c);
XtActionProc	followSingle   (Widget w, XButtonEvent *e,
				String *s, Cardinal *c);
XtActionProc	endSingle      (Widget w, XButtonEvent *e,
				String *s, Cardinal *c);
XtActionProc	clearSingle    (Widget w, XEvent *e,
				String *s, Cardinal *c);
XtActionProc 	followDir      (Widget w, XMotionEvent *e, 
				String *s, Cardinal *c);
XtActionProc 	followFile     (Widget w, XMotionEvent *e, 
				String *s, Cardinal *c);
XtActionProc 	followWS       (Widget w, XMotionEvent *e, 
				String *s, Cardinal *c);
XtActionProc	refresh_icon   (Widget w, XExposeEvent *e, 
				String *s, Cardinal *c);

/* graph.c */
extern	void	drawDir	       (Widget window, Dir_Glyph *dir, 
				Boolean select, Boolean back);
extern	void	drawFile       (Folder_Glyph *folder, int entry,
				Boolean selected, Boolean back);
extern	void	drawWSE        (WS_Glyph *folder, int entry,
				Boolean selected, Boolean back);

/* main.c */
extern	Dir_Glyph *getGlyph    (Dir_Glyph *root, Dimension x, Dimension y);

/* dir.c */
extern	String	getPath        (Dir_Glyph *dir);

/* fodler.c */
extern	void	newFolder      (Dir_Glyph *dir);

/* grab.c */
extern	Widget	grabWindow	(XButtonEvent *e);

/* action_copy.c */
extern	void	init_copy       (char *from, char *to);
extern	void	exec_copy       (char *from, char *to);

/* action_move.c */
extern	void	init_move       (char *from, char *to);
extern	void	exec_more       (char *from, char *to);

/* workspace.c */
extern	void	addWSEtoWS     (WS_Glyph *ws, char *label,
				char *file, char *icon,
		 		Boolean can_arg, Boolean must_arg, Boolean do_ask, int x, int y);


/*********************************************************
 * name:	startSingle
 * description:	Ueberpruefen ob unter dem Zeiger ein
 *		anwaehltbares Item ist und, falls
 *		das Item zum zweiten Mal angewaehlt wurde
 *		und zwischen dem ersten und zweiten
 *		Click nicht mehr als defaults.click_interval
 *		millisekunden lagen, dann zum Doppelclick
 *		handler uebergehen
 * input:	none
 * output:	none
 * date:	14.6.93
 *********************************************************/
XtActionProc	startSingle    (Widget w, XButtonEvent *e,
				String *s, Cardinal *c)
{
	int	i;

	/*
	 * Cursor busy
	 */
	XDefineCursor (XtDisplay(dir_area), XtWindow(dir_area),
			busy_cursor);
	XDefineCursor (XtDisplay(workspace.window), 
			XtWindow(workspace.window), busy_cursor);
	for (i = 0; i < folder_count; i++)
		XDefineCursor (XtDisplay(folders[i]->window),
				XtWindow(folders[i]->window),
				busy_cursor);
	XFlush(XtDisplay(toplevel));

	/*
	 * Bewerten
	 */
	if (w != dir_area && w != workspace.window && folder) {
		int	y;

		/*
		 * Eintrag aus dem Folder holen
		 */
		y = (e->y - 4)/DIR_Y_STEP;
		
		last_v = y;

		/*
		 * Wenn Eintrag vorher noch nicht angewaehlt, dann neunen anwaehlen
		 */
		if (selc_f != last_v || selc_g || folder != selc_fo) {
			/*
			 * Neues File angewaehlt, alte Selection loeschen
			 */
			clearSingle (NULL, NULL, NULL, NULL);

			/*
			 * Markieren
			 */
			if (last_v < folder->file_count) {
				selc_f = last_v;
				selc_fo = folder;
				drawFile (folder, selc_f, TRUE, TRUE);
			}
		}
		/*
		 * Wenn Eintrag schon angewaehlt war, dann auf Doppelclick untersuchen
		 */
		else if (selc_f < 16000 && last_v == selc_f && selc_fo &&
			 ABSDIFF(e->time,selc_t) < defaults.click_interval) {
			/*
			 * Doppelclick -> Je nach Filetype Operation ausfuehren
			 */
			File_Glyph	*file = folder->file[selc_f];

			/*
			 * Pfeil fuer das Parentdir -> Eins im Directorybaum zurueck
			 */
			if (file->prog_type == FILE_ROOT && folder->dir->parent) {
				if (!defaults.multi_window) {
					Arg	args[1];
					char	*s;

					folder->dir = folder->dir->parent;
					s = getPath(folder->dir);
					selc_f = 16000;
					fillFolder(folder);
					FILE_CHANGED = TRUE;
					refresh_files(folder->window,NULL,NULL,NULL);
					XtSetArg(args[0],XtNlabel,(*s == '\0' ? "/" : s));
					XtSetValues(folder->label,args,1);
				}
			}
			/*
			 * Directory angewaehlt, eins im Baum hoch
			 */
			else if (file->prog_type == FILE_DIR ||
				 file->prog_type == FILE_LDIR) {
				int	i = 0, j = -1;

				/*
				 * Directory Glyph aus dem folder->dir Glyph heraus suchen
				 */
				if (!folder->dir->open && !folder->dir->dir_count) {
					fillDir(folder->dir);
					folder->dir->open = FALSE;
				}
				while (i < folder->dir->dir_count) {
					if (!(strcmp(folder->dir->dir[i]->name,file->name))) {
						j = i;
						i = folder->dir->dir_count;
					}
					i++;
				}
				/*
				 * Es gab ein solches Glyph, also Glyph fuellen und
				 * Folder neu darstellen
				 */
				if (j > -1) {
					if (defaults.multi_window) {
						Dir_Glyph	*nd;

						nd = folder->dir->dir[j];
						if (!nd->open && nd->dir_count == 0) {
							fillDir(nd);
							nd->open = FALSE;
						}
						clearSingle (NULL,NULL,NULL,NULL);
						newFolder (nd);
					}
					else {
						Arg	args[1];
						char	*s;

						selc_f = 16000;
						folder->dir = folder->dir->dir[j];
						s = getPath(folder->dir);
						if (!folder->dir->open && folder->dir->dir_count == 0) {
							fillDir (folder->dir);
							folder->dir->open = FALSE;
						}
						fillFolder (folder);
						FILE_CHANGED = TRUE;
						refresh_files(folder->window,NULL,NULL,NULL);
						XtSetArg(args[0],XtNlabel,(*s == '\0' ? "/" : s));
						XtSetValues(folder->label,args,1);
					}
				}
			}
			/*
			 * Angewaehltes File hatte die x-Flags gesetzt
			 */
			else if (file->prog_type == FILE_EXEC) {
				char	buf[300];
				char	*s = getPath(folder->dir);

				sprintf(buf,"xterm -geometry 80x4 -e %s/%s &\0",s,file->name);
				SYSTEM(buf);
				free(s);
			}
			/*
			 * Bei sonstigen Files in der Commandsliste nachsuchen
			 */
			else if (file->prog_type != FILE_PLAIN) {
				int	i = 0;

				while (filetypes[i].cmd && filetypes[i].type != file->prog_type)
					i++;

				if (filetypes[i].type == file->prog_type) {
					char	buf[200];
					char	*s = getPath(folder->dir);
					char	nbuf[200];

					sprintf(nbuf,"%s/%s",s,file->name);
					sprintf(buf,filetypes[i].cmd,nbuf);
					SYSTEM(buf);
					free(s);
					clearSingle(NULL,NULL,NULL,NULL);
				}
			}
		}
		/*
		 * Timer updaten
		 */
		selc_t = e->time;
	}
	else if (w == dir_area) {
		/*
		 * Glyph holen
		 */
		last_g = getGlyph(&root, e->x,e->y);
		if (last_g)
			last_y = last_g->y + 8;
		else
			last_y = 16000;

		/*
		 * Nachsehen ob Eintrag schon angewaehlt war. Wenn nicht, dann
		 * neu anwaehlen
		 */
		if (last_g != selc_g || (selc_f < 16000 && selc_fo)) {
			/*
			 * Alte Selection loeschen
			 */
			clearSingle (NULL, NULL, NULL, NULL);

			/*
			 * Markieren
			 */
			if (last_g) {
				selc_g = last_g;
				drawDir (dir_area, selc_g, TRUE, TRUE);
			}
		}
		/*
		 * Eintrag war schon angewaehlt, Pruefen ob Doppelclick
		 */
		else if (selc_g && last_g == selc_g &&
			 ABSDIFF(e->time,selc_t) < defaults.click_interval) {	/* Innerhalb der Doppelklickid */

			/*
			 * Nachpruefen ob Directory lesbar ist
			 */
			if (selc_g->flags & DIR_READABLE) {
				if (defaults.multi_window) {
					newFolder(selc_g);
				}
				else {
					Arg	args[1];
					char	*s = getPath(selc_g);

					selc_f = 16000;
					FILE_CHANGED = TRUE;
					folders[0]->dir = selc_g;
					fillFolder(folders[0]);
					refresh_files(folders[0]->window,NULL,NULL,NULL);
					XtSetArg(args[0],XtNlabel,(*s == '\0' ? "/" : s));
					XtSetValues(folders[0]->label,args,1);
				}
				selc_g->open = FALSE;
			}
		}
		/*
		 * Timer updaten
		 */
		selc_t = e->time;
	}
	else if (w == workspace.window) {
		int	x,y,i;

		/*
		 * last_ws und last_w holen
		 */
		last_ws = &workspace;
		last_w = 16000;
		x = e->x;
		y = e->y;

		for (i = 0; last_w == 16000 && i < last_ws->wse_count; i++)
			if (last_ws->wse[i]->x - last_ws->wse[i]->w/2 <= x &&
			    last_ws->wse[i]->x + last_ws->wse[i]->w/2 > x &&
			    last_ws->wse[i]->y <= y &&
			    last_ws->wse[i]->y + last_ws->wse[i]->h > y)
				last_w = i;

		/*
		 * Pruefen ob neuer Eintrag im Workspace angewaehlt
		 */
		if ((last_ws != selc_ws || last_w != selc_w)) {/* &&
			 last_ws && last_w < 16000) {*/
			/*
			 * Alte Selection loeschen
			 */
			clearSingle (NULL, NULL, NULL, NULL);

			/*
			 * Markieren
			 */
			if (last_ws && last_w < 16000) {
				selc_ws = last_ws;
				selc_w = last_w;
				drawWSE (last_ws, last_w, TRUE, TRUE);
			}
		}
		/*
		 * Auf Doppelclick pruefen
		 */
		else if (selc_ws == last_ws && last_w == selc_w &&
			 ABSDIFF(e->time,selc_t) < defaults.click_interval &&
			 !selc_ws->wse[selc_w]->must_arg) {
			/*
			 * Doppelclick -> Programm ausfuehren
			 */
			if (selc_ws->wse[selc_w]->do_ask)
				init_exec (selc_ws->wse[selc_w]->file,NULL);
			else
				exec_exec (selc_ws->wse[selc_w]->file,NULL);
		}

		/*
		 * Timer updaten
		 */
		selc_t = e->time;		
	}
	GRAB = FALSE;
	/*
	 * Cursor ruecksetzen
	 */
	XDefineCursor (XtDisplay(dir_area), XtWindow(dir_area),
			def_cursor);
	XDefineCursor (XtDisplay(workspace.window), 
			XtWindow(workspace.window), def_cursor);
	for (i = 0; i < folder_count; i++)
		XDefineCursor (XtDisplay(folders[i]->window),
				XtWindow(folders[i]->window),
				def_cursor);
	XFlush(XtDisplay(toplevel));
}

/*********************************************************
 * name:	followSingle
 * description:	bei gedrueckter Maustaste das Ziel der Graboperation
 *		markieren
 * input:	none
 * output:	none
 * date:	14.6.93
 *********************************************************/
XtActionProc	followSingle   (Widget w, XButtonEvent *e,
				String *s, Cardinal *c)
{
	/*
	 * Feststellen, in welchem Bereich der Pointer sich befindet
	 */
	if (w == dir_area && (selc_g || (selc_fo && selc_f < 16000)))
		followDir (w, (XMotionEvent *) e, s, c);
	else if (folder && w == folder->window &&
		 (selc_g || (selc_fo && selc_f < 16000)))
		followFile (w, (XMotionEvent *) e, s, c);
	else if (w == workspace.window && (selc_g || (selc_fo && selc_f < 16000)))
		followWS (w, (XMotionEvent *) e, s, c);
	else if (selc_ws && selc_w < 16000 && GRAB) {
		/* Nicht nur ws_move_shell, da die zu langsam ist */

		XEvent	ev;
		XMotionEvent	*event;
		int	mx,my;
		Boolean	got;

		mx = e->x_root + ws_move_offx;
		my = e->y_root + ws_move_offy;

		do {	/* Weitere Events gleich so auslesen, ohne das Fenster zu verschieben */
			got = FALSE;
			if (XCheckWindowEvent(XtDisplay(ws_move_shell),XtWindow(ws_move_shell),
					    ButtonMotionMask | EnterWindowMask
					    | LeaveWindowMask,&ev)) {
				event = (XMotionEvent *) &ev;

				got = TRUE;
				mx = event->x_root + ws_move_offx;
				my = event->y_root + ws_move_offy;
			}
		} while (got);

		printf("%d,%d,%d\n",mx,defaults.snap_grid,fmod(mx,defaults.snap_grid));
		mx -= fmod(mx,defaults.snap_grid);
		my -= fmod(my,defaults.snap_grid);

		XMoveWindow(XtDisplay(ws_move_shell),XtWindow(ws_move_shell),mx,my);
	}

	/*
	 * Auf Grabmode schalten - Nur im Dir-Feld und Folder
	 */
	if (!GRAB && (selc_g || (selc_fo && selc_f < 16000) || (selc_ws && selc_w < 16000))) {
		int	i;

		XUngrabPointer(XtDisplay(toplevel),CurrentTime);
		if (w == workspace.window) {
			ws_move_offx = last_ws->wse[last_w]->x - last_ws->wse[last_w]->w/2 - e->x;
			ws_move_offy = last_ws->wse[last_w]->y - e->y;

			ws_move_shell = XtVaCreatePopupShell("ws_move_shell",overrideShellWidgetClass,
								workspace.shell,
								XtNwidth,last_ws->wse[last_w]->w,
								XtNheight,last_ws->wse[last_w]->h,
								XtNx, e->x_root + ws_move_offx,
								XtNy, e->y_root + ws_move_offy,
								XtNborderWidth, 0,
								NULL);
			XtOverrideTranslations(ws_move_shell,XtParseTranslationTable(
							     "<Expose>: refresh-icon() \n\
							      <Btn1Up>: end-single() \n\
							      <Btn1Motion>: follow-single()"));
			XtManageChild(ws_move_shell);
			workspace_changed = TRUE;

			/* Shape setzen, damit der Rand verschwindet */
			if (last_ws->wse[last_w]->shape)
				XShapeCombineMask(XtDisplay(ws_move_shell),XtWindow(ws_move_shell),
						  ShapeBounding,0,0,last_ws->wse[last_w]->shape,
						  ShapeSet);
/*			else if (!last_ws->wse[last_w]->pmap)
				XShapeCombineMask(XtDisplay(ws_move_shell),XtWindow(ws_move_shell),
						  ShapeBounding,0,0,Shape_Exec_PM,
						  ShapeSet);
*/
			/* Pointer grabben */
			XGrabPointer (XtDisplay(toplevel),XtWindow(workspace.window), True,
					ButtonReleaseMask | Button1MotionMask,
					GrabModeAsync, GrabModeAsync, 
					XtWindow(workspace.window), def_cursor,
					CurrentTime);
		}
		else	/* Grabben begann nicht ueber einem Icon */
			XGrabPointer (XtDisplay(toplevel),XtWindow(toplevel), True,
					ButtonReleaseMask | Button1MotionMask,
					GrabModeAsync, GrabModeAsync, None, file_cursor,
					CurrentTime);
		GRAB = TRUE;
		REFRESH = TRUE;
	}
}

/*********************************************************
 * name:	endSingle
 * description:	Die Maustaste wurde losgelassen. Danach
 *		falls eine Graboperation stattgefunden
 *		hat das Ziel bestimmen und die
 *		entsprechende Operation ausfuehren
 * input:	none
 * output:	none
 * date:	14.6.93
 *********************************************************/
XtActionProc	endSingle      (Widget w, XButtonEvent *e,
				String *s, Cardinal *c)
{
	Arg	args[2],largs[2];
	int	i;

	/*
	 * Cursor busy
	 */
	XDefineCursor (XtDisplay(dir_area), XtWindow(dir_area),
			busy_cursor);
	XDefineCursor (XtDisplay(workspace.window), 
			XtWindow(workspace.window), busy_cursor);
	for (i = 0; i < folder_count; i++)
		XDefineCursor (XtDisplay(folders[i]->window),
				XtWindow(folders[i]->window),
				busy_cursor);
	XFlush(XtDisplay(toplevel));

	/*
	 * Der Endpunkt der Graboperation lag im Dir-Feld
	 */
	if (w == dir_area) {
		Dir_Glyph	*dir;

		/*
		 * Zunaechst einmal muss anhand der Koordinaten das entsprechde
		 * Dir_Glyph heraus gesucht werden
		 */
		dir = last_g;

		if (dir) {
			/*
			 * Nachsehen ob gerade eine Move-Grab operation ausgefuehrt wird
			 */
			if (GRAB) {
				int	i;

				if (selc_g && dir != selc_g) {
					/*
					 * Verschieben des Directories in das gerade selectierte
					 */
					struct	stat	buf;
					uid_t		uid = getuid();
					char		*got1 = getPath(selc_g);
					char		*got2 = getPath(dir);

					stat(got1,&buf);
					if (buf.st_uid != uid)
						init_copy (got1, got2);
					else
						init_move (got1, got2);
					free (got1);
					free (got2);
				}
				else if (selc_fo && selc_fo->dir != dir) {
					char	sbuf[255];
					char	*got1;
					char	*got2;

					/*
					 * Verschieben des Icons vom folder->window in die Dir-area
					 */
					got1 = getPath(selc_fo->dir);
					got2 = getPath(dir);
					if (strcmp(got1,"/"))
						sprintf(sbuf,"%s/%s",got1,
							selc_fo->file[selc_f]->name);
					else
						sprintf(sbuf,"/%s",
							selc_fo->file[selc_f]->name);
					{
						struct	stat	buf;
						uid_t		uid = getuid();

						stat(sbuf,&buf);
						if (buf.st_uid != uid) {
							if (defaults.drag_copy)
								init_copy (sbuf, got2);
							else
								exec_copy (sbuf, got2);
						}
						else {
							if (defaults.drag_move)
								init_move (sbuf, got2);
							else
								exec_move (sbuf, got2);
						}
					}
					free(got1);
					free(got2);
				}
				GRAB = FALSE;
				/*
				 * Unhighlight target
				 */
				XDrawRectangle(XtDisplay(dir_area),XtWindow(dir_area),
					       back_gc, last_g->x - 4, last_g->y - 2,
					       32 + XTextWidth (defaults.icon_font,
						last_g->name,strlen(last_g->name)), 20);
			}
			else if (!GRAB) {
				/*
				 * Nachpruefen ob Directory geoeffnet ist
				 */
				if (selc_g->open) {
					if (selc_g->dir_count > 0)
						DIR_CHANGED = TRUE;
					selc_g->open = FALSE;
					refresh_dirs(NULL,NULL,NULL,NULL);
				}
				else {
					if (selc_g->flags & DIR_READABLE) {
						fillDir(selc_g);
						if (selc_g->dir_count > 0)
							DIR_CHANGED = TRUE;
						refresh_dirs(NULL,NULL,NULL,NULL);
					}
				}
			}
			last_g = NULL;
			last_y = 16000;
		}
	}
	/*
	 * Der Endpunkt der Grabaktion lag im File-Feld
	 */
	else if (folder && w == folder->window) {
		/*
		 * Testen ob zum Schluss noch ein Argument aktiviert war
		 */
		if (GRAB) {
			int	i;

			if (selc_fo && selc_f < 16000 && last_v != selc_f) {
				char	sbuf[200];
				char	dbuf[200];
				char	*got1;
				char	*got2;

				got1 = getPath(selc_fo->dir);
				got2 = getPath(folder->dir);

				if (strcmp(got1,"/"))
					sprintf(dbuf,"%s/%s",got1,selc_fo->file[selc_f]->name);
				else
					sprintf(dbuf,"/%s",folder->file[selc_f]->name);

				if (last_v < 16000) {
					if (strcmp(got2,"/"))
						sprintf(sbuf,"%s/%s",got2,folder->file[last_v]->name);
					else
						sprintf(sbuf,"/%s",folder->file[last_v]->name);
				}
				else
					sprintf(sbuf,"%s",got2);

				if (last_v < 16000 || folder != selc_fo) {
					if (last_v < 16000 && 
					    folder->file[last_v]->prog_type == FILE_EXEC)
						init_exec (sbuf,dbuf);
					else {
						struct	stat	buf;
						uid_t		uid = getuid();

						stat(dbuf,&buf);
						if (buf.st_uid != uid) {
							if (defaults.drag_copy)
								init_copy (dbuf, sbuf);
							else
								exec_copy (dbuf, sbuf);
						}
						else {
							if (defaults.drag_move)
								init_move (dbuf, sbuf);
							else
								exec_move (dbuf, sbuf);
						}
					}
				}

				free(got1);
				free(got2);
			}
			else if (selc_g) {
				char	sbuf[200];
				char	*got1 = getPath(folder->dir);
				char	*got2 = getPath(selc_g);

				if (last_v < 16000) {
					if (strcmp(got1,"/"))
						sprintf(sbuf,"%s/%s",got1,folder->file[last_v]->name);
					else
						sprintf(sbuf,"/%s",folder->file[last_v]->name);
				}
				else
					sprintf(sbuf,"%s",got1);


				if (last_v < 16000 && folder->file[last_v]->prog_type == FILE_EXEC)
					init_exec (got2,sbuf);
				else if (last_v < 16000) {
					struct	stat	buf;
					uid_t		uid = getuid();

					stat(got2,&buf);
					if (buf.st_uid != uid) {
						if (defaults.drag_copy)
							init_copy (got2, sbuf);
						else
							exec_copy (got2, sbuf);
					}
					else {
						if (defaults.drag_move)
							init_move (got2, sbuf);
						else
							exec_move (got2, sbuf);
					}
				}
				free (got1);
				free (got2);
			}
			GRAB = FALSE;
			/*
			 * unhighlight des Grabtargets
			 */
			if (last_fo)
				XDrawRectangle(XtDisplay(last_fo->window),
					       XtWindow(last_fo->window),
					       back_gc, 16, 
					       last_v*DIR_Y_STEP + 4,
					       last_fo->max_length + 50 + typelength, 20);
		}
		last_v = 16000;
	}
	/*
	 * Endpunkt lag im Workspace
	 */
	else if (w == workspace.window) {
		if (ws_move_shell)
			XtDestroyWidget(ws_move_shell);
		ws_move_shell = NULL;
		if (GRAB) {	/* Es wurde was gezogen */
			if (last_ws && last_w < 16000) {
				char	s[1024];

				/*
				 * Aus dem Directoyfolder wurde was gedragged
				 */
				if (selc_g && last_ws->wse[last_w]->can_arg) {
					char	*d = getPath(selc_g);

					sprintf(s,"%s %s",last_ws->wse[last_w]->file,d);
					if (defaults.drag_exec)
						init_exec(s,NULL);
					else
						exec_exec(s,NULL);
					free(d);
				}
				else if (selc_fo && selc_f < 16000 &&
					 last_ws->wse[last_w]->can_arg) {
					char	*d = getPath(selc_fo->dir);

					if (strcmp(d,"/"))
						sprintf(s,"%s %s/%s",last_ws->wse[last_w]->file,
								d,selc_fo->file[selc_f]->name);
					else
						sprintf(s,"%s /%s",last_ws->wse[last_w]->file,
								selc_fo->file[selc_f]->name);
					if (defaults.drag_exec)
						init_exec(s,NULL);
					else
						exec_exec(s,NULL);
					free(d);					
				}
				/*
				 * Ziel unhighlighten
				 */
				XDrawRectangle(XtDisplay(toplevel),
						XtWindow(last_ws->window),
						back_gc,
						last_ws->wse[last_w]->x - last_ws->wse[last_w]->w/2 - 1,
						last_ws->wse[last_w]->y - 1,
						last_ws->wse[last_w]->w +1, last_ws->wse[last_w]->h + 1);
				last_ws = NULL;
				last_w = 16000;
			}
			/*
			 * Neuen Eintrag im Workspace erzeugen - provisorisch
			 */
			else if (last_ws && selc_fo && selc_f < 16000) {
				char	*d = getPath(selc_fo->dir);
				char	s[1024];

				if (strcmp(d,"/"))
					sprintf(s,"%s/%s",d,selc_fo->file[selc_f]->name);
				else
					sprintf(s,"/%s",selc_fo->file[selc_f]->name);
				free(d);
				if (!(d = (char *) malloc (strlen(s)+1)))
					FATAL_ERROR("endSingle: Malloc failed");
				sprintf(d,"%s",s);
				addWSEtoWS(last_ws,selc_fo->file[selc_f]->name,d,
						NULL,TRUE,FALSE,TRUE,10,10);
				refreshWS(last_ws->window,NULL,NULL,NULL);
			}
			else if (selc_ws && selc_w < 16000) {
				int	x,y,rx,ry;
				unsigned int	mask;
				Window	child,root;
				int	mx,my;

				XQueryPointer(XtDisplay(selc_ws->window),XtWindow(selc_ws->window),
						&root,&child,&rx,&ry,&x,&y,&mask);
				mx = x + ws_move_offx + selc_ws->wse[selc_w]->w/2;
				my = y + ws_move_offy;
				selc_ws->wse[selc_w]->x = mx - mx%defaults.snap_grid;
				selc_ws->wse[selc_w]->y = my - my%defaults.snap_grid;
				XClearWindow(XtDisplay(selc_ws->window),XtWindow(selc_ws->window));
				refreshWS(selc_ws->window,NULL,NULL,NULL);		
			}
			GRAB = FALSE;
		}
	}
	else if (w == ws_move_shell) {
		int	x,y,rx,ry;
		unsigned int	mask;
		Window	child,root;
		int	mx,my;

		if (ws_move_shell)
			XtDestroyWidget(ws_move_shell);
		ws_move_shell = NULL;
		XQueryPointer(XtDisplay(selc_ws->window),XtWindow(selc_ws->window),
				&root,&child,&rx,&ry,&x,&y,&mask);
		mx = x + ws_move_offx + selc_ws->wse[selc_w]->w/2;
		my = y + ws_move_offy;
		selc_ws->wse[selc_w]->x = mx - fmod(mx,defaults.snap_grid);
		selc_ws->wse[selc_w]->y = my - fmod(my,defaults.snap_grid);
		XClearWindow(XtDisplay(selc_ws->window),XtWindow(selc_ws->window));
		refreshWS(selc_ws->window,NULL,NULL,NULL);		
		GRAB = FALSE;
	}
	/*
	 * Cursor ruecksetzen
	 */
	XUngrabPointer (XtDisplay(toplevel),CurrentTime);
	XDefineCursor (XtDisplay(dir_area), XtWindow(dir_area),
			def_cursor);
	XDefineCursor (XtDisplay(workspace.window), 
			XtWindow(workspace.window), def_cursor);
	for (i = 0; i < folder_count; i++)
		XDefineCursor (XtDisplay(folders[i]->window),
				XtWindow(folders[i]->window),
				def_cursor);
	XFlush(XtDisplay(toplevel));
}

/*********************************************************
 * name:	clearSingle
 * description:	SingleSelection loeschen
 * input:	none
 * output:	none
 * date:	14.6.93
 *********************************************************/

XtActionProc	clearSingle    (Widget w, XEvent *e,
				String *s, Cardinal *c)
{
	/*
	 * Zunaechst nachsehen ob noch ein Single-Select besteht.
	 * Wenn ja, dann loeschen.
	 */
	if (selc_g) {
		drawDir (dir_area, selc_g, FALSE, TRUE);
		selc_g = NULL;
		selc_f = 16000;
		selc_fo = NULL;
		selc_ws = NULL;
		selc_w = 16000;
	}
	else if (selc_fo && selc_f < 16000) {
		drawFile (selc_fo, selc_f, FALSE, TRUE);
		selc_f = 16000;
		selc_fo = NULL;
		selc_g = NULL;
		selc_ws = NULL;
		selc_w = 16000;
	}
	else if (selc_ws && selc_w < 16000) {
		drawWSE (selc_ws, selc_w, FALSE, TRUE);
		selc_f = 16000;
		selc_fo = NULL;
		selc_g = NULL;
		selc_ws = NULL;
		selc_w = 16000;
	}
}


/*********************************************************
 * name:	followFile
 * description:	Der Mauszeiger wird im gedrueckten Zustand im Folder bewegt
 * input:	Widget		w	- Das Fenster
 *		XMotionEvent	*e	- Der Event
 *		String		*s	- unused
 *		Cardinal	*c	- unused
 * output:	none
 * author:	Ove Kalkan
 * date:	15.6.93
 *********************************************************/
XtActionProc 	followFile (Widget w, XMotionEvent *e, String *s, Cardinal *c)
{
	int		y;

	y = (e->y - 4)/DIR_Y_STEP;
	if (folder && y != last_v) {
		if (last_v < 16000 && last_fo) {
			XDrawRectangle(XtDisplay(last_fo->window),
				       XtWindow(last_fo->window),
				       back_gc, 16, last_v*DIR_Y_STEP + 4,
				       last_fo->max_length + 50 + typelength, 20);
			last_v = 16000;
			last_fo = NULL;
		}
		if (y < folder->file_count && y >= 0) {
			File_Glyph	*file;
			uid_t 		uid = getuid();
			gid_t		gid = getgid();

			file = folder->file[y];
			if ((uid == file->uid && S_IWUSR&file->mode) ||
	      		     (gid == file->gid && S_IWGRP&file->mode) ||
			     S_IWOTH&file->mode) {
				last_v = y;
				last_fo = folder;
				if (GRAB && (last_v != selc_f || folder != selc_fo))
					XDrawRectangle(XtDisplay(folder->window),XtWindow(folder->window),
						       selc_gc, 16, last_v*DIR_Y_STEP + 4,
						       folder->max_length + 50 + typelength, 20);
			}
		}
	}
}



/*********************************************************
 * name:	followDir
 * description:	Der Mauszeiger wird im gedrueckten Zustand im DirWindow bewegt
 * input:	Widget		w	- Das Fenster
 *		XMotionEvent	*e	- Der Event
 *		String		*s	- unused
 *		Cardinal	*c	- unused
 * output:	none
 * author:	Ove Kalkan
 * date:	15.6.93
 *********************************************************/
XtActionProc 	followDir (Widget w, XMotionEvent *e, String *s, Cardinal *c)
{
	Dir_Glyph	*dir;
	int		y;

	/*
	 * Nachsehen ob eventuell wieder in einem neuen Feld
	 */
	y = (e->y - last_y < 0) ? (last_y - e->y) : (e->y - last_y);
	if (y > DIR_Y_STEP/2) {
		if (last_g) {
			XDrawRectangle(XtDisplay(dir_area),XtWindow(dir_area),
				       back_gc, last_g->x - 4, last_g->y - 2,
				       32 + XTextWidth (defaults.icon_font,
					last_g->name,strlen(last_g->name)), 20);
			last_y = 16000;
			last_g = NULL;
		}
		dir = getGlyph(&root,e->x,e->y);
		if (dir) {
			if (dir->flags & DIR_WRITEABLE) {
				last_g = dir;
				if (GRAB && selc_g != last_g && (selc_fo == NULL || selc_f == 16000 || selc_fo->dir != dir))
					XDrawRectangle(XtDisplay(dir_area),XtWindow(dir_area),
						       selc_gc, last_g->x - 4, last_g->y - 2,
						       32 + XTextWidth (defaults.icon_font,
							last_g->name,strlen(last_g->name)), 20);
				last_y = dir->y + 8;
			}
		}
	}
}


/*********************************************************
 * name:	followWS
 * description:	Auf ButtonMotionEvents im Workspace achten
 * input:	MotionEvent *e	- Der Event mit den
 *				  Koordinaten
 * output:	none
 * author:	Ove Kalkan
 * date:	29.6.1993
 *********************************************************/
XtActionProc 	followWS (Widget w, XMotionEvent *e, String *s, Cardinal *c)
{
	int		x,y,i;
	WS_Glyph 	*new_ws;
	Dimension	new_w = 16000;

	/*
	 * last_ws und last_w holen
	 */
	new_ws = &workspace;

	x = e->x;
	y = e->y;

	for (i = 0; new_w == 16000 && i < new_ws->wse_count; i++)
		if (new_ws->wse[i]->x - new_ws->wse[i]->w/2 <= x &&
		    new_ws->wse[i]->x + new_ws->wse[i]->w/2 > x &&
		    new_ws->wse[i]->y <= y &&
		    new_ws->wse[i]->y + new_ws->wse[i]->h > y)
			new_w = i;

	/*
	 * Altes Member dehighlighten
	 */
	if (new_ws != last_ws || new_w != last_w) {
		if (last_ws && last_w < 16000) {
			XDrawRectangle(XtDisplay(toplevel),
					XtWindow(last_ws->window),
					back_gc, 
					last_ws->wse[last_w]->x - last_ws->wse[last_w]->w/2 - 1,
					last_ws->wse[last_w]->y - 1,
					last_ws->wse[last_w]->w + 1, last_ws->wse[last_w]->h + 1);
			last_ws = NULL;
			last_w = 16000;
		}
		last_ws = new_ws;
		if (new_ws && new_w < 16000) {
			last_w = new_w;
			last_ws = new_ws;
			if (last_ws->wse[last_w]->can_arg)
				XDrawRectangle(XtDisplay(toplevel),
						XtWindow(last_ws->window),
						selc_gc,
						last_ws->wse[last_w]->x - last_ws->wse[last_w]->w/2 - 1,
						last_ws->wse[last_w]->y - 1,
						last_ws->wse[last_w]->w + 1, last_ws->wse[last_w]->h + 1);
		}
	}		
}


/*********************************************************
 * name:	refresh_icon
 * description:	neuzeichnen des Inhalts des gerade verschobenen Icons
 * input:	Das uebliche fuer XtActionProcs
 * output:	none
 * author:	Ove Kalkan
 * date:	10.8.1993
 *********************************************************/

XtActionProc	refresh_icon   (Widget w, XExposeEvent *e, 
				String *s, Cardinal *c)
{
	if (selc_ws->wse[selc_w]->pmap)
		XCopyArea(XtDisplay(w),selc_ws->wse[selc_w]->pmap,XtWindow(w),selc_gc,
				0,0,selc_ws->wse[selc_w]->w,selc_ws->wse[selc_w]->h,0,0);
	else
		XCopyArea(XtDisplay(w),File_Exec_PM,XtWindow(w),selc_gc,
				0,0,16,16,0,0);
}