/* $Header:   U:/engineer/sw/t2r/misc/clock.c_v   1.0   20 Nov 1992 11:59:46   galen  $
 */

/* Usage: clock frequency [set]
 *      frequency is specified in MHz
 */
#include <stdio.h>
#include "number9.h"

main(argc, argv)
int argc;
char *argv[];
{
  long frequency;
  long clock_numbers;
  double freq;

  if (argc > 1)
    {
      sscanf(argv[1], "%lf", &freq);
      frequency = 1000000 * freq;
      if (argc > 2)
        clock_numbers = n9calc_clock(frequency, atoi(argv[2]));
      else
        clock_numbers = n9calc_clock(frequency, 0);
      if (argc == 4)
        sscanf(argv[3], "%lx", &clock_numbers);
      frequency = n9get_clock(clock_numbers);
      printf("Frequency = %lf, clock numbers = 0x%lx\n",
             (double)frequency / 1000000.0, clock_numbers);
      if (argc > 2)
        frequency = n9set_clock(clock_numbers);
    }
  else
    {
      printf("Usage: clock <frequency> [set]\n");
    }
#if 0
    for (frequency = 20000000; frequency < 130000000; frequency += 50000)
      {
        clock_numbers = n9calc_clock(frequency, 2);
        (void)n9get_clock(clock_numbers);
      }
#endif /* 0 */
}
