/*  double/dbck.c	check consistency of DouBle file  20 Dec 1993
 *
 *  Copyright (C) 1994 Jean-Marc Verbavatz  <jmv@receptor.mgh.harvard.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <errno.h>
#include <linux/double.h>

struct dble_device db;
extern struct db_header dbh;

int verbose = 0 ;
int extensive = 0;

void read_opt(char *name, char *s)
{
	while(*s) {
		switch(*s) {
			case 'v': verbose = 1;
				  break;
			case 'f': extensive = 1;
				  break;
			case 0:	  return;
			default:  usage(name);
		}
		s++;
	}
}
main(argc, argv)
int argc;
char **argv;
{
int	i;
u_long	n, bitmaps, errors;
u_long	empty, total, blocks;
float	factor;
char *file = NULL;

for(i = 1; i < argc; i++)
	switch(*argv[i]) {
		case '-': read_opt(argv[0], argv[i]+1);
			  break;
		default: if(file != NULL) usage(argv[0]);
			 file = argv[i];
	}
if(file == NULL || !db_open(&db, file)) usage(argv[0]);

LZW_init();
printf("DouBle device version %d.%d\n", dbh.version>>8, dbh.version&0xff);

if(dbh.version < 2)
	printf("This device is an older one; converting recommanded\n");

/* Could check data from header here (I'll see to it later) */
if(verbose) printf("Header not checked\n");

total = blocks = empty = 0;
if(verbose) printf("Checking blocks ...\n");
for(n = errors = 0; n<db.oblocks; n++) {
	i = get_block(&db, n, extensive);
	if(verbose && !(n&0x7f)) {
		putchar('.');
		fflush(stdout);
	}
	switch(i) {
		case  0: empty++; break;
		case -1: printf("\nCannot read cluster map");
			 break;
		case -2: printf("\nError in cluster map");
			 break;
		case -3: printf("\nBlock used set clear in bitmap");
			 break;
		case -4: printf("\nCluster truncated");
			 break;
		case -5: printf("\nDecoding error");
			 break;
		case -6: printf("\nCompression method unknown");
			 break;
		default: if(i > 0) total += i, blocks++;
			 else printf("\nError %d unknown", i);
	}
	if(i < 0) {
		errors++;
		printf(", cluster %ld\n", n);
	}
}
if(errors && verbose) printf("%ld Error(s) found\n", errors);
total += db.addr_blocks;

if(verbose) {
	printf("Checking bitmap ... ");
	fflush(stdout);
}
for(bitmaps = n = 0; n < db.iblocks; n++)
	if(!get_bit(&db, n)) bitmaps++;
if(bitmaps == total) {
	if(verbose) printf("OK\n");
}
else printf("%ld blocks set used are clear\n", bitmaps-total);

if(total > 0) {
	factor = (float)db.ratio/((float)(total-db.addr_blocks)/blocks);
	printf("\nAverage compression factor (excluding headers) = %2.2f\n", factor);
	printf("Approximately %.0fK still available\n", factor*db.isize*(db.iblocks-total)/1024);
} else {
	factor = 0;
	if(verbose) printf("\nDevice is empty\n");
}
printf("%ld/%ld (%2d%%) cluster used, %ld/%ld (%2d%%) blocks used.\n",
	blocks, db.oblocks, (int)(100*blocks/db.oblocks), total, db.iblocks,
	(int)(100*total/db.iblocks));
db_close();
if(verbose && factor > 0) {
	printf("\nConclusion: ");
	if(db.iblocks > total) {
		factor = empty*db.ratio/factor/(db.iblocks-total);
		if(factor < 0.75)
			printf("Compression ratio better than expected !\n\n");
		else if(factor > 1.3)
			printf("Poor compression ratio; could run out of space (beware) !\n\n");
		else printf("So far, the compression ratio looks OK to me.\n\n");
	}
	else printf("!! This thing is FULL !! Action required immediately!\n\n");
}
if(errors) exit(4);
exit(0);
}

usage(char *s)
{
if(errno) perror(s);
printf("usage: %s [options] device_file\n", s);
printf("\tcheck consistency of \"DouBle\" device/file\n");
printf("\toptions:\n\t\t-v:\tverbose.\n\t\t-f:\tfull check (not implemented).\n\n");
if(errno) exit(8);
exit(16);
}
