/*
 *  Project   : tin - a Usenet reader
 *  Module    : win32.h
 *  Author    : S.Lam
 *  Created   : 01-06-87
 *  Updated   : 15-04-93
 *  Notes     : ndir.h for MS-DOS by Samuel Lam <skl@van-bc.UUCP>, June/87
 *  Copyright : (c) Copyright 1987-93 by Samuel Lam
 *              You may  freely  copy or  redistribute  this software,
 *              so  long as there is no profit made from its use, sale
 *              trade or  reproduction.  You may not change this copy-
 *              right notice, and it must be included in any copy made
 */

#if defined(WIN32)

#ifndef WIN32_H
#define WIN32_H

#define MSDOS_MAXNAMLEN	12
#define MAXNAMLEN		MSDOS_MAXNAMLEN

struct direct {
   long d_ino;
   short d_reclen;
   short d_namlen;
   char d_name[MAXNAMLEN + 1];
};

typedef struct {
   char filereserved[21];
   char fileattr;
   int  filetime, filedate;
   long filesize;
   char filename[MSDOS_MAXNAMLEN + 1];
} DTA;

typedef struct {
   char dirid[4];
   struct direct dirent;
   DTA dirdta;
   int dirfirst;
} DIR;

extern DIR *opendirx (const char *dirname, char *pattern);

#define opendir(x) opendirx(x, "*.*")

extern struct direct *readdir (DIR *dirp);
extern void closedir (DIR *dirp);

#endif	/* WIN32_H */

#endif	/* WIN32 */
