/* conf.h
   Define the site specific configuration values and macros */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.2     20 November 1991               */
     /*                version 1.1     20 April 1991                  */
     /*                version 1.0     04 March 1991                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992 by                                             */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/


#ifndef G_CONFIG_H
#define G_CONFIG_H

/* ----- application defaults ---- */
/* Following are the default values for application resources.
   These are easily overridden in the system's or user's application
   defaults file. */

#define ROOT_SERVER	"gopher.uiuc.edu"  /* default host server	  */
#define ROOT_PORT	70		/* default host server	 	  */
#define ROOT_PATH	""		/* default selector string 	  */
#define MAIN_TITLE	"UIUC Gopher  Information Service"
					/* title of main menu	          */

/*  HELP_FILE is set through a symbol in the Imake file.  The
    effect is similar to the following, but it allows the file
    to be placed in the proper place in the X11 directory structure.

    #define HELP_FILE	"/usr/lib/X11/xgopher/xgopher.help"
*/

#define ALLOW_SAVE	TRUE		/* allow files to be saved?	  */
#define ALLOW_COPY	TRUE		/* allow files to be copied?	  */

#define ALLOW_PRINT	TRUE		/* allow files to be printed?	  */
#define PRINT_COMMAND	"out" 		/* default print command	  */

#define ALLOW_TELNET	TRUE		/* allow telnet sessions          */
#define TELNET_COMMAND	"xterm -e telnet"
					/* command to start telnet  	  */

#define ALLOW_TN3270	TRUE		/* allow tn3270 item execution    */

#ifndef _AIX
#define TN3270_COMMAND	"xterm -e tn3270"
					/* command to start tn3270 	  */
#else
#define TN3270_COMMAND	"aixterm -e tn3270"
					/* command to start tn3270 from aix */
#endif

#define ALLOW_BOOKMARK_SAVE TRUE	/* allow bookmarks to be saveed?  */
#define BOOKMARK_FILE	"~/.gopherbk"	/* default bookmark save file	  */
#define APPEND_BOOKMARKS TRUE		 /* append bkmks to be current list? */

#define HAS_SOUND	FALSE		/* the X server(!) has sound	  */
#define SOUND_COMMAND	"/bin/false"	/* command to get sound out  	  */

#define ALLOW_IMAGE	TRUE		/* image display is allowed 	  */
#define IMAGE_COMMAND	"/bin/echo The image display command was not provided:"
					/* command to display image file  */

#define LOAD_BOOKMARKS	TRUE		/* load bookmarks at each restart */
#define RESET_OPTIONS	TRUE		/* reset options at each restart  */

#define SWAP_RESTART_QUIT	FALSE	/* Swap restart & quit buttons 	  */
#define RESTART_BUTTON	TRUE		/* show restart button   	  */
#define OPTIONS_BUTTON	TRUE		/* show option panel button	  */
#define ALL_ITEMS	TRUE		/* show all gopher items   	  */
#define DIR_HISTORY	TRUE		/* show directory history window  */

#define DIRECTORY_TIME	600		/* number of seconds a dir is valid */
#define ITEMS_TO_START	500		/* initial number of gopher items */
#define ITEMS_TO_ADD	50		/* alloc this many more when needed */
#define DIRS_TO_START	50		/* initial number of gopher dirs  */
#define DIRS_TO_ADD	10		/* alloc this many more when needed */
#define DOUBLE_CLICK	TRUE		/* Allow double click for selection */
#define MARK_ROOT	TRUE		/* set automatic  bookmark at root */
#define TEMP_DIRECTORY	"/tmp"		/* directory for bringing files to */

	/* the following prefixes must be <= PREFIX_LEN characters long */

#define PREFIX_FILE	"      "	/* listing prefix for text files     */
#define PREFIX_DIR	"\273     "	/* listing prefix for directories    */
#define PREFIX_CSO	"<cso> "	/* listing prefix for CSO nameservers */
#define PREFIX_INDEX	"<idx> "	/* listing prefix for index search   */
#define PREFIX_TELNET	"<tel> "	/* listing prefix for telnet session */
#define PREFIX_TN3270	"<tn3> "	/* listing prefix for tn3270 session */
#define PREFIX_BINARY	"<bin> "	/* listing prefix for binary files   */
#define PREFIX_IMAGE	"<img> "	/* listing prefix for image files    */
#define PREFIX_SOUND	"<snd> "	/* listing prefix for sound files    */
#define PREFIX_UNKNOWN	"<???> "	/* listing prefix for unknown files  */

/* ----- end of application defaults ---- */

#define	PATH_NAME_LEN		1024	/* characters in a file path name */
#define USER_STRING_LEN		100	/* length of user display string  */
#define PREFIX_LEN		6	/* length of user string prefix   */
#define SELECTOR_STRING_MAX_LEN	1024	/* max length of selector string  */
#define HOST_STRING_LEN		100	/* length of host name string     */
#define MESSAGE_STRING_LEN	256	/* length of strings for messages */
#define FILE_LINE_LEN		512	/* length of line in text file    */
#define HELP_SEC_TITLE_LEN	80	/* length of help item title      */
#define INDEX_WORD_LEN          1024	/* total len of index word string */
#define INDEX_WORD_COUNT        40	/* number of distinct index words */

#define GOPHER		"xgopher"	/* name of the thing!             */
#define GOPHER_CLASS	"Xgopher"	/* name of the application class  */

#define NL		'\n'		/* New Line character             */
#define EOL_STRING	"\r\n"		/* terminate queries with  this   */


/* ----- Portability ----- */

/*       Each server allows a maximum window size.  It is not clear that
	 the server can be queried to obtain this maximum value.  Most
	 servers allow 65535 x 65535  (width, height).  However, some HP
	 servers, for example, allow only 8192 x 8192.  The following
	 constants define this maximum.  It is used to create an overlay
	 window for the stopwatch cursor during time-consuming operations.

	 If you use a virtual root window (e.g., with tvtwm) larger than
	 about 8k square, then you should make these values larger.
*/

#define SERVER_MAX_WINDOW_WIDTH		8192
#define SERVER_MAX_WINDOW_HEIGHT	8192


/* ----- X11R4 compatability ----- */

/*       The include file "compatR4.h" should correctly determine
	 whether or not you are compiling with X11R4 (instead of the
	 preferred X11R5).  If the tests in that file are not
	 functioning then you should explicitly inform the compiler by
	 uncommenting the line below to define the symbol XGOPHER_X11R4.
*/

/*  #define XGOPHER_X11R4   */


#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define NO_FD	-1

#endif /* ifndef G_CONFIG_H */
