/* database_saves.c */

/* saveButtonCB() - called when user clicks "Save" button on main
 *                  conference database form
 * databaseDoSave() - called when user clicks "Ok" button on filename
 *                    dialog (child of main conference database form)
 * descsaveButtonCB() - called when user clicks "Save" button on
 *                      Conferences Descriptions popup
 * descsaveDoSave() - called when user clicks "Ok" button on filename
 *                    dialog (child of Conferences Descriptions popup
 */
 
#include "database.h"

void
saveButtonCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Arg     args[5];
    Widget  popup;
    Position    x, y;
    Dimension   width, height;
    register int n;


    n = 0;
    XtSetArg(args[0], XtNwidth, &width); n++;
    XtSetArg(args[1], XtNheight, &height); n++;
    XtGetValues(w, args, n);
    XtTranslateCoords(w, (Position) (width / 2),
            (Position) (height / 2), &x, &y);


    n = 0;
    XtSetArg(args[n], XtNx, x);             n++;
    XtSetArg(args[n], XtNy, y);             n++;

    popup = XtCreatePopupShell("databaseSavePopup",
        transientShellWidgetClass, w, args, n);

    databaseSaveDialog = XtCreateManagedWidget("databaseSaveDialog",
        dialogWidgetClass, popup,NULL, 0);

    XawDialogAddButton(databaseSaveDialog, "ok", databaseDoSave,
        client_data);
    XawDialogAddButton(databaseSaveDialog, "cancel", Destroy_form,
        (XtPointer)databaseSaveDialog);

    XtPopup(popup, XtGrabExclusive);
}

void
descsaveButtonCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Arg     args[5];
    Widget  popup;
    Position    x, y;
    Dimension   width, height;
    register int n;


    n = 0;
    XtSetArg(args[0], XtNwidth, &width); n++;
    XtSetArg(args[1], XtNheight, &height); n++;
    XtGetValues(w, args, n);
    XtTranslateCoords(w, (Position) (width / 2),
            (Position) (height / 2), &x, &y);


    n = 0;
    XtSetArg(args[n], XtNx, x);             n++;
    XtSetArg(args[n], XtNy, y);             n++;

    popup = XtCreatePopupShell("descsaveSavePopup",
        transientShellWidgetClass, w, args, n);

    descsaveSaveDialog = XtCreateManagedWidget("descsaveSaveDialog",
        dialogWidgetClass, popup,NULL, 0);

    XawDialogAddButton(descsaveSaveDialog, "ok", descsaveDoSave,
        NULL);
    XawDialogAddButton(descsaveSaveDialog, "cancel", Destroy_form,
        (XtPointer)descsaveSaveDialog);

    XtPopup(popup, XtGrabExclusive);
}

void
databaseDoSave(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Arg args[3];
    char line[MAXLINE], filename[MAXLINE];
    String fname;
    Widget asciiSrc, DisplayText;

#ifdef DEBUG
    printf("in databaseDoSave\n");
#endif
    fname = XawDialogGetValueString(databaseSaveDialog);

    strcpy(filename, fname);

    XtSetArg(args[0], XtNtextSource, &asciiSrc);
    XtGetValues(databaseDisplayText, args, 1);

    replace(filename, "~", Home);

    if (XawAsciiSaveAsFile(asciiSrc, filename)) {
        sprintf(line, "saved contents in %s", filename);
        set_status(line, GREEN);
    } else {
        sprintf(line, "couldn't save contents in %s", filename);
        set_status(line, RED);
    }

    XtDestroyWidget( XtParent(databaseSaveDialog));
}

void
descsaveDoSave(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Arg args[3];
    char line[MAXLINE], filename[MAXLINE];
    String fname;
    Widget asciiSrc;

#ifdef DEBUG
    printf("in descsaveDoSave\n");
#endif
    fname = XawDialogGetValueString(descsaveSaveDialog);

    strcpy(filename, fname);

    XtSetArg(args[0], XtNtextSource, &asciiSrc);
    XtGetValues(descrecvDisplayText, args, 1);

    replace(filename, "~", Home);

    if (XawAsciiSaveAsFile(asciiSrc, filename)) {
        sprintf(line, "saved contents in %s", filename);
        set_status(line, GREEN);
    } else {
        sprintf(line, "couldn't save contents in %s", filename);
        set_status(line, RED);
    }

    XtDestroyWidget( XtParent(descsaveSaveDialog));
}

