#!/bin/bash

tempfile=$(mktemp)

trap debug_failure ERR

debug_failure()
{
  sudo systemctl status "$server" || true
  sudo journalctl --no-pager -t "$server"
  cat "$tempfile"
  rm "$tempfile"
}

wait_until_not_state()
{
  local server state count
  server="$1"
  state="$2"
  count=0
  echo "Leaving state '$state' and entering state '$(systemctl show -P ActiveState "$server")'."
  TIMEFORMAT='Elapsed time is %R seconds.'
  { time {
  while [ "$(systemctl show -P ActiveState "$server")" == "$state" ] ; do
    if [ $count -gt 60 ]; then
      break
    fi
    count=$((count + 1))
    sleep 1
  done
  } } 2>&1
  if [ ! $count -gt 60 ]; then
    echo "Success."
  else
    echo "Failed (reached timeout)."
    debug_failure
    exit 1
  fi
}

wait_until_ready()
{
  local server port count
  server="$1"
  port="$2"
  path="$3"
  count=0
  echo "Waiting until $server is up and running at http://localhost:${port:-8080}/$path"
  TIMEFORMAT='Elapsed time is %R seconds.'
  { time {
  while ! nc -z localhost "${port:-8080}" >/dev/null 2>&1 && [[ "$(curl -s -o /dev/null -w ''%{http_code}'' http://localhost:${port:-8080}/$path)" != "200" ]]; do
    if [ $count -gt 60 ]; then
      break
    fi
    count=$((count + 1))
    sleep 1
  done
  } } 2>&1
  if [ ! $count -gt 60 ]; then
    echo "Success."
  else
    echo "Failed (reached timeout)."
    debug_failure
    exit 1
  fi
}
