# frozen_string_literal: true

class PrepareTmpBackfillIndexForPipelineIdsToVulnerabilityOccurrences < Gitlab::Database::Migration[2.2]
  milestone '16.11'

  TABLE_NAME = :vulnerability_occurrences
  INITIAL_PIPELINE_INDEX = 'tmp_index_vulnerability_occurrences_id_and_initial_pipline_id'
  LATEST_PIPELINE_INDEX = 'tmp_index_vulnerability_occurrences_id_and_latest_pipeline_id'

  INITIAL_PIPELINE_COLUMNS = [:id, :initial_pipeline_id]
  LATEST_PIPELINE_COLUMNS = [:id, :latest_pipeline_id]

  # Index created synchronously in https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148514
  # TODO remove tmp index in https://gitlab.com/gitlab-org/gitlab/-/issues/454243
  def up
    prepare_async_index TABLE_NAME, INITIAL_PIPELINE_COLUMNS, name: INITIAL_PIPELINE_INDEX,
      where: 'initial_pipeline_id IS NULL'
    prepare_async_index TABLE_NAME, LATEST_PIPELINE_COLUMNS, name: LATEST_PIPELINE_INDEX,
      where: 'latest_pipeline_id IS NULL'
  end

  def down
    unprepare_async_index TABLE_NAME, INITIAL_PIPELINE_COLUMNS, name: INITIAL_PIPELINE_INDEX,
      where: 'initial_pipeline_id IS NULL'
    unprepare_async_index TABLE_NAME, LATEST_PIPELINE_COLUMNS, name: LATEST_PIPELINE_INDEX,
      where: 'latest_pipeline_id IS NULL'
  end
end
