/*
 * Decompiled with CFR 0.152.
 */
package com.sqlmagic.tinysql;

import com.sqlmagic.tinysql.tinySQL;
import com.sqlmagic.tinysql.tinySQLException;
import com.sqlmagic.tinysql.tinySQLTable;
import com.sqlmagic.tinysql.tinySQLWhere;
import com.sqlmagic.tinysql.tsColumn;
import com.sqlmagic.tinysql.tsRow;
import java.util.Hashtable;
import java.util.Vector;

public class tsResultSet {
    private Vector rows;
    private Vector rsColumns;
    private Vector selectColumns;
    private Vector orderByColumns;
    private Vector tables;
    private tinySQLWhere whereC;
    private int fetchsize;
    private int windowStart;
    private int level;
    private tinySQL dbengine;
    private Hashtable sTables;
    private String orderType;
    private boolean distinct;
    private int type;
    private boolean eof;
    private boolean groupedColumns = false;
    public String newLine = System.getProperty("line.separator");

    public tsResultSet() {
        this(null, null);
    }

    public tsResultSet(tinySQLWhere tinySQLWhere2, tinySQL tinySQL2) {
        this.dbengine = tinySQL2;
        this.windowStart = 0;
        this.whereC = tinySQLWhere2;
        this.rows = new Vector();
        this.rsColumns = new Vector();
        this.selectColumns = new Vector();
        this.orderByColumns = new Vector();
        this.tables = new Vector();
    }

    public void setState(int n, Hashtable hashtable, String string, boolean bl) throws tinySQLException {
        tsRow tsRow2 = new tsRow();
        this.sTables = hashtable;
        this.orderType = string;
        this.distinct = bl;
        this.level = n;
        if (this.groupedColumns) {
            int n2 = 0;
            while (n2 < this.rsColumns.size()) {
                tsColumn tsColumn2 = (tsColumn)this.rsColumns.elementAt(n2);
                tsColumn2.updateFunctions();
                if (tsColumn2.isNotNull()) {
                    tsRow2.put(tsColumn2.name, tsColumn2.getString());
                }
                ++n2;
            }
            this.addRow(tsRow2);
        }
    }

    public void setType(int n) {
        if (n == 1003 || n == 1005 || n == 1004) {
            this.type = n;
        }
    }

    public int getType() {
        return this.type;
    }

    public void setFetchSize(int n) {
        this.fetchsize = n;
    }

    public int getFetchSize() {
        return this.fetchsize;
    }

    public void addColumn(tsColumn tsColumn2) {
        this.rsColumns.addElement(tsColumn2);
        if (tsColumn2.getContext("SELECT")) {
            this.selectColumns.addElement(tsColumn2);
        }
        if (tsColumn2.getContext("ORDER")) {
            this.orderByColumns.addElement(tsColumn2);
        }
        if (tsColumn2.isGroupedColumn()) {
            this.groupedColumns = true;
        }
        boolean bl = true;
        if (tsColumn2.columnTable != (tinySQLTable)null) {
            int n = 0;
            while (n < this.tables.size()) {
                tinySQLTable tinySQLTable2 = (tinySQLTable)this.tables.elementAt(n);
                if (tinySQLTable2.table.equals(tsColumn2.columnTable.table)) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl) {
                this.tables.addElement(tsColumn2.columnTable);
            }
        }
    }

    public boolean isGrouped() {
        return this.groupedColumns;
    }

    public boolean getMoreResults(int n, int n2) {
        this.fetchsize = n2;
        if (this.dbengine != null) {
            try {
                if (this.type != 1004) {
                    this.rows.removeAllElements();
                    this.windowStart = n;
                }
                this.dbengine.contSelectStatement(this);
                if (this.level != 0) {
                    this.eof = false;
                    return this.eof;
                }
            }
            catch (tinySQLException tinySQLException2) {
                // empty catch block
            }
        }
        this.eof = true;
        return this.eof;
    }

    public boolean addRow(tsRow tsRow2) {
        return this.addRow(tsRow2, true);
    }

    public boolean addRow(tsRow tsRow2, boolean bl) {
        boolean bl2 = true;
        if (!bl) {
            this.rows.addElement(tsRow2);
            return true;
        }
        if (this.orderType != (String)null && this.orderType.startsWith("DESC")) {
            bl2 = false;
        }
        tsRow2.setOrderBy(this.orderByColumns);
        if (this.rows.size() > 0) {
            if (bl2) {
                int n = this.rows.size() - 1;
                while (n > -1) {
                    tsRow tsRow3 = (tsRow)this.rows.elementAt(n);
                    if (tsRow2.compareTo(tsRow3) >= 0) {
                        if (tsRow2.compareTo(tsRow3) == 0 & this.distinct) {
                            return true;
                        }
                        if (n == this.rows.size() - 1) {
                            this.rows.addElement(tsRow2);
                        } else {
                            this.rows.insertElementAt(tsRow2, n + 1);
                        }
                        return true;
                    }
                    --n;
                }
            } else {
                int n = this.rows.size() - 1;
                while (n > -1) {
                    tsRow tsRow4 = (tsRow)this.rows.elementAt(n);
                    if (tsRow2.compareTo(tsRow4) <= 0) {
                        if (tsRow2.compareTo(tsRow4) == 0 & this.distinct) {
                            return true;
                        }
                        if (n == this.rows.size() - 1) {
                            this.rows.addElement(tsRow2);
                        } else {
                            this.rows.insertElementAt(tsRow2, n + 1);
                        }
                        return true;
                    }
                    --n;
                }
            }
            this.rows.insertElementAt(tsRow2, 0);
            return true;
        }
        this.rows.addElement(tsRow2);
        return this.fetchsize <= 0 || this.rows.size() < this.fetchsize;
    }

    public void updateRow(tsRow tsRow2) {
        this.updateRow(tsRow2, this.rows.size() - 1);
    }

    public void updateRow(tsRow tsRow2, int n) {
        this.rows.setElementAt(tsRow2, n);
    }

    public Vector getTables() {
        return this.tables;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public Hashtable getTableState() {
        return this.sTables;
    }

    public tinySQLWhere getWhereClause() {
        return this.whereC;
    }

    public int getColumnCount() {
        return this.selectColumns.size();
    }

    public int numcols() {
        return this.rsColumns.size();
    }

    public void updateColumns(String string, String string2) throws tinySQLException {
        int n = 0;
        while (n < this.rsColumns.size()) {
            tsColumn tsColumn2 = (tsColumn)this.rsColumns.elementAt(n);
            tsColumn2.update(string, string2);
            ++n;
        }
    }

    public int size() {
        return this.rows.size();
    }

    public tsRow rowAt(int n) {
        int n2;
        if (n >= this.windowStart + this.rows.size()) {
            this.getMoreResults(n, this.fetchsize);
        }
        if ((n2 = n - this.windowStart) < this.rows.size()) {
            return (tsRow)this.rows.elementAt(n2);
        }
        return null;
    }

    public tsColumn columnAtIndex(int n) {
        return this.columnAtIndex(n, false);
    }

    public tsColumn columnAtIndex(int n, boolean bl) {
        if (bl) {
            return (tsColumn)this.rsColumns.elementAt(n);
        }
        return (tsColumn)this.selectColumns.elementAt(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.newLine + "Columns in ResultSet" + this.newLine);
        int n = 0;
        while (n < this.rsColumns.size()) {
            tsColumn tsColumn2 = (tsColumn)this.rsColumns.elementAt(n);
            stringBuffer.append(tsColumn2.toString());
            ++n;
        }
        stringBuffer.append(this.newLine + "Rows in tsResultSet" + this.newLine);
        n = 0;
        while (n < this.size()) {
            tsRow tsRow2 = this.rowAt(n);
            stringBuffer.append(tsRow2.toString() + this.newLine);
            ++n;
        }
        return stringBuffer.toString();
    }
}

