/* Extended Module Player
 * Copyright (C) 1996-2024 Claudio Matsuoka and Hipolito Carraro Jr
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "common.h"
#include "rng.h"

#include <time.h>

static unsigned libxmp_random_step_xorshift32(unsigned state)
{
	if (state == 0) state = 1;
	state ^= state << 13u;
	state ^= state >> 17u;
	return   state <<  5u;
}

unsigned libxmp_get_random(struct rng_state *rng, unsigned range)
{
	unsigned state = libxmp_random_step_xorshift32(rng->state);
	rng->state = state;

	return (uint64)range * state >> 32u;
}

void libxmp_set_random(struct rng_state *rng, unsigned state)
{
	rng->state = state;
}

void libxmp_init_random(struct rng_state *rng)
{
	rng->state = (unsigned) time(NULL);
	libxmp_get_random(rng, 0);
	libxmp_get_random(rng, 0);
	libxmp_get_random(rng, 0);
}
