# coding: utf-8

"""
    CLOUD API

    IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.  # noqa: E501

    The version of the OpenAPI document: 6.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class UserPropertiesPut(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'active': 'bool',

        'administrator': 'bool',

        'email': 'str',

        'firstname': 'str',

        'force_sec_auth': 'bool',

        'lastname': 'str',

        'password': 'str',

        'sec_auth_active': 'bool',
    }

    attribute_map = {

        'active': 'active',

        'administrator': 'administrator',

        'email': 'email',

        'firstname': 'firstname',

        'force_sec_auth': 'forceSecAuth',

        'lastname': 'lastname',

        'password': 'password',

        'sec_auth_active': 'secAuthActive',
    }

    def __init__(self, active=None, administrator=None, email=None, firstname=None, force_sec_auth=None, lastname=None, password=None, sec_auth_active=None, local_vars_configuration=None):  # noqa: E501
        """UserPropertiesPut - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._active = None
        self._administrator = None
        self._email = None
        self._firstname = None
        self._force_sec_auth = None
        self._lastname = None
        self._password = None
        self._sec_auth_active = None
        self.discriminator = None

        if active is not None:
            self.active = active
        if administrator is not None:
            self.administrator = administrator
        if email is not None:
            self.email = email
        if firstname is not None:
            self.firstname = firstname
        if force_sec_auth is not None:
            self.force_sec_auth = force_sec_auth
        if lastname is not None:
            self.lastname = lastname
        if password is not None:
            self.password = password
        if sec_auth_active is not None:
            self.sec_auth_active = sec_auth_active


    @property
    def active(self):
        """Gets the active of this UserPropertiesPut.  # noqa: E501

        Indicates if the user is active.  # noqa: E501

        :return: The active of this UserPropertiesPut.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this UserPropertiesPut.

        Indicates if the user is active.  # noqa: E501

        :param active: The active of this UserPropertiesPut.  # noqa: E501
        :type active: bool
        """

        self._active = active

    @property
    def administrator(self):
        """Gets the administrator of this UserPropertiesPut.  # noqa: E501

        Indicates if the user has admin rights.  # noqa: E501

        :return: The administrator of this UserPropertiesPut.  # noqa: E501
        :rtype: bool
        """
        return self._administrator

    @administrator.setter
    def administrator(self, administrator):
        """Sets the administrator of this UserPropertiesPut.

        Indicates if the user has admin rights.  # noqa: E501

        :param administrator: The administrator of this UserPropertiesPut.  # noqa: E501
        :type administrator: bool
        """

        self._administrator = administrator

    @property
    def email(self):
        """Gets the email of this UserPropertiesPut.  # noqa: E501

        The email address of the user.  # noqa: E501

        :return: The email of this UserPropertiesPut.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this UserPropertiesPut.

        The email address of the user.  # noqa: E501

        :param email: The email of this UserPropertiesPut.  # noqa: E501
        :type email: str
        """

        self._email = email

    @property
    def firstname(self):
        """Gets the firstname of this UserPropertiesPut.  # noqa: E501

        The first name of the user.  # noqa: E501

        :return: The firstname of this UserPropertiesPut.  # noqa: E501
        :rtype: str
        """
        return self._firstname

    @firstname.setter
    def firstname(self, firstname):
        """Sets the firstname of this UserPropertiesPut.

        The first name of the user.  # noqa: E501

        :param firstname: The firstname of this UserPropertiesPut.  # noqa: E501
        :type firstname: str
        """

        self._firstname = firstname

    @property
    def force_sec_auth(self):
        """Gets the force_sec_auth of this UserPropertiesPut.  # noqa: E501

        Indicates if secure authentication should be forced on the user.  # noqa: E501

        :return: The force_sec_auth of this UserPropertiesPut.  # noqa: E501
        :rtype: bool
        """
        return self._force_sec_auth

    @force_sec_auth.setter
    def force_sec_auth(self, force_sec_auth):
        """Sets the force_sec_auth of this UserPropertiesPut.

        Indicates if secure authentication should be forced on the user.  # noqa: E501

        :param force_sec_auth: The force_sec_auth of this UserPropertiesPut.  # noqa: E501
        :type force_sec_auth: bool
        """

        self._force_sec_auth = force_sec_auth

    @property
    def lastname(self):
        """Gets the lastname of this UserPropertiesPut.  # noqa: E501

        The last name of the user.  # noqa: E501

        :return: The lastname of this UserPropertiesPut.  # noqa: E501
        :rtype: str
        """
        return self._lastname

    @lastname.setter
    def lastname(self, lastname):
        """Sets the lastname of this UserPropertiesPut.

        The last name of the user.  # noqa: E501

        :param lastname: The lastname of this UserPropertiesPut.  # noqa: E501
        :type lastname: str
        """

        self._lastname = lastname

    @property
    def password(self):
        """Gets the password of this UserPropertiesPut.  # noqa: E501

        password of the user  # noqa: E501

        :return: The password of this UserPropertiesPut.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this UserPropertiesPut.

        password of the user  # noqa: E501

        :param password: The password of this UserPropertiesPut.  # noqa: E501
        :type password: str
        """

        self._password = password

    @property
    def sec_auth_active(self):
        """Gets the sec_auth_active of this UserPropertiesPut.  # noqa: E501

        Indicates if secure authentication is active for the user.  # noqa: E501

        :return: The sec_auth_active of this UserPropertiesPut.  # noqa: E501
        :rtype: bool
        """
        return self._sec_auth_active

    @sec_auth_active.setter
    def sec_auth_active(self, sec_auth_active):
        """Sets the sec_auth_active of this UserPropertiesPut.

        Indicates if secure authentication is active for the user.  # noqa: E501

        :param sec_auth_active: The sec_auth_active of this UserPropertiesPut.  # noqa: E501
        :type sec_auth_active: bool
        """

        self._sec_auth_active = sec_auth_active
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserPropertiesPut):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UserPropertiesPut):
            return True

        return self.to_dict() != other.to_dict()
