/* Configuration of lookup functions.
   Copyright (C) 2000, 2001, 2002, 2004 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

/* Some platforms need more information from the symbol lookup function
   than just the address.  But this is not generally the case.

   However, because of how _dl_sym and _dl_tls_symaddr are written, every
   platform needs it when we support TLS.  */

#define DL_LOOKUP_RETURNS_MAP
#define ELF_FUNCTION_PTR_IS_SPECIAL
#define DL_UNMAP_IS_SPECIAL

/* We do not support copy relocations for FR-V.  */
#define DL_NO_COPY_RELOCS

#define DL_RO_DYN_SECTION

/* Forward declaration.  */
struct link_map;

extern void *_dl_symbol_address (struct link_map *map, const Elf32_Sym *ref);

#define DL_SYMBOL_ADDRESS(map, ref) (_dl_symbol_address (map, ref))

extern Elf32_Addr _dl_lookup_address (const void *address);

#define DL_LOOKUP_ADDRESS(addr) (_dl_lookup_address (addr))

extern void _dl_unmap (struct link_map *map);

#define DL_UNMAP(map) _dl_unmap (map)

#define DL_AUTO_FUNCTION_ADDRESS(map, addr)		\
({							\
  frv_fdesc_t fptr;					\
  fptr.desc.ip = (Elf32_Addr) (addr);			\
  fptr.desc.gp = (Elf32_Addr) (map)->l_addr.got_value;	\
  (Elf32_Addr) &fptr;					\
})

#define DL_STATIC_FUNCTION_ADDRESS(map, addr)		\
({							\
  static frv_fdesc_t fptr;				\
  fptr.desc.ip = (Elf32_Addr) (addr);			\
  fptr.desc.gp = (Elf32_Addr) (map)->l_addr.got_value;	\
  (Elf32_Addr) &fptr;					\
})

#define DL_DT_INIT_ADDRESS(map, addr) DL_AUTO_FUNCTION_ADDRESS (map, addr)
#define DL_DT_FINI_ADDRESS(map, addr) DL_AUTO_FUNCTION_ADDRESS (map, addr)
