/* head-uc-fr401.S: FR401/3/5 uc-linux specific bits of initialisation
 *
 * Copyright (C) 2004 Red Hat, Inc. All Rights Reserved.
 * Written by David Howells (dhowells@redhat.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#include <linux/config.h>
#include <linux/threads.h>
#include <linux/linkage.h>
#include <asm/ptrace.h>
#include <asm/page.h>
#include <asm/pgtable.h>
#include <asm/spr-regs.h>
#include <asm/mb86943a.h>
#include "head.inc"


#define __400_DBR0	0xfe000e00
#define __400_DBR1	0xfe000e08
#define __400_DBR2	0xfe000e10	/* not on FR401 */
#define __400_DBR3	0xfe000e18	/* not on FR401 */
#define __400_DAM0	0xfe000f00
#define __400_DAM1	0xfe000f08
#define __400_DAM2	0xfe000f10	/* not on FR401 */
#define __400_DAM3	0xfe000f18	/* not on FR401 */
#define __400_LGCR	0xfe000010
#define __400_LCR	0xfe000100
#define __400_LSBR	0xfe000c00

	.section	.text.init,"ax"
	.balign		4

###############################################################################
#
# describe the position and layout of the SDRAM controller registers
#
#	ENTRY:			EXIT:
# GR5	-			cacheline size
# GR11	-			displacement of 2nd SDRAM addr reg from GR14
# GR12	-			displacement of 3rd SDRAM addr reg from GR14
# GR13	-			displacement of 4th SDRAM addr reg from GR14
# GR14	-			address of 1st SDRAM addr reg
# GR15	-			amount to shift address by to match SDRAM addr reg
# GR26	&__head_reference	[saved]
# GR30	LED address		[saved]
# CC0	-			T if DBR0 is present
# CC1	-			T if DBR1 is present
# CC2	-			T if DBR2 is present (not FR401/FR401A)
# CC3	-			T if DBR3 is present (not FR401/FR401A)
#
###############################################################################
	.globl		__head_fr401_describe_sdram
__head_fr401_describe_sdram:
	sethi.p		%hi(__400_DBR0),gr14
	setlo		%lo(__400_DBR0),gr14
	setlos.p	#__400_DBR1-__400_DBR0,gr11
	setlos		#__400_DBR2-__400_DBR0,gr12
	setlos.p	#__400_DBR3-__400_DBR0,gr13
	setlos		#32,gr5			; cacheline size
	setlos.p	#0,gr15			; amount to shift addr reg by

	# specify which DBR regs are present
	setlos		#0x00ff,gr4
	movgs		gr4,cccr
	movsg		psr,gr3			; check for FR401/FR401A
	srli		gr3,#25,gr3
	subicc		gr3,#0x20>>1,gr0,icc0
	bnelr		icc0,#1
	setlos		#0x000f,gr4
	movgs		gr4,cccr
	bralr

###############################################################################
#
# rearrange the bus controller registers
#
#	ENTRY:			EXIT:
# GR26	&__head_reference	[saved]
# GR30	LED address		revised LED address
#
###############################################################################
	.globl		__head_fr401_set_busctl
__head_fr401_set_busctl:
	sethi.p		%hi(__400_LGCR),gr4
	setlo		%lo(__400_LGCR),gr4
	sethi.p		%hi(__400_LSBR),gr10
	setlo		%lo(__400_LSBR),gr10
	sethi.p		%hi(__400_LCR),gr11
	setlo		%lo(__400_LCR),gr11

	# set the bus controller
	ldi		@(gr4,#0),gr5
	ori		gr5,#0xff,gr5		; make sure all chip-selects are enabled
	sti		gr5,@(gr4,#0)

	sethi.p		%hi(__region_CS1),gr4
	setlo		%lo(__region_CS1),gr4
	sethi.p		%hi(__region_CS1_M),gr5
	setlo		%lo(__region_CS1_M),gr5
	sethi.p		%hi(__region_CS1_C),gr6
	setlo		%lo(__region_CS1_C),gr6
	sti		gr4,@(gr10,#1*0x08)
	sti		gr5,@(gr10,#1*0x08+0x100)
	sti		gr6,@(gr11,#1*0x08)
	sethi.p		%hi(__region_CS2),gr4
	setlo		%lo(__region_CS2),gr4
	sethi.p		%hi(__region_CS2_M),gr5
	setlo		%lo(__region_CS2_M),gr5
	sethi.p		%hi(__region_CS2_C),gr6
	setlo		%lo(__region_CS2_C),gr6
	sti		gr4,@(gr10,#2*0x08)
	sti		gr5,@(gr10,#2*0x08+0x100)
	sti		gr6,@(gr11,#2*0x08)
	sethi.p		%hi(__region_CS3),gr4
	setlo		%lo(__region_CS3),gr4
	sethi.p		%hi(__region_CS3_M),gr5
	setlo		%lo(__region_CS3_M),gr5
	sethi.p		%hi(__region_CS3_C),gr6
	setlo		%lo(__region_CS3_C),gr6
	sti		gr4,@(gr10,#3*0x08)
	sti		gr5,@(gr10,#3*0x08+0x100)
	sti		gr6,@(gr11,#3*0x08)
	sethi.p		%hi(__region_CS4),gr4
	setlo		%lo(__region_CS4),gr4
	sethi.p		%hi(__region_CS4_M),gr5
	setlo		%lo(__region_CS4_M),gr5
	sethi.p		%hi(__region_CS4_C),gr6
	setlo		%lo(__region_CS4_C),gr6
	sti		gr4,@(gr10,#4*0x08)
	sti		gr5,@(gr10,#4*0x08+0x100)
	sti		gr6,@(gr11,#4*0x08)
	sethi.p		%hi(__region_CS5),gr4
	setlo		%lo(__region_CS5),gr4
	sethi.p		%hi(__region_CS5_M),gr5
	setlo		%lo(__region_CS5_M),gr5
	sethi.p		%hi(__region_CS5_C),gr6
	setlo		%lo(__region_CS5_C),gr6
	sti		gr4,@(gr10,#5*0x08)
	sti		gr5,@(gr10,#5*0x08+0x100)
	sti		gr6,@(gr11,#5*0x08)
	sethi.p		%hi(__region_CS6),gr4
	setlo		%lo(__region_CS6),gr4
	sethi.p		%hi(__region_CS6_M),gr5
	setlo		%lo(__region_CS6_M),gr5
	sethi.p		%hi(__region_CS6_C),gr6
	setlo		%lo(__region_CS6_C),gr6
	sti		gr4,@(gr10,#6*0x08)
	sti		gr5,@(gr10,#6*0x08+0x100)
	sti		gr6,@(gr11,#6*0x08)
	sethi.p		%hi(__region_CS7),gr4
	setlo		%lo(__region_CS7),gr4
	sethi.p		%hi(__region_CS7_M),gr5
	setlo		%lo(__region_CS7_M),gr5
	sethi.p		%hi(__region_CS7_C),gr6
	setlo		%lo(__region_CS7_C),gr6
	sti		gr4,@(gr10,#7*0x08)
	sti		gr5,@(gr10,#7*0x08+0x100)
	sti		gr6,@(gr11,#7*0x08)
	membar
	bar

	# adjust LED bank address
	sethi.p		%hi(LED_ADDR - 0x20000000 +__region_CS2),gr30
	setlo		%lo(LED_ADDR - 0x20000000 +__region_CS2),gr30
	bralr

###############################################################################
#
# determine the total SDRAM size
#
#	ENTRY:			EXIT:
# GR25	-			SDRAM size
# GR26	&__head_reference	[saved]
# GR30	LED address		[saved]
#
###############################################################################
	.globl		__head_fr401_survey_sdram
__head_fr401_survey_sdram:
	sethi.p		%hi(__400_DAM0),gr11
	setlo		%lo(__400_DAM0),gr11
	sethi.p		%hi(__400_DBR0),gr12
	setlo		%lo(__400_DBR0),gr12

	sethi.p		%hi(0xfe000000),gr17		; unused SDRAM DBR value
	setlo		%lo(0xfe000000),gr17
	setlos		#0,gr25

	ldi		@(gr12,#0x00),gr4		; DAR0
	subcc		gr4,gr17,gr0,icc0
	beq		icc0,#0,__head_no_DCS0
	ldi		@(gr11,#0x00),gr6		; DAM0: bits 31:20 match addr 31:20
	add		gr25,gr6,gr25
	addi		gr25,#1,gr25
__head_no_DCS0:

	ldi		@(gr12,#0x08),gr4		; DAR1
	subcc		gr4,gr17,gr0,icc0
	beq		icc0,#0,__head_no_DCS1
	ldi		@(gr11,#0x08),gr6		; DAM1: bits 31:20 match addr 31:20
	add		gr25,gr6,gr25
	addi		gr25,#1,gr25
__head_no_DCS1:

	# FR401/FR401A does not have DCS2/3
	movsg		psr,gr3
	srli		gr3,#25,gr3
	subicc		gr3,#0x20>>1,gr0,icc0
	beq		icc0,#0,__head_no_DCS3

	ldi		@(gr12,#0x10),gr4		; DAR2
	subcc		gr4,gr17,gr0,icc0
	beq		icc0,#0,__head_no_DCS2
	ldi		@(gr11,#0x10),gr6		; DAM2: bits 31:20 match addr 31:20
	add		gr25,gr6,gr25
	addi		gr25,#1,gr25
__head_no_DCS2:

	ldi		@(gr12,#0x18),gr4		; DAR3
	subcc		gr4,gr17,gr0,icc0
	beq		icc0,#0,__head_no_DCS3
	ldi		@(gr11,#0x18),gr6		; DAM3: bits 31:20 match addr 31:20
	add		gr25,gr6,gr25
	addi		gr25,#1,gr25
__head_no_DCS3:
	bralr

###############################################################################
#
# set the protection map with the I/DAMPR registers
#
#	ENTRY:			EXIT:
# GR25	SDRAM size		[saved]
# GR26	&__head_reference	[saved]
# GR30	LED address		[saved]
#
###############################################################################
	.globl		__head_fr401_set_protection
__head_fr401_set_protection:
	movsg		lr,gr27

	# set the I/O region protection registers for FR401/3/5
	sethi.p		%hi(__region_IO),gr5
	setlo		%lo(__region_IO),gr5
	ori		gr5,#xAMPRx_SS_512Mb|xAMPRx_S_KERNEL|xAMPRx_C|xAMPRx_V,gr5
	movgs		gr0,iampr7
	movgs		gr5,dampr7			; General I/O tile

	# need to tile the remaining IAMPR/DAMPR registers to cover as much of the RAM as possible
	# - start with the highest numbered registers
	sethi.p		%hi(__kernel_image_end),gr8
	setlo		%lo(__kernel_image_end),gr8
	sethi.p		%hi(32768),gr4			; allow for a maximal allocator bitmap
	setlo		%lo(32768),gr4
	add		gr8,gr4,gr8
	sethi.p		%hi(1024*2048-1),gr4		; round up to nearest 2MiB
	setlo		%lo(1024*2048-1),gr4
	add.p		gr8,gr4,gr8
	not		gr4,gr4
	and		gr8,gr4,gr8

	sethi.p		%hi(__page_offset),gr9
	setlo		%lo(__page_offset),gr9
	add		gr9,gr25,gr9

	# GR8 = base of uncovered RAM
	# GR9 = top of uncovered RAM

#ifdef CONFIG_MB93093_PDK
	sethi.p		%hi(__region_CS2),gr4
	setlo		%lo(__region_CS2),gr4
	ori		gr4,#xAMPRx_SS_1Mb|xAMPRx_S_KERNEL|xAMPRx_C|xAMPRx_V,gr4
	movgs		gr4,dampr6
	movgs		gr0,iampr6	
#else
	call		__head_split_region
	movgs		gr4,iampr6
	movgs		gr5,dampr6
#endif
	call		__head_split_region
	movgs		gr4,iampr5
	movgs		gr5,dampr5
	call		__head_split_region
	movgs		gr4,iampr4
	movgs		gr5,dampr4
	call		__head_split_region
	movgs		gr4,iampr3
	movgs		gr5,dampr3
	call		__head_split_region
	movgs		gr4,iampr2
	movgs		gr5,dampr2
	call		__head_split_region
	movgs		gr4,iampr1
	movgs		gr5,dampr1

	# cover kernel core image with kernel-only segment
	sethi.p		%hi(__page_offset),gr8
	setlo		%lo(__page_offset),gr8
	call		__head_split_region

#ifdef CONFIG_PROTECT_KERNEL
	ori.p		gr4,#xAMPRx_S_KERNEL,gr4
	ori		gr5,#xAMPRx_S_KERNEL,gr5
#endif

	movgs		gr4,iampr0
	movgs		gr5,dampr0
	jmpl		@(gr27,gr0)
