#############################################################
#
# netkittftp
#
#############################################################
ifneq ($(USE_CVS),true)
NETKITTFTP_SOURCE:=netkit-tftp.tar.gz
NETKITTFTP_SITE:=ftp://ftp.uk.linux.org/pub/linux/Networking/netkit/
NETKITTFTP_DIR:=$(BUILD_DIR)/${shell basename $(NETKITTFTP_SOURCE) .tar.gz}

NETKITTFTP_CAT:=zcat
else
# using CVS
NETKITTFTP_DIR:=$(BUILD_DIR)/netkit-tftp
endif

NETKITTFTP_BINARY:=tftp/tftp
NETKITTFTP_TARGET_BINARY:=usr/bin/tftp
NETKITTFTP_PATCH:=$(SOURCE_DIR)/netkittftp.patch

ifneq ($(USE_CVS),true)
netkittftp-fetch:
	 $(WGET) -P $(DL_DIR) $(NETKITTFTP_SITE)/$(NETKITTFTP_SOURCE)

netkittftp-source: $(DL_DIR)/$(NETKITTFTP_SOURCE)
else
netkittftp-source:
endif

NETKITTFTP_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d netkit-tftp $(CVS_TAG) $(CVS_PREFIX)netkit-tftp

netkittftp-checkout:
	@$(NETKITTFTP_CVSCO)

$(NETKITTFTP_DIR)/.unpacked: $(DL_DIR)/$(NETKITTFTP_SOURCE)
ifneq ($(USE_CVS),true)
	$(NETKITTFTP_CAT) $(DL_DIR)/$(NETKITTFTP_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(NETKITTFTP_CVSCO)
endif
	touch $(NETKITTFTP_DIR)/.unpacked

$(NETKITTFTP_DIR)/.configured: $(NETKITTFTP_DIR)/.unpacked
	(cd $(NETKITTFTP_DIR); PATH=$(TARGET_PATH) CC=$(TARGET_CC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure --installroot=$(TARGET_DIR) --with-c-compiler=$(TARGET_CC) \
	)
	touch  $(NETKITTFTP_DIR)/.configured

$(NETKITTFTP_DIR)/$(NETKITTFTP_BINARY): $(NETKITTFTP_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(NETKITTFTP_DIR)

$(TARGET_DIR)/$(NETKITTFTP_TARGET_BINARY): $(NETKITTFTP_DIR)/$(NETKITTFTP_BINARY)
	$(MAKE) INSTALLROOT=$(TARGET_DIR) -C $(NETKITTFTP_DIR) install
	$(STRIP) $(TARGET_DIR)/$(NETKITTFTP_TARGET_BINARY)
	$(STRIP) $(TARGET_DIR)/usr/sbin/in.tftpd
	# Enable tftp in inetd
	sed -i -e "s~^# tftp.*~tftp\tdgram\tudp\tnowait\troot\t/usr/sbin/in.tftpd\t/usr/sbin/in.tftpd~;" $(TARGET_DIR)/etc/inetd.conf
	mkdir -p $(DOC_DIR)/doc/netkit-tftp
	for f in BUGS README ; do \
	    install -m0644 $(NETKITTFTP_DIR)/$$f $(DOC_DIR)/doc/netkit-tftp/ ; \
	done

netkittftp: uclibc $(TARGET_DIR)/$(NETKITTFTP_TARGET_BINARY)

netkittftp-clean:
	-rm -f $(TARGET_DIR)/$(NETKITTFTP_TARGET_BINARY)
	-rm -f $(TARGET_DIR)/usr/sbin/in.tftpd
	-$(MAKE) -C $(NETKITTFTP_DIR) clean
	-rm -rf $(DOC_DIR)/doc/netkit-tftp

netkittftp-dirclean:
	rm -rf $(NETKITTFTP_DIR)

