#
# portmap
#
######################################################
ifneq ($(USE_CVS),true)
PORTMAP_SOURCE:=portmap.tar.gz
PORTMAP_CAT:=zcat
PORTMAP_DIR:=$(BUILD_DIR)/${shell basename $(PORTMAP_SOURCE) .tar.gz}
else
# using CVS
PORTMAP_DIR:=$(BUILD_DIR)/portmap
endif

PORTMAP_BINARY:=portmap
PORTMAP_TARGET_BINARY:=sbin/portmap
PORTMAP_PROGS:=portmap pmap_set pmap_dump

ifneq ($(USE_CVS),true)
nfs-utils-source: $(DL_DIR)/$(PORTMAP_SOURCE)
else
nfs-utils-source:
endif

PORTMAP_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d portmap $(CVS_TAG) $(CVS_PREFIX)portmap

portmap-checkout:
	@$(PORTMAP_CVSCO)

$(PORTMAP_DIR)/.unpacked: $(DL_DIR)/$(PORTMAP_SOURCE)
ifneq ($(USE_CVS),true)
	$(PORTMAP_CAT) $(DL_DIR)/$(PORTMAP_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(PORTMAP_CVSCO)
endif
	sed -i -e 's,^\(CFLAGS[[:space:]]*\)\(=\),\1+=,' $(PORTMAP_DIR)/Makefile
	touch $(PORTMAP_DIR)/.unpacked

$(PORTMAP_DIR)/$(PORTMAP_BINARY): $(PORTMAP_DIR)/.unpacked
	CFLAGS="$(TARGET_CFLAGS)" $(MAKE) CC=$(TARGET_CC) -C $(PORTMAP_DIR)

$(TARGET_DIR)/$(PORTMAP_TARGET_BINARY): $(PORTMAP_DIR)/$(PORTMAP_BINARY)
	install -m 0755 $(PORTMAP_DIR)/$(PORTMAP_BINARY) $(TARGET_DIR)/$(PORTMAP_TARGET_BINARY)
	install -m 0755 $(PORTMAP_DIR)/pmap_set $(TARGET_DIR)/usr/sbin/
	install -m 0755 $(PORTMAP_DIR)/pmap_dump $(TARGET_DIR)/usr/sbin/
	if [ -d $(TARGET_DIR)/etc/rc.d/init.d ]; then \
		install -m0755 $(PORTMAP_DIR)/portmap.init \
			$(TARGET_DIR)/etc/rc.d/init.d/portmap ; \
	fi
	mkdir -p $(DOC_DIR)/doc/portmap
	install -m0644 $(PORTMAP_DIR)/README $(DOC_DIR)/doc/portmap/
	for f in $(PORTMAP_PROGS) ; do \
	    install -m 0644 $(PORTMAP_DIR)/$$f.8 $(TARGET_DIR)/usr/man/man8/ ; \
	done

portmap-clean:
	$(MAKE) -C $(PORTMAP_DIR) clean
	-rm -f $(TARGET_DIR)/sbin/portmap \
		$(TARGET_DIR)/usr/sbin/pmap_dump \
		$(TARGET_DIR)/usr/sbin/pmap_set
	-rm -f $(TARGET_DIR)/usr/man/man8/portmap.8 \
		$(TARGET_DIR)/usr/man/man8/pmap_set.8 \
		$(TARGET_DIR)/usr/man/man8/pmap_dump.8
	-rm -f $(TARGET_DIR)/etc/rc.d/init.d/portmap
	-rm -rf $(DOC_DIR)/doc/portmap

portmap-dirclean:
	-rm -rf $(PORTMAP_DIR)

portmap: uclibc $(TARGET_DIR)/$(PORTMAP_TARGET_BINARY)

