/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.CopyOf;
import net.sf.saxon.instruct.ElementCreator;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.type.SchemaType;

public class Copy
extends ElementCreator {
    private boolean copyNamespaces;

    public Copy(AttributeSet[] attributeSetArray, boolean bl, SchemaType schemaType, int n) {
        this.useAttributeSets = attributeSetArray;
        this.copyNamespaces = bl;
        this.schemaType = schemaType;
        this.validation = n;
    }

    public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
        instructionDetails.setInstructionName("copy");
    }

    protected int getNameCode(XPathContext xPathContext) throws TransformerException {
        return ((NodeInfo)xPathContext.getContextItem()).getNameCode();
    }

    protected void outputNamespaceNodes(XPathContext xPathContext, Receiver receiver) throws TransformerException {
        if (this.copyNamespaces) {
            NodeInfo nodeInfo = (NodeInfo)xPathContext.getContextItem();
            nodeInfo.outputNamespaceNodes(receiver, true);
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = controller.getReceiver();
        Item item = controller.getCurrentItem();
        if (!(item instanceof NodeInfo)) {
            sequenceReceiver.append(item);
            return null;
        }
        NodeInfo nodeInfo = (NodeInfo)item;
        switch (nodeInfo.getNodeKind()) {
            case 1: {
                return super.processLeavingTail(xPathContext);
            }
            case 2: {
                try {
                    CopyOf.copyAttribute(nodeInfo, this.schemaType, this.validation, controller);
                }
                catch (NoOpenStartTagException noOpenStartTagException) {
                    this.recoverableError("Cannot write an attribute node when no element start tag is open", controller);
                }
                break;
            }
            case 3: {
                sequenceReceiver.characters(nodeInfo.getStringValue(), 0);
                break;
            }
            case 7: {
                sequenceReceiver.processingInstruction(nodeInfo.getDisplayName(), nodeInfo.getStringValue(), 0);
                break;
            }
            case 8: {
                sequenceReceiver.comment(nodeInfo.getStringValue(), 0);
                break;
            }
            case 13: {
                try {
                    nodeInfo.copy(sequenceReceiver, 0, false);
                }
                catch (NoOpenStartTagException noOpenStartTagException) {
                    this.recoverableError("Cannot write a namespace node when no element start tag is open", controller);
                }
                break;
            }
            case 9: {
                SequenceReceiver sequenceReceiver2 = null;
                Receiver receiver = controller.getConfiguration().getDocumentValidator(sequenceReceiver, nodeInfo.getBaseURI(), controller.getNamePool(), this.validation);
                if (receiver != sequenceReceiver) {
                    TreeReceiver treeReceiver = new TreeReceiver(receiver);
                    treeReceiver.setNamePool(controller.getNamePool());
                    sequenceReceiver2 = sequenceReceiver;
                    controller.setReceiver(treeReceiver);
                    receiver = treeReceiver;
                }
                receiver.setNamePool(controller.getNamePool());
                receiver.startDocument();
                this.processChildren(xPathContext);
                receiver.endDocument();
                if (sequenceReceiver2 == null) break;
                controller.setReceiver(sequenceReceiver2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node kind " + nodeInfo.getNodeKind());
            }
        }
        return null;
    }

    protected void getXPathExpressions(List list) {
    }

    public void display(int n, NamePool namePool) {
    }
}

