/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.classfile;

import com.claritysys.util.Java;
import com.claritysys.util.Strings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SigConverter {
    private Map aliasToFull = new HashMap(131);
    private Map types = new HashMap(131);
    private static Map primitives = new HashMap(131);
    private static final String[] NO_ARGS;

    public SigConverter() {
        this.types.putAll(primitives);
    }

    public SigConverter(SigConverter template) {
        this();
        this.aliasToFull.putAll(template.aliasToFull);
        this.types.putAll(template.types);
    }

    public String addImport(String cls) {
        if (cls.charAt(0) == 'L') {
            cls = cls.substring(1, cls.length() - 1);
        }
        cls = cls.replace('.', '/');
        String alias = Java.getShortNameInternal((String)cls);
        this.aliasToFull.put(alias, cls);
        return alias;
    }

    public String getFullName(String cls) {
        String fqName = (String)this.aliasToFull.get(cls);
        if (fqName == null) {
            if (cls.indexOf(46) != -1) {
                return cls.replace('.', '/');
            }
            throw new IllegalArgumentException("No import: " + cls);
        }
        return fqName;
    }

    public String toVmMethodSig(String jlSig) {
        String rtype = this.getReturnType(jlSig);
        String[] ptypes = this.getArgTypes(jlSig);
        return SigConverter.toVmSig(rtype, ptypes);
    }

    public static String toVmSig(String rtype, String[] ptypes) {
        StringBuffer b = new StringBuffer(32);
        b.append('(');
        for (int i = 0; i < ptypes.length; ++i) {
            b.append(ptypes[i]);
        }
        b.append(')');
        b.append(rtype);
        return b.toString();
    }

    public String getType(String javaType) {
        String type = (String)this.types.get(javaType);
        if (type != null) {
            return type;
        }
        int ch = javaType.length() - 1;
        if (ch == -1) {
            throw new IllegalArgumentException("Blank type!");
        }
        int dim = 0;
        while (javaType.charAt(ch) == ']') {
            ++dim;
            if (javaType.charAt(--ch) != '[') {
                throw new IllegalArgumentException("Malformed array: " + javaType);
            }
            --ch;
        }
        if (dim > 0) {
            String baseType = javaType.substring(0, ch + 1);
            type = this.getType(baseType);
        }
        if (type == null) {
            boolean isFq;
            boolean bl = isFq = javaType.indexOf(47) != -1;
            if (!isFq) {
                String fqCls = (String)this.aliasToFull.get(javaType);
                if (fqCls == null) {
                    this.dumpAliases();
                    throw new IllegalArgumentException("Unable to expand: " + javaType);
                }
                javaType = fqCls;
            }
            type = "L" + javaType + ";";
        }
        while (dim-- > 0) {
            type = "[" + type;
        }
        this.types.put(javaType, type);
        return type;
    }

    public String getReturnType(String sig) {
        int pos = sig.lastIndexOf(41);
        if (pos == sig.length() - 1) {
            return "V";
        }
        return this.getType(sig.substring(pos + 1));
    }

    public String[] getArgTypes(String sig) {
        int pos = sig.lastIndexOf(41);
        if (pos == 1) {
            return NO_ARGS;
        }
        String s = sig.substring(1, pos);
        Object obj = this.types.get(s);
        if (obj != null) {
            return new String[]{(String)obj};
        }
        String[] args = Strings.toArray((String)s, (String)",");
        String[] argTypes = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = this.getType(args[i].trim());
        }
        return argTypes;
    }

    public void dumpAliases() {
        System.out.println("Imported Name Listing");
        System.out.println("=====================");
        Iterator i = this.aliasToFull.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            System.out.println(entry.getKey() + " --> " + entry.getValue());
        }
    }

    static {
        primitives.put("byte", "B");
        primitives.put("char", "C");
        primitives.put("double", "D");
        primitives.put("float", "F");
        primitives.put("int", "I");
        primitives.put("long", "J");
        primitives.put("short", "S");
        primitives.put("boolean", "Z");
        primitives.put("void", "V");
        NO_ARGS = new String[0];
    }
}

