/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;

public final class AxisExpression
extends Expression {
    private byte axis;
    private NodeTest test;
    private ItemType itemType = null;
    private ItemType contextItemType = null;
    int computedCardinality = -1;

    public AxisExpression(byte axis, NodeTest nodeTest) {
        this.axis = axis;
        this.test = nodeTest;
    }

    public Expression simplify(ExpressionVisitor visitor) {
        if (this.axis == 9 && (this.test == null || this.test instanceof AnyNodeTest)) {
            ParentNodeExpression p = new ParentNodeExpression();
            ExpressionTool.copyLocationInfo(this, p);
            return p;
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        block48: {
            this.contextItemType = contextItemType;
            NamePool namePool = visitor.getConfiguration().getNamePool();
            StaticContext env = visitor.getStaticContext();
            if (contextItemType == null) {
                XPathException err = new XPathException("Axis step " + this.toString(namePool) + " cannot be used here: the context item is undefined");
                err.setIsTypeError(true);
                err.setErrorCode("XPDY0002");
                err.setLocator(this);
                throw err;
            }
            if (contextItemType.isAtomicType()) {
                XPathException err = new XPathException("Axis step " + this.toString(namePool) + " cannot be used here: the context item is an atomic value");
                err.setIsTypeError(true);
                err.setErrorCode("XPTY0020");
                err.setLocator(this);
                throw err;
            }
            if (contextItemType instanceof NodeTest) {
                int origin = contextItemType.getPrimitiveType();
                if (origin != 0 && Axis.isAlwaysEmpty(this.axis, origin)) {
                    env.issueWarning("The " + Axis.axisName[this.axis] + " axis starting at " + (origin == 1 || origin == 2 ? "an " : "a ") + NodeKindTest.nodeKindName(origin) + " node will never select anything", this);
                    return Literal.makeEmptySequence();
                }
                if (this.test != null) {
                    int kind = this.test.getPrimitiveType();
                    if (kind != 0 && !Axis.containsNodeKind(this.axis, kind)) {
                        env.issueWarning("The " + Axis.axisName[this.axis] + " axis will never select any " + NodeKindTest.nodeKindName(kind) + " nodes", this);
                        return Literal.makeEmptySequence();
                    }
                    if (this.axis == 12 && kind != 0 && origin != 0 && kind != origin) {
                        env.issueWarning("The self axis will never select any " + NodeKindTest.nodeKindName(kind) + " nodes when starting at " + (origin == 1 || origin == 2 ? "an " : "a ") + NodeKindTest.nodeKindName(origin) + " node", this);
                        return Literal.makeEmptySequence();
                    }
                    if (this.axis == 12) {
                        this.itemType = new CombinedNodeTest((NodeTest)contextItemType, 23, this.test);
                    }
                    if (contextItemType instanceof DocumentNodeTest && this.axis == 3 && kind == 1) {
                        IntHashSet selected;
                        NodeTest elementTest = ((DocumentNodeTest)contextItemType).getElementTest();
                        IntHashSet requiredNames = elementTest.getRequiredNodeNames();
                        if (requiredNames != null && (selected = this.test.getRequiredNodeNames()) != null && selected.intersect(requiredNames).isEmpty()) {
                            env.issueWarning("Starting at a document node, the step is selecting an element whose name is not among the names of child elements permitted for this document node type", this);
                            return Literal.makeEmptySequence();
                        }
                        this.itemType = elementTest;
                        return this;
                    }
                    SchemaType contentType = ((NodeTest)contextItemType).getContentType();
                    if (contentType == AnyType.getInstance()) {
                        return this;
                    }
                    int targetfp = this.test.getFingerprint();
                    if (contentType.isSimpleType()) {
                        if (!(this.axis != 3 && this.axis != 2 && this.axis != 4 && this.axis != 5 || kind != 1 && kind != 2 && kind != 9)) {
                            env.issueWarning("The " + Axis.axisName[this.axis] + " axis will never select any " + NodeKindTest.nodeKindName(kind) + " nodes when starting at a node with simple type " + contentType.getDescription(), this);
                        } else if (this.axis == 3 && kind == 3 && visitor.getParentExpression() instanceof Atomizer) {
                            env.issueWarning("Selecting the text nodes of an element with simple content may give the wrong answer in the presence of comments or processing instructions. It is usually better to omit the '/text()' step", this);
                        }
                    } else if (!(!((ComplexType)contentType).isSimpleContent() || this.axis != 3 && this.axis != 4 && this.axis != 5 || kind != 1 && kind != 9)) {
                        env.issueWarning("The " + Axis.axisName[this.axis] + " axis will never select any " + NodeKindTest.nodeKindName(kind) + " nodes when starting at a node with type " + contentType.getDescription() + ", as this type requires simple content", this);
                    } else if (((ComplexType)contentType).isEmptyContent() && (this.axis == 3 || this.axis == 4 || this.axis == 5)) {
                        env.issueWarning("The " + Axis.axisName[this.axis] + " axis will never select any " + " nodes when starting at a node with type " + contentType.getDescription() + ", as this type requires empty content", this);
                    } else if (this.axis == 2 && targetfp != -1) {
                        try {
                            SchemaType schemaType = ((ComplexType)contentType).getAttributeUseType(targetfp);
                            if (schemaType == null) {
                                String n = env.getNamePool().getDisplayName(targetfp);
                                env.issueWarning("The complex type " + contentType.getDescription() + " does not allow an attribute named " + n, this);
                                break block48;
                            }
                            this.itemType = new CombinedNodeTest(this.test, 23, new ContentTypeTest(2, schemaType, env.getConfiguration()));
                        }
                        catch (SchemaException e) {}
                    } else if (this.axis == 3 && kind == 1) {
                        try {
                            SchemaType schemaType;
                            int childElement = targetfp;
                            if (targetfp == -1) {
                                IntHashSet children = new IntHashSet();
                                ((ComplexType)contentType).gatherAllPermittedChildren(children);
                                if (children.isEmpty()) {
                                    env.issueWarning("The complex type " + contentType.getDescription() + " does not allow children", this);
                                    return this;
                                }
                                if (children.contains(-1)) {
                                    return this;
                                }
                                if (children.size() == 1) {
                                    IntIterator iter = children.iterator();
                                    if (iter.hasNext()) {
                                        childElement = iter.next();
                                    }
                                } else {
                                    return this;
                                }
                            }
                            if ((schemaType = ((ComplexType)contentType).getElementParticleType(childElement)) == null) {
                                String n = env.getNamePool().getDisplayName(childElement);
                                env.issueWarning("The complex type " + contentType.getDescription() + " does not allow a child element named " + n, this);
                            } else {
                                this.itemType = new CombinedNodeTest(this.test, 23, new ContentTypeTest(1, schemaType, env.getConfiguration()));
                                this.computedCardinality = ((ComplexType)contentType).getElementParticleCardinality(childElement);
                                visitor.resetStaticProperties();
                                if (!Cardinality.allowsMany(this.computedCardinality)) {
                                    return new FirstItemExpression(this);
                                }
                            }
                        }
                        catch (SchemaException e) {}
                    } else if (this.axis == 4 && kind == 1 && targetfp != -1) {
                        try {
                            IntHashSet descendants = new IntHashSet();
                            ((ComplexType)contentType).gatherAllPermittedDescendants(descendants);
                            if (descendants.contains(-1)) {
                                return this;
                            }
                            if (descendants.contains(targetfp)) {
                                IntHashSet children = new IntHashSet();
                                ((ComplexType)contentType).gatherAllPermittedChildren(children);
                                IntHashSet usefulChildren = new IntHashSet();
                                boolean considerSelf = false;
                                boolean considerDescendants = false;
                                IntIterator child = children.iterator();
                                while (child.hasNext()) {
                                    SchemaType st;
                                    int c = child.next();
                                    if (c == targetfp) {
                                        usefulChildren.add(c);
                                        considerSelf = true;
                                    }
                                    if ((st = ((ComplexType)contentType).getElementParticleType(c)) == null) {
                                        throw new AssertionError((Object)("Can't find type for element " + c));
                                    }
                                    if (!(st instanceof ComplexType)) continue;
                                    IntHashSet subDescendants = new IntHashSet();
                                    ((ComplexType)st).gatherAllPermittedDescendants(subDescendants);
                                    if (!subDescendants.contains(targetfp)) continue;
                                    usefulChildren.add(c);
                                    considerDescendants = true;
                                }
                                if (usefulChildren.size() < children.size()) {
                                    NodeTest childTest = this.makeUnionNodeTest(usefulChildren, visitor.getConfiguration().getNamePool());
                                    AxisExpression first = new AxisExpression(3, childTest);
                                    ExpressionTool.copyLocationInfo(this, first);
                                    byte nextAxis = considerSelf ? (considerDescendants ? (byte)5 : 12) : (byte)4;
                                    AxisExpression next = new AxisExpression(nextAxis, this.test);
                                    ExpressionTool.copyLocationInfo(this, next);
                                    PathExpression path = new PathExpression(first, next);
                                    ExpressionTool.copyLocationInfo(this, path);
                                    return path.typeCheck(visitor, contextItemType);
                                }
                            } else {
                                String n = env.getNamePool().getDisplayName(targetfp);
                                env.issueWarning("The complex type " + contentType.getDescription() + " does not allow a descendant element named " + n, this);
                            }
                        }
                        catch (SchemaException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                }
            }
        }
        return this;
    }

    private NodeTest makeUnionNodeTest(IntHashSet elements, NamePool pool) {
        NodeTest test = null;
        IntIterator iter = elements.iterator();
        while (iter.hasNext()) {
            int fp = iter.next();
            NameTest nextTest = new NameTest(1, fp, pool);
            if (test == null) {
                test = nextTest;
                continue;
            }
            test = new CombinedNodeTest(test, 1, nextTest);
        }
        if (test == null) {
            return EmptySequenceTest.getInstance();
        }
        return test;
    }

    public ItemType getContextItemType() {
        return this.contextItemType;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) {
        return this;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AxisExpression)) {
            return false;
        }
        if (this.axis != ((AxisExpression)other).axis) {
            return false;
        }
        if (this.test == null) {
            return ((AxisExpression)other).test == null;
        }
        return this.test.toString().equals(((AxisExpression)other).test.toString());
    }

    public int hashCode() {
        int h = 9375162 + this.axis << 20;
        if (this.test != null) {
            h ^= this.test.getPrimitiveType() << 16;
            h ^= this.test.getFingerprint();
        }
        return h;
    }

    public int getIntrinsicDependencies() {
        return 2;
    }

    public Expression copy() {
        AxisExpression a2 = new AxisExpression(this.axis, this.test);
        a2.itemType = this.itemType;
        a2.contextItemType = this.contextItemType;
        a2.computedCardinality = this.computedCardinality;
        return a2;
    }

    public int computeSpecialProperties() {
        return 0xC10000 | (Axis.isForwards[this.axis] ? 131072 : 262144) | (Axis.isPeerAxis[this.axis] ? 524288 : 0) | (Axis.isSubtreeAxis[this.axis] ? 0x100000 : 0) | (this.axis == 2 || this.axis == 8 ? 0x200000 : 0);
    }

    public final ItemType getItemType(TypeHierarchy th) {
        if (this.itemType != null) {
            return this.itemType;
        }
        short p = Axis.principalNodeType[this.axis];
        switch (p) {
            case 2: 
            case 13: {
                return NodeKindTest.makeNodeKindTest(p);
            }
        }
        if (this.test == null) {
            return AnyNodeTest.getInstance();
        }
        return this.test;
    }

    public final int computeCardinality() {
        if (this.computedCardinality != -1) {
            return this.computedCardinality;
        }
        if (this.axis == 2 && this.test instanceof NameTest) {
            return 24576;
        }
        if (this.axis == 12) {
            return 24576;
        }
        return 57344;
    }

    public byte getAxis() {
        return this.axis;
    }

    public NodeTest getNodeTest() {
        return this.test;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        if (pathMapNodeSet == null) {
            ContextItemExpression cie = new ContextItemExpression();
            cie.setContainer(this.getContainer());
            pathMapNodeSet = new PathMap.PathMapNodeSet(pathMap.makeNewRoot(cie));
        }
        PathMap.PathMapNodeSet target = pathMapNodeSet.createArc(this);
        return target;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        Item item = context.getContextItem();
        try {
            if (this.test == null) {
                return ((NodeInfo)item).iterateAxis(this.axis);
            }
            return ((NodeInfo)item).iterateAxis(this.axis, this.test);
        }
        catch (NullPointerException npe) {
            NamePool pool;
            try {
                pool = context.getConfiguration().getNamePool();
            }
            catch (Exception err) {
                pool = null;
            }
            XPathException err = new XPathException("The context item for axis step " + (pool == null ? this.toString() : this.toString(pool)) + " is undefined");
            err.setErrorCode("XPDY0002");
            err.setXPathContext(context);
            err.setLocator(this);
            err.setIsTypeError(true);
            throw err;
        }
        catch (ClassCastException cce) {
            NamePool pool;
            try {
                pool = context.getConfiguration().getNamePool();
            }
            catch (Exception err) {
                pool = null;
            }
            XPathException err = new XPathException("The context item for axis step " + (pool == null ? this.toString() : this.toString(pool)) + " is not a node");
            err.setErrorCode("XPTY0020");
            err.setXPathContext(context);
            err.setLocator(this);
            err.setIsTypeError(true);
            throw err;
        }
        catch (UnsupportedOperationException err) {
            this.dynamicError(err.getMessage(), "XPST0010", context);
            return null;
        }
    }

    public SequenceIterator iterate(Item origin) throws XPathException {
        try {
            if (this.test == null) {
                return ((NodeInfo)origin).iterateAxis(this.axis);
            }
            return ((NodeInfo)origin).iterateAxis(this.axis, this.test);
        }
        catch (ClassCastException cce) {
            XPathException err = new XPathException("The context item for axis step " + this.toString() + " is not a node");
            err.setErrorCode("XPTY0020");
            err.setLocator(this);
            err.setIsTypeError(true);
            throw err;
        }
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("axis");
        destination.emitAttribute("name", Axis.axisName[this.axis]);
        destination.emitAttribute("nodeTest", this.test == null ? "node()" : this.test.toString());
        destination.endElement();
    }

    public String toString() {
        return Axis.axisName[this.axis] + "::" + (this.test == null ? "node()" : this.test.toString());
    }

    public String toString(NamePool pool) {
        return Axis.axisName[this.axis] + "::" + (this.test == null ? "node()" : this.test.toString(pool));
    }
}

