/*
 * Copyright (c) 2012 Simon Busch <morphis@gravedo.de>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <android/hardware/sensors.h>

int main(int argc, char **argv)
{
	struct hw_module_t *hwmod;
	struct sensors_poll_device_t *dev;

	hw_get_module(SENSORS_HARDWARE_MODULE_ID, (const hw_module_t**) &hwmod);
	assert(hwmod != NULL);

	if (sensors_open(hwmod, &dev) < 0) {
		printf("ERROR: failed to open sensors device\n");
		exit(1);
	}

	if (sensors_close(dev) < 0) {
		printf("ERROR: failed to close sensors device\n");
		exit(1);
	}

	return 0;
}

// vim:ts=4:sw=4:noexpandtab
