<?php
/**
 * Test class for MongoId
 * Generated by PHPUnit on 2009-04-10 at 13:30:28.
 */
class MongoIdTest extends PHPUnit_Framework_TestCase
{
    public function testBasic() {
        if (preg_match("/5\.1\../", phpversion())) {
            $this->markTestSkipped("No implicit __toString in 5.1");
            return;
        }

        $id1 = new MongoId();
        $this->assertEquals(strlen("$id1"), 24);

        $copy = new MongoId($id1);
        $this->assertEquals((string)$id1, (string)$copy);

        $id2 = new MongoId('49c10bb63eba810c0c3fc158');
        $this->assertEquals((string)$id2, '49c10bb63eba810c0c3fc158');

        $m = new Mongo();
        $c = $m->selectCollection("phpunit", "id");
        $c->drop();
        $c->insert(array("_id" => 1));
        $obj = $c->findOne();
        $this->assertEquals($obj['_id'], 1);
    }

    // shouldn't throw an error, just ignore it
    public function testIncorrect() {
        if (preg_match("/5\.1\../", phpversion())) {
            $this->markTestSkipped("No implicit __toString in 5.1");
            return;
        }

        $id1 = new MongoId("foo");
        $this->assertNotEquals((string)$id1, "foo");
        $this->assertEquals(strlen("$id1"), 24);

        $id2 = new MongoId(234);
        $this->assertNotEquals("$id2", 234);
        $this->assertEquals(strlen("$id2"), 24);

        $this->assertNotEquals((string)$id1, (string)$id2);
    }
  
    public function testSerialize() {
        if (preg_match("/5\.1\../", phpversion())) {
            $this->markTestSkipped("No implicit __toString in 5.1");
            return;
        }

        $id = new MongoId("4a4391aa82c94f4f3adc0878");
        $x = serialize($id);
        $this->assertEquals('C:7:"MongoId":24:{4a4391aa82c94f4f3adc0878}', $x);
        
        $y = unserialize($x);
        $this->assertTrue($y instanceof MongoId);
        $this->assertEquals("$id", "$y");
    }

    public function testIncrement() {
        if (preg_match("/5\.1\../", phpversion())) {
            $this->markTestSkipped("No implicit __toString in 5.1");
            return;
        }

        $num = 10;
        $id = array();
        for ($i=0; $i<$num; $i++) {
            $id[] = new MongoId();
            sleep(1);
        }
        
        for ($i=0; $i<$num-1; $i++) {
            $this->assertGreaterThan($id[$i]."", $id[$i+1]."", $id[$i] . ", " . $id[$i+1]);
        }
    }

    public function testInc2() {
        if (preg_match("/5\.1\../", phpversion())) {
            $this->markTestSkipped("No implicit __toString in 5.1");
            return;
        }

        $num = 10;
        $id = array();
        for ($i=0; $i<$num; $i++) {
            $id[] = new MongoId();
        }
        
        for ($i=0; $i<$num-1; $i++) {
            $this->assertGreaterThan($id[$i]."", $id[$i+1]."", $id[$i] . ", " . $id[$i+1]);
        }        
    }

    public function testTimestamp() {
        $time = time();
        $id = new MongoId();
  
        $this->assertTrue(abs($time-$id->getTimestamp()) < 1000, $time-$id->getTimestamp());
    }

    public function testCompare() {
      $id1 = new MongoId('012345678901234567890123');
      $id2 = new MongoId('012345678901234567890123');
      $id3 = new MongoId();

      // in_array() 
      $array = array($id1); 
      $ok = in_array($id2, $array); 
      $this->assertTrue($ok);
 
      $ok = in_array($id3, $array); 
      $this->assertFalse($ok);
     
      // array_search() 
      $array = array($id3, $id1, $id2); 
      $key = array_search($id2, $array); 
      $this->assertEquals(1, $key);
      
      $this->assertTrue($id1 == $id2);
      $this->assertFalse($id1 == $id3);

      $ids = array();
      for ($i=0; $i<8;$i++) {
        $ids[] = new MongoId();
      }

      $mess = array($ids[5], $ids[2], $ids[7], $ids[1], $ids[0], $ids[3], $ids[4], $ids[7]);
      sort($mess);

      $this->assertEquals($ids[0], $mess[0]);
      $this->assertEquals($ids[1], $mess[1]);
      $this->assertEquals($ids[2], $mess[2]);
      $this->assertEquals($ids[3], $mess[3]);
      $this->assertEquals($ids[4], $mess[4]);
      $this->assertEquals($ids[5], $mess[5]);
      $this->assertEquals($ids[7], $mess[6]);
      $this->assertEquals($ids[7], $mess[7]);
    }

    public function testSetState() {
      if (preg_match('/5\.1\..+/', phpversion())) {
        $this->markTestSkipped("No implicit __toString() 5.1");
        return;
      }

      $m = new Mongo();
      $c = $m->phpunit->c;
      $c->drop();

      $c->insert(array('x'=>1));

      $cursor = $c->find();
      eval('$x='.var_export(iterator_to_array($cursor), true).';');

      foreach ($x as $k => $v) {
        $this->assertEquals(24, strlen($k));
        $this->assertEquals("00000000000000000000000", $v['_id']."");
        $this->assertTrue($v['_id'] instanceof MongoId);
      }
    }

    public function testGetHostname() {
      if (preg_match('/5\.[12]\..+/', phpversion())) {
        $this->markTestSkipped("No gethostname() 5.1 or 5.2");
        return;
      }

      $host1 = gethostname();
      $host2 = MongoId::getHostname();
      $this->assertEquals($host1, $host2);
    }

    public function testJsonEncode() {
      if (preg_match('/5\.1\..+/', phpversion())) {
        $this->markTestSkipped("No json_encode() in 5.1");
        return;
      }

      $id = new MongoId();
      $json = json_encode($id);
      $this->assertEquals('{"$id":"'.$id.'"}', $json);
    }

    public function testJsonEncode2() {
        if (preg_match('/5\.1\..+/', phpversion())) {
          $this->markTestSkipped("No json_encode() in 5.1");
          return;
        }

        $id = new MongoId();
        $m = new Mongo();
        $c = $m->phpunit->c;
        $c->drop();
        $c->insert(array("_id" => $id));
        $result = $c->findOne();
        
        $json = json_encode($result);
        $this->assertEquals('{"_id":{"$id":"'.$id.'"}}', $json);
    }

    public function testGetInc() {
      $id = new MongoId();
      $inc1 = $id->getInc();
      $id = new MongoId();
      $inc2 = $id->getInc();
      $this->assertEquals($inc1+1, $inc2);
    }

    public function testGetPID() {
      $id = new MongoId();
      $pid1 = $id->getPID();
      $id = new MongoId();
      $pid2 = $id->getPID();
      $this->assertEquals($pid1, $pid2);
    }
}

?>
