# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class WorkItemConfiguration(Model):
    """Work item configuration associated with an application insights resource.

    :param connector_id: Connector identifier where work item is created
    :type connector_id: str
    :param config_display_name: Configuration friendly name
    :type config_display_name: str
    :param is_default: Boolean value indicating whether configuration is
     default
    :type is_default: bool
    :param id: Unique Id for work item
    :type id: str
    :param config_properties: Serialized JSON object for detailed properties
    :type config_properties: str
    """

    _attribute_map = {
        'connector_id': {'key': 'ConnectorId', 'type': 'str'},
        'config_display_name': {'key': 'ConfigDisplayName', 'type': 'str'},
        'is_default': {'key': 'IsDefault', 'type': 'bool'},
        'id': {'key': 'Id', 'type': 'str'},
        'config_properties': {'key': 'ConfigProperties', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WorkItemConfiguration, self).__init__(**kwargs)
        self.connector_id = kwargs.get('connector_id', None)
        self.config_display_name = kwargs.get('config_display_name', None)
        self.is_default = kwargs.get('is_default', None)
        self.id = kwargs.get('id', None)
        self.config_properties = kwargs.get('config_properties', None)
