#===================================
#              pymm
#  Copyright 2010 - Nathan Osman
#
#     A small wrapper around
#       the messaging menu
#
#   StackApplet is released under
#        the MIT license
#===================================

# Import the indicate module
import indicate

class pymm:
    
    def __init__(self, desktop_file):
        
        # Create the server
        self.server = indicate.indicate_server_ref_default()
        
        # Set the server's desktop file
        self.server.set_desktop_file(desktop_file)
        
        # Set the type
        self.server.set_type("message.im")
        
        # Now show the item
        self.server.show()

class pymm_source:

    def __init__(self, name, icon = None):
        
        self.source = indicate.Indicator()
        
        self.source.set_property("subtype", "im")
        self.source.set_property("sender", name)
        
        if icon:
            self.source.set_property("icon", icon)
        
        self.source.show()
        
    def set_count(self, count):
    
        self.source.set_property("count", str(count))
    
    def set_notify(self, notify):
    	
    	if notify:
    		self.source.set_property("draw-attention", "true")
    	else:
    		self.source.set_property("draw-attention", "false")
