}q (X   __module_docstringqX   The classes in this module are the most commonly used classes for wxPython,
which is why they have been made visible in the core `wx` namespace.
Everything you need for building typical GUI applications is here.
qX	   CallLaterqXH   A convenience class for :class:`wx.Timer`, that calls the given callableqX
   RefCounterqX[   This class is used to manage reference-counting providing a simple interface and a counter.qX   ObjectqX8   This is the root class of many of the wxWidgets classes.qX	   ClassInfoq	X1   This class stores meta-information about classes.q
X   ClientDataContainerqXL   This class is a mixin that provides storage and management of "client data".qX   SharedClientDataContainerq
X   This class is a replacement for :ref:`wx.ClientDataContainer`, and unlike :ref:`wx.ClientDataContainer`  the :ref:`wx.SharedClientDataContainer`  client data is copiable, so it can be copied when objects containing it are cloned.qX   TimeZoneqX   Class representing a time zone.qX   TmqX.   Contains broken down date-time representation.qX   DateTimeqX@   :ref:`wx.DateTime`  class represents an absolute moment in time.qX   DateSpanqXe  This class is a "logical time span" and is useful for implementing program logic for such things as "add one month to the date" which, in general, doesn't mean to add 60x60x24x31 seconds to it, but to take the same date the next month (to understand that this is indeed different consider adding one month to Feb, 15 –  we want to get Mar, 15, of course).qX   TimeSpanqX5   :ref:`wx.TimeSpan`  class represents a time interval.qX	   StopWatchqXC   The :ref:`wx.StopWatch`  class allow you to measure time intervals.qX	   IdManagerqXL   :ref:`wx.IdManager`  is responsible for allocating and releasing window IDs.qX   WindowIDRefqXu   A WindowIDRef object wraps an ``ID`` value and marks it as being in-use until all references to that ``ID`` are gone.qX   PlatformInformationqX   This class holds information about the operating system, the toolkit and the basic architecture bitness of the machine where the application is currently running.q X   LinuxDistributionInfoq!Xl   A structure containing information about a Linux distribution as returned by the  ``lsb_release``   utility.q"X
   PlatformIdq#X-   Defines a very broad platform categorization.q$X	   VideoModeq%XG   Determines the sizes and locations of displays connected to the system.q&X   Displayq'XG   Determines the sizes and locations of displays connected to the system.q(X   LanguageInfoq)Xm   Encapsulates a :ref:`wx.Language`  identifier together with OS-specific information related to that language.q*X   Localeq+Xu   :ref:`wx.Locale`  class encapsulates all language-dependent settings and is a generalization of the C locale concept.q,X   Translationsq-X3   This class allows getting translations for strings.q.X   TranslationsLoaderq/X2   Abstraction of translations discovery and loading.q0X   FileTranslationsLoaderq1X6   Standard :ref:`wx.TranslationsLoader`  implementation.q2X   PageSetupDialogDataq3XO   This class holds a variety of information related to :ref:`wx.PageSetupDialog`.q4X	   PrintDataq5XZ   This class holds a variety of information related to printers and printer device contexts.q6X   PrintDialogDataq7X\   This class holds information related to the visual characteristics of :ref:`wx.PrintDialog`.q8X   Pointq9XF   A :ref:`wx.Point`  is a useful data structure for graphics operations.q:X   Sizeq;XE   A :ref:`wx.Size`  is a useful data structure for graphics operations.q<X   Rectq=X0   Represents a rectangle with integer coordinates.q>X	   RealPointq?XJ   A :ref:`wx.RealPoint`  is a useful data structure for graphics operations.q@X   ColourDatabaseqAXa   wxWidgets maintains a database of standard ``RGB`` colours for a predefined set of named colours.qBX   Point2DqCX    qDX   Rect2DqEhDX   Matrix2DqFX"   A simple container for 2x2 matrix.qGX   AffineMatrix2DBaseqHX:   A 2x3 matrix representing an affine ``2D`` transformation.qIX   AffineMatrix2DqJX:   A 3x2 matrix representing an affine ``2D`` transformation.qKX   PositionqLX   This class represents the position of an item in any kind of grid of rows and columns such as :ref:`wx.GridBagSizer`, or :ref:`wx.HVScrolledWindow`.qMX   ColourqNX   A colour is an object representing a combination of Red, Green, and Blue (``RGB``) intensity values and an Alpha value, and is used to determine drawing colours.qOX
   StreamBaseqPXI   This class is the base class of most stream related classes in wxWidgets.qQX   InputStreamqRXP   :ref:`wx.InputStream`  is an abstract base class which may not be used directly.qSX   OutputStreamqTXQ   :ref:`wx.OutputStream`  is an abstract base class which may not be used directly.qUX
   FileSystemqVXM   This class provides an interface for opening files on different file systems.qWX   FSFileqXXC   This class represents a single file opened by :ref:`wx.FileSystem`.qYX   FileSystemHandlerqZXZ   Classes derived from :ref:`wx.FileSystemHandler`  are used to access virtual file systems.q[X   MemoryFSHandlerq\Xq   This :ref:`wx.FileSystem`  handler can store arbitrary data in memory stream and make them accessible via an URL.q]X   ArchiveFSHandlerq^X=   A file system handler for accessing files inside of archives.q_X   FilterFSHandlerq`X   Filter file system handler.qaX   InternetFSHandlerqbX@   A file system handler for accessing files from internet servers.qcX   HSVValueqdXV   A simple class which stores hue, saturation and value as doubles in the range 0.0-1.0.qeX   RGBValueqfXd   A simple class which stores red, green and blue values as 8 bit  integers in the range of ``0-255``.qgX   ImageqhX5   This class encapsulates a platform-independent image.qiX   ImageHistogramqjhDX   ImageHandlerqkX`   This is the base class for implementing image file loading/saving, and image creation from data.qlX   TIFFHandlerqmX2   This is the image handler for the ``TIFF`` format.qnX
   GIFHandlerqoX1   This is the image handler for the ``GIF`` format.qpX
   IFFHandlerqqX1   This is the image handler for the ``IFF`` format.qrX   JPEGHandlerqsX2   This is the image handler for the ``JPEG`` format.qtX
   PCXHandlerquX1   This is the image handler for the ``PCX`` format.qvX
   PNGHandlerqwX1   This is the image handler for the ``PNG`` format.qxX
   PNMHandlerqyX1   This is the image handler for the ``PNM`` format.qzX
   TGAHandlerq{X1   This is the image handler for the ``TGA`` format.q|X
   XPMHandlerq}X-   This is the image handler for the XPM format.q~X	   GDIObjectqX   This class allows platforms to implement functionality to optimise GDI objects, such as :ref:`wx.Pen`, :ref:`wx.Brush`  and :ref:`wx.Font`.qX   BitmapqX   This class encapsulates the concept of a platform-dependent bitmap, either monochrome or colour or colour with alpha channel support.qX   MaskqXp   This class encapsulates a monochrome mask bitmap, where the masked area is black and the unmasked area is white.qX   BitmapBundleqXE   Contains representations of the same bitmap in different resolutions.qX   BitmapBundleImplqX@   Base class for custom implementations of :ref:`wx.BitmapBundle`.qX   IconqXX   An icon is a small rectangular bitmap usually used for denoting a minimized application.qX   IconLocationqXU   :ref:`wx.IconLocation`  is a tiny class describing the location of an (external, i.e.qX
   IconBundleqXB   This class contains multiple copies of an icon in different sizes.qX   FontInfoqX  This class is a helper used for :ref:`wx.Font`  creation using named parameter idiom: it allows specifying various :ref:`wx.Font`  attributes using the chained calls to its clearly named methods instead of passing them in the fixed order to :ref:`wx.Font`  constructors.qX   FontqX<   A font is an object which determines the appearance of text.qX   FontListqXC   A font list is a list containing all fonts which have been created.qX   NativeFontInfoqXg  :ref:`wx.NativeFontInfo`  is platform-specific font representation: this class should be considered as an opaque font description only used by the native functions, the user code can only get the objects of this type from somewhere and pass it somewhere else (possibly save them somewhere using :ref:`wx.ToString`  and restore them using :ref:`wx.FromString`)qX   PenInfoqX  This class is a helper used for :ref:`wx.Pen`  creation using named parameter idiom: it allows specifying various :ref:`wx.Pen`  attributes using the chained calls to its clearly named methods instead of passing them in the fixed order to :ref:`wx.Pen`  constructors.qX   PenqX-   A pen is a drawing tool for drawing outlines.qX   PenListqX?   There is only one instance of this class: :ref:`wx.ThePenList`.qX   BrushqX/   A brush is a drawing tool for filling in areas.qX	   BrushListqXF   A brush list is a list containing all brushes which have been created.qX   CursorqX   A cursor is a small bitmap usually used for denoting where the mouse pointer is, with a picture that might indicate the interpretation of a mouse click.qX   RegionIteratorqX   This class is used to iterate through the rectangles in a region, typically when examining the damaged regions of a window within an OnPaint call.qX   RegionqXX   A :ref:`wx.Region`  represents a simple or complex region on a device context or window.qX   FontMetricsqX*   Simple collection of various font metrics.qX   DCqXS   A :ref:`wx.DC`  is a `"device context"`  onto which graphics and text can be drawn.qX	   DCClipperqXl   :ref:`wx.DCClipper`  is a helper class for setting a clipping region on a :ref:`wx.DC`  during its lifetime.qX   DCBrushChangerqX   :ref:`wx.DCBrushChanger`  is a small helper class for setting a brush on a :ref:`wx.DC`  and unsetting it automatically in the destructor, restoring the previous one.qX   DCPenChangerqX   :ref:`wx.DCPenChanger`  is a small helper class for setting a pen on a :ref:`wx.DC`  and unsetting it automatically in the destructor, restoring the previous one.qX   DCTextColourChangerqX   :ref:`wx.DCTextColourChanger`  is a small helper class for setting a foreground text colour on a :ref:`wx.DC`  and unsetting it automatically in the destructor, restoring the previous one.qX
   DCFontChangerqX   :ref:`wx.DCFontChanger`  is a small helper class for setting a font on a :ref:`wx.DC`  and unsetting it automatically in the destructor, restoring the previous one.qX   DCTextBgColourChangerqX   :ref:`wx.DCTextBgColourChanger`  is a small helper class for setting a background text colour on a :ref:`wx.DC`  and unsetting it automatically in the destructor, restoring the previous one.qX   DCTextBgModeChangerqX   :ref:`wx.DCTextBgModeChanger`  is a small helper class for setting a background text mode on a :ref:`wx.DC`  and unsetting it automatically in the destructor, restoring the previous one.qX   WindowDCqX   A :ref:`wx.WindowDC`  must be constructed if an application wishes to paint on the whole area of a window (client and decorations).qX   ClientDCqXt   :ref:`wx.ClientDC`  is primarily useful for obtaining information about the window from outside EVT_PAINT() handler.qX   PaintDCqX   A :ref:`wx.PaintDC`  must be constructed if an application wishes to paint on the client area of a window from within an EVT_PAINT() event handler.qX   MemoryDCqXH   A memory device context provides a means to draw graphics onto a bitmap.qX
   BufferedDCqX   This class provides a simple way to avoid flicker: when drawing on it, everything is in fact first drawn on an in-memory buffer (a :ref:`wx.Bitmap`) and then copied to the screen, using the associated :ref:`wx.DC`, only once, when this object is destroyed.qX   BufferedPaintDCqX   This is a subclass of :ref:`wx.BufferedDC`  which can be used inside of an  ``EVT_PAINT()``   event handler to achieve double-buffered drawing.qX   AutoBufferedPaintDCqX{   This :ref:`wx.DC`  derivative can be used inside of an  ``EVT_PAINT()``   event handler to achieve double-buffered drawing.qX   ScreenDCqX9   A :ref:`wx.ScreenDC`  can be used to paint on the screen.qX   GCDCqXN   :ref:`wx.GCDC`  is a device context that draws on a :ref:`wx.GraphicsContext`.qX   MirrorDCqXD  :ref:`wx.MirrorDC`  is a simple wrapper class which is always associated with a real :ref:`wx.DC`  object and either forwards all of its operations to it without changes (no mirroring takes place) or exchanges `x`  and `y`  coordinates which makes it possible to reuse the same code to draw a figure and its mirror –  i.e.qX	   PrinterDCqXy   A printer device context is specific to MSW and Mac, and allows access to any printer with a Windows or Macintosh driver.qX   PostScriptDCqXt   This defines the wxWidgets Encapsulated PostScript device context, which can write PostScript files on any platform.qX	   SVGFileDCqX   A :ref:`wx.SVGFileDC`  is a device context onto which graphics and text can be drawn, and the output produced as a vector file, in ``SVG`` format.qX   SVGBitmapHandlerqXF   Abstract base class for handling bitmaps inside a :ref:`wx.SVGFileDC`.qX   SVGBitmapEmbedHandlerqXB   Handler embedding bitmaps as base64-encoded PNGs into the ``SVG``.qX   SVGBitmapFileHandlerqXT   Handler saving bitmaps to external ``PNG`` files and linking to it from the ``SVG``.qX   MetafileqXt   A  ** :ref:`wx.Metafile` **   represents the MS Windows metafile object, so metafile operations have no effect in X.qX
   MetafileDCqX   This is a type of device context that allows a metafile object to be created (Windows only), and has most of the characteristics of a normal  ** :ref:`wx.DC` ** .qX   GraphicsObjectqXF   This class is the superclass of native graphics objects like pens etc.qX   GraphicsBitmapqX   Represents a bitmap.qX
   GraphicsBrushqXA   A :ref:`wx.GraphicsBrush`  is a native representation of a brush.qX   GraphicsFontqX?   A :ref:`wx.GraphicsFont`  is a native representation of a font.qX   GraphicsPenInfoqX#  This class is a helper used for :ref:`wx.GraphicsPen`  creation using named parameter idiom: it allows specifying various :ref:`wx.GraphicsPen`  attributes using the chained calls to its clearly named methods instead of passing them in the fixed order to :ref:`wx.GraphicsPen`  constructors.qX   GraphicsPenqX=   A :ref:`wx.GraphicsPen`  is a native representation of a pen.qX   GraphicsContextqXG   A :ref:`wx.GraphicsContext`  instance is the object that is drawn upon.qX   GraphicsGradientStopqXv   Represents a single gradient stop in a collection of gradient stops as represented by :ref:`wx.GraphicsGradientStops`.qX   GraphicsGradientStopsqX{   Represents a collection of GraphicGradientStop values for use with CreateLinearGradientBrush and CreateRadialGradientBrush.qX   GraphicsMatrixqXK   A :ref:`wx.GraphicsMatrix`  is a native representation of an affine matrix.qX   GraphicsPathqXI   A :ref:`wx.GraphicsPath`  is a native representation of a geometric path.qX   GraphicsRendererqXY   A :ref:`wx.GraphicsRenderer`  is the instance corresponding to the rendering engine used.qX	   ImageListqXZ   A :ref:`wx.ImageList`  contains a list of images, which are stored in an unspecified form.qX   OverlayqX_   Creates an overlay over an existing window, allowing for manipulations like rubberbanding, etc.qX	   DCOverlayqX&   Connects an overlay with a drawing DC.qX   PaletteqX?   A palette is a table that maps pixel values to ``RGB`` colours.qX   SplitterRenderParamsqXl   This is just a simple  ``struct``   used as a return value of  :meth:`wx.RendererNative.GetSplitterParams` .qX   HeaderButtonParamsqX   This  ``struct``   can optionally be used with  :meth:`wx.RendererNative.DrawHeaderButton`   to specify custom values used to draw the text or bitmap label.r   X   RendererNativer  XN   First, a brief introduction to :ref:`wx.RendererNative`  and why it is needed.r  X   DelegateRendererNativer  X   :ref:`wx.DelegateRendererNative`  allows reuse of renderers code by forwarding all the :ref:`wx.RendererNative`  methods to the given object and thus allowing you to only modify some of its methods –  without having to reimplement all of them.r  X   RendererVersionr  X   This simple struct represents the :ref:`wx.RendererNative`  interface version and is only used as the return value of :meth:`wx.RendererNative.GetVersion` .r  X
   PixelDataBaser  hDX   NativePixelDatar  X9   A class providing direct access to a :class:`wx.Bitmap`'sr	  X   NativePixelData_Accessorr
  hDX   AlphaPixelDatar  X9   A class providing direct access to a :class:`wx.Bitmap`'sr  X   AlphaPixelData_Accessorr
  hDX
   Accessibler  X   The :ref:`wx.Accessible`  class allows wxWidgets applications, and wxWidgets itself, to return extended information about user interface elements to client applications such as screen readers.r  X   AcceleratorEntryr  Xi   An object used by an application wishing to create an accelerator table (see :ref:`wx.AcceleratorTable`).r  X   AcceleratorTabler  Xq   An accelerator table allows the application to specify a table of keyboard shortcuts for menu or button commands.r  X   Logr  X   :ref:`wx.Log`  class defines the interface for the `log targets`  used by wxWidgets logging functions as explained in the :ref:`Logging Overview <logging overview>`.r  X   LogGuir  XB   This is the default log target for the GUI wxWidgets applications.r  X   LogNullr  X5   This class allows you to temporarily suspend logging.r  X
   LogRecordInfor  X8   Information about a log record (unit of the log output).r  X   LogChainr  X   This simple class allows you to chain log sinks, that is to install a new sink but keep passing log messages to the old one instead of replacing it completely as :meth:`wx.Log.SetActiveTarget`   does.r  X
   LogInterposerr  XQ   A special version of :ref:`wx.LogChain`  which uses itself as the new log target.r  X   LogInterposerTempr   XQ   A special version of :ref:`wx.LogChain`  which uses itself as the new log target.r!  X	   LogWindowr"  X   This class represents a background log window: to be precise, it collects all log messages in the log frame which it manages but also passes them on to the log target which was active at the moment of its creation.r#  X	   LogStderrr$  Xm   This class can be used to redirect the log messages to a C file stream (not to be confused with C++ streams).r%  X	   LogBufferr&  X  :ref:`wx.LogBuffer`  is a very simple implementation of log sink which simply collects all the logged messages in a string (except the debug messages which are output in the usual way immediately as we're presumably not interested in collecting them for later).r'  X   LogTextCtrlr(  XL   Using these target all the log messages can be redirected to a text control.r)  X   LogFormatterr*  XA   :ref:`wx.LogFormatter`  class is used to format the log messages.r+  X
   DataFormatr,  X   A :ref:`wx.DataFormat`  is an encapsulation of a platform-specific format handle which is used by the system for the clipboard and drag and drop operations.r-  X
   DataObjectr.  Xl   A :ref:`wx.DataObject`  represents data that can be copied to or from the clipboard, or dragged and dropped.r/  X   DataObjectSimpler0  XP   This is the simplest possible implementation of the :ref:`wx.DataObject`  class.r1  X   CustomDataObjectr2  X   :ref:`wx.CustomDataObject`  is a specialization of :ref:`wx.DataObjectSimple`  for some application-specific data in arbitrary (either custom or one of the standard ones).r3  X   DataObjectCompositer4  X~   :ref:`wx.DataObjectComposite`  is the simplest :ref:`wx.DataObject`  derivation which may be used to support multiple formats.r5  X   BitmapDataObjectr6  XY   :ref:`wx.BitmapDataObject`  is a specialization of :ref:`wx.DataObject`  for bitmap data.r7  X   TextDataObjectr8  X[   :ref:`wx.TextDataObject`  is a specialization of :ref:`wx.DataObjectSimple`  for text data.r9  X
   URLDataObjectr:  XZ   :ref:`wx.URLDataObject`  is a :ref:`wx.DataObject`  containing an URL and can be used e.g.r;  X   FileDataObjectr<  XV   :ref:`wx.FileDataObject`  is a specialization of :ref:`wx.DataObject`  for file names.r=  X   HTMLDataObjectr>  XG   :ref:`wx.HTMLDataObject`  is used for working with HTML-formatted text.r?  X   ImageDataObjectr@  XW   :ref:`wx.ImageDataObject`  is a specialization of :ref:`wx.DataObject`  for image data.rA  X
   DropSourcerB  X=   This class represents a source for a drag and drop operation.rC  X
   DropTargetrD  X=   This class represents a target for a drag and drop operation.rE  X   TextDropTargetrF  X4   A predefined drop target for dealing with text data.rG  X   FileDropTargetrH  XR   This is a drop target which accepts files (dragged from File Manager or Explorer).rI  X	   ClipboardrJ  X'   A class for manipulating the clipboard.rK  X
   ConfigBaserL  XH   :ref:`wx.ConfigBase`  defines the basic interface of all config classes.rM  X
   FileConfigrN  X   :ref:`wx.FileConfig`  implements :ref:`wx.ConfigBase`  interface for storing and retrieving configuration information using plain text files.rO  X   ConfigPathChangerrP  X_   A handy little class which changes the current path in a Config object and restores it in dtor.rQ  X	   TrackablerR  X)   Add-on base class for a trackable object.rS  X
   KeyboardStaterT  XE   Provides methods for testing the state of the keyboard modifier keys.rU  X
   MouseStaterV  X   Represents the mouse state.rW  X   ToolTiprX  Xj   This class holds information about a tooltip associated with a window (see :meth:`wx.Window.SetToolTip` ).rY  X   IndividualLayoutConstraintrZ  hDX   LayoutConstraintsr[  hDX
   EvtHandlerr\  X9   A class that can handle events from the windowing system.r]  X   EventBlockerr^  X   This class is a special event handler which allows discarding any event (or a set of event types) directed to a specific window.r_  X   PropagationDisablerr`  X=   Helper class to temporarily change an event to not propagate.ra  X
   PropagateOncerb  X4   Helper class to temporarily lower propagation level.rc  X   Eventrd  Xc   An event is a structure holding information about an event passed to a callback or member function.re  X   CommandEventrf  Xn   This event class contains information about command events, which originate from a variety of simple controls.rg  X
   ActivateEventrh  XY   An activate event is sent when a window or application is being activated or deactivated.ri  X   ChildFocusEventrj  X   A child focus event is sent to a (parent-)window when one of its child windows gains focus, so that the window could restore the focus back to its corresponding child if it loses it now and regains later.rk  X   ClipboardTextEventrl  X   This class represents the events generated by a control (typically a :ref:`wx.TextCtrl`  but other windows can generate these events as well) when its content gets copied or cut to, or pasted from the clipboard.rm  X
   CloseEventrn  XL   This event class contains information about window and session close events.ro  X   ContextMenuEventrp  X   This class is used for context menu events, sent to give the application a chance to show a context (popup) menu for a :ref:`wx.Window`.rq  X   DisplayChangedEventrr  X]   A display changed event is sent to top-level windows when the display resolution has changed.rs  X   DPIChangedEventrt  X   Event sent when the display scale factor or pixel density (measured in dots-per-inch, or ``DPI``) of the monitor a window is on changes.ru  X   DropFilesEventrv  X`   This class is used for drop files events, that is, when files have been dropped onto the window.rw  X
   EraseEventrx  XH   An erase event is sent when a window's background needs to be repainted.ry  X
   FocusEventrz  X4   A focus event is sent when a window's focus changes.r{  X	   HelpEventr|  XH   A help event is sent when the user has requested context-sensitive help.r}  X   IconizeEventr~  XG   An event being sent when the frame is iconized (minimized) or restored.r  X	   IdleEventr  XU   This class is used for idle events, which are generated when the system becomes idle.r  X   InitDialogEventr  XO   A :ref:`wx.InitDialogEvent`  is sent as a dialog or panel is being initialised.r  X
   JoystickEventr  Xe   This event class contains information about joystick events, particularly events received by windows.r  X   KeyEventr  XI   This event class contains information about key press and release events.r  X
   MaximizeEventr  X9   An event being sent when a top level window is maximized.r  X   FullScreenEventr  XC   An event being sent when the user enters or exits full screen mode.r  X	   MenuEventr  X8   This class is used for a variety of menu-related events.r  X   MouseCaptureChangedEventr  XO   A mouse capture changed event is sent to a window that loses its mouse capture.r  X   MouseCaptureLostEventr  X   A mouse capture lost event is sent to a window that had obtained mouse capture, which was subsequently lost due to an "external" event (for example, when a dialog box is shown or if another application captures the mouse).r  X
   MouseEventr  X   This event class contains information about the events generated by the mouse: they include mouse buttons press and release events and mouse move events.r  X	   MoveEventr  X<   A move event holds information about window position change.r  X   NavigationKeyEventr  Xv   This event class contains information about navigation events, generated by navigation keys such as tab and page down.r  X   NotifyEventr  X   This class is not used by the event handlers by itself, but is a base class for other event classes (such as :ref:`wx.BookCtrlEvent`).r  X
   PaintEventr  XE   A paint event is sent when a window's contents needs to be repainted.r  X   PaletteChangedEventr  hDX   QueryNewPaletteEventr  hDX   ScrollEventr  X   A scroll event holds information about events sent from stand-alone scrollbars (see :ref:`wx.ScrollBar`) and sliders (see :ref:`wx.Slider`).r  X   ScrollWinEventr  XJ   A scroll event holds information about events sent from scrolling windows.r  X   SetCursorEventr  X   A :ref:`wx.SetCursorEvent`  is generated from :ref:`wx.Window`  when the mouse cursor is about to be set as a result of mouse motion.r  X	   ShowEventr  X7   An event being sent when the window is shown or hidden.r  X	   SizeEventr  XL   A size event holds information about size change events of :ref:`wx.Window`.r  X   SysColourChangedEventr  X   This class is used for system colour change events, which are generated when the user changes the colour settings or when the system theme changes (e.g. automatic dark mode switching on macOS).r  X
   UpdateUIEventr  X   This class is used for pseudo-events which are called by wxWidgets to give an application the chance to update various user interface elements.r  X   WindowCreateEventr  Xl   This event is sent just after the actual window associated with a :ref:`wx.Window`  object has been created.r  X   WindowDestroyEventr  XN   This event is sent as early as possible during the window destruction process.r  X   GestureEventr  X8   This is the base class for all supported gesture events.r  X   PanGestureEventr  XD   This event is generated when the user moves a finger on the surface.r  X   ZoomGestureEventr  XM   This event is generated when two fingers pinch the surface to zoom in or out.r  X   RotateGestureEventr  XT   This event is generated when two fingers move in opposite directions on the surface.r  X   TwoFingerTapEventr  XL   This event is generated when two fingers touch the surface at the same time.r  X   LongPressEventr  XS   This event is generated when one finger touches the surface and remains stationary.r  X   PressAndTapEventr  X^   This event is generated when the user press the surface with one finger and taps with another.r  X   ThreadEventr  Xg   This class adds some simple functionality to :ref:`wx.Event`  to facilitate inter-thread communication.r  X
   PyEventBinderr  XK   Instances of this class are used to bind specific events to event handlers.r  X   PyEventr  XD   :class:`PyEvent` can be used as a base class for implementing customr  X   PyCommandEventr  XD   :class:`PyCommandEvent` can be used as a base class for implementingr  X	   SizerItemr  X   The :ref:`wx.SizerItem`  class is used to track the position, size and other attributes of each item managed by a :ref:`wx.Sizer`.r  X
   SizerFlagsr  XB   Container for sizer items flags providing readable names for them.r  X   Sizerr  XW   :ref:`wx.Sizer`  is the abstract base class used for laying out subwindows in a window.r  X   BoxSizerr  X   The basic idea behind a box sizer is that windows will most often be laid out in rather simple basic geometry, typically in a row or a column or several hierarchies of either.r  X   StaticBoxSizerr  Xm   :ref:`wx.StaticBoxSizer`  is a sizer derived from :ref:`wx.BoxSizer`  but adds a static box around the sizer.r  X	   GridSizerr  X   A grid sizer is a sizer which lays out its children in a two-dimensional table with all table fields having the same size, i.e.r  X
   FlexGridSizerr  X'  A flex grid sizer is a sizer which lays out its children in a two-dimensional table with all table fields in one row having the same height and all fields in one column having the same width, but all rows or all columns are not necessarily the same height or width as in the :ref:`wx.GridSizer`.r  X   StdDialogButtonSizerr  X   This class creates button layouts which conform to the standard button spacing and ordering defined by the platform or toolkit's user interface guidelines (if such things exist).r  X
   GBPositionr  Xx   This class represents the position of an item in a virtual grid of rows and columns managed by a :ref:`wx.GridBagSizer`.r  X   GBSpanr  Xg   This class is used to hold the row and column spanning attributes of items in a :ref:`wx.GridBagSizer`.r  X   GBSizerItemr  Xl   The :ref:`wx.GBSizerItem`  class is used by the :ref:`wx.GridBagSizer`  for tracking the items in the sizer.r  X   GridBagSizerr  X  A :ref:`wx.Sizer`  that can lay out items in a virtual grid like a :ref:`wx.FlexGridSizer`  but in this case explicit positioning of the items is allowed using :ref:`wx.GBPosition`, and items can optionally span more than one row and/or column using :ref:`wx.GBSpan`.r  X	   WrapSizerr  X~   A wrap sizer lays out its items in a single line, like a box sizer –  as long as there is space available in that direction.r  X
   StandardPathsr  X   :ref:`wx.StandardPaths`  returns the standard locations in the file system and should be used by applications to find their data files in a portable way.r  X   EventFilterr  XQ   A global event filter for pre-processing all the events generated in the program.r  X
   EventLoopBaser  X.   Base class for all event loop implementations.r  X   EventLoopActivatorr  X'   Makes an event loop temporarily active.r  X   GUIEventLoopr  X/   A generic implementation of the GUI event loop.r  X	   AppTraitsr  XW   The :ref:`wx.AppTraits`  class defines various configurable aspects of a :ref:`wx.App`.r  X
   AppConsoler  Xi   This class is essential for writing console-only or hybrid apps without having to define  ``USE_GUI=0`` .r  X   PyAppr  XP   The :ref:`wx.App`  class represents the application itself when  ``USE_GUI=1`` .r  X   PyOnDemandOutputWindowr  X<   A class that can be used for redirecting Python's stdout andr  X   Appr  X?   The ``wx.App`` class represents the application and is used to:r  X   PySimpleAppr  X;   This class is deprecated.  Please use :class:`App` instead.r  X   Timerr  XM   The :ref:`wx.Timer`  class allows you to execute code at specified intervals.r  X   TimerRunnerr  X7   Starts the timer in its constructor, stops in the dtor.r  X
   TimerEventr  Xm   :ref:`wx.TimerEvent`  object is passed to the event handler of timer events (see :meth:`wx.Timer.SetOwner` ).r  X   VisualAttributesr  X9   Struct containing all the visual attributes of a control.r  X
   WindowBaser  hDX   ChildrenRepositioningGuardr  Xp   Helper for ensuring :meth:`~wx.Window.ChildrenRepositioningGuard.EndRepositioningChildren`  is called correctly.r   X   Windowr  X`   :ref:`wx.Window`  is the base class for all windows and represents any visible object on screen.r  X	   Validatorr  X   :ref:`wx.Validator`  is the base class for a family of validator classes that mediate between a class of control, and application data.r  X   Panelr  X1   A panel is a window on which controls are placed.r  X   MenuItemr  X)   A menu item represents an item in a menu.r  X   Menur	  X   A menu is a popup (or pull down) list of items, one of which may be selected before the menu goes away (clicking elsewhere dismisses the menu).r
  X   MenuBarr  XC   A menu bar is a series of menus accessible from the top of a frame.r  X   Scrolledr
  X   The :ref:`wx.Scrolled`  class manages scrolling for its client area, transforming the coordinates according to the scrollbar positions, and setting the scroll positions, thumb sizes and ranges according to the area in view.r  X   ScrolledCanvasr  XI   The :ref:`ScrolledCanvas` class is a combination of the :ref:`Window` andr  X   ScrolledWindowr  X-   Scrolled window derived from :ref:`wx.Panel`.r  X   VarScrollHelperBaser  Xf  This class provides all common base functionality for scroll calculations shared among all variable scrolled window implementations as well as automatic scrollbar functionality, saved scroll positions, controlling target windows to be scrolled, as well as defining all required virtual functions that need to be implemented for any orientation specific work.r  X   VarVScrollHelperr  Xz   This class provides functions wrapping the :ref:`wx.VarScrollHelperBase`  class, targeted for vertical-specific scrolling.r  X   VarHScrollHelperr  X|   This class provides functions wrapping the :ref:`wx.VarScrollHelperBase`  class, targeted for horizontal-specific scrolling.r  X   VarHVScrollHelperr  X   This class provides functions wrapping the :ref:`wx.VarHScrollHelper`  and :ref:`wx.VarVScrollHelper`  classes, targeted for scrolling a window in both axis.r  X   VScrolledWindowr  XV  In the name of this class, "V" may stand for "variable" because it can be used for scrolling rows of variable heights; "virtual", because it is not necessary to know the heights of all rows in advance –  only those which are shown on the screen need to be measured; or even "vertical", because this class only supports scrolling vertically.r  X   HScrolledWindowr  Xw   In the name of this class, "H" stands for "horizontal" because it can be used for scrolling columns of variable widths.r  X   HVScrolledWindowr  Xb   This window inherits all functionality of both vertical and horizontal, variable scrolled windows.r   X   Controlr!  X1   This is the base class for a control or "widget".r"  X   ItemContainerImmutabler#  X   :ref:`wx.ItemContainer`  defines an interface which is implemented by all controls which have string subitems each of which may be selected.r$  X
   ItemContainerr%  X   This class is an abstract base class for some wxWidgets controls which contain several items such as :ref:`wx.ListBox`, :ref:`wx.CheckListBox`, :ref:`wx.ComboBox`  or :ref:`wx.Choice`.r&  X   ControlWithItemsr'  X`   This is convenience class that derives from both :ref:`wx.Control`  and :ref:`wx.ItemContainer`.r(  X   StaticBitmapr)  X*   A static bitmap control displays a bitmap.r*  X   GenericStaticBitmapr+  X*   A static bitmap control displays a bitmap.r,  X
   StaticTextr-  XC   A static text control displays one or more lines of read-only text.r.  X	   StaticBoxr/  X]   A static box is a rectangle drawn around other windows to denote a logical grouping of items.r0  X	   StatusBarr1  X{   A status bar is a narrow window that can be placed along the bottom of a frame to give small amounts of status information.r2  X
   StatusBarPaner3  X=   A status bar pane data container used by :ref:`wx.StatusBar`.r4  X   Choicer5  X9   A choice item is used to select one of a list of strings.r6  X	   AnyButtonr7  XX   A class for common button functionality used as the base for the various button classes.r8  X   Buttonr9  Xc   A button is a control that contains a text string, and is one of the most common elements of a GUI.r:  X   BitmapButtonr;  X4   A bitmap button is a control that contains a bitmap.r<  X
   WithImagesr=  XK   A mixin class to be used with other classes that use a :ref:`wx.ImageList`.r>  X   BookCtrlBaser?  Xm   A book control is a convenient way of displaying multiple pages of information, displayed one page at a time.r@  X
   BookCtrlEventrA  X   This class represents the events generated by book controls (:ref:`wx.Notebook`, :ref:`wx.Listbook`, :ref:`wx.Choicebook`, :ref:`wx.Treebook`, :ref:`wx.aui.AuiNotebook`).rB  X   NotebookrC  X^   This class represents a notebook control, which manages multiple windows with associated tabs.rD  X   SplitterWindowrE  X(   This class manages up to two subwindows.rF  X
   SplitterEventrG  XA   This class represents the events generated by a splitter control.rH  X   CollapsiblePanerI  X   A collapsible pane is a container with an embedded button-like control which can be used by the user to collapse or expand the pane's contents.rJ  X   CollapsiblePaneEventrK  XO   This event class is used for the events generated by :ref:`wx.CollapsiblePane`.rL  X
   StaticLinerM  X^   A static line is just a line which may be used in a dialog to separate the groups of controls.rN  X
   TextCompleterrO  X-   Base class for custom text completer objects.rP  X   TextCompleterSimplerQ  X2   A simpler base class for custom completer objects.rR  X	   TextEntryrS  X4   Common base class for single line text entry fields.rT  X   TextAttrrU  X   :ref:`wx.TextAttr`  represents the character and paragraph attributes, or style, for a range of text in a :ref:`wx.TextCtrl`  or :ref:`wx.richtext.RichTextCtrl`.rV  X   TextCtrlrW  X6   A text control allows text to be displayed and edited.rX  X   TextUrlEventrY  hDX   ComboBoxrZ  XB   A combobox is like a combination of an edit control and a listbox.r[  X   CheckBoxr\  Xh   A checkbox is a labelled box which by default is either on (checkmark is visible) or off (no checkmark).r]  X   ListBoxr^  X=   A listbox is used to select one or more of a list of strings.r_  X   CheckListBoxr`  Xc   A :ref:`wx.CheckListBox`  is like a :ref:`wx.ListBox`, but allows items to be checked or unchecked.ra  X   Gaugerb  XL   A gauge is a horizontal or vertical bar which shows a quantity (often time).rc  X   HeaderColumnrd  X   Represents a column header in controls displaying tabular data such as :ref:`wx.dataview.DataViewCtrl`  or :ref:`wx.grid.Grid`.re  X   SettableHeaderColumnrf  XD   Adds methods to set the column attributes to :ref:`wx.HeaderColumn`.rg  X   HeaderColumnSimplerh  X6   Simple container for the information about the column.ri  X
   HeaderCtrlrj  Xv   :ref:`wx.HeaderCtrl`  is the control containing the column headings which is usually used for display of tabular data.rk  X   HeaderCtrlSimplerl  X   :ref:`wx.HeaderCtrlSimple`  is a concrete header control which can be used directly, without inheriting from it as you need to do when using :ref:`wx.HeaderCtrl`  itself.rm  X   HeaderCtrlEventrn  XF   Event class representing the events generated by :ref:`wx.HeaderCtrl`.ro  X
   SearchCtrlrp  Xb   A search control is a composite control with a search button, a text control, and a cancel button.rq  X   RadioBoxrr  XO   A radio box item is used to select one of number of mutually exclusive choices.rs  X   RadioButtonrt  X`   A radio button item is a button which usually denotes one of several mutually exclusive options.ru  X   Sliderrv  X[   A slider is a control with a handle which can be pulled back and forth to change the value.rw  X
   SpinButtonrx  XT   A :ref:`wx.SpinButton`  has two small up and down (or left and right) arrow buttons.ry  X	   SpinEventrz  Xb   This event class is used for the events generated by :ref:`wx.SpinButton`  and :ref:`wx.SpinCtrl`.r{  X   SpinCtrlr|  XZ   :ref:`wx.SpinCtrl`  combines :ref:`wx.TextCtrl`  and :ref:`wx.SpinButton`  in one control.r}  X   SpinCtrlDoubler~  X{   :ref:`wx.SpinCtrlDouble`  combines :ref:`wx.TextCtrl`  and :ref:`wx.SpinButton`  in one control and displays a real number.r  X   SpinDoubleEventr  XN   This event class is used for the events generated by :ref:`wx.SpinCtrlDouble`.r  X   ToggleButtonr  XP   :ref:`wx.ToggleButton`  is a button that stays pressed when clicked by the user.r  X   BitmapToggleButtonr  Xb   :ref:`wx.BitmapToggleButton`  is a :ref:`wx.ToggleButton`  that contains a bitmap instead of text.r  X	   ScrollBarr  XW   A :ref:`wx.ScrollBar`  is a control that represents a horizontal or vertical scrollbar.r  X   ToolBarToolBaser  X2   A toolbar tool represents one item on the toolbar.r  X   ToolBarr  Xk   A toolbar is a bar of buttons and/or other controls usually placed below the menu bar in a :ref:`wx.Frame`.r  X   InfoBarr  X~   An info bar is a transient window shown at top or bottom of its parent window to display non-critical information to the user.r  X   ItemAttrr  Xf   Represents the attributes (colour, font, ...) of an item of a control with multiple items such as e.g.r  X   ListItemr  XI   This class stores information about a :ref:`wx.ListCtrl`  item or column.r  X   ListCtrlr  Xl   A list control presents lists in a number of formats: list view, report view, icon view and small icon view.r  X   ListViewr  X   This class currently simply presents a simpler to use interface for the :ref:`wx.ListCtrl`  –  it can be thought of as a `façade`  for that complicated class.r  X	   ListEventr  XX   A list event holds information about events associated with :ref:`wx.ListCtrl`  objects.r  X
   TreeItemIdr  X#   An opaque reference to a tree item.r  X   TreeCtrlr  Xj   A tree control presents information as a hierarchy, with items that may be expanded to show further items.r  X	   TreeEventr  XX   A tree event holds information about events associated with :ref:`wx.TreeCtrl`  objects.r  X
   PickerBaser  XL   Base abstract class for all pickers which support an auxiliary text control.r  X   ColourPickerCtrlr  X0   This control allows the user to select a colour.r  X   ColourPickerEventr  XP   This event class is used for the events generated by :ref:`wx.ColourPickerCtrl`.r  X   FilePickerCtrlr  X.   This control allows the user to select a file.r  X
   DirPickerCtrlr  X3   This control allows the user to select a directory.r  X   FileDirPickerEventr  Xn   This event class is used for the events generated by :ref:`wx.FilePickerCtrl`  and by :ref:`wx.DirPickerCtrl`.r  X   FontPickerCtrlr  X.   This control allows the user to select a font.r  X   FontPickerEventr  XN   This event class is used for the events generated by :ref:`wx.FontPickerCtrl`.r  X   FileCtrlr  X.   This control allows the user to select a file.r  X
   FileCtrlEventr  X`   A file control event holds information about events associated with :ref:`wx.FileCtrl`  objects.r  X
   ComboPopupr  Xv   In order to use a custom popup with :ref:`wx.ComboCtrl`, an interface class must be derived from :ref:`wx.ComboPopup`.r  X   ComboCtrlFeaturesr  X)   Features enabled for :ref:`wx.ComboCtrl`.r  X	   ComboCtrlr  XG   A combo control is a generic combobox that allows totally custom popup.r  X
   Choicebookr  X   :ref:`wx.Choicebook`  is a class similar to :ref:`wx.Notebook`, but uses a :ref:`wx.Choice`  control to show the labels instead of the tabs.r  X   Listbookr  X   :ref:`wx.Listbook`  is a class similar to :ref:`wx.Notebook`  but which uses a :ref:`wx.ListCtrl`  to show the labels instead of the tabs.r  X   Toolbookr  X   :ref:`wx.Toolbook`  is a class similar to :ref:`wx.Notebook`  but which uses a :ref:`wx.ToolBar`  to show the labels instead of the tabs.r  X   Treebookr  X   This class is an extension of the :ref:`wx.Notebook`  class that allows a tree structured set of pages to be shown in a control.r  X
   Simplebookr  XL   :ref:`wx.Simplebook`  is a control showing exactly one of its several pages.r  X   VListBoxr  X  :ref:`wx.VListBox`  is a ListBox-like control with the following two main differences from a regular :ref:`wx.ListBox`: it can have an arbitrarily huge number of items because it doesn't store them itself but uses the :meth:`~wx.VListBox.OnDrawItem`  callback to draw them (so it is a virtual listbox) and its items can have variable height as determined by :meth:`~wx.VListBox.OnMeasureItem`  (so it is also a listbox with the lines of variable height).r  X   ActivityIndicatorr  Xq   Small control showing an animation indicating that the program is currently busy performing some background task.r  X   CollapsibleHeaderCtrlr  X(   Header control above a collapsible pane.r  X   NonOwnedWindowr  X,   Common base class for all non-child windows.r  X   GeometrySerializerr  X   Class used with :meth:`~wx.TopLevelWindow.GeometrySerializer.SaveGeometry`  and :meth:`~wx.TopLevelWindow.GeometrySerializer.RestoreToGeometry`.r  X   TopLevelWindowr  X[   :ref:`wx.TopLevelWindow`  is a common base class for :ref:`wx.Dialog`  and :ref:`wx.Frame`.r  X   Dialogr  Xl   A dialog box is a window with a title bar and sometimes a system menu, which can be moved around the screen.r  X   DialogLayoutAdapterr  Xn   This abstract class is the base for classes that help wxWidgets perform run-time layout adaptation of dialogs.r  X   WindowModalDialogEventr  XI   Event sent by :meth:`wx.Dialog.ShowWindowModal`   when the dialog closes.r  X	   DirDialogr  X3   This class represents the directory chooser dialog.r  X   GenericDirCtrlr  Xc   This control can be used to place a directory listing (with optional files) on an arbitrary window.r  X   DirFilterListCtrlr  hDX
   FileDialogr  X.   This class represents the file chooser dialog.r  X   FileDialogButtonr  X7   Represents a custom button inside :ref:`wx.FileDialog`.r  X   FileDialogChoicer  XC   Represents a custom read-only combobox inside :ref:`wx.FileDialog`.r  X   FileDialogCheckBoxr  X9   Represents a custom checkbox inside :ref:`wx.FileDialog`.r  X   FileDialogCustomControlr  X=   The base class for all :ref:`wx.FileDialog`  custom controls.r  X   FileDialogCustomizer  X\   Used with :ref:`wx.FileDialogCustomizeHook`  to add custom controls to :ref:`wx.FileDialog`.r  X   FileDialogCustomizeHookr  XB   Base class for customization hooks used with :ref:`wx.FileDialog`.r  X   FileDialogRadioButtonr  X=   Represents a custom radio button inside :ref:`wx.FileDialog`.r  X   FileDialogStaticTextr  X<   Represents a custom static text inside :ref:`wx.FileDialog`.r  X   FileDialogTextCtrlr  X=   Represents a custom text control inside :ref:`wx.FileDialog`.r  X   Framer  XQ   A frame is a window whose size and position can (usually) be changed by the user.r  X
   MessageDialogr  X   This class represents a dialog that shows a single or multi-line message, with a choice of ``wx.OK``, Yes, No and Cancel buttons.r  X   GenericMessageDialogr  X   This class represents a dialog that shows a single or multi-line message, with a choice of ``wx.OK``, Yes, No and Cancel buttons.r  X   RichMessageDialogr  XD   Extension of :ref:`wx.MessageDialog`  with additional functionality.r  X   GenericProgressDialogr  XM   This class represents a dialog that shows a short message and a progress bar.r  X   ProgressDialogr  X   If supported by the platform this class will provide the platform's native progress dialog, else it will simply be the  ` :ref:`wx.GenericProgressDialog` ` .r  X   PopupWindowr  XR   A special kind of top level window used for popup menus, combobox popups and such.r  X   PopupTransientWindowr  X   A :ref:`wx.PopupWindow`  which disappears automatically when the user clicks mouse outside it or if it loses focus in any other way.r  X	   TipWindowr  X4   Shows simple text in a popup tip window on creation.r  X
   ColourDatar  XD   This class holds a variety of information related to colour dialogs.r   X   ColourDialogr  X0   This class represents the colour chooser dialog.r  X   ColourDialogEventr  XL   This event class is used for the events generated by :ref:`wx.ColourDialog`.r  X   MultiChoiceDialogr  Xg   This class represents a dialog that shows a list of strings, and allows the user to select one or more.r  X   SingleChoiceDialogr  X_   This class represents a dialog that shows a list of strings, and allows the user to select one.r  X   FindDialogEventr	  X$   :ref:`wx.FindReplaceDialog`  events.r
  X   FindReplaceDatar  XJ   :ref:`wx.FindReplaceData`  holds the data for :ref:`wx.FindReplaceDialog`.r  X   FindReplaceDialogr
  X   :ref:`wx.FindReplaceDialog`  is a standard modeless dialog which is used to allow the user to search for some text (and possibly replace it with something else).r  X   MDIClientWindowr  Xw   An MDI client window is a child of :ref:`wx.MDIParentFrame`, and manages zero or more :ref:`wx.MDIChildFrame`  objects.r  X   MDIParentFramer  X   An MDI (Multiple Document Interface) parent frame is a window which can contain MDI child frames in its client area which emulates the full desktop.r  X
   MDIChildFramer  X   An MDI child frame is a frame that can only exist inside a :ref:`wx.MDIClientWindow`, which is itself a child of :ref:`wx.MDIParentFrame`.r  X   FontDatar  XB   This class holds a variety of information related to font dialogs.r  X
   FontDialogr  X.   This class represents the font chooser dialog.r  X
   RearrangeListr  X^   A listbox-like control allowing the user to rearrange the items and to enable or disable them.r  X
   RearrangeCtrlr  Xk   A composite control containing a :ref:`wx.RearrangeList`  and the buttons allowing to move the items in it.r  X   RearrangeDialogr  X<   A dialog allowing the user to rearrange the specified items.r  X	   MiniFramer  X.   A miniframe is a frame with a small title bar.r   X   TextEntryDialogr!  XR   This class represents a dialog that requests a one-line text string from the user.r"  X   PasswordEntryDialogr#  XV   This class represents a dialog that requests a one-line password string from the user.r$  X   NumberEntryDialogr%  XK   This class represents a dialog that requests a numeric input from the user.r&  X
   PowerEventr'  XH   The power events are generated when the system power state changes, e.g.r(  X
   PowerResourcer)  XF   Helper functions for acquiring and releasing the given power resource.r*  X   PowerResourceBlockerr+  XA   Helper ``RAII`` class ensuring that power resources are released.r,  X   WindowDisablerr-  X   This class disables all top level windows of the application (maybe with the exception of one of them) in its constructor and enables them back in its destructor.r.  X
   BusyCursorr/  XP   This class makes it easy to tell your user that the program is temporarily busy.r0  X   VersionInfor1  X4   :ref:`wx.VersionInfo`  contains version information.r2  X   Processr3  XW   The objects of this class are used in conjunction with the :ref:`wx.Execute`  function.r4  X   ProcessEventr5  Xr   A process event is sent to the :ref:`wx.EvtHandler`  specified to :ref:`wx.Process`  when a process is terminated.r6  X   UIActionSimulatorr7  Xu   :ref:`wx.UIActionSimulator`  is a class used to simulate user interface actions such as a mouse click or a key press.r8  X   SingleInstanceCheckerr9  Xk   :ref:`wx.SingleInstanceChecker`  class allows checking that only a single instance of a program is running.r:  X   HelpControllerBaser;  X{   This is the abstract base class a family of classes by which applications may invoke a help viewer to provide on-line help.r<  X   HelpProviderr=  X   :ref:`wx.HelpProvider`  is an abstract class used by a program implementing context-sensitive help to show the help text for the given window.r>  X   SimpleHelpProviderr?  X   :ref:`wx.SimpleHelpProvider`  is an implementation of :ref:`wx.HelpProvider`  which supports only plain text help strings, and shows the string associated with the control (if any) in a tooltip.r@  X   HelpControllerHelpProviderrA  X   :ref:`wx.HelpControllerHelpProvider`  is an implementation of :ref:`wx.HelpProvider`  which supports both context identifiers and plain text help strings.rB  X   ContextHelprC  Xg   This class changes the cursor to a query and puts the application into a 'context-sensitive help mode'.rD  X   ContextHelpButtonrE  X   Instances of this class may be used to add a question mark button that when pressed, puts the application into context-help mode.rF  X   SystemSettingsrG  XU   :ref:`wx.SystemSettings`  allows the application to ask for details about the system.rH  X   SystemAppearancerI  X9   Provides information about the current system appearance.rJ  X
   SystemOptionsrK  X   :ref:`wx.SystemOptions`  stores option/value pairs that wxWidgets itself or applications can use to alter behaviour at run-time.rL  X   ArtProviderrM  XT   :ref:`wx.ArtProvider`  class is used to customize the look of wxWidgets application.rN  X	   DragImagerO  Xd   This class is used when you wish to drag an object on the screen, and a simple cursor is not enough.rP  X   GenericDragImagerQ  Xd   This class is used when you wish to drag an object on the screen, and a simple cursor is not enough.rR  X   PreviewControlBarrS  Xg   This is the default implementation of the preview control bar, a panel with buttons and a zoom control.rT  X
   PreviewCanvasrU  X_   A preview canvas is the default canvas used by the print preview system to display the preview.rV  X   PreviewFramerW  XO   This class provides the default method of managing the print preview interface.rX  X   PrintPreviewrY  X7   Objects of this class manage the print preview process.rZ  X   Printerr[  X   This class represents the Windows or PostScript printer, and is the vehicle through which printing may be launched by an application.r\  X   Printoutr]  XR   This class encapsulates the functionality of printing out an application document.r^  X   PrintAbortDialogr_  X`   The dialog created by default by the print framework that enables aborting the printing process.r`  X   PrintDialogra  X?   This class represents the print and print setup common dialogs.rb  X   PageSetupDialogrc  X3   This class represents the page setup common dialog.rd  X   MessageParametersre  X&   Class representing message parameters.rf  X   FileTyperg  X8   This class holds information about a given `file`  type.rh  X   FileTypeInfori  X2   Container of information about :ref:`wx.FileType`.rj  X   MimeTypesManagerrk  X   This class allows the application to retrieve information about all known MIME types from a system-specific location and the filename extensions to the MIME types and vice versa.rl  X   BusyInform  XP   This class makes it easy to tell your user that the program is temporarily busy.rn  X
   BusyInfoFlagsro  X"   Parameters for :ref:`wx.BusyInfo`.rp  X   Caretrq  XS   A caret is a blinking cursor showing the position where the typed text will appear.rr  X   FontEnumeratorrs  X  :ref:`wx.FontEnumerator`  enumerates either all available fonts on the system or only the ones with given attributes - either only fixed-width (suited for use in programs such as terminal emulators and the like) or the fonts available in the given encoding).rt  X
   FontMapperru  X|   :ref:`wx.FontMapper`  manages user-definable correspondence between logical font names and the fonts present on the machine.rv  X   MouseEventsManagerrw  XL   Helper for handling mouse input events in windows containing multiple items.rx  X   FileHistoryry  X   The :ref:`wx.FileHistory`  encapsulates a user interface convenience, the list of most recently visited files as shown on a menu (usually the File menu).rz  X   Commandr{  X   :ref:`wx.Command`  is a base class for modelling an application command, which is an action usually performed by selecting a menu item, pressing a toolbar button or any other means provided by the application to change the data or view.r|  X   CommandProcessorr}  Xs   :ref:`wx.CommandProcessor`  is a class that maintains a history of Commands, with undo/redo functionality built-in.r~  X   FileSystemWatcherr  X]   The :ref:`wx.FileSystemWatcher`  class allows receiving notifications of file system changes.r  X   FileSystemWatcherEventr  X7   A class of events sent when a file system event occurs.r  X   PreferencesEditorr  X   Manage preferences dialog.r  X   PreferencesPager  X   One page of preferences dialog.r  X   StockPreferencesPager  X_   Specialization of :ref:`wx.PreferencesPage`  useful for certain commonly used preferences page.r  X   ModalDialogHookr  X+   Allows intercepting all modal dialog calls.r  X   UniCharr  X1   This class represents a single Unicode character.r  u.