/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonToken;

public class ListUnmarshaller<T>
implements Unmarshaller<List<T>, JsonUnmarshallerContext> {
    private final Unmarshaller<T, JsonUnmarshallerContext> itemUnmarshaller;

    public ListUnmarshaller(Unmarshaller<T, JsonUnmarshallerContext> itemUnmarshaller) {
        this.itemUnmarshaller = itemUnmarshaller;
    }

    @Override
    public List<T> unmarshall(JsonUnmarshallerContext context) throws Exception {
        ArrayList<T> list = new ArrayList<T>();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        JsonToken token;
        while ((token = context.nextToken()) != null) {
            if (token == JsonToken.START_ARRAY) continue;
            if (token == JsonToken.END_ARRAY || token == JsonToken.END_OBJECT) {
                if (context.getCurrentDepth() >= originalDepth) continue;
                return list;
            }
            list.add(this.itemUnmarshaller.unmarshall(context));
        }
        return list;
    }
}

