/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.NetworkInterfaceDescription;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeNetworkInterfaces
extends BaseCmd {
    public DescribeNetworkInterfaces(String[] args) {
        super("ec2dnic", "ec2-describe-network-interfaces");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "[ NETWORKINTERFACE ... ] [SPECIFIC OPTIONS]";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)this.joinDescription("Add a filter criterion for the result-set."));
        options.addOption(OptionBuilder.create((String)"F"));
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Gives you information about one or more network interfaces.");
        System.out.println("     The NETWORKINTERFACE parameters, if specified, are the IDs of the network");
        System.out.println("     interfaces to describe.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("filter");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rsp = jec2.describeNetworkInterfaces(this.getFilterMap(true), this.getNonOptions());
        for (NetworkInterfaceDescription nic : (List)rsp.getResponse()) {
            out.output(System.out, nic);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeNetworkInterfaces(args).invoke();
    }
}

