/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc.example;

import net.noderunner.xmlrpc.Invoker;
import net.noderunner.xmlrpc.NoHandlerException;
import net.noderunner.xmlrpc.ParamIterator;
import net.noderunner.xmlrpc.XmlRpcException;
import net.noderunner.xmlrpc.XmlRpcHandler;

public class XmlRpcProvisioningServer 
	implements XmlRpcHandler
{
	Invoker i;
	ProvisioningInterface client;

	XmlRpcProvisioningServer(ProvisioningInterface client) {
		this.client = client;
		i = new Invoker(client);
	}

    public ParamIterator execute(String methodName, ParamIterator params) 
		throws XmlRpcException
	{
		ProvIterator in = new XmlRpcInputAdapter(params); 
		try {
			ProvIterator out = null;
			if (methodName.equals("addSubscribers")) {
				out = client.addSubscribers(in);
			} else
			if (methodName.equals("deleteSubscribers")) {
				out = client.deleteSubscribers(in);
			} else
			if (methodName.equals("findSubscribers")) {
				out = client.findSubscribers((SubscriberSearch)in.next());
			} else {
				throw new NoHandlerException("unknown method " + methodName);
			}
			return new XmlRpcOutputAdapter(out); 
		} catch (ProvException pe) {
			throw new XmlRpcException(0, "execute failure", pe);
		}
	}

}
