package org.jboss.cache.commands.write;

import static org.easymock.EasyMock.createStrictControl;
import static org.easymock.EasyMock.expect;
import org.easymock.IMocksControl;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.mock.NodeSpiMock;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.transaction.GlobalTransaction;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.Map;

/**
 * Tester class for {@link PutDataMapCommand}
 *
 * @author Mircea.Markus@jboss.com
 * @since 2.2
 */
@Test(groups = "unit")
public class PutDataMapCommandTest
{
   Fqn testFqn = Fqn.fromString("/testfqn");
   PutDataMapCommand command;

   GlobalTransaction gtx;
   Notifier notifier;
   DataContainer container;
   Map dataMap;
   IMocksControl control;
   NodeSpiMock node;


   @BeforeMethod
   protected void setUp()
   {
      gtx = new GlobalTransaction();
      dataMap = new HashMap();
      command = new PutDataMapCommand(gtx, testFqn, dataMap);
      control = createStrictControl();
      notifier = control.createMock(Notifier.class);
      container = control.createMock(DataContainer.class);
      command.initialize(notifier, container);
      node = new NodeSpiMock(testFqn);
      node.put("k", "v");
   }

   public void testAddDataNoErase()
   {
      expect(container.peekStrict(gtx, testFqn, false)).andReturn(node);
      dataMap.put("k2", "v2");
      Map expected = new HashMap(dataMap);
      expected.putAll(node.getDataDirect());
      expect(notifier.shouldNotifyOnNodeModified()).andReturn(true);
      notifier.notifyNodeModified(testFqn, true, NodeModifiedEvent.ModificationType.PUT_MAP, node.getData(), null);
      expect(notifier.shouldNotifyOnNodeModified()).andReturn(true);
      notifier.notifyNodeModified(testFqn, false, NodeModifiedEvent.ModificationType.PUT_MAP, expected, null);

      control.replay();
      assert null == command.perform(null) : "null result is always expected";
      assert command.getOldData().size() == 1;
      assert command.getOldData().get("k").equals("v");
      control.verify();
   }


   public void testRollbackNonexistentNode()
   {
      expect(container.peek(testFqn, false, true)).andReturn(null);
      control.replay();
      command.rollback();
      control.verify();
   }
}
