/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStream
extends FilterInputStream {
    private static int defaultBufferSize = 2048;
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int markpos = -1;
    protected int marklimit;

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public BufferedInputStream(InputStream inputStream) {
        this(inputStream, defaultBufferSize);
    }

    public BufferedInputStream(InputStream inputStream, int n) {
        super(inputStream);
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[n];
    }

    private void fill() throws IOException {
        int n;
        if (this.markpos < 0) {
            this.pos = 0;
        } else if (this.pos >= this.buf.length) {
            if (this.markpos > 0) {
                n = this.pos - this.markpos;
                System.arraycopy(this.buf, this.markpos, this.buf, 0, n);
                this.pos = n;
                this.markpos = 0;
            } else if (this.buf.length >= this.marklimit) {
                this.markpos = -1;
                this.pos = 0;
            } else {
                n = this.pos * 2;
                if (n > this.marklimit) {
                    n = this.marklimit;
                }
                byte[] byArray = new byte[n];
                System.arraycopy(this.buf, 0, byArray, 0, this.pos);
                this.buf = byArray;
            }
        }
        this.count = this.pos;
        n = this.in.read(this.buf, this.pos, this.buf.length - this.pos);
        if (n > 0) {
            this.count = n + this.pos;
        }
    }

    public synchronized int read() throws IOException {
        if (this.pos >= this.count) {
            this.ensureOpen();
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    private int read1(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.count - this.pos;
        if (n3 <= 0) {
            if (n2 >= this.buf.length && this.markpos < 0) {
                return this.in.read(byArray, n, n2);
            }
            this.fill();
            n3 = this.count - this.pos;
            if (n3 <= 0) {
                return -1;
            }
        }
        int n4 = n3 < n2 ? n3 : n2;
        System.arraycopy(this.buf, this.pos, byArray, n, n4);
        this.pos += n4;
        return n4;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.ensureOpen();
        if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n4 = this.read1(byArray, n, n2);
        if (n4 <= 0) {
            return n4;
        }
        while (n4 < n2 && this.in.available() > 0 && (n3 = this.read1(byArray, n + n4, n2 - n4)) > 0) {
            n4 += n3;
        }
        return n4;
    }

    public synchronized long skip(long l) throws IOException {
        this.ensureOpen();
        if (l <= 0L) {
            return 0L;
        }
        long l2 = this.count - this.pos;
        if (l2 <= 0L) {
            if (this.markpos < 0) {
                return this.in.skip(l);
            }
            this.fill();
            l2 = this.count - this.pos;
            if (l2 <= 0L) {
                return 0L;
            }
        }
        long l3 = l2 < l ? l2 : l;
        this.pos = (int)((long)this.pos + l3);
        return l3;
    }

    public synchronized int available() throws IOException {
        this.ensureOpen();
        return this.count - this.pos + this.in.available();
    }

    public synchronized void mark(int n) {
        this.marklimit = n;
        this.markpos = this.pos;
    }

    public synchronized void reset() throws IOException {
        this.ensureOpen();
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.pos = this.markpos;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
        this.buf = null;
        this.count = 0;
        this.pos = 0;
    }
}

