/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.ui;

import gr.zeus.ui.JSplashLabel;
import gr.zeus.util.GUIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;

public final class JSplash
extends JWindow {
    private final JProgressBar m_progress = new JProgressBar();
    private boolean m_progressBar = false;
    private boolean m_progressBarMessages = false;
    private boolean m_progressBarPercent = false;

    public JSplash(URL url, boolean progress, boolean messages, boolean percent, String versionString, Font versionStringFont, Color versionStringColor) {
        this.m_progressBar = progress;
        this.m_progressBarMessages = messages;
        this.m_progressBarPercent = percent;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.setContentPane(panel);
        JSplashLabel label = new JSplashLabel(url, versionString, versionStringFont, versionStringColor);
        if (this.m_progressBar) {
            if (this.m_progressBarMessages || this.m_progressBarPercent) {
                this.m_progress.setStringPainted(true);
            } else {
                this.m_progress.setStringPainted(false);
            }
            if (this.m_progressBarMessages && !this.m_progressBarPercent) {
                this.m_progress.setString("");
            }
            this.m_progress.setMaximum(100);
            this.m_progress.setMinimum(0);
            this.m_progress.setValue(0);
        }
        this.getContentPane().add((Component)label, "Center");
        if (this.m_progressBar) {
            this.getContentPane().add((Component)this.m_progress, "South");
        }
        this.pack();
        GUIUtils.centerOnScreen(this);
        this.setVisible(false);
    }

    public void splashOn() {
        this.setVisible(true);
    }

    public void splashOff() {
        this.setVisible(false);
        this.dispose();
    }

    public void setProgress(int value) {
        if (this.m_progressBar && value >= 0 && value <= 100) {
            this.m_progress.setValue(value);
        }
    }

    public void setProgress(int value, String msg) {
        this.setProgress(value);
        if (this.m_progressBarMessages && !this.m_progressBarPercent && msg != null) {
            this.m_progress.setString(msg);
        }
    }

    public final JProgressBar getProgressBar() {
        return this.m_progress;
    }
}

