/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ClassHelper {
    private static Map allMethods = new HashMap();
    private static Map allFields = new HashMap();

    public static String getTruncatedClassName(Class clazz) {
        return ClassHelper.getTruncatedName(clazz.getName());
    }

    public static String getTruncatedName(String name) {
        int lastInd = name.lastIndexOf(46);
        if (lastInd == -1) {
            return name;
        }
        return name.substring(lastInd + 1);
    }

    public static String getPackagePortion(String name) {
        int lastInd = name.lastIndexOf(46);
        if (lastInd == -1) {
            return "";
        }
        return name.substring(0, lastInd);
    }

    public static Method[] getAllMethods(Class clazz) {
        Object[] retval = (Method[])allMethods.get(clazz);
        if (retval == null) {
            HashSet methods = new HashSet();
            for (Class c = clazz; c != null; c = c.getSuperclass()) {
                Method[] currentMethods = c.getDeclaredMethods();
                block1: for (int i = 0; i < currentMethods.length; ++i) {
                    Method current = currentMethods[i];
                    int size = methods.size();
                    Iterator iter = methods.iterator();
                    while (--size >= 0) {
                        Method override = (Method)iter.next();
                        if (!current.getName().equals(override.getName()) || !Arrays.equals(current.getParameterTypes(), override.getParameterTypes()) || current.getReturnType() != override.getReturnType()) continue;
                        continue block1;
                    }
                    methods.add(current);
                }
            }
            retval = new Method[methods.size()];
            methods.toArray(retval);
            allMethods.put(clazz, retval);
        }
        return retval;
    }

    public static Field[] getAllFields(Class clazz) {
        Object[] retval = (Field[])allFields.get(clazz);
        if (retval == null) {
            HashSet fields = new HashSet();
            for (Class c = clazz; c != null; c = c.getSuperclass()) {
                Field[] currentFields = c.getDeclaredFields();
                block1: for (int i = 0; i < currentFields.length; ++i) {
                    Field current = currentFields[i];
                    int size = fields.size();
                    Iterator iter = fields.iterator();
                    while (--size >= 0) {
                        Field override = (Field)iter.next();
                        if (!current.getName().equals(override.getName()) || current.getType() != override.getType()) continue;
                        continue block1;
                    }
                    fields.add(current);
                }
            }
            retval = new Field[fields.size()];
            fields.toArray(retval);
            allFields.put(clazz, retval);
        }
        return retval;
    }
}

