/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.java.net.PlainSocketImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ServerSocketChannel;

public class ServerSocket {
    private static SocketImplFactory factory;
    private SocketImpl impl;
    private boolean bound;

    ServerSocket(SocketImpl impl) throws IOException {
        if (impl == null) {
            throw new NullPointerException("impl may not be null");
        }
        this.impl = impl;
        this.impl.create(true);
    }

    SocketImpl getImpl() {
        return this.impl;
    }

    public ServerSocket() throws IOException {
        this.impl = factory != null ? factory.createSocketImpl() : new PlainSocketImpl();
        this.impl.create(true);
    }

    public ServerSocket(int port) throws IOException {
        this(port, 50);
    }

    public ServerSocket(int port, int backlog) throws IOException {
        this(port, backlog, null);
    }

    public ServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        this();
        this.bind(new InetSocketAddress(bindAddr, port), backlog);
    }

    public void bind(SocketAddress endpoint) throws IOException {
        this.bind(endpoint, 50);
    }

    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        InetAddress addr;
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Address type not supported");
        }
        InetSocketAddress tmp = (InetSocketAddress)endpoint;
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkListen(tmp.getPort());
        }
        if ((addr = tmp.getAddress()) == null) {
            addr = InetAddress.ANY_IF;
        }
        try {
            this.impl.bind(addr, tmp.getPort());
            this.impl.listen(backlog);
            this.bound = true;
        }
        catch (IOException exception) {
            this.close();
            throw exception;
        }
        catch (RuntimeException exception) {
            this.close();
            throw exception;
        }
        catch (Error error) {
            this.close();
            throw error;
        }
    }

    public InetAddress getInetAddress() {
        if (!this.isBound()) {
            return null;
        }
        try {
            return (InetAddress)this.impl.getOption(15);
        }
        catch (SocketException e) {
            return null;
        }
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        return this.impl.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getLocalPort());
    }

    public Socket accept() throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkListen(this.impl.getLocalPort());
        }
        Socket socket = new Socket();
        this.implAccept(socket);
        return socket;
    }

    protected final void implAccept(Socket socket) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        if (this.getChannel() != null && !this.getChannel().isBlocking() && !((PlainSocketImpl)this.getImpl()).isInChannelOperation()) {
            throw new IllegalBlockingModeException();
        }
        this.impl.accept(socket.getImpl());
    }

    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.impl.close();
        this.impl = null;
        this.bound = false;
        if (this.getChannel() != null) {
            this.getChannel().close();
        }
    }

    public ServerSocketChannel getChannel() {
        return null;
    }

    public boolean isBound() {
        return this.bound;
    }

    public boolean isClosed() {
        return this.impl == null;
    }

    public void setSoTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("SO_TIMEOUT value must be >= 0");
        }
        this.impl.setOption(4102, new Integer(timeout));
    }

    public int getSoTimeout() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        Object timeout = this.impl.getOption(4102);
        if (!(timeout instanceof Integer)) {
            throw new IOException("Internal Error");
        }
        return (Integer)timeout;
    }

    public void setReuseAddress(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        this.impl.setOption(4, new Boolean(on));
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        Object reuseaddr = this.impl.getOption(4);
        if (!(reuseaddr instanceof Boolean)) {
            throw new SocketException("Internal Error");
        }
        return (Boolean)reuseaddr;
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("SO_RCVBUF value must be > 0");
        }
        this.impl.setOption(4098, new Integer(size));
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        Object buf = this.impl.getOption(4098);
        if (!(buf instanceof Integer)) {
            throw new SocketException("Internal Error: Unexpected type");
        }
        return (Integer)buf;
    }

    public String toString() {
        if (!this.isBound()) {
            return "ServerSocket[unbound]";
        }
        return "ServerSocket[addr=" + this.getInetAddress() + ",port=" + this.impl.getPort() + ",localport=" + this.impl.getLocalPort() + "]";
    }

    public static synchronized void setSocketFactory(SocketImplFactory fac) throws IOException {
        factory = fac;
    }
}

