/***************************************************************************
                          preferencesdialog.cpp  -  description
                             -------------------
    begin                : mer ao 6 2003
    copyright            : (C) 2003 by ervin
    email                : ervin at tuxfamily dot org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "preferencesdialog.h"

#include <klocale.h>
#include <kmimetype.h>
#include <qvbox.h>
#include <qwhatsthis.h>
#include <klistview.h>
#include <kfiledetailview.h>

class DeviceTypeItem : public QCheckListItem
{
public:
	DeviceTypeItem(QListView *parent, const QString name,
	               const QString mimetype)
		: QCheckListItem(parent, name, CheckBox),
		  mMimeType(mimetype) { }

	const QString &mimeType() const { return mMimeType; }

private:
	QString mMimeType;
};

class DeviceItem : public QCheckListItem
{
public:
	DeviceItem(QListView *parent, const QString name,
	           const KFileItem device)
		: QCheckListItem(parent, name, CheckBox),
		  mDevice(device) { }

	const QString itemURL() const { return mDevice.url().url(); }

private:
	KFileItem mDevice;
};



PreferencesDialog::PreferencesDialog(KFileItemList devices, QWidget *parent,
                                     const char *name)
	: KDialogBase(Tabbed, i18n("Devices Applet Preferences"), Ok|Cancel|Default,
	              Ok, parent, name, true),
	  mDevices(devices)
{
	QVBox *types_page = addVBoxPage( i18n("Device Types") );
	mpDeviceTypesListView = new KListView(types_page);

	//mpDeviceTypesListView->setFullWidth(true);
	mpDeviceTypesListView->addColumn( i18n("Types to Display") );
	QWhatsThis::add(mpDeviceTypesListView, i18n("Deselect the device types which you do not want to see in the applet"));



	QVBox *devices_page = addVBoxPage( i18n("Devices") );
	mpDevicesListView = new KListView(devices_page);

	//mpDevicesListView->setFullWidth(true);
	mpDevicesListView->addColumn( i18n("Devices to Display") );
	QWhatsThis::add(mpDevicesListView, i18n("Deselect the devices which you do not want to see in the applet"));

	slotDefault();
}

PreferencesDialog::~PreferencesDialog()
{
}

void PreferencesDialog::slotDefault()
{
	QStringList defaultExclude;

	defaultExclude << "kdedevice/hdd_mounted";
	defaultExclude << "kdedevice/hdd_unmounted";
	defaultExclude << "kdedevice/cdrom_unmounted";
	defaultExclude << "kdedevice/cdwriter_unmounted";
	defaultExclude << "kdedevice/dvd_unmounted";

	setExcludedDeviceTypes(defaultExclude);
	setExcludedDevices(QStringList());
}

QStringList PreferencesDialog::excludedDeviceTypes()
{
	QStringList excludedTypes;

	for(DeviceTypeItem *it=static_cast<DeviceTypeItem *>(mpDeviceTypesListView->firstChild());
	    it; it=static_cast<DeviceTypeItem *>(it->nextSibling()))
	{
		if(!it->isOn()) excludedTypes << it->mimeType();
	}

	return excludedTypes;
}

void PreferencesDialog::setExcludedDeviceTypes(QStringList excludedTypesList)
{
	mpDeviceTypesListView->clear();
	mpDeviceTypesListView->setRootIsDecorated(false);
	KMimeType::List mimetypes = KMimeType::allMimeTypes();

	QValueListIterator<KMimeType::Ptr> it(mimetypes.begin());

	for(; it != mimetypes.end(); ++it)
	{
		if ((*it)->name().startsWith("kdedevice/"))
		{
			bool ok=excludedTypesList.contains((*it)->name())==0;
			DeviceTypeItem *item = new DeviceTypeItem(mpDeviceTypesListView, (*it)->comment(), (*it)->name());
			item->setOn(ok);
		}
	}
}

QStringList PreferencesDialog::excludedDevices()
{
	QStringList excluded;

	for(DeviceItem *it=static_cast<DeviceItem *>(mpDevicesListView->firstChild());
	    it; it=static_cast<DeviceItem *>(it->nextSibling()))
	{
		if(!it->isOn()) excluded << it->itemURL();
	}

	return excluded;
}

void PreferencesDialog::setExcludedDevices(QStringList excludedList)
{
	mpDevicesListView->clear();
	mpDevicesListView->setRootIsDecorated(false);

	KFileItemListIterator it( mDevices );
	KFileItem *file;
	while ( (file = it.current()) != 0 )
	{
		++it;

		bool ok = excludedList.contains(file->url().url())==0;
		DeviceItem *item = new DeviceItem(mpDevicesListView,
		                                  file->name(), *file);
		item->setOn(ok);
	}
}


#include "preferencesdialog.moc"
