/*
    cryptoconfigdialog.h

    This file is part of kgpgcertmanager
    Copyright (c) 2004 Klarlvdalens Datakonsult AB

    Libkleopatra is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License,
    version 2, as published by the Free Software Foundation.

    Libkleopatra is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    In addition, as a special exception, the copyright holders give
    permission to link the code of this program with any edition of
    the Qt library by Trolltech AS, Norway (or with modified versions
    of Qt that use the same license as Qt), and distribute linked
    combinations including the two.  You must obey the GNU General
    Public License in all respects for all of the code used other than
    Qt.  If you modify this file, you may extend this exception to
    your version of the file, but you are not obligated to do so.  If
    you do not wish to do so, delete this exception statement from
    your version.
*/

#ifndef CRYPTOCONFIGDIALOG_H
#define CRYPTOCONFIGDIALOG_H

#include <kdialogbase.h>

namespace Kleo {

  class CryptoConfig;
  class CryptoConfigModule;

  /**
   * Simple KDialogBase wrapper around CryptoConfigModule
   */
  class CryptoConfigDialog : public KDialogBase
  {
    Q_OBJECT
  public:
    CryptoConfigDialog( Kleo::CryptoConfig* config, QWidget *parent = 0, const char* name = 0 );

  protected:
    virtual void slotOk();
    virtual void slotCancel();
    virtual void slotDefault();
    virtual void slotApply();
    virtual void slotUser1(); // reset

  public slots:
    void slotChanged();

  private:
    CryptoConfigModule* mMainWidget;
  };

}

#endif /* CRYPTOCONFIGDIALOG_H */

