/*
  File autogenerated by gengetopt version 2.12.2
  generated with the following command:
  gengetopt --unamed-opts --input idn.ggo --file-name idn_cmd 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "idn_cmd.h"

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->stringprep_given = 0 ;
  args_info->punycode_decode_given = 0 ;
  args_info->punycode_encode_given = 0 ;
  args_info->idna_to_ascii_given = 0 ;
  args_info->idna_to_unicode_given = 0 ;
  args_info->allow_unassigned_given = 0 ;
  args_info->usestd3asciirules_given = 0 ;
  args_info->tld_given = 0 ;
  args_info->profile_given = 0 ;
  args_info->debug_given = 0 ;
  args_info->quiet_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->allow_unassigned_flag = 0;
  args_info->usestd3asciirules_flag = 0;
  args_info->tld_flag = 1;
  args_info->profile_arg = NULL;
  args_info->debug_flag = 0;
  args_info->quiet_flag = 0;
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
"  Command line interface to the internationalized domain name library.\n  All strings are expected to be encoded in the preferred charset used\n  by your locale.  Use `--debug' to find out what this charset is.  You\n  can override the charset used by setting environment variable CHARSET.\n  To process a string that starts with `-', for example `-foo', use `--'\n  to signal the end of parameters, as in `idn --quiet -a -- -foo'.\n"
  "\n"
  "Usage: %s [OPTIONS]... [STRINGS]...\n", CMDLINE_PARSER_PACKAGE);
  printf("\n");
  printf("%s\n","  -h, --help               Print help and exit");
  printf("%s\n","  -V, --version            Print version and exit");
  printf("%s\n","  -s, --stringprep         Prepare string according to nameprep profile");
  printf("%s\n","  -d, --punycode-decode    Decode Punycode");
  printf("%s\n","  -e, --punycode-encode    Encode Punycode");
  printf("%s\n","  -a, --idna-to-ascii      Convert to ACE according to IDNA (default)");
  printf("%s\n","  -u, --idna-to-unicode    Convert from ACE according to IDNA");
  printf("%s\n","      --allow-unassigned   Toggle IDNA AllowUnassigned flag  (default=off)");
  printf("%s\n","      --usestd3asciirules  Toggle IDNA UseSTD3ASCIIRules flag  (default=off)");
  printf("%s\n","  -t, --tld                Check string for TLD specific rules\n                             Only for --idna-to-ascii and --idna-to-unicode  \n                             (default=on)");
  printf("%s\n","  -p, --profile=STRING     Use specified stringprep profile instead\n                             Valid stringprep profiles are `Nameprep', `iSCSI', \n                             `Nodeprep', `Resourceprep', `trace', and \n                             `SASLprep'.");
  printf("%s\n","      --debug              Print debugging information  (default=off)");
  printf("%s\n","      --quiet              Silent operation  (default=off)");
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);

  args_info->inputs = NULL;
  args_info->inputs_num = 0;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  
  unsigned int i;
  if (args_info->profile_arg)
    {
      free (args_info->profile_arg); /* free previous argument */
      args_info->profile_arg = 0;
    }
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);
  
  if (args_info->inputs_num)
    free (args_info->inputs);
  
  clear_given (args_info);
}

/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;

  result = cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "stringprep",	0, NULL, 's' },
        { "punycode-decode",	0, NULL, 'd' },
        { "punycode-encode",	0, NULL, 'e' },
        { "idna-to-ascii",	0, NULL, 'a' },
        { "idna-to-unicode",	0, NULL, 'u' },
        { "allow-unassigned",	0, NULL, 0 },
        { "usestd3asciirules",	0, NULL, 0 },
        { "tld",	0, NULL, 't' },
        { "profile",	1, NULL, 'p' },
        { "debug",	0, NULL, 0 },
        { "quiet",	0, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVsdeautp:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 's':	/* Prepare string according to nameprep profile.  */
          if (local_args_info.stringprep_given)
            {
              fprintf (stderr, "%s: `--stringprep' (`-s') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->stringprep_given && ! override)
            continue;
          local_args_info.stringprep_given = 1;
          args_info->stringprep_given = 1;
          break;

        case 'd':	/* Decode Punycode.  */
          if (local_args_info.punycode_decode_given)
            {
              fprintf (stderr, "%s: `--punycode-decode' (`-d') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->punycode_decode_given && ! override)
            continue;
          local_args_info.punycode_decode_given = 1;
          args_info->punycode_decode_given = 1;
          break;

        case 'e':	/* Encode Punycode.  */
          if (local_args_info.punycode_encode_given)
            {
              fprintf (stderr, "%s: `--punycode-encode' (`-e') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->punycode_encode_given && ! override)
            continue;
          local_args_info.punycode_encode_given = 1;
          args_info->punycode_encode_given = 1;
          break;

        case 'a':	/* Convert to ACE according to IDNA (default).  */
          if (local_args_info.idna_to_ascii_given)
            {
              fprintf (stderr, "%s: `--idna-to-ascii' (`-a') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->idna_to_ascii_given && ! override)
            continue;
          local_args_info.idna_to_ascii_given = 1;
          args_info->idna_to_ascii_given = 1;
          break;

        case 'u':	/* Convert from ACE according to IDNA.  */
          if (local_args_info.idna_to_unicode_given)
            {
              fprintf (stderr, "%s: `--idna-to-unicode' (`-u') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->idna_to_unicode_given && ! override)
            continue;
          local_args_info.idna_to_unicode_given = 1;
          args_info->idna_to_unicode_given = 1;
          break;

        case 't':	/* Check string for TLD specific rules\nOnly for --idna-to-ascii and --idna-to-unicode.  */
          if (local_args_info.tld_given)
            {
              fprintf (stderr, "%s: `--tld' (`-t') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->tld_given && ! override)
            continue;
          local_args_info.tld_given = 1;
          args_info->tld_given = 1;
          args_info->tld_flag = !(args_info->tld_flag);
          break;

        case 'p':	/* Use specified stringprep profile instead\nValid stringprep profiles are `Nameprep', `iSCSI', `Nodeprep', `Resourceprep', `trace', and `SASLprep'..  */
          if (local_args_info.profile_given)
            {
              fprintf (stderr, "%s: `--profile' (`-p') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->profile_given && ! override)
            continue;
          local_args_info.profile_given = 1;
          args_info->profile_given = 1;
          if (args_info->profile_arg)
            free (args_info->profile_arg); /* free previous string */
          args_info->profile_arg = gengetopt_strdup (optarg);
          break;


        case 0:	/* Long option with no short option */
          /* Toggle IDNA AllowUnassigned flag.  */
          if (strcmp (long_options[option_index].name, "allow-unassigned") == 0)
          {
            if (local_args_info.allow_unassigned_given)
              {
                fprintf (stderr, "%s: `--allow-unassigned' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->allow_unassigned_given && ! override)
              continue;
            local_args_info.allow_unassigned_given = 1;
            args_info->allow_unassigned_given = 1;
            args_info->allow_unassigned_flag = !(args_info->allow_unassigned_flag);
          }
          
          /* Toggle IDNA UseSTD3ASCIIRules flag.  */
          else if (strcmp (long_options[option_index].name, "usestd3asciirules") == 0)
          {
            if (local_args_info.usestd3asciirules_given)
              {
                fprintf (stderr, "%s: `--usestd3asciirules' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->usestd3asciirules_given && ! override)
              continue;
            local_args_info.usestd3asciirules_given = 1;
            args_info->usestd3asciirules_given = 1;
            args_info->usestd3asciirules_flag = !(args_info->usestd3asciirules_flag);
          }
          
          /* Print debugging information.  */
          else if (strcmp (long_options[option_index].name, "debug") == 0)
          {
            if (local_args_info.debug_given)
              {
                fprintf (stderr, "%s: `--debug' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->debug_given && ! override)
              continue;
            local_args_info.debug_given = 1;
            args_info->debug_given = 1;
            args_info->debug_flag = !(args_info->debug_flag);
          }
          
          /* Silent operation.  */
          else if (strcmp (long_options[option_index].name, "quiet") == 0)
          {
            if (local_args_info.quiet_given)
              {
                fprintf (stderr, "%s: `--quiet' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->quiet_given && ! override)
              continue;
            local_args_info.quiet_given = 1;
            args_info->quiet_given = 1;
            args_info->quiet_flag = !(args_info->quiet_flag);
          }
          

          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if (check_required)
    {
    }

  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;

      args_info->inputs_num = argc - optind ;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ;
    }

  return 0;

failure:
  return (EXIT_FAILURE);
}
