/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/
#include <kdebug.h>

void ConfigCrypto::load( const IfConfig &ifconfig)
{
  cmb_activeKey->setCurrentItem( ifconfig.m_activeKey-1 );
  bg_cryptoMode->setButton( ifconfig.m_cryptoMode );
  
  le_key1->setText( ifconfig.m_keys[0].key() );
  cb_key1String->setChecked( ifconfig.m_keys[0].isString() );
  le_key2->setText( ifconfig.m_keys[1].key() );
  cb_key2String->setChecked( ifconfig.m_keys[1].isString() );
  le_key3->setText( ifconfig.m_keys[2].key() );
  cb_key3String->setChecked( ifconfig.m_keys[2].isString() );
  le_key4->setText( ifconfig.m_keys[3].key() );
  cb_key4String->setChecked( ifconfig.m_keys[3].isString() );
}

void ConfigCrypto::save( IfConfig &ifconfig )
{
  ifconfig.m_activeKey = cmb_activeKey->currentItem()+1;
  ifconfig.m_cryptoMode = (IfConfig::CryptoMode)bg_cryptoMode->selectedId();

  ifconfig.m_keys[0].setKey( le_key1->text() );
  ifconfig.m_keys[0].setIsString(cb_key1String->isChecked() );
  ifconfig.m_keys[1].setKey( le_key2->text() );
  ifconfig.m_keys[1].setIsString(cb_key2String->isChecked() );
  ifconfig.m_keys[2].setKey( le_key3->text() );
  ifconfig.m_keys[2].setIsString(cb_key3String->isChecked() );
  ifconfig.m_keys[3].setKey( le_key4->text() );
  ifconfig.m_keys[3].setIsString(cb_key4String->isChecked() );
}
