/* This file is part of the KDE project
   Copyright (C) 2004 Nadeem Hasan <nhasan@kde.org>
             (C) 2001-2004 by Stefan Winter <mail@stefan-winter.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING. If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include "mainconfig.h"
#include "wificonfig.h"

#include <kcombobox.h>
#include <klineedit.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kprocio.h>
#include <kpushbutton.h>

#include <qcheckbox.h>
#include <qfile.h>

MainConfig::MainConfig( QWidget *parent, const char *name )
    : MainConfigBase( parent, name )
{
  connect( cb_usePreset, SIGNAL( toggled( bool ) ), SIGNAL( changed() ) );
  connect( cmb_presetConfig, SIGNAL( activated( int ) ), SIGNAL( changed() ) );
  connect( le_interface, SIGNAL( textChanged( const QString & ) ),
                         SIGNAL( changed() ) );

  connect( pb_autodetect, SIGNAL( clicked() ), SLOT( slotAutoDetect() ) );
  connect( pb_activate, SIGNAL( clicked() ), SIGNAL( activateClicked() ) );
}

void MainConfig::load()
{
  WifiConfig *config = WifiConfig::instance();

  cb_usePreset->setChecked( config->m_usePreset );
  cmb_presetConfig->setCurrentItem( config->m_presetConfig );
  le_interface->setText( config->m_interface );
}

void MainConfig::save()
{
  WifiConfig *config = WifiConfig::instance();

  config->m_usePreset = cb_usePreset->isChecked();
  config->m_presetConfig = cmb_presetConfig->currentItem();
  config->m_interface = le_interface->text();
}

void MainConfig::slotAutoDetect()
{
  le_interface->setText( QString::null );

  QFile procFile ( "/proc/net/dev" );

  if ( !procFile.open( IO_ReadOnly ) )
  {
    KMessageBox::sorry( this,
        i18n( "Unable to autodetect wireless interface." ) );
    return;
  }

  QStringList list;
  QString line;

  while ( !procFile.atEnd() )
  {
    procFile.readLine( line, 9999 );
    if ( line.find( ":" ) > 0 )
    {
      line.truncate ( line.find( ":" ) );
      list.append( line.stripWhiteSpace() );
    }
  }

  procFile.close();

  if ( list.empty() )
  {
    KMessageBox::sorry( this,
        i18n( "Unable to autodetect wireless interface." ) );
    return;
  }

  for ( QStringList::Iterator it = list.begin (); it != list.end (); ++it )
  {
    if ( ((*it).contains("wifi"))==0 ) { // if the name is wifiX, ignore
      KProcIO test;
      test << "iwconfig";
      test << *it;
      connect( &test, SIGNAL( readReady( KProcIO * ) ),
                      SLOT( slotTestInterface( KProcIO * ) ) );
      test.start ( KProcess::Block );
    }
  }

  if ( le_interface->text().isEmpty() )
  {
    KMessageBox::sorry( this,
        i18n( "Unable to autodetect wireless interface." ) );
    return;
  }
}

void MainConfig::slotTestInterface( KProcIO *proc )
{
  QString output;
  proc->readln( output );
  if ( output.find ( "no wireless extensions" ) == -1 )
  {
    output.truncate( output.find ( " " ) );
    le_interface->setText( output.stripWhiteSpace() );
  }
}

#include "mainconfig.moc"
