/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.image;

import gnu.java.awt.image.ImageDecoder;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

public class XBMDecoder
extends ImageDecoder {
    BufferedReader reader;
    static final ColorModel cm = ColorModel.getRGBdefault();
    static final int black = -16777216;
    static final int transparent = 0;
    static final int[] masktable = new int[]{1, 2, 4, 8, 16, 32, 64, 128};

    public XBMDecoder(String filename) {
        super(filename);
    }

    public XBMDecoder(URL url) {
        super(url);
    }

    public void produce(Vector v, InputStream is) throws IOException {
        ImageConsumer ic;
        int i;
        this.reader = new BufferedReader(new InputStreamReader(is));
        int width = -1;
        int height = -1;
        for (i = 0; i < 2; ++i) {
            String line = this.reader.readLine();
            StringTokenizer st = new StringTokenizer(line);
            st.nextToken();
            st.nextToken();
            if (i == 0) {
                width = Integer.parseInt(st.nextToken(), 10);
                continue;
            }
            height = Integer.parseInt(st.nextToken(), 10);
        }
        for (i = 0; i < v.size(); ++i) {
            ic = (ImageConsumer)v.elementAt(i);
            ic.setDimensions(width, height);
            ic.setColorModel(cm);
            ic.setHints(30);
        }
        while (this.reader.read() != 123) {
        }
        for (int line = 0; line < height; ++line) {
            int[] scanline = XBMDecoder.getScanline(this.reader, width);
            for (int i2 = 0; i2 < v.size(); ++i2) {
                ImageConsumer ic2 = (ImageConsumer)v.elementAt(i2);
                ic2.setPixels(0, 0 + line, width, 1, cm, scanline, 0, width);
            }
        }
        for (i = 0; i < v.size(); ++i) {
            ic = (ImageConsumer)v.elementAt(i);
            ic.imageComplete(3);
        }
    }

    public static int[] getScanline(Reader in, int len) throws IOException {
        char[] byteStr = new char[2];
        int[] scanline = new int[len];
        int x = 0;
        while (x < len) {
            int ch = in.read();
            if (ch != 48) continue;
            in.read();
            byteStr[0] = (char)in.read();
            byteStr[1] = (char)in.read();
            int byteVal = Integer.parseInt(new String(byteStr), 16);
            int i = 0;
            while (i < 8) {
                if (x == len) {
                    return scanline;
                }
                scanline[x] = (byteVal & masktable[i]) != 0 ? -16777216 : 0;
                ++i;
                ++x;
            }
        }
        return scanline;
    }
}

