/*
 * Unix SMB/CIFS implementation.
 * parser auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"

#undef DBGC_CLASS
#define DBGC_CLASS DBGC_RPC_PARSE

/* netdfs structures */
BOOL init_netdfs_dfs_Info0(NETDFS_DFS_INFO0 *v)
{
	DEBUG(5,("init_netdfs_dfs_Info0\n"));
	
	return True;
}

BOOL netdfs_io_dfs_Info0_p(const char *desc, NETDFS_DFS_INFO0 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_Info0_p");
	depth++;
	return True;
}

BOOL netdfs_io_dfs_Info0_d(const char *desc, NETDFS_DFS_INFO0 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_Info0_d");
	depth++;
	return True;
}

BOOL init_netdfs_dfs_Info1(NETDFS_DFS_INFO1 *v, const char *path)
{
	DEBUG(5,("init_netdfs_dfs_Info1\n"));
	
	if (path) {
		v->ptr0_path = 1;
		init_unistr2(&v->path, path, UNI_FLAGS_NONE);
	} else {
		v->ptr0_path = 0;
	}
	
	return True;
}

BOOL netdfs_io_dfs_Info1_p(const char *desc, NETDFS_DFS_INFO1 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_Info1_p");
	depth++;
	if (!prs_uint32("ptr0_path", ps, depth, &v->ptr0_path))
		return False;
	
	
	return True;
}

BOOL netdfs_io_dfs_Info1_d(const char *desc, NETDFS_DFS_INFO1 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_Info1_d");
	depth++;
	if (v->ptr0_path) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!smb_io_unistr2("path", &v->path, 1, ps, depth))
			return False;
	}
	
	return True;
}

BOOL init_netdfs_dfs_Info2(NETDFS_DFS_INFO2 *v, const char *path, const char *comment, uint32 state, uint32 num_stores)
{
	DEBUG(5,("init_netdfs_dfs_Info2\n"));
	
	if (path) {
		v->ptr0_path = 1;
		init_unistr2(&v->path, path, UNI_FLAGS_NONE);
	} else {
		v->ptr0_path = 0;
	}
	
	if (comment) {
		v->ptr0_comment = 1;
		init_unistr2(&v->comment, comment, UNI_FLAGS_NONE);
	} else {
		v->ptr0_comment = 0;
	}
	
	v->state = state;
	
	v->num_stores = num_stores;
	
	return True;
}

BOOL netdfs_io_dfs_Info2_p(const char *desc, NETDFS_DFS_INFO2 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_Info2_p");
	depth++;
	if (!prs_uint32("ptr0_path", ps, depth, &v->ptr0_path))
		return False;
	
	
	if (!prs_uint32("ptr0_comment", ps, depth, &v->ptr0_comment))
		return False;
	
	
	if (!prs_uint32("state", ps, depth, &v->state))
		return False;
	
	if (!prs_uint32("num_stores", ps, depth, &v->num_stores))
		return False;
	
	return True;
}

BOOL netdfs_io_dfs_Info2_d(const char *desc, NETDFS_DFS_INFO2 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_Info2_d");
	depth++;
	if (v->ptr0_path) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!smb_io_unistr2("path", &v->path, 1, ps, depth))
			return False;
	}
	
	if (v->ptr0_comment) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!smb_io_unistr2("comment", &v->comment, 1, ps, depth))
			return False;
	}
	
	
	
	return True;
}

BOOL init_netdfs_dfs_StorageInfo(NETDFS_DFS_STORAGEINFO *v, uint32 state, const char *server, const char *share)
{
	DEBUG(5,("init_netdfs_dfs_StorageInfo\n"));
	
	v->state = state;
	
	if (server) {
		v->ptr0_server = 1;
		init_unistr2(&v->server, server, UNI_FLAGS_NONE);
	} else {
		v->ptr0_server = 0;
	}
	
	if (share) {
		v->ptr0_share = 1;
		init_unistr2(&v->share, share, UNI_FLAGS_NONE);
	} else {
		v->ptr0_share = 0;
	}
	
	return True;
}

BOOL netdfs_io_dfs_StorageInfo_p(const char *desc, NETDFS_DFS_STORAGEINFO *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_StorageInfo_p");
	depth++;
	if (!prs_uint32("state", ps, depth, &v->state))
		return False;
	
	if (!prs_uint32("ptr0_server", ps, depth, &v->ptr0_server))
		return False;
	
	
	if (!prs_uint32("ptr0_share", ps, depth, &v->ptr0_share))
		return False;
	
	
	return True;
}

BOOL netdfs_io_dfs_StorageInfo_d(const char *desc, NETDFS_DFS_STORAGEINFO *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_StorageInfo_d");
	depth++;
	
	if (v->ptr0_server) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!smb_io_unistr2("server", &v->server, 1, ps, depth))
			return False;
	}
	
	if (v->ptr0_share) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!smb_io_unistr2("share", &v->share, 1, ps, depth))
			return False;
	}
	
	return True;
}

BOOL init_netdfs_dfs_Info3(NETDFS_DFS_INFO3 *v, const char *path, const char *comment, uint32 state, uint32 num_stores, NETDFS_DFS_STORAGEINFO **stores)
{
	DEBUG(5,("init_netdfs_dfs_Info3\n"));
	
	if (path) {
		v->ptr0_path = 1;
		init_unistr2(&v->path, path, UNI_FLAGS_NONE);
	} else {
		v->ptr0_path = 0;
	}
	
	if (comment) {
		v->ptr0_comment = 1;
		init_unistr2(&v->comment, comment, UNI_FLAGS_NONE);
	} else {
		v->ptr0_comment = 0;
	}
	
	v->state = state;
	
	v->num_stores = num_stores;
	
	if (stores) {
		v->ptr0_stores = 1;
		v->stores = *stores;
	} else {
		v->ptr0_stores = 0;
	}
	
	return True;
}

BOOL netdfs_io_dfs_Info3_p(const char *desc, NETDFS_DFS_INFO3 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_Info3_p");
	depth++;
	if (!prs_uint32("ptr0_path", ps, depth, &v->ptr0_path))
		return False;
	
	
	if (!prs_uint32("ptr0_comment", ps, depth, &v->ptr0_comment))
		return False;
	
	
	if (!prs_uint32("state", ps, depth, &v->state))
		return False;
	
	if (!prs_uint32("num_stores", ps, depth, &v->num_stores))
		return False;
	
	if (!prs_uint32("ptr0_stores", ps, depth, &v->ptr0_stores))
		return False;
	
	
	return True;
}

BOOL netdfs_io_dfs_Info3_d(const char *desc, NETDFS_DFS_INFO3 *v, prs_struct *ps, int depth)
{
	uint32 i_stores_1;
	
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_Info3_d");
	depth++;
	if (v->ptr0_path) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!smb_io_unistr2("path", &v->path, 1, ps, depth))
			return False;
	}
	
	if (v->ptr0_comment) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!smb_io_unistr2("comment", &v->comment, 1, ps, depth))
			return False;
	}
	
	
	
	if (v->ptr0_stores) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!prs_uint32("size_stores", ps, depth, &v->size_stores))
			return False;
		
		if (UNMARSHALLING(ps)) {
			v->stores = (void *)PRS_ALLOC_MEM_VOID(ps,sizeof(*v->stores)*v->num_stores);
		}
		for (i_stores_1=0; i_stores_1<v->num_stores;i_stores_1++) {
			if (!netdfs_io_dfs_StorageInfo_p("stores", &v->stores[i_stores_1], ps, depth))
				return False;
		}
		for (i_stores_1=0; i_stores_1<v->num_stores;i_stores_1++) {
			if (!netdfs_io_dfs_StorageInfo_d("stores", &v->stores[i_stores_1], ps, depth))
				return False;
		}
	}
	
	return True;
}

BOOL init_netdfs_dfs_Info4(NETDFS_DFS_INFO4 *v, const char *path, const char *comment, uint32 state, uint32 timeout, struct uuid guid, uint32 num_stores, NETDFS_DFS_STORAGEINFO **stores)
{
	DEBUG(5,("init_netdfs_dfs_Info4\n"));
	
	if (path) {
		v->ptr0_path = 1;
		init_unistr2(&v->path, path, UNI_FLAGS_NONE);
	} else {
		v->ptr0_path = 0;
	}
	
	if (comment) {
		v->ptr0_comment = 1;
		init_unistr2(&v->comment, comment, UNI_FLAGS_NONE);
	} else {
		v->ptr0_comment = 0;
	}
	
	v->state = state;
	
	v->timeout = timeout;
	
	
	
	v->num_stores = num_stores;
	
	if (stores) {
		v->ptr0_stores = 1;
		v->stores = *stores;
	} else {
		v->ptr0_stores = 0;
	}
	
	return True;
}

BOOL netdfs_io_dfs_Info4_p(const char *desc, NETDFS_DFS_INFO4 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_Info4_p");
	depth++;
	if (!prs_uint32("ptr0_path", ps, depth, &v->ptr0_path))
		return False;
	
	
	if (!prs_uint32("ptr0_comment", ps, depth, &v->ptr0_comment))
		return False;
	
	
	if (!prs_uint32("state", ps, depth, &v->state))
		return False;
	
	if (!prs_uint32("timeout", ps, depth, &v->timeout))
		return False;
	
	if (!smb_io_uuid("guid", &v->guid, ps, depth))
		return False;
	
	if (!prs_uint32("num_stores", ps, depth, &v->num_stores))
		return False;
	
	if (!prs_uint32("ptr0_stores", ps, depth, &v->ptr0_stores))
		return False;
	
	
	return True;
}

BOOL netdfs_io_dfs_Info4_d(const char *desc, NETDFS_DFS_INFO4 *v, prs_struct *ps, int depth)
{
	uint32 i_stores_1;
	
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_Info4_d");
	depth++;
	if (v->ptr0_path) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!smb_io_unistr2("path", &v->path, 1, ps, depth))
			return False;
	}
	
	if (v->ptr0_comment) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!smb_io_unistr2("comment", &v->comment, 1, ps, depth))
			return False;
	}
	
	
	
	
	
	if (v->ptr0_stores) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!prs_uint32("size_stores", ps, depth, &v->size_stores))
			return False;
		
		if (UNMARSHALLING(ps)) {
			v->stores = (void *)PRS_ALLOC_MEM_VOID(ps,sizeof(*v->stores)*v->num_stores);
		}
		for (i_stores_1=0; i_stores_1<v->num_stores;i_stores_1++) {
			if (!netdfs_io_dfs_StorageInfo_p("stores", &v->stores[i_stores_1], ps, depth))
				return False;
		}
		for (i_stores_1=0; i_stores_1<v->num_stores;i_stores_1++) {
			if (!netdfs_io_dfs_StorageInfo_d("stores", &v->stores[i_stores_1], ps, depth))
				return False;
		}
	}
	
	return True;
}

BOOL init_netdfs_dfs_Info100(NETDFS_DFS_INFO100 *v, const char *comment)
{
	DEBUG(5,("init_netdfs_dfs_Info100\n"));
	
	if (comment) {
		v->ptr0_comment = 1;
		init_unistr2(&v->comment, comment, UNI_FLAGS_NONE);
	} else {
		v->ptr0_comment = 0;
	}
	
	return True;
}

BOOL netdfs_io_dfs_Info100_p(const char *desc, NETDFS_DFS_INFO100 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_Info100_p");
	depth++;
	if (!prs_uint32("ptr0_comment", ps, depth, &v->ptr0_comment))
		return False;
	
	
	return True;
}

BOOL netdfs_io_dfs_Info100_d(const char *desc, NETDFS_DFS_INFO100 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_Info100_d");
	depth++;
	if (v->ptr0_comment) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!smb_io_unistr2("comment", &v->comment, 1, ps, depth))
			return False;
	}
	
	return True;
}

BOOL init_netdfs_dfs_Info101(NETDFS_DFS_INFO101 *v, uint32 state)
{
	DEBUG(5,("init_netdfs_dfs_Info101\n"));
	
	v->state = state;
	
	return True;
}

BOOL netdfs_io_dfs_Info101_p(const char *desc, NETDFS_DFS_INFO101 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_Info101_p");
	depth++;
	if (!prs_uint32("state", ps, depth, &v->state))
		return False;
	
	return True;
}

BOOL netdfs_io_dfs_Info101_d(const char *desc, NETDFS_DFS_INFO101 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_Info101_d");
	depth++;
	
	return True;
}

BOOL init_netdfs_dfs_Info102(NETDFS_DFS_INFO102 *v, uint32 timeout)
{
	DEBUG(5,("init_netdfs_dfs_Info102\n"));
	
	v->timeout = timeout;
	
	return True;
}

BOOL netdfs_io_dfs_Info102_p(const char *desc, NETDFS_DFS_INFO102 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_Info102_p");
	depth++;
	if (!prs_uint32("timeout", ps, depth, &v->timeout))
		return False;
	
	return True;
}

BOOL netdfs_io_dfs_Info102_d(const char *desc, NETDFS_DFS_INFO102 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_Info102_d");
	depth++;
	
	return True;
}

BOOL init_netdfs_dfs_Info200(NETDFS_DFS_INFO200 *v, const char *dom_root)
{
	DEBUG(5,("init_netdfs_dfs_Info200\n"));
	
	if (dom_root) {
		v->ptr0_dom_root = 1;
		init_unistr2(&v->dom_root, dom_root, UNI_FLAGS_NONE);
	} else {
		v->ptr0_dom_root = 0;
	}
	
	return True;
}

BOOL netdfs_io_dfs_Info200_p(const char *desc, NETDFS_DFS_INFO200 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_Info200_p");
	depth++;
	if (!prs_uint32("ptr0_dom_root", ps, depth, &v->ptr0_dom_root))
		return False;
	
	
	return True;
}

BOOL netdfs_io_dfs_Info200_d(const char *desc, NETDFS_DFS_INFO200 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_Info200_d");
	depth++;
	if (v->ptr0_dom_root) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!smb_io_unistr2("dom_root", &v->dom_root, 1, ps, depth))
			return False;
	}
	
	return True;
}

BOOL init_netdfs_dfs_Info300(NETDFS_DFS_INFO300 *v, uint32 flags, const char *dom_root)
{
	DEBUG(5,("init_netdfs_dfs_Info300\n"));
	
	v->flags = flags;
	
	if (dom_root) {
		v->ptr0_dom_root = 1;
		init_unistr2(&v->dom_root, dom_root, UNI_FLAGS_NONE);
	} else {
		v->ptr0_dom_root = 0;
	}
	
	return True;
}

BOOL netdfs_io_dfs_Info300_p(const char *desc, NETDFS_DFS_INFO300 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_Info300_p");
	depth++;
	if (!prs_uint32("flags", ps, depth, &v->flags))
		return False;
	
	if (!prs_uint32("ptr0_dom_root", ps, depth, &v->ptr0_dom_root))
		return False;
	
	
	return True;
}

BOOL netdfs_io_dfs_Info300_d(const char *desc, NETDFS_DFS_INFO300 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_Info300_d");
	depth++;
	
	if (v->ptr0_dom_root) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!smb_io_unistr2("dom_root", &v->dom_root, 1, ps, depth))
			return False;
	}
	
	return True;
}

BOOL netdfs_io_dfs_Info_p(const char *desc, NETDFS_DFS_INFO_CTR* v, prs_struct *ps, int depth)
{
	if (!prs_uint32("switch_value", ps, depth, &v->switch_value))
		return False;
	
	switch (v->switch_value) {
		case 0:
			depth++;
			if (!prs_uint32("ptr0_info0", ps, depth, &v->ptr0))
				return False;
			
			depth--;
			break;
		
		case 1:
			depth++;
			if (!prs_uint32("ptr0_info1", ps, depth, &v->ptr0))
				return False;
			
			depth--;
			break;
		
		case 2:
			depth++;
			if (!prs_uint32("ptr0_info2", ps, depth, &v->ptr0))
				return False;
			
			depth--;
			break;
		
		case 3:
			depth++;
			if (!prs_uint32("ptr0_info3", ps, depth, &v->ptr0))
				return False;
			
			depth--;
			break;
		
		case 4:
			depth++;
			if (!prs_uint32("ptr0_info4", ps, depth, &v->ptr0))
				return False;
			
			depth--;
			break;
		
		case 100:
			depth++;
			if (!prs_uint32("ptr0_info100", ps, depth, &v->ptr0))
				return False;
			
			depth--;
			break;
		
		case 101:
			depth++;
			if (!prs_uint32("ptr0_info101", ps, depth, &v->ptr0))
				return False;
			
			depth--;
			break;
		
		case 102:
			depth++;
			if (!prs_uint32("ptr0_info102", ps, depth, &v->ptr0))
				return False;
			
			depth--;
			break;
		
		default:
			return False;
		
	}
	
	return True;
}

BOOL netdfs_io_dfs_Info_d(const char *desc, NETDFS_DFS_INFO_CTR* v, prs_struct *ps, int depth)
{
	switch (v->switch_value) {
		case 0:
			depth++;
			if (v->ptr0) {
				if (!prs_align_custom(ps, 1))
					return False;
				
				if (!netdfs_io_dfs_Info0_p("info0", &v->u.info0, ps, depth))
					return False;
				if (!netdfs_io_dfs_Info0_d("info0", &v->u.info0, ps, depth))
					return False;
			}
			depth--;
			break;
		
		case 1:
			depth++;
			if (v->ptr0) {
				if (!prs_align_custom(ps, 4))
					return False;
				
				if (!netdfs_io_dfs_Info1_p("info1", &v->u.info1, ps, depth))
					return False;
				if (!netdfs_io_dfs_Info1_d("info1", &v->u.info1, ps, depth))
					return False;
			}
			depth--;
			break;
		
		case 2:
			depth++;
			if (v->ptr0) {
				if (!prs_align_custom(ps, 4))
					return False;
				
				if (!netdfs_io_dfs_Info2_p("info2", &v->u.info2, ps, depth))
					return False;
				if (!netdfs_io_dfs_Info2_d("info2", &v->u.info2, ps, depth))
					return False;
			}
			depth--;
			break;
		
		case 3:
			depth++;
			if (v->ptr0) {
				if (!prs_align_custom(ps, 4))
					return False;
				
				if (!netdfs_io_dfs_Info3_p("info3", &v->u.info3, ps, depth))
					return False;
				if (!netdfs_io_dfs_Info3_d("info3", &v->u.info3, ps, depth))
					return False;
			}
			depth--;
			break;
		
		case 4:
			depth++;
			if (v->ptr0) {
				if (!prs_align_custom(ps, 4))
					return False;
				
				if (!netdfs_io_dfs_Info4_p("info4", &v->u.info4, ps, depth))
					return False;
				if (!netdfs_io_dfs_Info4_d("info4", &v->u.info4, ps, depth))
					return False;
			}
			depth--;
			break;
		
		case 100:
			depth++;
			if (v->ptr0) {
				if (!prs_align_custom(ps, 4))
					return False;
				
				if (!netdfs_io_dfs_Info100_p("info100", &v->u.info100, ps, depth))
					return False;
				if (!netdfs_io_dfs_Info100_d("info100", &v->u.info100, ps, depth))
					return False;
			}
			depth--;
			break;
		
		case 101:
			depth++;
			if (v->ptr0) {
				if (!prs_align_custom(ps, 4))
					return False;
				
				if (!netdfs_io_dfs_Info101_p("info101", &v->u.info101, ps, depth))
					return False;
				if (!netdfs_io_dfs_Info101_d("info101", &v->u.info101, ps, depth))
					return False;
			}
			depth--;
			break;
		
		case 102:
			depth++;
			if (v->ptr0) {
				if (!prs_align_custom(ps, 4))
					return False;
				
				if (!netdfs_io_dfs_Info102_p("info102", &v->u.info102, ps, depth))
					return False;
				if (!netdfs_io_dfs_Info102_d("info102", &v->u.info102, ps, depth))
					return False;
			}
			depth--;
			break;
		
	}
	
	return True;
}
BOOL init_netdfs_dfs_EnumArray1(NETDFS_DFS_ENUMARRAY1 *v, uint32 count, NETDFS_DFS_INFO1 **s)
{
	DEBUG(5,("init_netdfs_dfs_EnumArray1\n"));
	
	v->count = count;
	
	if (s) {
		v->ptr0_s = 1;
		v->s = *s;
	} else {
		v->ptr0_s = 0;
	}
	
	return True;
}

BOOL netdfs_io_dfs_EnumArray1_p(const char *desc, NETDFS_DFS_ENUMARRAY1 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_EnumArray1_p");
	depth++;
	if (!prs_uint32("count", ps, depth, &v->count))
		return False;
	
	if (!prs_uint32("ptr0_s", ps, depth, &v->ptr0_s))
		return False;
	
	
	return True;
}

BOOL netdfs_io_dfs_EnumArray1_d(const char *desc, NETDFS_DFS_ENUMARRAY1 *v, prs_struct *ps, int depth)
{
	uint32 i_s_1;
	
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_EnumArray1_d");
	depth++;
	
	if (v->ptr0_s) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!prs_uint32("size_s", ps, depth, &v->size_s))
			return False;
		
		if (UNMARSHALLING(ps)) {
			v->s = (void *)PRS_ALLOC_MEM_VOID(ps,sizeof(*v->s)*v->count);
		}
		for (i_s_1=0; i_s_1<v->count;i_s_1++) {
			if (!netdfs_io_dfs_Info1_p("s", &v->s[i_s_1], ps, depth))
				return False;
		}
		for (i_s_1=0; i_s_1<v->count;i_s_1++) {
			if (!netdfs_io_dfs_Info1_d("s", &v->s[i_s_1], ps, depth))
				return False;
		}
	}
	
	return True;
}

BOOL init_netdfs_dfs_EnumArray2(NETDFS_DFS_ENUMARRAY2 *v, uint32 count, NETDFS_DFS_INFO2 **s)
{
	DEBUG(5,("init_netdfs_dfs_EnumArray2\n"));
	
	v->count = count;
	
	if (s) {
		v->ptr0_s = 1;
		v->s = *s;
	} else {
		v->ptr0_s = 0;
	}
	
	return True;
}

BOOL netdfs_io_dfs_EnumArray2_p(const char *desc, NETDFS_DFS_ENUMARRAY2 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_EnumArray2_p");
	depth++;
	if (!prs_uint32("count", ps, depth, &v->count))
		return False;
	
	if (!prs_uint32("ptr0_s", ps, depth, &v->ptr0_s))
		return False;
	
	
	return True;
}

BOOL netdfs_io_dfs_EnumArray2_d(const char *desc, NETDFS_DFS_ENUMARRAY2 *v, prs_struct *ps, int depth)
{
	uint32 i_s_1;
	
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_EnumArray2_d");
	depth++;
	
	if (v->ptr0_s) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!prs_uint32("size_s", ps, depth, &v->size_s))
			return False;
		
		if (UNMARSHALLING(ps)) {
			v->s = (void *)PRS_ALLOC_MEM_VOID(ps,sizeof(*v->s)*v->count);
		}
		for (i_s_1=0; i_s_1<v->count;i_s_1++) {
			if (!netdfs_io_dfs_Info2_p("s", &v->s[i_s_1], ps, depth))
				return False;
		}
		for (i_s_1=0; i_s_1<v->count;i_s_1++) {
			if (!netdfs_io_dfs_Info2_d("s", &v->s[i_s_1], ps, depth))
				return False;
		}
	}
	
	return True;
}

BOOL init_netdfs_dfs_EnumArray3(NETDFS_DFS_ENUMARRAY3 *v, uint32 count, NETDFS_DFS_INFO3 **s)
{
	DEBUG(5,("init_netdfs_dfs_EnumArray3\n"));
	
	v->count = count;
	
	if (s) {
		v->ptr0_s = 1;
		v->s = *s;
	} else {
		v->ptr0_s = 0;
	}
	
	return True;
}

BOOL netdfs_io_dfs_EnumArray3_p(const char *desc, NETDFS_DFS_ENUMARRAY3 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_EnumArray3_p");
	depth++;
	if (!prs_uint32("count", ps, depth, &v->count))
		return False;
	
	if (!prs_uint32("ptr0_s", ps, depth, &v->ptr0_s))
		return False;
	
	
	return True;
}

BOOL netdfs_io_dfs_EnumArray3_d(const char *desc, NETDFS_DFS_ENUMARRAY3 *v, prs_struct *ps, int depth)
{
	uint32 i_s_1;
	
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_EnumArray3_d");
	depth++;
	
	if (v->ptr0_s) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!prs_uint32("size_s", ps, depth, &v->size_s))
			return False;
		
		if (UNMARSHALLING(ps)) {
			v->s = (void *)PRS_ALLOC_MEM_VOID(ps,sizeof(*v->s)*v->count);
		}
		for (i_s_1=0; i_s_1<v->count;i_s_1++) {
			if (!netdfs_io_dfs_Info3_p("s", &v->s[i_s_1], ps, depth))
				return False;
		}
		for (i_s_1=0; i_s_1<v->count;i_s_1++) {
			if (!netdfs_io_dfs_Info3_d("s", &v->s[i_s_1], ps, depth))
				return False;
		}
	}
	
	return True;
}

BOOL init_netdfs_dfs_EnumArray4(NETDFS_DFS_ENUMARRAY4 *v, uint32 count, NETDFS_DFS_INFO4 **s)
{
	DEBUG(5,("init_netdfs_dfs_EnumArray4\n"));
	
	v->count = count;
	
	if (s) {
		v->ptr0_s = 1;
		v->s = *s;
	} else {
		v->ptr0_s = 0;
	}
	
	return True;
}

BOOL netdfs_io_dfs_EnumArray4_p(const char *desc, NETDFS_DFS_ENUMARRAY4 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_EnumArray4_p");
	depth++;
	if (!prs_uint32("count", ps, depth, &v->count))
		return False;
	
	if (!prs_uint32("ptr0_s", ps, depth, &v->ptr0_s))
		return False;
	
	
	return True;
}

BOOL netdfs_io_dfs_EnumArray4_d(const char *desc, NETDFS_DFS_ENUMARRAY4 *v, prs_struct *ps, int depth)
{
	uint32 i_s_1;
	
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_EnumArray4_d");
	depth++;
	
	if (v->ptr0_s) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!prs_uint32("size_s", ps, depth, &v->size_s))
			return False;
		
		if (UNMARSHALLING(ps)) {
			v->s = (void *)PRS_ALLOC_MEM_VOID(ps,sizeof(*v->s)*v->count);
		}
		for (i_s_1=0; i_s_1<v->count;i_s_1++) {
			if (!netdfs_io_dfs_Info4_p("s", &v->s[i_s_1], ps, depth))
				return False;
		}
		for (i_s_1=0; i_s_1<v->count;i_s_1++) {
			if (!netdfs_io_dfs_Info4_d("s", &v->s[i_s_1], ps, depth))
				return False;
		}
	}
	
	return True;
}

BOOL init_netdfs_dfs_EnumArray200(NETDFS_DFS_ENUMARRAY200 *v, uint32 count, NETDFS_DFS_INFO200 **s)
{
	DEBUG(5,("init_netdfs_dfs_EnumArray200\n"));
	
	v->count = count;
	
	if (s) {
		v->ptr0_s = 1;
		v->s = *s;
	} else {
		v->ptr0_s = 0;
	}
	
	return True;
}

BOOL netdfs_io_dfs_EnumArray200_p(const char *desc, NETDFS_DFS_ENUMARRAY200 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_EnumArray200_p");
	depth++;
	if (!prs_uint32("count", ps, depth, &v->count))
		return False;
	
	if (!prs_uint32("ptr0_s", ps, depth, &v->ptr0_s))
		return False;
	
	
	return True;
}

BOOL netdfs_io_dfs_EnumArray200_d(const char *desc, NETDFS_DFS_ENUMARRAY200 *v, prs_struct *ps, int depth)
{
	uint32 i_s_1;
	
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_EnumArray200_d");
	depth++;
	
	if (v->ptr0_s) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!prs_uint32("size_s", ps, depth, &v->size_s))
			return False;
		
		if (UNMARSHALLING(ps)) {
			v->s = (void *)PRS_ALLOC_MEM_VOID(ps,sizeof(*v->s)*v->count);
		}
		for (i_s_1=0; i_s_1<v->count;i_s_1++) {
			if (!netdfs_io_dfs_Info200_p("s", &v->s[i_s_1], ps, depth))
				return False;
		}
		for (i_s_1=0; i_s_1<v->count;i_s_1++) {
			if (!netdfs_io_dfs_Info200_d("s", &v->s[i_s_1], ps, depth))
				return False;
		}
	}
	
	return True;
}

BOOL init_netdfs_dfs_EnumArray300(NETDFS_DFS_ENUMARRAY300 *v, uint32 count, NETDFS_DFS_INFO300 **s)
{
	DEBUG(5,("init_netdfs_dfs_EnumArray300\n"));
	
	v->count = count;
	
	if (s) {
		v->ptr0_s = 1;
		v->s = *s;
	} else {
		v->ptr0_s = 0;
	}
	
	return True;
}

BOOL netdfs_io_dfs_EnumArray300_p(const char *desc, NETDFS_DFS_ENUMARRAY300 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_EnumArray300_p");
	depth++;
	if (!prs_uint32("count", ps, depth, &v->count))
		return False;
	
	if (!prs_uint32("ptr0_s", ps, depth, &v->ptr0_s))
		return False;
	
	
	return True;
}

BOOL netdfs_io_dfs_EnumArray300_d(const char *desc, NETDFS_DFS_ENUMARRAY300 *v, prs_struct *ps, int depth)
{
	uint32 i_s_1;
	
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_EnumArray300_d");
	depth++;
	
	if (v->ptr0_s) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!prs_uint32("size_s", ps, depth, &v->size_s))
			return False;
		
		if (UNMARSHALLING(ps)) {
			v->s = (void *)PRS_ALLOC_MEM_VOID(ps,sizeof(*v->s)*v->count);
		}
		for (i_s_1=0; i_s_1<v->count;i_s_1++) {
			if (!netdfs_io_dfs_Info300_p("s", &v->s[i_s_1], ps, depth))
				return False;
		}
		for (i_s_1=0; i_s_1<v->count;i_s_1++) {
			if (!netdfs_io_dfs_Info300_d("s", &v->s[i_s_1], ps, depth))
				return False;
		}
	}
	
	return True;
}

BOOL netdfs_io_dfs_EnumInfo_p(const char *desc, NETDFS_DFS_ENUMINFO_CTR* v, prs_struct *ps, int depth)
{
	if (!prs_uint32("switch_value", ps, depth, &v->switch_value))
		return False;
	
	switch (v->switch_value) {
		case 1:
			depth++;
			if (!prs_uint32("ptr0_info1", ps, depth, &v->ptr0))
				return False;
			
			depth--;
			break;
		
		case 2:
			depth++;
			if (!prs_uint32("ptr0_info2", ps, depth, &v->ptr0))
				return False;
			
			depth--;
			break;
		
		case 3:
			depth++;
			if (!prs_uint32("ptr0_info3", ps, depth, &v->ptr0))
				return False;
			
			depth--;
			break;
		
		case 4:
			depth++;
			if (!prs_uint32("ptr0_info4", ps, depth, &v->ptr0))
				return False;
			
			depth--;
			break;
		
		case 200:
			depth++;
			if (!prs_uint32("ptr0_info200", ps, depth, &v->ptr0))
				return False;
			
			depth--;
			break;
		
		case 300:
			depth++;
			if (!prs_uint32("ptr0_info300", ps, depth, &v->ptr0))
				return False;
			
			depth--;
			break;
		
		default:
			return False;
		
	}
	
	return True;
}

BOOL netdfs_io_dfs_EnumInfo_d(const char *desc, NETDFS_DFS_ENUMINFO_CTR* v, prs_struct *ps, int depth)
{
	switch (v->switch_value) {
		case 1:
			depth++;
			if (v->ptr0) {
				if (!prs_align_custom(ps, 4))
					return False;
				
				if (!netdfs_io_dfs_EnumArray1_p("info1", &v->u.info1, ps, depth))
					return False;
				if (!netdfs_io_dfs_EnumArray1_d("info1", &v->u.info1, ps, depth))
					return False;
			}
			depth--;
			break;
		
		case 2:
			depth++;
			if (v->ptr0) {
				if (!prs_align_custom(ps, 4))
					return False;
				
				if (!netdfs_io_dfs_EnumArray2_p("info2", &v->u.info2, ps, depth))
					return False;
				if (!netdfs_io_dfs_EnumArray2_d("info2", &v->u.info2, ps, depth))
					return False;
			}
			depth--;
			break;
		
		case 3:
			depth++;
			if (v->ptr0) {
				if (!prs_align_custom(ps, 4))
					return False;
				
				if (!netdfs_io_dfs_EnumArray3_p("info3", &v->u.info3, ps, depth))
					return False;
				if (!netdfs_io_dfs_EnumArray3_d("info3", &v->u.info3, ps, depth))
					return False;
			}
			depth--;
			break;
		
		case 4:
			depth++;
			if (v->ptr0) {
				if (!prs_align_custom(ps, 4))
					return False;
				
				if (!netdfs_io_dfs_EnumArray4_p("info4", &v->u.info4, ps, depth))
					return False;
				if (!netdfs_io_dfs_EnumArray4_d("info4", &v->u.info4, ps, depth))
					return False;
			}
			depth--;
			break;
		
		case 200:
			depth++;
			if (v->ptr0) {
				if (!prs_align_custom(ps, 4))
					return False;
				
				if (!netdfs_io_dfs_EnumArray200_p("info200", &v->u.info200, ps, depth))
					return False;
				if (!netdfs_io_dfs_EnumArray200_d("info200", &v->u.info200, ps, depth))
					return False;
			}
			depth--;
			break;
		
		case 300:
			depth++;
			if (v->ptr0) {
				if (!prs_align_custom(ps, 4))
					return False;
				
				if (!netdfs_io_dfs_EnumArray300_p("info300", &v->u.info300, ps, depth))
					return False;
				if (!netdfs_io_dfs_EnumArray300_d("info300", &v->u.info300, ps, depth))
					return False;
			}
			depth--;
			break;
		
	}
	
	return True;
}
BOOL init_netdfs_dfs_EnumStruct(NETDFS_DFS_ENUMSTRUCT *v, uint32 level, NETDFS_DFS_ENUMINFO_CTR e)
{
	DEBUG(5,("init_netdfs_dfs_EnumStruct\n"));
	
	v->level = level;
	
	v->e = e;
	v->e.switch_value = v->level;
	
	return True;
}

BOOL netdfs_io_dfs_EnumStruct_p(const char *desc, NETDFS_DFS_ENUMSTRUCT *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_EnumStruct_p");
	depth++;
	if (!prs_uint32("level", ps, depth, &v->level))
		return False;
	
	if (!netdfs_io_dfs_EnumInfo_p("e", &v->e, ps, depth))
		return False;
	
	return True;
}

BOOL netdfs_io_dfs_EnumStruct_d(const char *desc, NETDFS_DFS_ENUMSTRUCT *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_dfs_EnumStruct_d");
	depth++;
	
	if (!prs_align_custom(ps, 4))
		return False;
	
	if (!netdfs_io_dfs_EnumInfo_d("e", &v->e, ps, depth))
		return False;
	
	return True;
}

/* netdfs functions */
BOOL init_netdfs_q_dfs_GetManagerVersion(NETDFS_Q_DFS_GETMANAGERVERSION *v)
{
	DEBUG(5,("init_netdfs_q_dfs_GetManagerVersion\n"));
	
	return True;
}

BOOL netdfs_io_q_dfs_GetManagerVersion(const char *desc, NETDFS_Q_DFS_GETMANAGERVERSION *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_GetManagerVersion");
	depth++;
	return True;
}

BOOL init_netdfs_r_dfs_GetManagerVersion(NETDFS_R_DFS_GETMANAGERVERSION *v, uint32 *exist_flag)
{
	DEBUG(5,("init_netdfs_r_dfs_GetManagerVersion\n"));
	
	if (!exist_flag)
		return False;
	
	v->exist_flag = *exist_flag;
	
	return True;
}

BOOL netdfs_io_r_dfs_GetManagerVersion(const char *desc, NETDFS_R_DFS_GETMANAGERVERSION *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_GetManagerVersion");
	depth++;
	if (!prs_uint32("exist_flag", ps, depth, &v->exist_flag))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_Add(NETDFS_Q_DFS_ADD *v, const char *path, const char *server, const char *share, const char *comment, uint32 flags)
{
	DEBUG(5,("init_netdfs_q_dfs_Add\n"));
	
	if (!path)
		return False;
	
	init_unistr2(&v->path, path, UNI_FLAGS_NONE);
	
	if (!server)
		return False;
	
	init_unistr2(&v->server, server, UNI_FLAGS_NONE);
	
	if (share) {
		v->ptr0_share = 1;
		init_unistr2(&v->share, share, UNI_FLAGS_NONE);
	} else {
		v->ptr0_share = 0;
	}
	
	if (comment) {
		v->ptr0_comment = 1;
		init_unistr2(&v->comment, comment, UNI_FLAGS_NONE);
	} else {
		v->ptr0_comment = 0;
	}
	
	v->flags = flags;
	
	return True;
}

BOOL netdfs_io_q_dfs_Add(const char *desc, NETDFS_Q_DFS_ADD *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_Add");
	depth++;
	if (!prs_align_custom(ps, 4))
		return False;
	
	if (!smb_io_unistr2("path", &v->path, 1, ps, depth))
		return False;
	
	if (!prs_align_custom(ps, 4))
		return False;
	
	if (!smb_io_unistr2("server", &v->server, 1, ps, depth))
		return False;
	
	if (!prs_align_custom(ps, 4))
		return False;
	
	if (!prs_uint32("ptr0_share", ps, depth, &v->ptr0_share))
		return False;
	
	if (v->ptr0_share) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!smb_io_unistr2("share", &v->share, 1, ps, depth))
			return False;
	}
	
	if (!prs_align_custom(ps, 4))
		return False;
	
	if (!prs_uint32("ptr0_comment", ps, depth, &v->ptr0_comment))
		return False;
	
	if (v->ptr0_comment) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!smb_io_unistr2("comment", &v->comment, 1, ps, depth))
			return False;
	}
	
	if (!prs_align_custom(ps, 4))
		return False;
	
	if (!prs_uint32("flags", ps, depth, &v->flags))
		return False;
	
	return True;
}

BOOL init_netdfs_r_dfs_Add(NETDFS_R_DFS_ADD *v, const char *path, const char *server, const char *share, const char *comment, uint32 flags, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_Add\n"));
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_Add(const char *desc, NETDFS_R_DFS_ADD *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_Add");
	depth++;
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_Remove(NETDFS_Q_DFS_REMOVE *v, const char *path, const char *server, const char *share)
{
	DEBUG(5,("init_netdfs_q_dfs_Remove\n"));
	
	if (!path)
		return False;
	
	init_unistr2(&v->path, path, UNI_FLAGS_NONE);
	
	if (server) {
		v->ptr0_server = 1;
		init_unistr2(&v->server, server, UNI_FLAGS_NONE);
	} else {
		v->ptr0_server = 0;
	}
	
	if (share) {
		v->ptr0_share = 1;
		init_unistr2(&v->share, share, UNI_FLAGS_NONE);
	} else {
		v->ptr0_share = 0;
	}
	
	return True;
}

BOOL netdfs_io_q_dfs_Remove(const char *desc, NETDFS_Q_DFS_REMOVE *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_Remove");
	depth++;
	if (!prs_align_custom(ps, 4))
		return False;
	
	if (!smb_io_unistr2("path", &v->path, 1, ps, depth))
		return False;
	
	if (!prs_align_custom(ps, 4))
		return False;
	
	if (!prs_uint32("ptr0_server", ps, depth, &v->ptr0_server))
		return False;
	
	if (v->ptr0_server) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!smb_io_unistr2("server", &v->server, 1, ps, depth))
			return False;
	}
	
	if (!prs_align_custom(ps, 4))
		return False;
	
	if (!prs_uint32("ptr0_share", ps, depth, &v->ptr0_share))
		return False;
	
	if (v->ptr0_share) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!smb_io_unistr2("share", &v->share, 1, ps, depth))
			return False;
	}
	
	return True;
}

BOOL init_netdfs_r_dfs_Remove(NETDFS_R_DFS_REMOVE *v, const char *path, const char *server, const char *share, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_Remove\n"));
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_Remove(const char *desc, NETDFS_R_DFS_REMOVE *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_Remove");
	depth++;
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_SetInfo(NETDFS_Q_DFS_SETINFO *v)
{
	DEBUG(5,("init_netdfs_q_dfs_SetInfo\n"));
	
	return True;
}

BOOL netdfs_io_q_dfs_SetInfo(const char *desc, NETDFS_Q_DFS_SETINFO *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_SetInfo");
	depth++;
	return True;
}

BOOL init_netdfs_r_dfs_SetInfo(NETDFS_R_DFS_SETINFO *v, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_SetInfo\n"));
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_SetInfo(const char *desc, NETDFS_R_DFS_SETINFO *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_SetInfo");
	depth++;
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_GetInfo(NETDFS_Q_DFS_GETINFO *v, const char *path, const char *server, const char *share, uint32 level)
{
	DEBUG(5,("init_netdfs_q_dfs_GetInfo\n"));
	
	if (!path)
		return False;
	
	init_unistr2(&v->path, path, UNI_FLAGS_NONE);
	
	if (server) {
		v->ptr0_server = 1;
		init_unistr2(&v->server, server, UNI_FLAGS_NONE);
	} else {
		v->ptr0_server = 0;
	}
	
	if (share) {
		v->ptr0_share = 1;
		init_unistr2(&v->share, share, UNI_FLAGS_NONE);
	} else {
		v->ptr0_share = 0;
	}
	
	v->level = level;
	
	return True;
}

BOOL netdfs_io_q_dfs_GetInfo(const char *desc, NETDFS_Q_DFS_GETINFO *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_GetInfo");
	depth++;
	if (!prs_align_custom(ps, 4))
		return False;
	
	if (!smb_io_unistr2("path", &v->path, 1, ps, depth))
		return False;
	
	if (!prs_align_custom(ps, 4))
		return False;
	
	if (!prs_uint32("ptr0_server", ps, depth, &v->ptr0_server))
		return False;
	
	if (v->ptr0_server) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!smb_io_unistr2("server", &v->server, 1, ps, depth))
			return False;
	}
	
	if (!prs_align_custom(ps, 4))
		return False;
	
	if (!prs_uint32("ptr0_share", ps, depth, &v->ptr0_share))
		return False;
	
	if (v->ptr0_share) {
		if (!prs_align_custom(ps, 4))
			return False;
		
		if (!smb_io_unistr2("share", &v->share, 1, ps, depth))
			return False;
	}
	
	if (!prs_align_custom(ps, 4))
		return False;
	
	if (!prs_uint32("level", ps, depth, &v->level))
		return False;
	
	return True;
}

BOOL init_netdfs_r_dfs_GetInfo(NETDFS_R_DFS_GETINFO *v, const char *path, const char *server, const char *share, uint32 level, NETDFS_DFS_INFO_CTR *info, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_GetInfo\n"));
	
	if (!info)
		return False;
	
	v->info = *info;
	v->info.switch_value = level;
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_GetInfo(const char *desc, NETDFS_R_DFS_GETINFO *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_GetInfo");
	depth++;
	if (!netdfs_io_dfs_Info_p("info", &v->info, ps, depth))
		return False;
	if (!netdfs_io_dfs_Info_d("info", &v->info, ps, depth))
		return False;
	
	if (!prs_align_custom(ps, 4))
		return False;
	
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_Enum(NETDFS_Q_DFS_ENUM *v, uint32 level, uint32 bufsize, NETDFS_DFS_ENUMSTRUCT *info, uint32 *total)
{
	DEBUG(5,("init_netdfs_q_dfs_Enum\n"));
	
	v->level = level;
	
	v->bufsize = bufsize;
	
	if (info) {
		v->ptr0_info = 1;
		v->info = *info;
	} else {
		v->ptr0_info = 0;
	}
	
	if (total) {
		v->ptr0_total = 1;
		v->total = *total;
	} else {
		v->ptr0_total = 0;
	}
	
	return True;
}

BOOL netdfs_io_q_dfs_Enum(const char *desc, NETDFS_Q_DFS_ENUM *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_Enum");
	depth++;
	if (!prs_uint32("level", ps, depth, &v->level))
		return False;
	
	if (!prs_uint32("bufsize", ps, depth, &v->bufsize))
		return False;
	
	if (!prs_uint32("ptr0_info", ps, depth, &v->ptr0_info))
		return False;
	
	if (v->ptr0_info) {
		if (!netdfs_io_dfs_EnumStruct_p("info", &v->info, ps, depth))
			return False;
		if (!netdfs_io_dfs_EnumStruct_d("info", &v->info, ps, depth))
			return False;
	}
	
	if (!prs_align_custom(ps, 4))
		return False;
	
	if (!prs_uint32("ptr0_total", ps, depth, &v->ptr0_total))
		return False;
	
	if (v->ptr0_total) {
		if (!prs_uint32("total", ps, depth, &v->total))
			return False;
	}
	
	return True;
}

BOOL init_netdfs_r_dfs_Enum(NETDFS_R_DFS_ENUM *v, uint32 level, uint32 bufsize, NETDFS_DFS_ENUMSTRUCT *info, uint32 *unknown, uint32 *total, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_Enum\n"));
	
	if (info) {
		v->ptr0_info = 1;
		v->info = *info;
	} else {
		v->ptr0_info = 0;
	}
	
	if (total) {
		v->ptr0_total = 1;
		v->total = *total;
	} else {
		v->ptr0_total = 0;
	}
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_Enum(const char *desc, NETDFS_R_DFS_ENUM *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_Enum");
	depth++;
	if (!prs_uint32("ptr0_info", ps, depth, &v->ptr0_info))
		return False;
	
	if (v->ptr0_info) {
		if (!netdfs_io_dfs_EnumStruct_p("info", &v->info, ps, depth))
			return False;
		if (!netdfs_io_dfs_EnumStruct_d("info", &v->info, ps, depth))
			return False;
	}
	
	if (!prs_align_custom(ps, 4))
		return False;
	
	if (!prs_uint32("ptr0_total", ps, depth, &v->ptr0_total))
		return False;
	
	if (v->ptr0_total) {
		if (!prs_uint32("total", ps, depth, &v->total))
			return False;
	}
	
	if (!prs_align_custom(ps, 4))
		return False;
	
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_Rename(NETDFS_Q_DFS_RENAME *v)
{
	DEBUG(5,("init_netdfs_q_dfs_Rename\n"));
	
	return True;
}

BOOL netdfs_io_q_dfs_Rename(const char *desc, NETDFS_Q_DFS_RENAME *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_Rename");
	depth++;
	return True;
}

BOOL init_netdfs_r_dfs_Rename(NETDFS_R_DFS_RENAME *v, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_Rename\n"));
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_Rename(const char *desc, NETDFS_R_DFS_RENAME *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_Rename");
	depth++;
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_Move(NETDFS_Q_DFS_MOVE *v)
{
	DEBUG(5,("init_netdfs_q_dfs_Move\n"));
	
	return True;
}

BOOL netdfs_io_q_dfs_Move(const char *desc, NETDFS_Q_DFS_MOVE *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_Move");
	depth++;
	return True;
}

BOOL init_netdfs_r_dfs_Move(NETDFS_R_DFS_MOVE *v, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_Move\n"));
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_Move(const char *desc, NETDFS_R_DFS_MOVE *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_Move");
	depth++;
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_ManagerGetConfigInfo(NETDFS_Q_DFS_MANAGERGETCONFIGINFO *v)
{
	DEBUG(5,("init_netdfs_q_dfs_ManagerGetConfigInfo\n"));
	
	return True;
}

BOOL netdfs_io_q_dfs_ManagerGetConfigInfo(const char *desc, NETDFS_Q_DFS_MANAGERGETCONFIGINFO *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_ManagerGetConfigInfo");
	depth++;
	return True;
}

BOOL init_netdfs_r_dfs_ManagerGetConfigInfo(NETDFS_R_DFS_MANAGERGETCONFIGINFO *v, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_ManagerGetConfigInfo\n"));
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_ManagerGetConfigInfo(const char *desc, NETDFS_R_DFS_MANAGERGETCONFIGINFO *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_ManagerGetConfigInfo");
	depth++;
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_ManagerSendSiteInfo(NETDFS_Q_DFS_MANAGERSENDSITEINFO *v)
{
	DEBUG(5,("init_netdfs_q_dfs_ManagerSendSiteInfo\n"));
	
	return True;
}

BOOL netdfs_io_q_dfs_ManagerSendSiteInfo(const char *desc, NETDFS_Q_DFS_MANAGERSENDSITEINFO *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_ManagerSendSiteInfo");
	depth++;
	return True;
}

BOOL init_netdfs_r_dfs_ManagerSendSiteInfo(NETDFS_R_DFS_MANAGERSENDSITEINFO *v, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_ManagerSendSiteInfo\n"));
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_ManagerSendSiteInfo(const char *desc, NETDFS_R_DFS_MANAGERSENDSITEINFO *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_ManagerSendSiteInfo");
	depth++;
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_AddFtRoot(NETDFS_Q_DFS_ADDFTROOT *v)
{
	DEBUG(5,("init_netdfs_q_dfs_AddFtRoot\n"));
	
	return True;
}

BOOL netdfs_io_q_dfs_AddFtRoot(const char *desc, NETDFS_Q_DFS_ADDFTROOT *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_AddFtRoot");
	depth++;
	return True;
}

BOOL init_netdfs_r_dfs_AddFtRoot(NETDFS_R_DFS_ADDFTROOT *v, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_AddFtRoot\n"));
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_AddFtRoot(const char *desc, NETDFS_R_DFS_ADDFTROOT *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_AddFtRoot");
	depth++;
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_RemoveFtRoot(NETDFS_Q_DFS_REMOVEFTROOT *v)
{
	DEBUG(5,("init_netdfs_q_dfs_RemoveFtRoot\n"));
	
	return True;
}

BOOL netdfs_io_q_dfs_RemoveFtRoot(const char *desc, NETDFS_Q_DFS_REMOVEFTROOT *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_RemoveFtRoot");
	depth++;
	return True;
}

BOOL init_netdfs_r_dfs_RemoveFtRoot(NETDFS_R_DFS_REMOVEFTROOT *v, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_RemoveFtRoot\n"));
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_RemoveFtRoot(const char *desc, NETDFS_R_DFS_REMOVEFTROOT *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_RemoveFtRoot");
	depth++;
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_AddStdRoot(NETDFS_Q_DFS_ADDSTDROOT *v)
{
	DEBUG(5,("init_netdfs_q_dfs_AddStdRoot\n"));
	
	return True;
}

BOOL netdfs_io_q_dfs_AddStdRoot(const char *desc, NETDFS_Q_DFS_ADDSTDROOT *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_AddStdRoot");
	depth++;
	return True;
}

BOOL init_netdfs_r_dfs_AddStdRoot(NETDFS_R_DFS_ADDSTDROOT *v, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_AddStdRoot\n"));
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_AddStdRoot(const char *desc, NETDFS_R_DFS_ADDSTDROOT *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_AddStdRoot");
	depth++;
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_RemoveStdRoot(NETDFS_Q_DFS_REMOVESTDROOT *v)
{
	DEBUG(5,("init_netdfs_q_dfs_RemoveStdRoot\n"));
	
	return True;
}

BOOL netdfs_io_q_dfs_RemoveStdRoot(const char *desc, NETDFS_Q_DFS_REMOVESTDROOT *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_RemoveStdRoot");
	depth++;
	return True;
}

BOOL init_netdfs_r_dfs_RemoveStdRoot(NETDFS_R_DFS_REMOVESTDROOT *v, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_RemoveStdRoot\n"));
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_RemoveStdRoot(const char *desc, NETDFS_R_DFS_REMOVESTDROOT *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_RemoveStdRoot");
	depth++;
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_ManagerInitialize(NETDFS_Q_DFS_MANAGERINITIALIZE *v)
{
	DEBUG(5,("init_netdfs_q_dfs_ManagerInitialize\n"));
	
	return True;
}

BOOL netdfs_io_q_dfs_ManagerInitialize(const char *desc, NETDFS_Q_DFS_MANAGERINITIALIZE *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_ManagerInitialize");
	depth++;
	return True;
}

BOOL init_netdfs_r_dfs_ManagerInitialize(NETDFS_R_DFS_MANAGERINITIALIZE *v, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_ManagerInitialize\n"));
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_ManagerInitialize(const char *desc, NETDFS_R_DFS_MANAGERINITIALIZE *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_ManagerInitialize");
	depth++;
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_AddStdRootForced(NETDFS_Q_DFS_ADDSTDROOTFORCED *v)
{
	DEBUG(5,("init_netdfs_q_dfs_AddStdRootForced\n"));
	
	return True;
}

BOOL netdfs_io_q_dfs_AddStdRootForced(const char *desc, NETDFS_Q_DFS_ADDSTDROOTFORCED *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_AddStdRootForced");
	depth++;
	return True;
}

BOOL init_netdfs_r_dfs_AddStdRootForced(NETDFS_R_DFS_ADDSTDROOTFORCED *v, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_AddStdRootForced\n"));
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_AddStdRootForced(const char *desc, NETDFS_R_DFS_ADDSTDROOTFORCED *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_AddStdRootForced");
	depth++;
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_GetDcAddress(NETDFS_Q_DFS_GETDCADDRESS *v)
{
	DEBUG(5,("init_netdfs_q_dfs_GetDcAddress\n"));
	
	return True;
}

BOOL netdfs_io_q_dfs_GetDcAddress(const char *desc, NETDFS_Q_DFS_GETDCADDRESS *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_GetDcAddress");
	depth++;
	return True;
}

BOOL init_netdfs_r_dfs_GetDcAddress(NETDFS_R_DFS_GETDCADDRESS *v, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_GetDcAddress\n"));
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_GetDcAddress(const char *desc, NETDFS_R_DFS_GETDCADDRESS *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_GetDcAddress");
	depth++;
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_SetDcAddress(NETDFS_Q_DFS_SETDCADDRESS *v)
{
	DEBUG(5,("init_netdfs_q_dfs_SetDcAddress\n"));
	
	return True;
}

BOOL netdfs_io_q_dfs_SetDcAddress(const char *desc, NETDFS_Q_DFS_SETDCADDRESS *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_SetDcAddress");
	depth++;
	return True;
}

BOOL init_netdfs_r_dfs_SetDcAddress(NETDFS_R_DFS_SETDCADDRESS *v, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_SetDcAddress\n"));
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_SetDcAddress(const char *desc, NETDFS_R_DFS_SETDCADDRESS *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_SetDcAddress");
	depth++;
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_FlushFtTable(NETDFS_Q_DFS_FLUSHFTTABLE *v)
{
	DEBUG(5,("init_netdfs_q_dfs_FlushFtTable\n"));
	
	return True;
}

BOOL netdfs_io_q_dfs_FlushFtTable(const char *desc, NETDFS_Q_DFS_FLUSHFTTABLE *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_FlushFtTable");
	depth++;
	return True;
}

BOOL init_netdfs_r_dfs_FlushFtTable(NETDFS_R_DFS_FLUSHFTTABLE *v, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_FlushFtTable\n"));
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_FlushFtTable(const char *desc, NETDFS_R_DFS_FLUSHFTTABLE *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_FlushFtTable");
	depth++;
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_Add2(NETDFS_Q_DFS_ADD2 *v)
{
	DEBUG(5,("init_netdfs_q_dfs_Add2\n"));
	
	return True;
}

BOOL netdfs_io_q_dfs_Add2(const char *desc, NETDFS_Q_DFS_ADD2 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_Add2");
	depth++;
	return True;
}

BOOL init_netdfs_r_dfs_Add2(NETDFS_R_DFS_ADD2 *v, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_Add2\n"));
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_Add2(const char *desc, NETDFS_R_DFS_ADD2 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_Add2");
	depth++;
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_Remove2(NETDFS_Q_DFS_REMOVE2 *v)
{
	DEBUG(5,("init_netdfs_q_dfs_Remove2\n"));
	
	return True;
}

BOOL netdfs_io_q_dfs_Remove2(const char *desc, NETDFS_Q_DFS_REMOVE2 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_Remove2");
	depth++;
	return True;
}

BOOL init_netdfs_r_dfs_Remove2(NETDFS_R_DFS_REMOVE2 *v, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_Remove2\n"));
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_Remove2(const char *desc, NETDFS_R_DFS_REMOVE2 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_Remove2");
	depth++;
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_EnumEx(NETDFS_Q_DFS_ENUMEX *v)
{
	DEBUG(5,("init_netdfs_q_dfs_EnumEx\n"));
	
	return True;
}

BOOL netdfs_io_q_dfs_EnumEx(const char *desc, NETDFS_Q_DFS_ENUMEX *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_EnumEx");
	depth++;
	return True;
}

BOOL init_netdfs_r_dfs_EnumEx(NETDFS_R_DFS_ENUMEX *v, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_EnumEx\n"));
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_EnumEx(const char *desc, NETDFS_R_DFS_ENUMEX *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_EnumEx");
	depth++;
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

BOOL init_netdfs_q_dfs_SetInfo2(NETDFS_Q_DFS_SETINFO2 *v)
{
	DEBUG(5,("init_netdfs_q_dfs_SetInfo2\n"));
	
	return True;
}

BOOL netdfs_io_q_dfs_SetInfo2(const char *desc, NETDFS_Q_DFS_SETINFO2 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_q_dfs_SetInfo2");
	depth++;
	return True;
}

BOOL init_netdfs_r_dfs_SetInfo2(NETDFS_R_DFS_SETINFO2 *v, WERROR status)
{
	DEBUG(5,("init_netdfs_r_dfs_SetInfo2\n"));
	
	v->status = status;
	
	return True;
}

BOOL netdfs_io_r_dfs_SetInfo2(const char *desc, NETDFS_R_DFS_SETINFO2 *v, prs_struct *ps, int depth)
{
	if (v == NULL)
		return False;
	
	prs_debug(ps, depth, desc, "netdfs_io_r_dfs_SetInfo2");
	depth++;
	if (!prs_werror("status", ps, depth, &v->status))
		return False;
	
	return True;
}

