Name: brltty
Version: 3.7.2
Release: 1

Group: System Environment/Daemons
License: GPL
Vendor: The BRLTTY Team
Packager: Dave Mielke <dave@mielke.cc>
URL: http://mielke.cc/brltty/
Source: http://mielke.cc/brltty/releases/%{name}-%{version}.tar.gz

BuildRequires: autoconf >= 2.53
BuildRequires: make
BuildRequires: gcc
BuildRequires: /bin/sh
BuildRequires: /bin/ln
BuildRequires: /usr/bin/ld
BuildRequires: /sbin/ldconfig
BuildRequires: /usr/bin/ranlib
BuildRequires: /usr/bin/ar
BuildRequires: /usr/bin/awk
BuildRequires: /usr/bin/bison
BuildRequires: /usr/bin/install
BuildRequires: glibc-devel

BuildRoot: %{_tmppath}/%{name}-%{version}-InstallRoot
%define _bindir /bin
%define _sbindir /sbin
%define _libdir /lib
%define _sysconfdir /etc

AutoProv: 1

AutoReq: 1
Requires: /bin/sh

Summary: Braille display driver for Linux/Unix.
%description
BRLTTY is a background process (daemon) which provides access to
the console screen (when in text mode) for a blind person using a
refreshable braille display.  It drives the braille display, and
provides complete screen review functionality.  Some speech capability
has also been incorporated.

Install this package if you use a refreshable braille display.

%package -n brlapi
Version: 0.4.1
Group: Applications/System
License: LGPL

AutoProv: 1

AutoReq: 1

Summary: Appliation Programming Interface for BRLTTY.
%description -n brlapi
This package provides the run-time support for the Application
Programming Interface to BRLTTY.

Install this package if you have an application which directly accesses
a refreshable braille display.

%package -n brlapi-devel
Version: 0.4.1
Group: Development/System
License: LGPL

AutoProv: 1

AutoReq: 1
Requires: brlapi = 0.4.1

Summary: Headers, static archive, and documentation for BrlAPI.
%description -n brlapi-devel
This package provides the header files, static archive, shared object
linker reference, and reference documentation for BrlAPI (the
Application Programming Interface to BRLTTY).  It enables the
implementation of applications which take direct advantage of a
refreshable braille display in order to present information in ways
which are more appropriate for blind users and/or to provide user
interfaces which are more specifically atuned to their needs.

Install this package if you're developing or maintaining an application
which directly accesses a refreshable braille display.

%prep
# %setup -n %{name}-%{version}
%setup -n brltty-3.7.2

%build
%configure --with-install-root="${RPM_BUILD_ROOT}" --without-flite --without-mikropuhe --without-swift --without-theta --without-viavoice --without-libbraille --without-curses --without-x --with-braille-driver=-tt
make

directory="doc"
mkdir -p "${directory}"
for file in `find . \( -path "./${directory}" -o -path ./Documents \) -prune -o \( -name 'README*' -o -name '*.patch' -o -name '*.txt' -o -name '*.html' -o -name '*.sgml' -o \( -path "./Bootdisks/*" -type f -perm +ugo=x \) \) -print`
do
   mkdir -p "${directory}/${file%/*}"
   cp -rp "${file}" "${directory}/${file}"
done

%install
make install
install -m 644 Documents/brltty.conf "${RPM_BUILD_ROOT}%{_sysconfdir}"

%clean
rm -fr "${RPM_BUILD_ROOT}"

%files
%defattr(-,root,root)
%{_bindir}/brltty
%{_bindir}/brltty-*
%{_libdir}/brltty
%{_sysconfdir}/brltty
%doc %{_mandir}/man1/*
%doc Documents/Manual.sgml Documents/Manual.txt Documents/Manual-HTML
%doc COPYING
%doc Documents/ChangeLog Documents/TODO
%doc doc/*
%config(noreplace) %verify(not size md5 mtime) %{_sysconfdir}/brltty.conf

%files -n brlapi
%defattr(-,root,root)
%{_libdir}/libbrlapi.so.*
%doc Documents/BrlAPI.sgml Documents/BrlAPI.txt Documents/BrlAPI-HTML
%doc Documents/README.Gnopernicus

%files -n brlapi-devel
%defattr(-,root,root)
%{_libdir}/libbrlapi.a
%{_libdir}/libbrlapi.so
%{_includedir}/brltty
%doc %{_mandir}/man3/*
%doc Documents/BrlAPIref-HTML

%changelog
* Mon Dec 26 2005 Dave Mielke <dave@mielke.cc> 3.7.2
+  The AtSpi screen driver doesn't load due to a missing Xt dependency.
+  Check for X11/extensions/XKB.h.
+  Swedish text translation table changes:
      Add text.se.tbl (1996 standard).
      Rename text.se2.tbl to text.se-old.tbl (1989 standard).
      Remove text.se1.tbl (modified english table).
+  English grade 2 contraction table changes:
      The "m-st" contraction should always be used when "must" is the root word.
* Mon Dec 12 2005 Dave Mielke <dave@mielke.cc> 3.7.1
+  (is|validate)(Integer|Float) should only modify *value when returning true.
+  usbWriteEndpoint() in usb_libusb.c called usbGetInputEndpoint().
+  KDGETMODE, KDGKBMETA and KDGKBMODE need an int (not a long) operand.
+  Add the BRL_BLK_(PR|NX)DIFCHAR functions.
+  Allow the end of the cut region to be corrected.
+  Fix a call to brlapi_perror() within xbrlapi.
+  Waiting for output to unblock wasn't being done correctly.
+  English grade 2 contraction table changes:
      Don't use a letter sign when a letter is followed by a period.
      Handle "by-and-by" as a special case.
      Don't use a contraction if a capitalization state change within it needs clarification.
      Use "ed" for "redolent".
+  Baum braille driver changes:
      A Vario 40 can return device identity but not cell count.
      Add a few more "words of wisdom" to README.Inka.
      Binding changes:
         Function  Old         New
         SETMARK   TL1+TL2+CRn TL1+TL3+CRn
         GOTOMARK  TL2+TL3+CRn TR1+TR3+CRn
         PRINDENT  TR2+TR1+CRn TL2+TL1+CRn
         NXINDENT  TR2+TR3+CRn TL2+TL3+CRn
         PRDIFCHAR -           TR2+TR1+CRn
         NXDIFCHAR -           TR2+TR3+CRn
+  API changes:
      Correct the documentation for the BRLPACKET_WRITE packet.
      Remove the prototype of brlapi_getDriverInfo() from api.h.
      An API client should forget the authorization key as soon as it's been sent to the server.
      Ensure that the Unix-domain socket is removed before binding to it.
      Fix the behaviour of the "and" dot mask.
+  Build changes:
      Check for -lXtst and -lXext.
      Move the X dependencies from the executables to the components which need them.
      Move the curses dependency from the executables to the TTY braille driver.
      Some shells don't like the semicolon in "for i; do".
* Sat Sep 17 2005 Dave Mielke <dave@mielke.cc> 3.7
+  Change the dot-to-bit mapping to comply with ISO/TR 11548-1.
+  New cursor routing algorithm (works with editors with wrapped lines).
+  Replace the -N [--no-speech] option with -N [--no-api].
+  Get the fully qualified path to the executable.
+  getWorkingDirectory() should use reallocWrapper().
+  hasTimedOut(0) should return true in order to handle a timeout of 0.
+  Create the rescaleInteger() function from in-line preferences menu code.
+  Define and implement BRL_BLK_GOTOLINE.
+  NULs are written to the end of the visual display if it's off the end of the screen.
+  Termination signals should just set a flag and let brltty terminate safely.
+  Change all "bluez" uses to "bluetooth".
+  Split the autorepeat code out into a separate function.
+  Autospeak sometimes decides that characters have been deleted when, in fact, they've been replaced.
+  Enable autorepeat and autospeak for the preferences menu.
+  Write debug logs for braille and speech setting changes.
+  The coordinates on the status line should start from 1 rather than from 0.
+  Generate lower status digits symbolically rather than mathematically.
+  Operate serial devices in true nonblocking mode.
+  Give better names to serialTestLines()'s arguments.
+  Text table renames: fr -> fr_CA, fr-iso01 -> fr_FR
+  Force OSS PCM output to be blocking.
      There appears to be a bug in ALSA OSS simulation.
      Output is nonblocking if snd_seq_oss is loaded with nonblock_open=1.
      In this case, write() always returns the full count even though
      large chunks of sound are missing.
+  Ensure that the PCM ALSA support uses a sensible sample rate.
+  By default, use the PCM ALSA device "default".
+  Fix ALSA MIDI event timing and output flushing.
+  Alva braille driver changes:
      Add input/output packet logging.
      Remove the autodetect loop.
      Remove some hard-coded delays during open.
      Ensure that all packet buffers are as large as the largest possible packet.
      Wait during open to see if the status cells have been turned off.
+  BrailleLite braille driver changes:
      Redefine the key-to-dots table in terms of braille dot constants.
      Remove other hard-coded dot values.
      Redo the layout of the bindings table to make it easier to edit.
+  BrailleNote braille driver changes:
      Reindent the source to 2 (form 3).
      Remove the probe loop from brl_open().
      Add packet I/O.
      Add output flow control.
      Define a structure for input packets.
+  EuroBraille braille driver changes:
      Use symbolic, rather than hard-coded, dot-to-bit mapping.
+  FreedomScientific braille driver changes:
      Reduce the USB retry count from 5 to 3.
      Remove the "no response from display" warning.
      Fix a typo in the definition of the Focus 40 braille display.
+  HandyTech braille driver changes:
      Reduce the USB retry count from 5 to 3.
      Remove the "no response from display" warning.
+  LogText braille driver changes:
      Redefine the output and input tables in terms of braille dot constants.
      Don't prepare the output and input tables more than once.
+  MDV braille driver changes:
      Remove the autodetect loop.
+  Papenmeier braille driver changes:
      Reduce the USB retry count from 5 to 3.
      Remove the "no response from display" warning.
      Add automatic cursor routing to horizontal combined mode bindings.
      read_config:
         Include prologue.h.
         Link with $(LDLIBS).
+  TTY braille driver changes:
      Position the cursor correctly.
      Build even if no curses package is available.
+  Virtual braille driver changes:
      Use PF_LOCAL/AF_LOCAL instead of PF_UNIX/AF_UNIX.
      Don't index the names array beyond its size.
+  VisioBraille braille driver changes:
      Redefine the output table in terms of braille dot constants.
+  Voyager braille driver changes:
      Reformat the definition of the dots table.
+  XWindow braille driver changes:
      Reindent source.
      Rename the xtparms parameter to tkparms.
      Add the input= parameter.
      Add a more advanced model (based on the VisioBraille mapping).
      Xm isn't initernationalized.
      Add cursor routing and displaying of dots.
      Show the cursor position within the visual display.
      Right-clicking on the window pops up a menu in which one can
      change the size and model of the emulated braille device.
      Keep the window on top.
      Add a setup menu.
      Add support for command autorepeating.
      Include X11/Intrinsic.h in more places to keep Solaris happy.
+  ExternalSpeech speech driver changes:
      Allow names, rather than just numbers, to be passed to the uid/gid parameters.
+  Swift speech driver changes:
      Add debug logs for the setting of parameters.
+  API changes:
      Change BrlAPI's release to 0.4.0.
      Add void to argumentless routine prototypes where missing.
      Move brlapi_fd_mutex from api.h to api_protocol.h.
      Move BRL_KEYBUF_SIZE from api.h to api_client.c.
      Define the BRLAPI_MAXKEYSETSIZE constant and use it in api_client.c.
      brlapi_readFile() and brlapi_writeFile() are only used within api_common.c.
      Clean up the API TTY list in a safe way.
      The API should automatically clean up its TTY tree.
      Remove the ancestor loop from brlapi_getControllingTty().
      Require clients to be more precise when claiming a tty or entering raw mode:
         getRaw() has an argument to specify the driver one wants to exchange packets with.
         The integer argument of getTty() used to specify either BRL_KEYCODES or BRL_COMMANCS
         has been replaced by a string argument.
         If either NULL or "" then keypresses are delivered as BRLTTY commands.
         If a driver name then the server verifies that that driver is being used 
         and that it actually supports raw key codes.
         brlapi_getRaw() should return an error rather than an exception
         when the required driver is not the one used by BRLTTY.
      Define BRLCOMMANDS (in api.h) in a backward compatible way.
      Verify the result of gethostbyname().
      Add conditional code for PF_LOCAL.
      Use sockaddr_storage rather than sockaddr.
      Split brlapi_readPacket() into brlapi_readPacketHeader() and brlapi_readPacketContent().
      Split processRequest() into several smaller functions.
      Check cursor value more carefully in brlapi_writeText().
      Only real commands (neither NOOP nor EOF) should be sent to clients.
      The server side of the API should do non-blocked reads.
      Report packet read errors via errno rather than via brlapi_libcerrno.
      Rename errorHandler to exceptionHandler.
      Add the brlapi_strexception() function.
      More clearly distinguish between errors and exceptions.
      Problems caused by getTty and (un)ignoreKeySet should be reported as errors rather than as exceptions.
      brlapi_packetType() should return a convenient string for exception packets.
      Clean up error handling by putting all necessary information for printing errors into a struct.
      Add the infrastructure for handling display size changes.
      Handle client's charset and convert as needed in the server.
      Recognize -1 (rather than 0) as the "no screen" vt.
      Several (rare) race condition fixes.
      Add support for the Unicode braille row.
      If supported, reduce the thread stack size to 64K (from 8M).
      Add the API parameter stacksize=.
      Remove the TOORECURSE error code.
      Replace both RAWNOTSUPP and KEYSNOTSUMP errors by OPNOTSUPP.
      Return OPNOTSUPP (rather than INVALID_PARAMETER) when a charset is specified and iconv is absent.
      Simplify the returning of errors.
      Fix tty table extension.
      brlapi_write() should use the specified length rather than call strlen since the data could contain NUL bytes.
      Add the brlapi_getTtyPath() function.
      Use recursive locking so that brl_readCommand() can call message().
      Change the prototypes for brlapi_(send|recv)Raw() to use "void *" instead of "unsigned char *".
      Allow the KeyFile= parameter to accept the special string "none".
      Reject empty key files.
      Accept keys larger than the allowed key size.
      By default, the client should also check for the IP socket.
      Check for an already-running BrlAPI server.
      Provide public access to brlapi_splitHost().
      Dot masks should be unsigned.
      Remove the trailing newline from the "BrlAPI resize" log.
      "code" has already been converted to host byte order by the caller.
      Add some synchronisation cleanups.
      Allow users to call brlapi_write(NULL).
      api.h should internally include what it depends on.
      Preprocess the autorepeat flags.
      Let the clients see BRL_CMD_NOOP.
+  apitest changes:
      Add the -d [--dots] option.
      Exit show dots mode when a braille display key (rather than a keyboard key) is pressed.
      Learn Mode:
         Announce entry.
         Write command descriptions to standard error.
         Eliminate bogus error message when leaving.
+  xbrlapi changes:
      Add key event support.
      No longer use the deprecated BRLCOMMANDS constant.
      Close the connection via a signal-safe method.
+  tbltest changes:
      Add support for writing tables.
      Add support for .a2b (Gnopernicus) braille tables.
      Interpret - as standard input.
+  en-us-g2 contraction table fixes:
      [had]rian, hid[ea]way, r[er]egister, un[con]genial.
      Don't remove space after "a" if before "and", "for", "of", "the", or "with".
      Don't contract the word "in" after a dash.
+  USB changes:
      Remove the assumption that a USB device maps to a file system object.
      A device should point to the proper descriptor for the current interface alternative.
      Use a common algorithm for iterating through the configuration descriptor block.
      Only reread the configuration descriptor block if the first buffer is too small.
      Publicize the functions for getting the configuration descriptor and its components.
      When setting the configuration, deallocate the cached copy of the old descriptor.
      Add a function for reading the device descriptor from the device itself.
      Automatically close an open interface when changing the configuration.
      Add an endpoint parameter to usbReapResponse().
      Improve the timeout used for in-line endpoint reading when awaiting input.
      Calculate timeouts more accurately.
      Make device closing more robust.
      Check for a serial adapter even if configuration data for it isn't supplied.
      Fix the bulk input loop.
      Asynchronous errors should always be passed back to the caller.
      Code restructuring:
         Reorder the platform-dependent function definitions.
         Group the global internal function definitions by where they need to be implemented.
         Rename the constants to avoid conflicts with libusb.
      Linux changes:
         Allow reaping the URB for a specific endpoint.
         Reap a URB after discarding it.
         Add support for inline reading of an interrupt endpoint.
         Add support for inline writing to an interrupt endpoint.
      BSD changes:
         Add more robustness to deallocating device and endpoint extensions.
      Darwin changes:
         Add more robustness to deallocating an endpoint extension.
      Add support for libusb.
+  General code changes:
      Update the copyright prologues from 2004 to 2005.
      Change "Linux console" to "console screen" in the copyright prologues.
      Change the nested inclusion protection convention from _NAME_H to BRLTTY_INCLUDED_NAME.
      <sys/types.h> needs to be included before almost any other header  on some BSD systems.
      gcc-3.3 (at least on cygwin) doesn't like apostrophes in #error directives.
      gcc-4 does a lot more checking for matching signedness.
      gcc-4 doesn't allow a variable to be declared global and then static.
      Remove the casts from the results of malloc() calls.
      Clean up the passing of TranslationTable and DotsTable parameters.
      Logs to standard error should be prefixed with the program's name.
      Use LogPrint() rather than fprintf(stderr) for option processing errors.
      Rename ctb_definitions.h to ctb_internal.h.
      Remove dummy timezone parameters to gettimeofday().
      Rename infmode to infoMode.
      Remove tests for and calls to endhostent() and endservent().
      Ensure that all I/O headers are prefixed with "io_" (primarily because of <usb.h>.
+  General driver changes:
      Define opt_pcmDevice as external for those speech drivers which need it.
      Change the speech rate,volume handlers to take a floating-point multiplier.
      Prefix all driver identification #defines with the driver code.
      Uniformly refer to driver codes as "codes" rather than as "identifiers".
      Add the driver comment string to the driver structure.
      Split the braille and speech drivers into separate subdirectories.
      Don't create the /lib/brltty/brltty-???.lst files.
      Make the screen drivers dyamically loadable.
      Add skeleton braille,speech,screen driver source.
+  Screen driver changes:
      Define screen driver parameters in a more standard way.
      Allow screen driver codes to be used as parameter qualifiers.
      Make --without-screen-driver work.
      Add the screen-driver configuration directive and -x command line option to BRLTTY.
      Remove hard-coded limitations and assumptions from the screen state table.
      Don't keep two copies of the current screen number.
      All screen drivers should determine their vt# in only one place.
      Clean up the code which switches between the live,frozen,help screens.
      The read() method should return a boolean rather than the buffer.
      Add the uservt() method to the MainScreen object.
      Add the uservt() method to the Screen screen driver.
      Add the currentvt() method to the FrozenScreen object.
      Correctly detect when the Linux console switches between text and graphics mode.
+  Solaris changes:
      Define AF_LOCAL to be AF_INET.
      Define _XOPEN_SOURCE=500 and __EXTENSIONS__.
      Add native USB support.
      Remove the use of "[from ... to] =" initializers.
      Remove the use of type-casted tuples.
      Remove the use of __label__ declarations.
      "#pragma weak", rather than "__attributes__((weak))", is needed on Solaris.
+  Build changes:
      gendeps changes:
         Remove the need for TclX.
         Search for tclsh rather than hard-code its path.
      Rename the "aux" subdirectory to "acdir" (for Cygwin).
      Don't build spktest automatically.
      Build/install/uninstall xbrlapi.
      Pass the list of needed libraries to the linking of the API server library.
      Link the API client library with only those dependencies which it actually needs.
      Add build-time detection for: pwd.h, grp.h, regex.h, gai_strerror(), hstrerror().
      Add compile-time detection for: ETIMEDOUT, EAFNOSUPORT.
      Explicitly test for libX11, libXt, and the xt toolkit library.
      Separate the concepts of dynamic library and loadable module.
      Use <NAME> rather than <SONAME> in the MKLIB macro.
      Use libusb, if available, if we don't provie native USB support.
      Upgrade the BrlAPIref doxygen configuration file to 1.3.9.1.
      Clean up the top-level <driver-type>.mk files.
      Correct the documentation regarding default installed package locations.
      Rename the brltty_setup_files macro to brltty_make_files.
      Rename setup.mk.in to prologue.mk.in.
      "make clean/distclean" should process the directories for internal drivers.
      "make all" in the "Documents/" subdirectory should make the man3 files.
      Add the make file targets tar,gz,bz2,rpm.
      Fix the hard-coded dependencies which allow the VideoBraille braille driver to be built-in.
      Split the non-config parts of config.h into prologue.h and include the former from the latter.
      Remove the leading ./ from config.h in make file dependency lists.
      Some compilers don't like trailing slashes on directory paths.
      Use the shell variable $RANDOM as a last resort when generating the API key.
+  rhmkiso chagnes:
      Build in the Linux screen driver, and don't build any other screen drivers.
      Add support for making a braillified Fedora Core 4 installer image.
+  RPM changes:
      The spec file referenced an old substitution for the API version.
      Don't include the TTY braille driver.
+  Gnopernicus changes:
      ttybrl.c:
         Improve the BRLTTY command to Gnopernicus key mappings.
         Use Gnopernicus layer-key codes rather than Baum key codes.
         Move all key code generation into a common routine.
         Rename key to blk and keypress to key.
         Ignore BRL_CMD_NOOP.
         Handle the autorepeat flags.
         Check for errors in the command read loop.
         ignore_input() is no longer needed because flags aren't taken into account when ignoring commands.
         Adapt to BrlAPI 0.4.0.
      README.Gnopernicus:
         Add a note about using BRLTTY's Patches/ttybrl.c.
         Document the latest BRLTTY command to Gnopernicus key mappings.
         Document how to get the routing keys to work.
+  Initial support for the Hurd platform.
+  Initial support for the Mac OS X (Darwin) platform.
+  Initial support for the Cygwin platform.
+  Initial support for the MinGW platform.
+  Remove the Vario braille driver.
+  Remove the VarioHT braille driver.
+  Add the Baum braille driver.
+  Add the Braudi braille driver.
+  Add the BrlAPI braille driver.
+  Add the Libbraille braille driver.
+  Add the TechniBraille braille driver.
+  Add the AtSpi screen driver.
+  Add the Hurd screen driver.
+  Add the Windows screen driver.
+  Rename the shm screen driver to Screen.
+  Add al,bm,bn,ht,md to the braille driver serial autodetect list.
+  Add bm to the braille driver USB autodetect list.
+  Add bm to the braille driver Bluetooth autodetect list.

